$(document).ready(function () {
    
    $('#divSubTotalizar').show();
    $('[name="ordem"]').on('ifChecked', function (event) {
        if ($(this).val() == 'Q') {
            $('#divSubTotalizar').hide();
        } else if ($(this).val() == 'P') {
            $('#divSubTotalizar').hide();
        } else {
            $('#divSubTotalizar').show();
        }
    });

    $('#pesquisar').on('click', function (e) {
        $('#visualizarInput').val('true');
        $("input[name*='tipoRelatorio']").val('html');  

        var $form = $('#form'),
            params = $form.serializeArray(),
            formData = new FormData();

        $.each(params, function (i, val) {
            formData.append(val.name, val.value);
        });

        $.ajax({
            url: "?m=cobranca&c=relatorioCobranca&a=relatorio",
            data: formData,
            cache: false,
            contentType: false,
            processData: false,
            type: 'POST',
            beforeSend: function () {
                $('#pesquisar').disable = true;
                $('#receiver').empty();
            },
            success: function (json) {
                //se fizer a parse do json fora do if, o else no funciona,
                //por isso esta sendo feita uma verificacao do primeiro caracter que vier do json.
                //Se for '{'  por que aconteceu algum erro.
                if (json[0] == '{') {
                    var erros = JSON.parse(json);

                    $('.msgErros').html(erros.msgErros).show();
                    setTimeout(function () {
                        $('.msgErros').slideUp();
                    }, 5000);
                } else {     

                    $('.middle').slideUp(800);
                    $('#hide-content').css('display', 'block');
                    $('#receiver').html(json);           
                    $('html, body').animate({ scrollTop: $('.row').offset().top }, 'slow');
                }

            }
        });
    });

    $('#pdf').on('click', function (e) {
        e.preventDefault();
        $('#visualizarInput').val('false');        
        $("input[name*='tipoRelatorio']").val('pdf');   
        $('#form').attr('target', '_self');

        var $form = $('#form'),
            params = $form.serializeArray(),
            formData = new FormData();

        $.each(params, function (i, val) {
            formData.append(val.name, val.value);
        });

        $.ajax({
            url: "?m=cobranca&c=relatorioCobranca&a=relatorio",
            data: formData,
            cache: false,
            contentType: false,
            processData: false,
            type: 'POST',
            beforeSend: function () {
                $('#pdf').disable = true;
            },
            success: function (json) {

                if (json[0] == '{') {

                    var erros = JSON.parse(json);

                    $('.msgErros').html(erros.msgErros).show();
                    setTimeout(function () {
                        $('.msgErros').slideUp();
                    }, 5000);
                } else {
                    $("#form").attr('target',  '_blank');   
                    $('form').submit();
                }      
            }
        })
    });

    $('#xls').on('click', function (e) {
        e.preventDefault();
        $('#visualizarInput').val('false');
        $("input[name*='tipoRelatorio']").val('xls');   
        $('#form').attr('target', '_self');

        var $form = $('#form'),
            params = $form.serializeArray(),
            formData = new FormData();

        $.each(params, function (i, val) {
            formData.append(val.name, val.value);
        });

        $.ajax({
            url: "?m=cobranca&c=relatorioCobranca&a=relatorio",
            data: formData,
            cache: false,
            contentType: false,
            processData: false,
            type: 'POST',
            beforeSend: function () {
                $('#xls').disable = true;
            },
            success: function (json) {

                if (json[0] == '{') {
                    
                    var erros = JSON.parse(json);

                    $('.msgErros').html(erros.msgErros).show();
                    setTimeout(function () {
                        $('.msgErros').slideUp();
                    }, 5000);
                } else {            
                    $("#form").attr('target',  '_blank');
                    $('form').submit();
                }
            }
        })
    });

    $('#hide-content').on('click', function(e) {
        $('.middle').slideDown(800);
        $('#hide-content').css('display', 'none');
        $('html, body').animate({ scrollTop: $('.content').offset().top }, 'medium');
    });
});

function selectChange(select) {

    if (select.hasClass('empreendimentoRelatorioCobranca')) {
        $("#clienteRelatorioCobranca").prop('disabled', false);
        $("#clienteRelatorioCobranca").empty();
        $.ajax({
            type: "POST",
            url: "?m=rl&c=relatorioPagas&a=clienteParcelasPagas",
            data: "id_empreendimento=" + select.val(),
            success: function (response) {
                var json = JSON.parse(response);
                if (json) {
                    $('.span120dias').show();
                    $("#clienteRelatorioCobranca").prop('disabled', false);
                    $("#clienteRelatorioCobranca").select2({
                        'data': json,
                        'placeholder': 'Escolha o Cliente',
                        'allowClear': true,
                        'language': {
                            "noResults": function () {
                                return "Nenhum resultado encontrado";
                            },
                            "searching": function () {
                                return "Pesquisando...";
                            }
                        }
                    });
                    $('#clienteRelatorioCobranca').val('*').trigger('change.select2');
                }
            }
        });
        $.ajax({
            type: "POST",
            url: "?m=rl&c=relatorioPagas&a=loteByEmpreendimento",
            data: "id_empreendimento=" + select.val(),
            success: function (response) {
                var json = JSON.parse(response);
                if (json) {
                    $('#receiver').empty();
                    $('#hide-content').click();
                    $("#quadraRelatorioCobranca").select2({
                        'data': json,
                        'placeholder': 'Escolha a Quadra/Lote',
                        'allowClear': true,
                        'language': {
                            "noResults": function () {
                                return "Nenhum resultado encontrado";
                            },
                            "searching": function () {
                                return "Pesquisando...";
                            }
                        }
                    });
                    $('#quadraRelatorioCobranca').val('*').trigger('change.select2');
                }
            }
        });
        $.ajax({
            type: "POST",
            url: "?m=rl&c=relatorioPagas&a=bancoByEmpreendimentos",
            data: "id_empreendimento=" + select.val(),
            success: function (response) {
                var json = JSON.parse(response);
                if (json) {
                    $("#bancoRelatorioCobranca").select2({
                        'data': json,
                        'placeholder': 'Escolha o Banco',
                        'allowClear': true,
                        'language': {
                            "noResults": function () {
                                return "Nenhum resultado encontrado";
                            },
                            "searching": function () {
                                return "Pesquisando...";
                            }
                        }
                    });
                    $('#bancoRelatorioCobranca').val('*').trigger('change.select2');
                }
            }
        });
    }
}