$(document).ready(function () {
    /**
     * Listar
     *
     */

    $('#TabelaListar').DataTable({

        "processing": true,
        "ajax": "index.php?m=cobranca&c=cobranca&a=listar",
        "columns": [
            {"data": 'cobranca'},
            {"data": 'empreendimento'},
            {"data": 'abertura'},
            {"data": 'encerramento'},
            {"data": 'ordem'},
            {"data": 'status'},
            {"data": 'acoes'}
        ],

        //Define a coluna default que ser ordenada quando abrir a pgina
        "order": [[0, "desc"]],

        //Organiza os botoes, paginao, campos e notificaes
        dom: '<"btnAdicionar">lfrtip',

        //Define as opes de quantidade de linhas que apareco na lista
        "lengthMenu": [[10, 25, 50], [10, 25, 50]],

        //Define as colunas que no tero ordenao
        "columnDefs": [
            {
                "orderable": false,
                "targets": -1,
                "searchable": false
            },
            {
                "className": "dt-center", "targets": [0,2,3,4,5]
            }
        ],

        //Pensonalizando as mensagens que por default so em ingls e formatao de valores
        language: {
            "sEmptyTable": "Nenhum registro encontrado",
            "sInfo": "",
            "sInfoEmpty": "",
            "sInfoFiltered": "",
            "sInfoPostFix": "",
            "sInfoThousands": ".",
            "sLengthMenu": "_MENU_",
            "sLoadingRecords": "Carregando...",
            "sProcessing": "Processando...",
            "sZeroRecords": "Nenhum registro encontrado",
            "sSearch": "Busca",
            "oPaginate": {
                "sNext": "Prximo",
                "sPrevious": "Anterior",
                "sFirst": "Primeiro",
                "sLast": "ltimo"
            },
            "oAria": {
                "sSortAscending": ": Ordenar colunas de forma ascendente",
                "sSortDescending": ": Ordenar colunas de forma descendente"
            },

            "decimal": ",",
            "thousands": "."
        }
    });

    //Boto "Adicionar" da listagem de todas telas
    var btnAdicionar = '<a class="btn btn-success" href="?m=cobranca&c=cobranca&a=adicionar"><i class="fa fa-plus-circle"></i> Nova Cobrana</a>';
    $("div.btnAdicionar").html(btnAdicionar);

        $(document).on('click', '#encerramento', function() {
            var id_cobranca = $(this).val();
            $.ajax({
                type:'POST',
                url: '?m=cobranca&c=cobranca&a=encerrar&id='+id_cobranca,
                dataType: 'json',
                data: {id_cobranca: id_cobranca},
                success: function(data) {
                    //msg
                }
            });
        });
});

$(document).on('click', '.btnVisualizar', function () {
    var cdItem = $(this).val();

    $.ajax({
        type: 'POST',
        url: "index.php?m=cobranca&c=cobranca&a=visualizar",
        dataType: 'json',
        data: {cdItem: cdItem},
        success: function (item) {

            switch (item[0].tp_ordenacao) {
                case 'A':
                    item[0].tp_ordenacao = 'Aleatrio';
                    break;
                case 'C':
                    item[0].tp_ordenacao = 'Cliente';
                    break;
                case 'Q':
                    item[0].tp_ordenacao = 'Quadra/Lote';
                    break;
                case 'M':
                    item[0].tp_ordenacao = 'Vencimento';
                    break;
                case 'P':
                    item[0].tp_ordenacao = 'Decrescente de parcelas';
                    break; 
                case 'D':
                    item[0].tp_ordenacao = 'Crescente de parcelas';
                    break;    
            }

            $('#idCobranca').html(item[0].id_cobranca);
            $('#nmEmpreendimento').html(item[0].nm_empreendimento);
            $('#dtAbertura').html(getDate(item[0].dt_abertura));

            if (item[0].dt_encerramento == null) {
                item[0].dt_encerramento = '';
            }

            $('#dtEncerramento').html(getDate(item[0].dt_encerramento));
            $('#tpOrdem').html(item[0].tp_ordenacao);

            $.each(item[1], function(index) {
                if(item[1][index].nr_tipo_parcela){
                    item[1][index].parcela = item[1][index].nr_tipo_parcela;
                }
                else{
                    item[1][index].parcela = item[1][index].parcela+ '' +item[1][index].tipo;
                }

                switch (item[1][index].status) {
                    case 'S':
                        item[1][index].status = '<div class="label label-success">Sucesso</div>';
                        break;
                    case 'F':
                        item[1][index].status = '<div class="label label-danger">Fracasso</div>';
                        break;
                    default :
                        item[1][index].status = '<div class="label label-warning">Pendente</div>'
                }

                item[1][index].vencimento = getDate(item[1][index].vencimento);
            });

            $('#TabelaCobrancas').DataTable().destroy();
            $('#TabelaCobrancas').DataTable({
                data: item[1],
                columns: [
                    {data: 'cliente'},
                    {data: 'lote'},
                    {data: 'quadra'},
                    {data: 'contrato'},
                    {data: 'parcela'},
                    {data: 'vencimento'},
                    {data: 'valor'},
                    {data: 'status'}
                ],
                //Define a coluna default que ser ordenada quando abrir a pgina
                order: [[4, "asc"]],
                //Define as opes de quantidade de linhas que apareco na lista
                "lengthMenu": [[4, 10, 25], [4, 10, 25]],
                //Define as colunas que no tero ordenao
                "columnDefs": [
                    {
                        "orderable": false,
                        "targets": -1,
                        "searchable": false
                    },
                    {
                        "className": "dt-center", "targets": [1,2,3,4,5,6,7]
                    }
                ],
                //Pensonalizando as mensagens que por default so em ingls e formatao de valores
                language: {
                    "sEmptyTable": "Nenhum registro encontrado",
                    "sInfo": "",
                    "sInfoEmpty": "",
                    "sInfoFiltered": "",
                    "sInfoPostFix": "",
                    "sInfoThousands": ".",
                    "sLengthMenu": "_MENU_",
                    "sLoadingRecords": "Carregando...",
                    "sProcessing": "Processando...",
                    "sZeroRecords": "Nenhum registro encontrado",
                    "sSearch": "Busca",
                    "oPaginate": {
                        "sNext": "Prximo",
                        "sPrevious": "Anterior",
                        "sFirst": "Primeiro",
                        "sLast": "ltimo"
                    },
                    "oAria": {
                        "sSortAscending": ": Ordenar colunas de forma ascendente",
                        "sSortDescending": ": Ordenar colunas de forma descendente"
                    },
                    "decimal": ",",
                    "thousands": "."
                }
            });
        }
    });
});
