$(document).ready(function() {

    $('#nmEndereco').editable();
    $('#nrTelefone').editable();
    $('#username').editable();
    $('#nrCep').editable();
    $('#nrCelular').editable();
    $('#nmBairro').editable();
    $('#nrRecado').editable();
    $('#dsComplemento').editable();
    $('#email').editable();
    $('#nrEndereco').editable();

    $('#idSelectContrato').on('change', function(){
        let searchParams = new URLSearchParams(window.location.search);
        searchParams.has('id');
        let id = searchParams.get('id');

        //if para verificar se o usurio esta iniciando a cobrana pela cobrana individual ou coletiva.
        if (searchParams.has('individual')) {
            window.location.href = "?m=cobranca&c=cobranca&a=iniciar&id="+id+"&idSelectContrato="+$("#idSelectContrato").val() +"&individual=true";
        } else {
            window.location.href = "?m=cobranca&c=cobranca&a=iniciar&id="+id+"&idSelectContrato="+$("#idSelectContrato").val();
        }
    });

    select2RemoteData(
        '#cdCidade',
        false,
        true,
        'Digite o nome da Cidade',
        'index.php?m=lo&c=ajax&a=findCidade'
    );
    
    // $('#nrCep').on('save', function(e, params) {
    //     // alert('Saved value: ' + params.newValue);
    //     // alert($('#nmEndereco').html());
    //     // alert($('.nmBairro').val());
    //     /**
    //     * Service para buscar remotamente o endereo
    //     * https://viacep.com.br/
    //     */
    //     $.getJSON("//viacep.com.br/ws/" + params.newValue + "/json/?callback=?", function (dados) {

    //         if (!("erro" in dados)) {
    //             var logradouro = (dados.logradouro);
    //             var limite = 45;
    //             var limitarCaracteres = logradouro.length;
    //             if (limitarCaracteres > limite){
    //                 var logradouroLimitado = logradouro.substr(0, limite);
    //                 $("#nmEndereco").html(logradouroLimitado);
    //                 $("#nmEndereco").val(logradouroLimitado);
    //             }else{
    //                 $("#nmEndereco").html(dados.logradouro);
    //                 $("#nmEndereco").val(logradouroLimitado);
    //             }
    //             $("#nmBairro").html(dados.bairro);
    //             $("#nmBairro").val(dados.bairro);
                
    //             $.ajax({
    //                 type: "GET",
    //                 url: "index.php?m=lo&c=ajax&a=find_cidade",
    //                 data: "term=" + removeAcento(dados.localidade)+'&uf='+dados.uf,
    //                 success: function (data) {
    //                     var obj = jQuery.parseJSON(data)[0];
    //                     $('#cd_cidade').html('<option value="' + obj.id + '" selected>' + obj.value + '</option>').trigger('change');
    //                 }
    //             });
    //         } //end if.
    //         else {
    //             //CEP pesquisado no foi encontrado.
    //             $(this).val(null);
    //             $('#cepDesconhecido').html('<a href="https://viacep.com.br/cep/" target="_blank">No encontrou o CEP?</a>');
    //             alert("CEP no encontrado.");
    //             $("[name='cd_cidade']").attr("required", true);
    //         }
    //     })
    // });
    
    $('.editable-click-select').on('click', function () {
        $('#divCidade').show();
        $('#linkCidade').hide();
    });

    $("#divCidade").on('change', function () {

        var cd_cidade = $('#cdCidade').val();
        var nm_cidade = $('#cdCidade option:selected').text();
        var idPessoa = $('#linkCidade').attr('idPessoa');
        var ciAnterior = $('#linkCidade').attr('ciAnterior');
        var idContrato = $('#linkCidade').attr('idContrato');

        $.ajax({
            type: 'POST',
            url: '?m=cobranca&c=cobranca&a=editar&cdCidade='+cd_cidade+'&idPessoa='+idPessoa+'&valAntigo='
                +ciAnterior+'&valNovo='+nm_cidade+'&idContrato='+idContrato,
            data: cd_cidade,
            success: function (response) {
                $('#divCidade').hide();
                $('#linkCidade').show();
                $('#linkCidade').html(nm_cidade);
            }
        });
    });

    $("#vlMulta,#vlJuros,#valor_desconto,#vlAcrescimo").on('blur', function () {

        var vlMulta = ($("#vlMulta").val() == '' || $("#vlMulta").val() == 0) ? 0 : moeda2float($("#vlMulta").val()),
            vlJuros = ($("#vlJuros").val() == '' || $("#vlJuros").val() == 0) ? 0 : moeda2float($("#vlJuros").val()),
            acrescimo = ($("#vlAcrescimo").val() == '' || $("#vlAcrescimo").val() == 0) ? 0 : moeda2float($("#vlAcrescimo").val()),
            desconto = ($("#valor_desconto").val() == '' || $("#valor_desconto").val() == 0) ? 0 : moeda2float($("#valor_desconto").val()),
            vlTitulo = ($("#vlTitulo").val() == '' || $("#vlTitulo").val() == 0) ? 0 : moeda2float($("#vlTitulo").val());

        if (vlMulta < 0) {
            alert('O valor da multa no pode ser negativo.');
            $("#vlMulta").focus();
        } else {
            var vlTotal = vlMulta + vlJuros + vlTitulo;
            $(".vlAtualParcela").val('R$ ' + float2moeda(vlTotal + acrescimo - desconto));
            $("#vlAtualParcela").val(float2moeda(vlTotal));
        }
    });
    // Ao criada para no fazer um submit, mas sim um verificar completamente por AJAX.
    $('#btnGerar').on('click', function (e) {
        if($("#descontoBoleto").val() == 'S'){
            $("#vlAtualParcela").val($("#vlTitulo").val());
        }
        
        var parcelas = $('#parcelas').val(),
            idContrato = $('#parcelas').attr('idContrato'),
            $form = $('#form'),
        params = $form.serializeArray(),
            formData = new FormData();

        $.each(params, function (i, val) {
            formData.append(val.name, val.value);
        });

        formData.append('a', getUrl('a'));
        formData.append('id', getUrl('id'));

        $.ajax({
            url: "?m=cobranca&c=cobranca&a=gerarBoleto&parcelas="+parcelas+"&idContrato="+idContrato,
            data: formData,
            cache: false,
            contentType: false,
            processData: false,
            dataType: false,
            type: 'POST',
            success: function (json) {
                console.log(json);
                agendarParcelaComunicacao();
                json = JSON.parse(json);
                window.open('?m=bo&c=emissao&a=gerarBoleto&modelo=C&idsParcelas='+json);
            }
        })
    });

    $("#btnSalvarRelacionamento").on('click', function () {

        $.ajax({
            url: "?m=cobranca&c=cobranca&a=salvaRelacionamento",
            data:
                "idSituacao="+$("#situacao").val()+
                "&tpSituacao="+$.trim($('#situacao option:selected').text())+
                "&data="+$("#data").val()+
                "&dataRetorno="+$("#dataRetorno").val()+
                "&usuario="+$("#usuario").val()+
                "&assunto="+$("#assunto").val()+
                "&idContrato="+$("#idContratoRelacionamento").val(),
            cache: false,
            processData: false,
            type: 'POST',
            success : function (json) {
                var json = JSON.parse(json);
                if (json.dados) {
                    
                    $("#lista_historico").prepend(
                        '<div class="historico">' + 
                            'Data: ' + json.dados['data'] + '<br/>' +
                            'Assunto: ' + json.dados['assunto'] + '<br/>' +
                            'Usurio: ' + json.dados['usuario'] + 
                        '</div>' +
                        '<br/>'
                    );
                        
                    $(window).scrollTop(0);
                    $('.msgSucess').html(json.msg).show();
                    setTimeout(function () {
                        $('.msgSucess').slideUp();
                    }, 5000);
                    //reseta o campo select, fazendo com que o mesmo receba o valor default
                    $('#situacao').val(null).trigger('change');
                    //limpa os campos obrigatrios
                    $('#assunto').val('');
                    $('#dataRetorno').val('');
                    
                } else {
                    $(window).scrollTop(0);
                    $('.msgErros').html(json.msg).show();
                    setTimeout(function () {
                        $('.msgErros').slideUp();
                    }, 5000);
                }
            }
        })
    })

    $('#btnProsseguir').on('click', function(){ 

        /*pega o id da cobrana da url*/
        var sPageURL = window.location.search.substring(1);
        var sURLVariables = sPageURL.split('&');
        for (var i = 0; i < sURLVariables.length; i++)
        {
            var sParameterName = sURLVariables[i].split('=');
            if (sParameterName[0] == 'id')
            {
                var idCobranca = sParameterName[1];
                break;
            }
        }

        $.ajax({
            url: "?m=cobranca&c=cobranca&a=encerramento",
            data:
                "idContrato="+$("#idContrato").html()+
                "&opcaoEncerramento="+$("input[name='opcaoEncerramento']:checked").val()+
                "&idCobranca="+idCobranca+'&idContratoSelect='+$("#idSelectContrato").val(),
            cache: false,
            processData: false,
            type: "POST",
            success : function (json) {
                json = JSON.parse(json);

                if (json['idCobranca']) {
                    window.location.href = "?m=cobranca&c=cobranca&a=iniciar&id="+json.idCobranca;
                } else {
                    $(window).scrollTop(0);
                    $('.msgErros').html('A cobrança, não possui contratos inadimplentes, até o momento').show();
                    setTimeout(function () {
                        $('.msgErros').slideUp();
                    }, 5000);
                    setTimeout(function() {
                        window.location.href = "?m=cobranca&c=cobranca&a=listar";
                    }, 0);
                }
            }
        });
    });

    var input = $('#obs_cobranca');
    input.on('change', function(event) {
        var value = input.val();
        if ($("#idSelectContrato").val() > 0){
            var id_contrato = $("#idSelectContrato").val();
        } else {
            var id_contrato = $("#idContrato").text();
        }
        $.ajax({
            url: "?m=cobranca&c=cobranca&a=obs",
            type: 'POST',
            data: {
                'id_contrato': id_contrato,
                obs_cobranca: value,
            },
        });
    });

    $('#finalizarCobranca').on('click', function () {
        
        var sPageURL = window.location.search.substring(1);
        var sURLVariables = sPageURL.split('&');
        for (var i = 0; i < sURLVariables.length; i++)
        {
            var sParameterName = sURLVariables[i].split('=');
            if (sParameterName[0] == 'idSelectContrato')
            {
                var idContrato = sParameterName[1];
                break;
            }
        }

        var idsParcelasAtrasadas = $("#idsParcelasAtrasadas").html();

        $.ajax({
            url : '?m=cobranca&c=cobrancaIndividual&a=encerramentoCobranca',
            data : 'idContrato=' + idContrato + 
                    '&idsParcelasAtrasadas=' + idsParcelasAtrasadas +
                    '&opcaoEncerramento=' + $("input[name='opcaoEncerramento']:checked").val(),
            cache : false,
            processData : false,
            type : 'POST',
            success : function (json)
            { 
                var json = JSON.parse(json);
                if (json)
                {
                    $(window).scrollTop(0);
                    $('.msgSucess').html('Cobrana realizada com sucesso.').show();
                    setTimeout (function () {
                        $('.msgSucess').slideUp();
                        window.location.replace("?m=cobranca&c=cobrancaIndividual&a=index");
                    }, 5000);
                }
            }
        });
    });

    //esconde os campos da gerao de 2 via da tela de cobrana
    $('[name="gerarBoleto"]').on('ifChecked', function (event) {
        switch ($(this).val()) {
            case 'S':
                $("#divBoleto2ViaCobranca").show();
                if($("#tx_juros").val()> 0){
                    $("#divDescontoBoleto").show();
                }
                $("#divValidaBoleto").show();
                break;
            case 'N':
                $("#divBoleto2ViaCobranca").hide();
                $("#divDescontoBoleto").hide();
                $("#divValidaBoleto").show();
                break;
        }
    });
});

$(function () {
    $('#myTab a:last').tab('show');
});

$('a[data-toggle="tab"]').on('shown.bs.tab', function (e) {
    var target = $(e.target).attr("href");
    if ((target == '#boleto2Via')) {
        $("#divBoleto2ViaCobranca").show()
    } else {
        $("#divBoleto2ViaCobranca").hide();
    }
});

function selectChange(select) {

    if (select.hasClass('parcelas')) {
        
        let searchParams = new URLSearchParams(window.location.search);
        searchParams.has('idSelectContrato');
        let id = searchParams.get('idSelectContrato');
        let idContratoCobrancaColetiva = $("#idContrato").html();
       
        if (select.val()) {
            $.ajax({
                type: "POST",
                url: "index.php?m=cobranca&c=cobranca&a=validaDataBoleto",
                data: "parcelaId=" + parseFloat(select.val()) +
                      "&contratoId=" + id +
                      "&idContratoCobrancaColetiva=" + idContratoCobrancaColetiva +
                      "&tpParcela=" + select.val().replace(/[^a-zA-Z]+/g, ''),
                success: function (response) {
                    var json = JSON.parse(response);
                    
                    if (json.validaBoleto) {
                        $("#divBoleto2ViaCobranca").hide();
                        $("#divValidaBoleto").show();
                    } else {
                        $("#divBoleto2ViaCobranca").show();
                        $("#divValidaBoleto").hide();
                    }
                }
            });
        } 
    }
}

$('#btnCobrancaNegociacao').on('click', function () {
    
    let searchParams = new URLSearchParams(window.location.search);
    searchParams.has('idSelectContrato');
    
    if (searchParams.has('idSelectContrato'))
    {
        var idContrato = searchParams.get('idSelectContrato');
    } else {
        
        if ($('#idContrato').html())
        {
            var idContrato = $('#idContrato').html();
        } else {
            var idContrato = $('#idSelectContrato').val();
        }
    }
    $.ajax({
        url: "?m=cobranca&c=cobranca&a=negociacao&idContrato="+idContrato,
        data: false,
        cache: false,
        contentType: false,
        processData: false,
        type: 'POST',
        success: function (json) {
            json = JSON.parse(json);
            window.open("?m=fin&c=negociacao&a=passo1&idContrato="+json.idContrato+'&idEmpreendimento='+json.idEmpreendimento);
        }
    });
});

$('#btnGerar2Via').on('click', function () {

    // Caso seja marcado para recalcular desconto sob a tabela PRICE no enviar para o boleto o valor do desconto.
    if(document.getElementsByName('descontoBoleto')[0].checked == true){
        $("#vlAtualParcela").val($("#vlTitulo").val());

        if(($('#valor_desconto').val()==0) || ($('#valor_desconto').val()==0)){
            var vlDesconto =0.0001; //desconta um valor irrisrio s para realizar o desconto corretamente
            var vlAcrescimo = 0.0001; //adiciona um valor irrisrio s para realizar o acrescimo corretamente
        }else{
            var vlDesconto = $('#valor_desconto').val();
            var vlAcrescimo = $('#vlAcrescimo').val();
        }
    }else{
        if(($('#valor_desconto').val()==0) || ($('#valor_desconto').val()==0)){
            var vlDesconto =0.0001; //desconta um valor irrisrio s para realizar o desconto corretamente
            var vlAcrescimo = 0.0001; //adiciona um valor irrisrio s para realizar o acrescimo corretamente
        }else{
            var vlDesconto = $('#valor_desconto').val();
            var vlAcrescimo = $('#vlAcrescimo').val();
        }

    }

    var vlAtualParcela = $('#vlAtualParcela').val(),
        novoVencimento = $('#dtNovoVencimento').val().split('/'),
        idContrato = $('#parcelas').attr('idContrato'),
        parcela = $('#parcela2via').val(),
        $form = $('#form'),
        params = $form.serializeArray(),
        formData = new FormData();



        let searchParams = new URLSearchParams(window.location.search);
        searchParams.has('individual');
        let id = searchParams.get('individual');
        
    $.each(params, function (i, val) {
        formData.append(val.name, val.value);
    });

    formData.append('a', getUrl('a'));
    formData.append('id', getUrl('id'));

    novoVencimento = novoVencimento[0]+'/'+novoVencimento[1]+'/'+novoVencimento[2];

    $.ajax({
        url: "?m=cobranca&c=cobranca&a=gerarBoleto2Via&idContrato="+idContrato+'&parcela='+parcela+'&dataVencimento='+novoVencimento+'&individual='+id,
        data: formData,
        cache: false,
        contentType: false,
        processData: false,
        type: 'POST',
        success: function (json) {
            json = JSON.parse(json);

            if (json.msgErros !== null) {
                $(window).scrollTop(0);
                $('.msgErros').html(json.msgErros, 'Selecione uma parcela.').show();
                setTimeout(function () {
                    $('.msgErros').slideUp();
                }, 5000);

            } else {
                json = json.parcela;
                agendarParcelaSegundaViaComunicacao(idContrato,json['id_parcela_contrato']);
                window.open('?m=bo&c=boleto2aVia&a=gerar&modelo=C&2aViaCobranca=1&parcelaContrato='+json['id_parcela_contrato']+'&dataVencimento='+novoVencimento+'&valor_atual='+vlAtualParcela+'&acrescimo='+vlAcrescimo+'&desconto='+vlDesconto);
                $('form').submit();
            }
        }
    });
});

$('#parcela2via').on('change', function(e) {
    
    $('#sim').iCheck('uncheck'); //To uncheck the radio button
    $('#nao').iCheck('check'); //To check the radio button
    $('#dtNovoVencimento').val('');
    $(".reimprimir").hide();
    
    buscaParcela();
});

$('#dtNovoVencimento').on('changeDate blur', function () {
    var data = $('#parcela2via').find(":selected").text().split(" ")[54].split("/");
    var datanova = $("#dtNovoVencimento").val();
    datanova = datanova.split("/");

    var datainversa = data[2]+'-'+data[1]+'-'+data[0];
    datanova = datanova[2]+'-'+datanova[1]+'-'+datanova[0];

    if((new Date(datanova) < new Date(datainversa))&&($("#tx_juros").val() > 0)&&(document.getElementsByName('descontoBoleto')[0].checked == true)){
        descontoboleto(datanova);
    }else{
        $("#desconto").val(0);
        $("#acrescimo").val(0);
        calculaValor(moeda2float($("#vlTitulo").val()), $("#dataParcelaOriginal").val());
    }
});

$('#vlAcrescimo', '#valor_desconto').on('blur', function () {
    buscaParcela();
});

function descontoboleto(data){
    $.ajax({
        type: "POST",
        url: "index.php?m=sc&c=calculoPrice&a=descontoBoleto",
        data: "parcelaId=" + $("#parcela2via").val() + "&data_vencimento="+data,
        success: function (json) {
            json = JSON.parse(json);

            //preenche o valor da parcela fixo e a data da parcela original  guardada em um hidden dataParcelaOriginal

            if (json.desconto) {
                $("#valor_desconto").val(float2moeda(json.desconto));
                //$("#dataParcelaOriginal").val(json.data_vencimento);
                $("#vlAtualDisplay").val('R$ ' + float2moeda(json.vlrfinal));
                $("#vlAtualParcela").val(float2moeda(json.vlrfinal));
            } else $("#valor_desconto").val(0);
        }
    })
}

function buscaParcela() {

    var parcela = $('#parcela2via').val();
    var idContrato = $('#parcela2via').attr('idContrato');
    let searchParams = new URLSearchParams(window.location.search);
    searchParams.has('individual');
    let id = searchParams.get('individual');

    $.ajax({
        url: "?m=cobranca&c=cobranca&a=parcelas2Via&parcelas="+parcela+"&idContrato="+idContrato+"&individual="+id,
        cache: false,
        contentType: false,
        processData: false,
        type: 'POST',
        success: function (json) {
            json = JSON.parse(json);

            if (json.msgErros !== null) {

                $(window).scrollTop(0);
                $('.msgErros').html(json.msgErros).show();
                setTimeout(function () {
                    $('.msgErros').slideUp();
                }, 7000);
                //limpa os campos
                $('#dtNovoVencimento').val('').prop('disabled', true);
                $('#vlMulta').val('').prop('disabled', true);
                $('#vlJuros').val('').prop('disabled', true);
                $('#vlAcrescimo').val('').prop('disabled', true);
                $('#valor_desconto').val('').prop('disabled', true);
                //desabilita o boto de gerar boleto
                $('#btnGerar2Via').prop('disabled', true);
            } else {
                //habilita novamente os campos, caso os mesmos estejam desabilitados
                $('#dtNovoVencimento').val('').prop('disabled', false);
                $('#vlMulta').val('').prop('disabled', false);
                $('#vlJuros').val('').prop('disabled', false);
                $('#vlAcrescimo').val('').prop('disabled', false);
                $('#valor_desconto').val('').prop('disabled', false);
                $('#btnGerar2Via').prop('disabled', false);
                $("#link").attr('href','#');
                $(".reimprimir").hide();

                if (json.parcela['dt_parcela_2avia'] != null) {
                    $(".reimprimir").show();
                    $("#data2aVia").html(getDate(json.parcela['dt_parcela_2avia']));
                    $("#link").attr('href','?m=bo&c=boleto2aVia&a=reimprimir&idParcela='+json.parcela['id_parcela_contrato']+'&modelo=C');
                }
                $('#vlTitulo').val(float2moeda(json.parcela['vl_parcela']));
                $('#vlAtualParcela').val(json.parcela['vl_parcela']);
                $('#tpMulta_vlMulta').val(json.parcela['tp_multa']+'/'+json.parcela['multa']);
                $('#tpJuros_vlJuros').val(json.parcela['tp_juros']+'/'+json.parcela['juros']);

                if (json.parcela['multa']) {
                    $('#vlMulta').val(float2moeda(json.parcela['multa']));
                } else $('#vlMulta').val(float2moeda(0));

                if (json.parcela['juros']) {
                    $('#vlJuros').val(json.parcela['juros']);
                    $("#tx_juros").val(json.parcela['tx_juros']);
                } else $('#vlJuros').val(float2moeda(0));

                if (json.parcela['acrescimo']) {
                    $('#vlAcrescimo').val(json.parcela['acrescimo']);
                } else $('#vlAcrescimo').val(float2moeda(0));

                if (json.parcela['desconto']) {
                    $('#valor_desconto').val(float2moeda(json.parcela['desconto']));
                } else $('#valor_desconto').val(float2moeda(0));

                $('#dataParcelaOriginal').val(json.parcela['dt_parcela']);

                calculaValor(parseFloat(json.parcela['vl_parcela']), json.parcela['dt_parcela']);
            }
        }
    });
}
function enviar(){
    var contrato = $("#idSelectContrato").val();
    if(!contrato){
        contrato= $("#idContrato").html();
    }
    $.ajax({
        url: "?m=comunicacao&c=agendamento&a=agendarCobranca",
        data: {idContrato:contrato,whatsapp:$("input[name=whatsapp]:checked").val(),email:$("input[name=email]:checked").val()},
        type: 'POST',
        success: function (json) {
            json = JSON.parse(json);
            alert(json.status);
            if(json.status!="Agendado"){
                console.log(json.status);
            }
        }
    });
}
function agendarParcelaComunicacao(){
    var contrato = $("#idSelectContrato").val();
    if(!contrato){
        contrato= $("#idContrato").html();
    }
    var parcelas = $('#parcelas').val();
    $('#parcelas').val().every(p =>{
        if(p.length>10){
            p.split(",").forEach( d=>{
                var id_parcela= d;
                var email= $("#email_cliente").html();
                var enviarEmail= $("#enviarEmail").val();
                var nome= $("#nm_pessoa").html();
                var quadra= $("#quadra").html();
                var lote= $("#lote").html();
                var celular= $("#nr_celular_cliente").html();
                var idEmail= $("input[name=emailParcela]:checked").val();
                var idWhatsApp= $("input[name=whatsappParcela]:checked").val();
                var assuntoEmail= "Cobrana";
                var nm_empreendimento = $("#nm_empreendimento").html();
                //$("#status"+id_parcela)[0].innerHTML = "Criando Agendamento";
                $.ajax({
                    url: "?m=comunicacao&c=agendamento&a=agendarParcela",
                    data: {segundaVia:1,id_parcela:id_parcela,data:dataEnvio,celular:celular,email:email,assuntoEmail:assuntoEmail,idEmail:idEmail,idWhatsApp:idWhatsApp,nome:nome,quadra:quadra,lote:lote,nm_empreendimento:nm_empreendimento,banco:$("#idBanco").val(),contrato:contrato},
                    type: 'POST',
                    success: function (json) {
                        json = JSON.parse(json);
                        console.log( json.status+". "+json.limite);
                    }
                });
            });

            return false;
        }
        else{
            var id_parcela= p;
            var email= $("#email_cliente").html();
            var enviarEmail= $("#enviarEmail").val();
            var nome= $("#nm_pessoa").html();
            var quadra= $("#quadra").html();
            var lote= $("#lote").html();
            var celular= $("#nr_celular_cliente").html();
            var idEmail= $("input[name=emailParcela]:checked").val();
            var idWhatsApp= $("input[name=whatsappParcela]:checked").val();
            var assuntoEmail= "Cobrana";
            var nm_empreendimento = $("#nm_empreendimento").html();
            //$("#status"+id_parcela)[0].innerHTML = "Criando Agendamento";
            $.ajax({
                url: "?m=comunicacao&c=agendamento&a=agendarParcela",
                data: {segundaVia:1,id_parcela:id_parcela,data:dataEnvio,celular:celular,email:email,assuntoEmail:assuntoEmail,idEmail:idEmail,idWhatsApp:idWhatsApp,nome:nome,quadra:quadra,lote:lote,nm_empreendimento:nm_empreendimento,banco:$("#idBanco").val(),contrato:contrato},
                type: 'POST',
                success: function (json) {
                    json = JSON.parse(json);
                    alert( json.status+". "+json.limite);
                }
            });
            return true;
        }
    })
}
function agendarParcelaSegundaViaComunicacao(contrato,id_parcela){

    var email= $("#email_cliente").html();
    var enviarEmail= $("#enviarEmail").val();
    var nome= $("#nm_pessoa").html();
    var quadra= $("#quadra").html();
    var lote= $("#lote").html();
    var celular= $("#nr_celular_cliente").html();    
    var idEmail= $("input[name=emailSegundaVia]:checked").val();
    var idWhatsApp= $("input[name=whatsappSegundaVia]:checked").val();
    var assuntoEmail= "Cobrana";
    var nm_empreendimento = $("#nm_empreendimento").html();
    //$("#status"+id_parcela)[0].innerHTML = "Criando Agendamento";
    $.ajax({
        url: "?m=comunicacao&c=agendamento&a=agendarParcela",
        data: {segundaVia:1,id_parcela:id_parcela,data:dataEnvio,celular:celular,email:email,assuntoEmail:assuntoEmail,idEmail:idEmail,idWhatsApp:idWhatsApp,nome:nome,quadra:quadra,lote:lote,nm_empreendimento:nm_empreendimento,banco:$("#idBanco").val(),contrato:contrato},
        type: 'POST',
        success: function (json) {
            json = JSON.parse(json);
            alert( json.status+". "+json.limite);
        }
    });
}
function databrasil(data){
    $dataAtual = data.split('-').reverse().join('/');
    return $dataAtual;
}

function calculaValor(valor, data) {
    //calcula o juros usando os dados do banco do empreendimento
    var multa = $('#tpMulta_vlMulta').val().split('/');
    var juros = $('#tpJuros_vlJuros').val().split('/');

    var tpMulta = multa[0];
    var tpJuros = juros[0];
    var vlMulta = parseFloat(multa[1]);
    var vlJuros = parseFloat(juros[1]);

    var acrescimo = $("#vlAcrescimo").val();
    var desconto = $("#valor_desconto").val();

    //data atual da parcela
    var dtAtual = new Date(data),
        dtNova = $('#dtNovoVencimento').val().split('/');

    dtNova = new Date(dtNova[2]+'-'+dtNova[1]+'-'+dtNova[0]);
    //as duas linhas de cdigo abaixo calculam a deferena entre a data de vencimento atual e a nova
    var diferencaDatas = dtNova.getTime() - dtAtual.getTime(),
        dias = diferencaDatas / (1000 * 3600 * 24);

    if (dias > 0) {
        if (vlMulta) {
            if (tpMulta == 'P') {
                vlMulta = (vlMulta * valor) / 100;
            }
            else if (tpMulta == 'V') {
                vlMulta = vlMulta;
            }
            else vlMulta = 0;

            $("#vlMulta").val(float2moeda(vlMulta));
        } else {
            $("#vlMulta").val('0,00');
        }

        if (juros) {
            if (tpJuros == 'P') {
                vlJuros = (vlJuros * valor) / 100;
            }
            else if (tpJuros == 'V') {
                vlJuros = vlJuros;
            }
            else vlJuros = 0;

            vlJuros = vlJuros * dias;
            $("#vlJuros").val(float2moeda(vlJuros));
        } else {
            $("#vlJuros").val('0,00');
        }
    } else {
        $("#vlJuros").val("0,00");
        $("#vlMulta").val("0,00");
    }

    //atualiza o campo valor atual com a soma dos valores
    if (valor) {
        var valorTotal = parseFloat(valor), valorTotalComDesconto = 0;
        if (vlMulta) valorTotal += parseFloat(moeda2float($("#vlMulta").val()));
        if (vlJuros) valorTotal += parseFloat(moeda2float($("#vlJuros").val()));
        valorTotalComDesconto = valorTotal;

        if (acrescimo) valorTotalComDesconto += parseFloat(moeda2float($("#vlAcrescimo").val()));
        if (desconto) valorTotalComDesconto -= parseFloat(moeda2float($("#valor_desconto").val()));
        $(".vlAtualParcela").val('R$ ' + float2moeda(valorTotalComDesconto));
        $("#vlAtualParcela").val(float2moeda(valorTotal));
    }
}