$(document).ready(function () {

    /**
     * Listar
     *
     */

    var table = $('#TabelaListar').dataTable({


        "autoWidth": true,
        "ajax": $('#TabelaListar').dataTable.pipeline({
            "url": "?m=bo&c=retornoBoletoArquivo&a=listar",
            "pages": 5
        }),
        orderCellsTop: true,
        "columns": [
            {"data": 'codigo'},
            {"data": 'numero'},
            {"data": 'criacao'},
            {"data": 'processamento'},
            {"data": 'cliente'},
            {"data": 'agenConta'},
            {"data": 'banco'},
            {"data": 'arquivo'},
            {"data": 'acoes'}
        ],

        //Define a coluna default que ser ordenada quando abrir a pgina
        "order": [[0, "desc"]],

        //Organiza os botoes, paginao, campos e notificaes
        dom: '<"btnGerar"><"btnAdicionar">lfrtip',

        //Define as opes de quantidade de linhas que apareco na lista
        "lengthMenu": [[10, 25, 50], [10, 25, 50]],

        //Define as colunas que no tero ordenao
        "columnDefs": [
            {
                "orderable": false,
                "targets": -1,
                "searchable": false
            }
        ],

        //Pensonalizando as mensagens que por default so em ingls e formatao de valores
        language: {
            "sEmptyTable": "Nenhum registro encontrado",
            "sInfo": "",
            "sInfoEmpty": "",
            "sInfoFiltered": "",
            "sInfoPostFix": "",
            "sInfoThousands": ".",
            "sLengthMenu": "_MENU_",
            "sLoadingRecords": "Carregando...",
            "sProcessing": "Processando...",
            "sZeroRecords": "Nenhum registro encontrado",
            "sSearch": "Busca",
            "oPaginate": {
                "sNext": "Prximo",
                "sPrevious": "Anterior",
                "sFirst": "Primeiro",
                "sLast": "ltimo"
            },
            "oAria": {
                "sSortAscending": ": Ordenar colunas de forma ascendente",
                "sSortDescending": ": Ordenar colunas de forma descendente"
            },

            "decimal": ",",
            "thousands": "."
        }
    });

    //Boto "Adicionar" da listagem de todas telas
    var btnAdicionar = '<a class="btn btn-success" href="?m=bo&c=retornoBoletoArquivo&a=gerar"><i class="icon-publish"></i> Processar</a>';
    $("div.btnAdicionar").html(btnAdicionar);

    $('#TabelaListar thead tr:eq(1) th').each(function (i) {
        title = $(this).text();
        if (title == 'Cd.' || title == 'N' || title == 'Criao' || title == 'Processado' || title == 'Cliente' || title == 'Conta' || title == 'Banco' || title == 'Arquivo') {
            var search = '<input hide type="text" class="form-control input-sm" style="width:100%" placeholder="' + title + '" />';
        } else {
            var search = '';
        }
        $(this).html('');
        $(search).appendTo(this).keyup(function(){table.fnFilter($(this).val(),i)})
    });
    
    $('thead tr').last().hide();
    $('.dataTables_filter').after('<a href="#" class="btn btn-sm btn-default" onClick="hide()">Busca Avanada</a>');

});

function hide() {
    $('thead tr').last().toggle('1000');
}