$(document).ready(function () {

    $('#arquivo').on('change', function () {
        $("#infoLoading").show();
        fileData = event.target.files; // para apenas 1 arquivo
        fdata = new FormData();
        fdata.append(0, fileData[fileData.length - 1]);
        $.ajax({
            url: "?m=bo&c=retornoBoletoArquivo&a=verificaRetorno",
            type: 'POST',
            data: fdata,
            dataType: "json",
            processData: false,
            contentType: false,
            async: true,
            success: function (json) {
                if (!json['erro']) {
                    var diaGeracao = json['header'].data_geracao_arq.substring(0,2),
                        mesGeracao = json['header'].data_geracao_arq.substring(2,4),
                        anoGeracao = json['header'].data_geracao_arq.substring(4,8),
                        horaGeracao = json['header'].hora_geracao_arq.substring(0,2),
                        minGeracao = json['header'].hora_geracao_arq.substring(2,4),
                        segGeracao = json['header'].hora_geracao_arq.substring(4,6);
                    
                    if (json['banco']) {
                        $('#status').html('<span class="label label-success">Banco Cadastrado no Sistema</span>');
                        $("#btnProcessar").attr("disabled", false);
                    } else {
                        $('#status').html('<span class="label label-danger">Banco No Cadastrado no Sistema</span>');
                    }

                    $('#banco').html(json['header'].nome_banco);
                    
                    //$('#layout').html('Cod: '+json['header'].cod_layout+' - Nome: '+json['header'].arq_layout_rem['nm_layout']);

                    $('#cod_layout').val(json['header'].cod_layout);
                    $('#codBanco').html(json['header'].banco);
                    $('#cd_banco').val(json['header'].banco);
                    $('#nomeEmpresa').html(json['header'].nome_empresa);
                    $('#dvAgencia').html('-'+json['header'].dv_agencia);
                    $('#dataGeracao').html(diaGeracao+'/'+mesGeracao+'/'+anoGeracao+' '+horaGeracao+':'+minGeracao+':'+segGeracao);
                    $("#infoArquivo").show('fast');
                    $('#msgErro').html(null);
                    $('#conta,#cedente').html(parseInt(json['header'].conta_corrente));
                    
                    if (json['header'].banco != '741')
                        $('#dvConta').html('-'+json['header'].dv_conta);
                    
                    $('#agencia').html(+json['header'].agencia);

                    if (json['header'].banco == '741'){
                        $('#conta,#cedente').html(json.conta_corrente_com_dv);
                        $('#agencia').html(json['header'].agencia);
                    }

                    if (json['header'].banco == '104') {
                        $('#liAgConta').hide();
                        $('#liCedente').show();
                    } else {
                        $('#liAgConta').show();
                        $('#liCedente').hide();
                    }
                } else {
                    $('#msgErro').html('<div class="alert alert-danger alert-dismissable">'+json['erro']+'</div>');
                    $('#infoArquivo').hide();
                }
                $("#infoLoading").hide();
            }
        });
    });

});