$(document).ready(function () {
    /**
     * Listar
     *
     */

    $('#TabelaListar').DataTable({

        "processing": true,
        "ajax": "index.php?m=bo&c=remessa&a=listar",
        "columns": [
            {"data": 'codigo'},
            {"data": 'num_remessa'},
            {"data": 'data'},
            {"data": 'empreendimento'},
            {"data": 'banco'},
            {"data": 'arquivo'},
            {"data": 'status'},
            {"data": 'acoes'}
        ],

        //Define a coluna default que ser ordenada quando abrir a pgina
        "order": [[0, "desc"]],

        //Organiza os botoes, paginao, campos e notificaes
        dom: '<"btnAdicionar">lfrtip',

        //Define as opes de quantidade de linhas que apareco na lista
        "lengthMenu": [[10, 25, 50], [10, 25, 50]],

        //Define as colunas que no tero ordenao
        "columnDefs": [
            {
                "orderable": false,
                "targets": -1,
                "searchable": false
            },
            {
                "className": "dt-center", "targets": [0,1,2,5]
            }
        ],

        //Pensonalizando as mensagens que por default so em ingls e formatao de valores
        language: {
            "sEmptyTable": "Nenhum registro encontrado",
            "sInfo": "",
            "sInfoEmpty": "",
            "sInfoFiltered": "",
            "sInfoPostFix": "",
            "sInfoThousands": ".",
            "sLengthMenu": "_MENU_",
            "sLoadingRecords": "Carregando...",
            "sProcessing": "Processando...",
            "sZeroRecords": "Nenhum registro encontrado",
            "sSearch": "Busca",
            "oPaginate": {
                "sNext": "Prximo",
                "sPrevious": "Anterior",
                "sFirst": "Primeiro",
                "sLast": "ltimo"
            },
            "oAria": {
                "sSortAscending": ": Ordenar colunas de forma ascendente",
                "sSortDescending": ": Ordenar colunas de forma descendente"
            },

            "decimal": ",",
            "thousands": "."
        }
    });

    //Boto "Adicionar" da listagem de todas telas
    var btnAdicionar = '<a class="btn btn-success" href="?m=bo&c=remessa&a=gerarRemessa"><i class="fa fa-plus-circle"></i> Gerar</a>';
    $("div.btnAdicionar").html(btnAdicionar);
});

$(document).on('click', '.btnVisualizar', function () {
    var cdItem = $(this).val();
    $.ajax({
        type: 'POST',
        url: "index.php?m=bo&c=remessa&a=visualizar",
        dataType: 'json',
        data: {cdItem: cdItem},
        success: function (retorno) {
            var status = retorno.tp_status;

            $('#id').html(retorno.nr_remessa);
            $('#empreendimento').html(retorno.nm_empreendimento);
            $('#dtGeracao').html(getDate(retorno.dtGeracao));
            $('#periodo').html(retorno.periodo);
            $('#qtdeRegistros').html(retorno.qtdeRegistros);
            $('#arquivo').html(retorno.arquivo);
            $('#tp_status').html(status);

            $('#TabelaParcelas').DataTable().destroy();
            $('#TabelaParcelas').DataTable({
                data: retorno.parcelas,
                columns: [
                    {data: 'nm_pessoa'},
                    {data: 'lote'},
                    {data: 'quadra'},
                    {data: 'id_contrato'},
                    {data: 'nr_parcela'},
                    {data: 'tp_parcela'},
                    {data: 'dt_parcela'},
                    {data: 'vl_parcela'}
                ],
                //Define a coluna default que ser ordenada quando abrir a pgina
                order: [[4, "asc"]],
                //Define as opes de quantidade de linhas que apareco na lista
                "lengthMenu": [[4, 10, 25, -1], [4, 10, 25, "Todos"]],
                //Pensonalizando as mensagens que por default so em ingls e formatao de valores
                language: {
                    "sEmptyTable": "Nenhum registro encontrado",
                    "sInfo": "",
                    "sInfoEmpty": "",
                    "sInfoFiltered": "",
                    "sInfoPostFix": "",
                    "sInfoThousands": ".",
                    "sLengthMenu": "_MENU_",
                    "sLoadingRecords": "Carregando...",
                    "sProcessing": "Processando...",
                    "sZeroRecords": "Nenhum registro encontrado",
                    "sSearch": "Busca",
                    "oPaginate": {
                        "sNext": "Prximo",
                        "sPrevious": "Anterior",
                        "sFirst": "Primeiro",
                        "sLast": "ltimo"
                    },
                    "oAria": {
                        "sSortAscending": ": Ordenar colunas de forma ascendente",
                        "sSortDescending": ": Ordenar colunas de forma descendente"
                    },
                    "decimal": ",",
                    "thousands": "."
                }
            });
        }
    });

});

function baixarArquivo(id) {
    $.ajax({
        type: "POST",
        url: "index.php?m=bo&c=remessa&a=baixarArquivo",
        data: "id=" + id,
        success: function (response) {
            if (response) {
                if ($("#status_" + id).hasClass('label-warning'))
                    $("#status_" + id).addClass('label-info').removeClass('label-warning').html('Enviar ao Banco');
            }
        }
    });
}
function confirmaEnvio(id) {
    $.ajax({
        type: "POST",
        url: "?m=bo&c=remessa&a=confirmaEnvio",
        data: "id=" + id,
        success: function (response) {
            if (response) {
                if ($("#status_" + id).hasClass('label-info'))
                    $("#status_" + id).addClass('label-success').removeClass('label-info').html('Enviado');
            }
        }
    });
}