$(document).ready(function () {
    //PASSO 2
    $('#TabelaListarRemessa').DataTable({
        "processing": true,

        //Define a coluna default que ser ordenada quando abrir a pgina
        "order": [[4, "asc"]],

        //Organiza os botoes, paginao, campos e notificaes
        dom: '<"btnAdicionar">lfrtip',

        "pageLength": -1,
        "bLengthChange": false,
        "bFilter": false,
        "paging": false,

        //Define as colunas que no tero ordenao
        "columnDefs": [
            {
                "orderable": false,
                "targets": 0,
                "searchable": false
            },
            {
                "orderable": false,
                "targets": -1,
                "searchable": false
            }
        ],

        //Pensonalizando as mensagens que por default so em ingls e formatao de valores
        language: {
            "sEmptyTable": "Nenhum registro encontrado",
            "sInfo": "",
            "sInfoEmpty": "",
            "sInfoFiltered": "",
            "sInfoPostFix": "",
            "sInfoThousands": ".",
            "sLengthMenu": "_MENU_",
            "sLoadingRecords": "Carregando...",
            "sProcessing": "Processando...",
            "sZeroRecords": "Nenhum registro encontrado",
            "sSearch": "Busca",
            "oPaginate": {
                "sNext": "Prximo",
                "sPrevious": "Anterior",
                "sFirst": "Primeiro",
                "sLast": "ltimo"
            },
            "oAria": {
                "sSortAscending": ": Ordenar colunas de forma ascendente",
                "sSortDescending": ": Ordenar colunas de forma descendente"
            },

            "decimal": ",",
            "thousands": "."
        }
    });

    $("#id_contrato").on('change', function() {
        
        if ($('#id_contrato').val() != null)
        {
            var valor = $('#id_contrato').val()[0];

            if (valor == '*' || valor == '')
            {
                $('#id_contrato').removeAttr('multiple');
                //limpa o campos do select
                $("#id_contrato").val([]);
                $("#id_contrato").val(valor);

            } else {
                $('#id_contrato').attr('multiple', 'multiple');
            }
        }
    });
});

//Funo para change do select2 funcionar mais tranquilamente //PASSO 1
function selectChange(select) {
    if (select.hasClass('empreendimento_remessa')) {
        $("select.banco_remessa").html('<option value="">Selecione ...</option>');
        $.ajax({
            type: "POST",
            url: "index.php?m=bo&c=remessa&a=bancoByEmpreendimento",
            data: "id_empreendimento=" + select.val(),
            success: function (response) {
                $("select.banco_remessa").select2({
                    'data': JSON.parse(response),
                    'placeholder': 'Selecione o Banco',
                    'allowClear': true
                });
            }
        });
    }
    if (select.hasClass('banco_remessa')) {
        $("select.contrato_remessa").html('<option value="">Selecione ...</option>');
        $.ajax({
            type: "POST",
            url: "index.php?m=bo&c=remessa&a=contratoByBancoEmpreendimento",
            data: {
                banco: select.val(),
                id_empreendimento: $("#id_empreendimento").val()
            },
            success: function (response) {
                $("select.contrato_remessa").select2({
                    'data': JSON.parse(response),
                    'placeholder': 'Selecione o Contrato',
                    'allowClear': true
                });
            }
        });
    }
}

function buscarParcela(contrato) {
    var table = document.getElementById("TabelaParcelas");
    $.ajax({
        type: "POST",
        url: "index.php?m=bo&c=remessa&a=buscaParcelas",
        data: {
            contrato: contrato,
            dtInicio: $('#dtInicio').val(),
            dtFinal: $('#dtFim').val(),
            banco: $('#banco_remessa').val()
        },
        success: function (data) {
            data = JSON.parse(data);
            while (table.rows.length > 1) {
                table.deleteRow(1);
            }
            $.each(data, function (i, item) {
                var check = 'class="parcela' + parseInt(item.id_parcela_contrato) + '"';
                var parcela = item.id_parcela_contrato;
                var vinculo = 'Desvincular';
                if ($("#parcelasDesvinculadas option[value='" + parseInt(parcela) + "']").length > 0) {
                    check += ' style="color:red;"';
                    vinculo = 'Vincular';
                }
                var conteudo = '';
                conteudo += '<td ' + check + ' align="center">' + parcela + '</td>';
                conteudo += '<td ' + check + ' align="center">' + item.id_contrato + '</td>';
                conteudo += '<td ' + check + ' align="center">' + item.id_parcela + '</td>';
                conteudo += '<td ' + check + ' align="center">' + item.tp_parcela + '</td>';
                conteudo += '<td ' + check + ' align="right">' + float2moeda(item.vl_parcela) + '</td>';
                conteudo += '<td ' + check + ' align="center">' + item.dt_parcela + '</td>';
                conteudo += '<td align="center"><a href="#" onclick="vincularParcela(' + parseInt(item.id_parcela_contrato) + ')"' + '><span id="parcelaAcao' + parseInt(item.id_parcela_contrato) + '">'+ vinculo +'</span></a></td>';

                table.insertRow().innerHTML = conteudo;
            });
            if (table.rows.length == 1)
                table.insertRow(-1).innerHTML = '<td align="center" colspan="7">Nenhuma parcela a ser gerada no perodo</td>';
        }
    });
}

//Salva as parcelas como vinculadas ou no nas remessas
function vincularParcela(parcela) {
    if ($("#parcelaAcao" + parcela).html() == 'Vincular') {
        $(".parcela" + parcela).attr("style", "color:black");
        $("#parcelaAcao" + parcela).html('Desvincular');
        $("#parcelasDesvinculadas option[value='" + parcela + "']").remove();
    } else {
        $(".parcela" + parcela).attr("style", "color:red");
        $("#parcelaAcao" + parcela).html('Vincular');
        $("#parcelasDesvinculadas").append('<option value="' + parcela + '" selected>' + parcela + '</option>');
    }
}

$(document).on('click', '.btnVisualizar', function () {
    buscarParcela($(this).val());
});