$(document).ready(function () {
    
    $('#btnVisualizar').on('click', function (e) {

        var $form = $('#form'),
            params = $form.serializeArray(),
            formData = new FormData();

        $.each(params, function (i, val) {
            formData.append(val.name, val.value);
        });

        $.ajax({
            url: "?m=bo&c=relatorioBoleto&a=visualizar",
            data: formData,
            cache: false,
            contentType: false,
            processData: false,
            type: 'POST',
            beforeSend: function () {
                $('#btnVisualizar').disable = true;
                $('#receiver').empty();
            },
            success: function (json) { 

                if (json == 'false') {

                    var msg = $('#idEmpreendimento'). val() ? '' : 'O empreendimento  obrigatrio.<br>';
                    msg += $('#vencimentoInicial').val() ? '' : 'A data de vencimento inicial  obrigatria.<br>';
                    msg += $('#vencimentoFinal').val() ? '' : 'A data de vencimento final  obrigatria.';

                    $('.msgErros').html(msg).show();
                    setTimeout(function () {
                        $('.msgErros').slideUp();
                    }, 5000);
                } else {     
                    $('#hide-content').css('display', 'block');
                    $('#receiver').html(json);           
                    $('html, body').animate({ scrollTop: $('.row').offset().top }, 'slow');
                }
            }
        });
    });
    
    $('#btnPdf').on('click', function (e) {

        var $form = $('#form'),
            params = $form.serializeArray(),
            formData = new FormData();

        $.each(params, function (i, val) {
            formData.append(val.name, val.value);
        });

        $.ajax({
            url: "?m=bo&c=relatorioBoleto&a=relatorio",
            data: formData,
            cache: false,
            contentType: false,
            processData: false,
            type: 'POST',
            beforeSend: function () {
                $('#btnPdf').disable = true;
                $('#receiver').empty();
            },
            success: function (json) { 

                if (json == 'false') {

                    var msg = $('#idEmpreendimento'). val() ? '' : 'O empreendimento  obrigatrio.<br>';
                    msg += $('#vencimentoInicial').val() ? '' : 'A data de vencimento inicial  obrigatria.<br>';
                    msg += $('#vencimentoFinal').val() ? '' : 'A data de vencimento final  obrigatria.';

                    $('.msgErros').html(msg).show();
                    setTimeout(function () {
                        $('.msgErros').slideUp();
                    }, 5000);
                } else {
                    $("#form").attr('target',  '_blank');   
                    $('form').submit();
                }
            }
        });
    });
})