$(document).ready(function () {

    /**
     * Listar
     *
     */

    var table = $('#TabelaListar').dataTable({


        "autoWidth": true,
        "ajax": $('#TabelaListar').dataTable.pipeline({
            "url": "?m=bo&c=parcelasMigradas&a=listar",
            "pages": 5
        }),
        orderCellsTop: true,
        "columns": [
            {"data": 'codigo'},
            {"data": 'numero'},
            {"data": 'criacao'},
            {"data": 'processamento'},
            {"data": 'cliente'},
            {"data": 'agenConta'},
            {"data": 'banco'},
            {"data": 'arquivo'},
            {"data": 'acoes'}
        ],

        //Define a coluna default que ser ordenada quando abrir a pgina
        "order": [[0, "desc"]],

        //Organiza os botoes, paginao, campos e notificaes
        dom: '<"btnGerar"><"btnAdicionar">lfrtip',

        //Define as opes de quantidade de linhas que apareco na lista
        "lengthMenu": [[10, 25, 50], [10, 25, 50]],

        //Define as colunas que no tero ordenao
        "columnDefs": [
            {
                "orderable": false,
                "targets": [2,3,4],
                "className": "text-center",
                "searchable": false,
            }
        ],

        //Pensonalizando as mensagens que por default so em ingls e formatao de valores
        language: {
            "sEmptyTable": "Nenhum registro encontrado",
            "sInfo": "",
            "sInfoEmpty": "",
            "sInfoFiltered": "",
            "sInfoPostFix": "",
            "sInfoThousands": ".",
            "sLengthMenu": "_MENU_",
            "sLoadingRecords": "Carregando...",
            "sProcessing": "Processando...",
            "sZeroRecords": "Nenhum registro encontrado",
            "sSearch": "Busca",
            "oPaginate": {
                "sNext": "Prximo",
                "sPrevious": "Anterior",
                "sFirst": "Primeiro",
                "sLast": "ltimo"
            },
            "oAria": {
                "sSortAscending": ": Ordenar colunas de forma ascendente",
                "sSortDescending": ": Ordenar colunas de forma descendente"
            },

            "decimal": ",",
            "thousands": "."
        }
    });

    //Boto "Adicionar" da listagem de todas telas
    var btnAdicionar = '<a class="btn btn-success" href="?m=bo&c=parcelasMigradas&a=gerar"><i class="icon-publish"></i> Processar</a>';
    $("div.btnAdicionar").html(btnAdicionar);
});