$(document).ready(function () {
    
    $("form").on('submit', function () {
        $(".button").val("Gerado...");
        $(".button").attr("disabled", true);
        return true;
    });

    $('[name="cd_banco"],[name="arquivo"]').on('change', function () {
        $(".button").val("Gerar Relatrio");
        $(".button").attr("disabled", false);
    });

    $('#arquivo').on('change', function () {
        $("#infoLoading").show();
        var idBanco = $('#bancoMigrada option:selected').val();
        fileData = event.target.files; // para apenas 1 arquivo
        fdata = new FormData();
        fdata.append(0, fileData[fileData.length - 1]);
        
        $.ajax({
            url: "?m=bo&c=parcelasMigradas&a=verificaRetorno&banco="+idBanco,
            type: 'POST',
            data: fdata,
            dataType: "json",
            processData: false,
            contentType: false,
            async: true,
            success: function (json) {
                if (!json['erro']) {
                    var diaGeracao = json['header'].data_geracao_arq.substring(0,2),
                        mesGeracao = json['header'].data_geracao_arq.substring(2,4),
                        anoGeracao = json['header'].data_geracao_arq.substring(4,8),
                        horaGeracao = json['header'].hora_geracao_arq.substring(0,2),
                        minGeracao = json['header'].hora_geracao_arq.substring(2,4),
                        segGeracao = json['header'].hora_geracao_arq.substring(4,6);
                    if (json['banco']) {
                        $('#status').html('<span class="label label-success">Banco Cadastrado no Sistema</span>');
                        $("#btnProcessar").attr("disabled", false);
                    } else {
                        $('#status').html('<span class="label label-danger">Banco No Cadastrado no Sistema</span>');
                    }
                    $('#banco').html(json['header'].nome_banco);
                    $('#codBanco').html(json['header'].banco);
                    $('#nomeEmpresa').html(json['header'].nome_empresa);
                    $('#agencia').html(+json['header'].agencia);
                    $('#dvAgencia').html('-'+json['header'].dv_agencia);
                    $('#conta,#cedente').html(parseInt(json['header'].conta_corrente));
                    $('#dvConta').html('-'+json['header'].dv_conta);
                    $('#dataGeracao').html(diaGeracao+'/'+mesGeracao+'/'+anoGeracao+' '+horaGeracao+':'+minGeracao+':'+segGeracao);
                    $("#infoArquivo").show('fast');
                    $('#msgErro').html(null);
                    if (json['header'].banco == '104') {
                        $('#liAgConta').hide();
                        $('#liCedente').show();
                    } else {
                        $('#liAgConta').show();
                        $('#liCedente').hide();
                    }
                } else {
                    $('#msgErro').html('<div class="alert alert-danger alert-dismissable">'+json['erro']+'</div>');
                    $('#infoArquivo').hide();
                }
                $("#infoLoading").hide();
            }
        });
    });

});