var idBanco;
var lote;
var quadra;
var nm_pessoa;
var email;
var celular;
var listaEmail;
$(document).ready(function () {

    $('[name="modelo"]').on('ifChecked', function (event) {
        var link = $('#link').attr('href').split('&');
        $('#link').attr('href',link[0]+'&'+link[1]+'&'+link[2]+'&'+link[3]+'&modelo='+$(this).val());
    });

    $('[name="gerarBoleto"]').on('ifChecked', function (event) {
        switch ($(this).val()) {
            case 'S':
                $("#fieldDadosBoleto").show();
                    if($("#tx_juros").val()> 0){
                        $("#divDescontoBoleto").show();
                    }
                $("#divOperacoes").show();
                break;
            case 'N':
                $("#fieldDadosBoleto").hide();
                $("#divOperacoes").hide();
                break;
        }
    });

    $("select.parcela2aVia").change(function () {
        $.ajax({
            type: "POST",
            url: "index.php?m=lo&c=ajax&a=parcelaById",
            data: "parcelaId=" + $(this).val() + "&banco=" +$("#banco_boleto2Via").val() + "&empreendimento="+$("#id_empreendimento").val(),
            success: function (json) {
                json = JSON.parse(json);
                quadra = json.quadra;
                lote = json.lote;
                nm_pessoa = json.nm_pessoa;
                email = json.email;
                celular = json.nr_celular; 
                //preenche o valor da parcela fixo e a data da parcela original  guardada em um hidden dataParcelaOriginal
                if (json.vl_parcela) {
                    $(".valor_do_titulo").val(float2moeda(json.vl_parcela));
                } else $("valor_do_titulo").val(0);

                if (json.acrescimo) {
                    $("#acrescimo").val(float2moeda(json.acrescimo));
                } else $("#acrescimo").val(0);

                if (json.desconto) {
                    $("#desconto").val(float2moeda(json.desconto));
                } else $("#desconto").val(0);

                if (json.tx_juros) {
                    $("#tx_juros").val(json.tx_juros);
                } else $("#tx_juros").val(0);

                if(json.dt_parcela_2avia != ""){
                    $(".reiprimir").show();
                    $("#data2aVia").html(getDate(json.dt_parcela_2avia));
                    $("#link").attr('href','?m=bo&c=boleto2aViaMulti&a=reimprimir&idParcela='+json.id_parcela_contrato+'&modelo='+$('[name="modelo"]:checked').val());
                }else{
                    $("#link").attr('href','#');
                    $(".reiprimir").hide();
                }

                if(json.validaBoleto == true) {
                    $("#divValidaBoleto").show();
                    $("#fieldDadosBoleto").hide();
                    $("#divOperacoes").hide();
                } else {
                    $("#divValidaBoleto").hide();
                    $("#fieldDadosBoleto").show();
                    $("#divOperacoes").show();
                }

                $("#dataParcelaOriginal").val(json.dt_parcela);

                calculaValor(json.vl_parcela, json.dt_parcela);
            }
        })
    });

    $("#dataVencimento").on('blur changeDate', function (){
        // var data = document.getElementById('dataVencimento').value;
        var data = $('.parcela2aVia').find(":selected").text().split(" ")[6];
        var datanova = $("#dataVencimento").val();

        data = data.split("/");
        datanova = datanova.split("/");

        data = data[2]+'-'+data[1]+'-'+data[0];
        datanova = datanova[2]+'-'+datanova[1]+'-'+datanova[0];

        if((new Date(datanova) < new Date(data))&&($("#tx_juros").val() > 0)&&(document.getElementsByName('descontoBoleto')[0].checked == true)){
            descontoboleto(datanova);
        }else{
            $("#desconto").val(0);
            $("#acrescimo").val(0);
            calculaValor(moeda2float($("#vlTitulo").val()), $("#dataParcelaOriginal").val());
        }

    });



    //Boletos da segunda via
    $("#vl_multa2Boleto,#vl_juros2Boleto,#desconto,#acrescimo").blur(function () {

        var vlMulta = ($("#vl_multa2Boleto").val() == '' || $("#vl_multa2Boleto").val() == 0) ? 0 : moeda2float($("#vl_multa2Boleto").val()),
            vlJuros = ($("#vl_juros2Boleto").val() == '' || $("#vl_juros2Boleto").val() == 0) ? 0 : moeda2float($("#vl_juros2Boleto").val()),
            acrescimo = ($("#acrescimo").val() == '' || $("#acrescimo").val() == 0) ? 0 : moeda2float($("#acrescimo").val()),
            desconto = ($("#desconto").val() == '' || $("#desconto").val() == 0) ? 0 : moeda2float($("#desconto").val()),
            vlTitulo = ($(".valor_do_titulo").val() == '' || $(".valor_do_titulo").val() == 0) ? 0 : moeda2float($(".valor_do_titulo").val());

        if (vlMulta < 0) {
            alert('O valor da multa no pode ser negativo.');
            $("#vl_multa2Boleto").focus();
        } else {
            var vlTotal = vlMulta + vlJuros + vlTitulo;
            $(".valor_atual").val('R$ ' + float2moeda(vlTotal + acrescimo - desconto));
            $("#valor_atual").val(float2moeda(vlTotal));
        }
    });

    //Boletos da segunda via
    $("#reimprimir").click(function () {
        if ($('#parcela2aVia').val() != '')
            window.open('?m=bo&c=boleto2aViaMulti&a=reimprimir&idParcela=' + $('#parcela2aVia').val(), '_blank');
    });

    $('#gerar').on('click', function (e) {
        if(document.getElementsByName('descontoBoleto')[0].checked == true){
            $("#valor_atual").val($("#vlTitulo").val());
        }

        var $form = $('#form'),
            params = $form.serializeArray(),
            formData = new FormData();

        $.each(params, function (i, val) {
            formData.append(val.name, val.value);
        });

        $.ajax({
            url: "?m=bo&c=boleto2aViaMulti&a=validar",
            data: formData,
            cache: false,
            contentType: false,
            processData: false,
            type: 'POST',
            beforeSend: function () {
                $('#gerar').disable = true;
            },
            success: function (json) {
                json = JSON.parse(json);
                if (json.msgErros) {
                    $('.msgErros').html(json.msgErros).show();
                    setTimeout(function () {
                        $('.msgErros').slideUp();
                    }, 5000);
                } else{
                    /*var idEmail = $("#enviarEmail").val();
                    var idWhatsApp = $("#enviarWhatsApp").val();
                    if(idEmail||idWhatsApp){
                        var id_parcela= $("#parcela2aVia").val();
                        var contrato = $("#id_contrato").val();
                        var nm_empreendimento = $("#id_empreendimento").select2('data')[0].text;
                        var data= $("#dataVencimento").val();
                        $.ajax({
                            url: "?m=comunicacao&c=agendamento&a=agendarParcela",
                            data: {contrato:contrato,idWhatsApp:idWhatsApp,celular:celular,id_parcela:id_parcela,nm_empreendimento:nm_empreendimento,banco:idBanco,data:data,quadra:quadra,lote:lote,idEmail:idEmail,nome:nm_pessoa,email:email,segundaVia:1},
                            type: 'POST',
                            success: function (json) {
                                $('form').submit();
                                json = JSON.parse(json);
                                console.log(json);
                                alert(json.status+". "+json.limite);
                                
                            },
                            error: function (jqXHR, textStatus, errorThrown) { 
                                $('form').submit();
                                alert("Falha ao agendar segunda via");
                            }
                        });
                        //console.log($("#listaEmails > tbody > tr:nth-child("+i+") > th")[0].textContent);
                    }
                    else{*/
                        $('form').submit();
                    //}
                }
            }
        })
    })
});
function databrasil(data){
    $dataAtual = data.split('-').reverse().join('/');
    return $dataAtual;
}
function descontoboleto(data){
    $.ajax({
        type: "POST",
        url: "index.php?m=sc&c=calculoPrice&a=descontoBoleto",
        data: "parcelaId=" + $("#parcela2aVia").val() + "&data_vencimento="+data+"&banco=" +$("#banco_boleto2Via").val() + "&empreendimento="+$("#id_empreendimento").val(),
        success: function (json) {
            var data = new Date();
            json = JSON.parse(json);

            //preenche o valor da parcela fixo e a data da parcela original  guardada em um hidden dataParcelaOriginal

            if (json.desconto) {
                $("#desconto").val(float2moeda(json.desconto));
                //$("#dataParcelaOriginal").val(json.data_vencimento);
                $("#vlAtualDisplay").val('R$ ' + float2moeda(json.vlrfinal));
                $("#valor_atual").val(float2moeda(json.vlrfinal));
            } else $("#desconto").val(0);
        }
    })
}

//Funo para change do select2 funcionar mais tranquilamente
function selectChange(select) {
    if (select.hasClass('empreendimento_boleto2aVia')) {
        $("select.contrato_boleto2aVia").html('<option value="">Selecione ...</option>');
        $("#banco_boleto2Via").html('<option value="">Selecione ...</option>');
        $.ajax({
            type: "POST",
            url: "index.php?m=bo&c=boleto2aViaMulti&a=loteClienteByEmpreendimento",
            data: "id_empreendimento=" + select.val(),
            success: function (response) {
                $("select.contrato_boleto2aVia").select2({
                    'data': JSON.parse(response),
                    'placeholder': 'Selecione o Contrato',
                    'allowClear': true
                });
            }
        });
        $("#link").attr('href','#');
        $(".reiprimir").hide();
    }

    if (select.hasClass('contrato_boleto2aVia')) {
        $.ajax({
            type: "POST",
            url: "index.php?m=bo&c=boleto2aViaMulti&a=bancoByEmp",
            data: "empreendimento=" + $('.empreendimento_boleto2aVia').val(),
            success: function (response) {
                var resposta = JSON.parse(response),
                bancoInativo = false;

                $.each(resposta,function(index, value) {
                    //Criado condio para verificar se o banco est ativo
                    if (value.flAtivo == 0) {
                        bancoInativo = true;
                        //Deleta o banco inativo da lista
                        resposta[index] = null;
                    }
                });
                
                $("#banco_boleto2Via").attr('disabled', false);

                $("#banco_boleto2Via").select2({
                    'data': resposta,
                    'placeholder': 'Selecione o Banco',
                    'allowClear': true
                });

                if (bancoInativo) {
                    // alert('Existe bancos inativos que no sero listados.');
                }
            }
        });
    }

    if (select.hasClass('banco_boleto2Via')) {
        $.ajax({
            type: "POST",
            url: "index.php?m=bo&c=boleto2aViaMulti&a=findBanco",
            data: "banco=" + select.val(),
            success: function (response) {
                var resposta = JSON.parse(response);

                $("#vlMulta").val(resposta[0].multa);
                $("#vlJuros").val(resposta[0].juros);
                $("#tpMulta").val(resposta[0].tp_multa);
                $("#tpJuros").val(resposta[0].tp_juros);
            }
        });
        
        $("select.parcela2aVia").html('<option value="">Selecione ...</option>');
        $.ajax({
            type: "POST",
            url: "index.php?m=bo&c=boleto2aViaMulti&a=parcelaByContrato2Via",
            data: "contrato=" + $('#id_contrato').val(),
            success: function (response) {
                var json = JSON.parse(response);

                $("select.parcela2aVia").attr('disabled', false);

                //Criado condio para verificar se h parcelas no contrato
                if (json.parcelas != '' && json.fl_ativo == 1) {
                    $("select.parcela2aVia").attr('disabled', false);
                    $("select.parcela2aVia").select2({
                        'data': json.parcelas,
                        'placeholder': 'Selecione a Parcela',
                        'allowClear': true
                    });
                } else if (json.parcelas == '' && json.fl_ativo == 1) {
                    alert('No h parcelas neste contrato');
                    $("select.parcela2aVia").select2.defaults.reset();
                    $("select.parcela2aVia").attr('disabled', true);
                    $(".reiprimir").hide();
                } else {
                    $("select.parcela2aVia").select2.defaults.reset();
                    $("select.parcela2aVia").attr('disabled', true);
                    $(".reiprimir").hide();
                }
            }
        });
    }
}

function calculaValor(valor, data) {
    //calcula o juros usando os dados do banco do empreendimento
    var multa = $("#vlMulta").val();
    var juros = $("#vlJuros").val();
    var tpMulta = $("#tpMulta").val();
    var tpJuros = $("#tpJuros").val();
    var acrescimo = $("#acrescimo").val();
    var desconto = $("#desconto").val();

    var dias = diferencaDatasDias(($("#dataVencimento").val()), data);
    if (dias > 0) {
        if (multa) {
            if (tpMulta == 'P') {
                multa = multa * 0.01 * valor;
            }
            $("#vl_multa2Boleto").val(float2moeda(multa));
        } else $("#vl_multa2Boleto").val('0,00');
        if (juros) {
            if (tpJuros == 'P') {
                juros = juros * 0.01 * valor;
            }
            juros = juros * dias;
            $("#vl_juros2Boleto").val(float2moeda(juros));
        } else {
            $("#vl_juros2Boleto").val('0,00');
        }
    } else {
        $("#vl_juros2Boleto").val('0,00');
        $("#vl_multa2Boleto").val('0,00');
    }

    //atualiza o campo valor atual com a soma dos valores
    if (valor) {
        var valorTotal = parseFloat(valor),
            valorTotalComDesconto = 0;
        if (multa) valorTotal += parseFloat(moeda2float($("#vl_multa2Boleto").val()));
        if (juros) valorTotal += parseFloat(moeda2float($("#vl_juros2Boleto").val()));
        valorTotalComDesconto = valorTotal;
        if (acrescimo) valorTotalComDesconto += parseFloat(moeda2float($("#acrescimo").val()));
        if (desconto) valorTotalComDesconto -= parseFloat(moeda2float($("#desconto").val()));
        $("#vlAtualDisplay").val('R$ ' + float2moeda(valorTotalComDesconto));
        $("#valor_atual").val(float2moeda(valorTotal));
    }
}
$( "#link" ).on( "click", function() {
    try{
        var idEmail = $("#enviarEmail").val();
        var idWhatsApp = $("#enviarWhatsApp").val();
        if(idEmail||idWhatsApp){
            var id_parcela= $("#parcela2aVia").val();
            var contrato = $("#id_contrato").val();
            var nm_empreendimento = $("#id_empreendimento").select2('data')[0].text;
            var data=$("option[value="+id_parcela+"]").html().split(" ")[6].split("/").reverse().join("-");
            $.ajax({
                url: "?m=comunicacao&c=agendamento&a=agendarParcela",
                data: {contrato:contrato,id_parcela:id_parcela,idWhatsApp:idWhatsApp,celular:celular,nm_empreendimento:nm_empreendimento,banco:idBanco,data:data,quadra:quadra,lote:lote,idEmail:idEmail,nome:nm_pessoa,email:email,segundaVia:1},
                type: 'POST',
                success: function (json) {
                    json = JSON.parse(json);
                    alert(json.status+". "+json.limite);
                },
                error: function (jqXHR, textStatus, errorThrown) { 
                    $('form').submit();
                    alert("Falha ao agendar segunda via");
                }
            });
        }
    }
    catch (e) {
        console.log(e);
    }
});
