$(document).ready(function () {

    /**
     * Listar
     *
     */
    $.when( carregaDados() ).done(function( thisTable ) {
        inputAvanc(thisTable, true)
    });
});

//Carregas os contratos ao selecionar o filtro
function carregaDados() {
    //se a tabela j tiver sido inicializada, recarrega ajax
    var table = $('#TabelaListar').dataTable({
        "processing": true,
        "ajax": $('#TabelListar').dataTable.pipeline({
            "url": "index.php?m=adm&c=transferenciaLotes&a=listar",
            "pages": 3
        }),
        destroy: true,
        orderCellsTop: true,
        "columns": [
            {"data": 'data'},
            {"data": 'empreendimento'},
            {"data": 'contrato'},
            {"data": 'loteOrigem'},
            {"data": 'loteDestino'},
            {"data": 'cedente'},
            {"data": 'acoes'}
        ],

        //Define a coluna default que ser� ordenada quando abrir a p�gina
        "order": [[0, "desc"]],

        //Organiza os botoes, pagina��o, campos e notifica��es
        dom: '<"btnAdicionar">lfrtip',

        //Define as op��es de quantidade de linhas que aparec�o na lista
        "lengthMenu": [[10, 25, 50], [10, 25, 50]],

        //Define as colunas que n�o ter�o ordena��o
        "columnDefs": [
            {
                "orderable": false,
                "targets": -1,
                "searchable": false
            }
        ],

        //Pensonalizando as mensagens que por default s�o em ingl�s e formata��o de valores
        language: {
            "sEmptyTable": "Nenhum registro encontrado",
            "sInfo": "",
            "sInfoEmpty": "",
            "sInfoFiltered": "",
            "sInfoPostFix": "",
            "sInfoThousands": ".",
            "sLengthMenu": "_MENU_",
            "sLoadingRecords": "Carregando...",
            "sProcessing": "Processando...",
            "sZeroRecords": "Nenhum registro encontrado",
            "sSearch": "Busca",
            "oPaginate": {
                "sNext": "Prximo",
                "sPrevious": "Anterior",
                "sFirst": "Primeiro",
                "sLast": "ltimo"
            },
            "oAria": {
                "sSortAscending": ": Ordenar colunas de forma ascendente",
                "sSortDescending": ": Ordenar colunas de forma descendente"
            },

            "decimal": ",",
            "thousands": "."
        }
    });
    //Boto "Adicionar" da listagem de todas telas
    var btnAdicionar = '<a class="btn btn-success" href="?m=adm&c=transferenciaLotes&a=adicionar"><i class="fa fa-plus-circle"></i> Adicionar</a>';
    $("div.btnAdicionar").html(btnAdicionar);

    return table;   
}

function hide() {
    $('thead tr').last().toggle('1000');
}

function inputAvanc(table, first) {
    $(document).ready(function () {
        // Busca avanada
        $('#TabelaListar thead tr:eq(1) th').each(function (i) {
            title = $(this).text();
            if (title == 'Data' || title == 'Empreendimento' || title == 'Lote Origem' || title == 'Lote Destino' || title == 'Cedente') {
                var search = '<input hide type="text" class="form-control input-sm" style="width:100%" placeholder="' + title + '" />';            
            } else {
                var search = '';
            }
            if (first) {
                $(this).html('');
            }
            // Apply the filter
            $(search).appendTo(this).keyup(function(){table.fnFilter($(this).val(),i)})
        });

        $('thead tr').last().hide();
        $('.dataTables_filter').after('<a href="#" class="btn btn-sm btn-default" onClick="hide()">Busca Avanada</a>');
    });
}