$(document).ready(function () {
    $('#doGerarWord').hide();
    /**
     * Listar
     *
     */
    $.when( carregaDados() ).done(function( thisTable ) {
        inputAvanc(thisTable, true)
    });

    function carregaDados() {
        var table = $('#TabelaListar').dataTable({
            "ajax": $('#TabelaListar').dataTable.pipeline({
                "url": "index.php?m=adm&c=transferencia&a=listar",
                "pages": 5
            }),    
            destroy: true,
            orderCellsTop: true,        
            "columns": [
                {"data": 'data'},
                {"data": 'empreendimento',"width": "18%"},
                {"data": 'contrato'},
                {"data": 'quadra'},
                {"data": 'lote'},
                {"data": 'cedente',"width": "16%"},
                {"data": 'cessionario',"width": "18"},
                {"data": 'status'},
                {"data": 'acoes'}
            ],
    
            //Define a coluna default que ser ordenada quando abrir a pgina
            "order": [[0, "desc"]],
    
            //Organiza os botoes, paginao, campos e notificaes
            dom: '<"btnAdicionar">lfrtip',
    
            //Define as opes de quantidade de linhas que apareco na lista
            "lengthMenu": [[10, 25, 50], [10, 25, 50]],
    
            //Define as colunas que no tero ordenao
            "columnDefs": [
                {
                    "orderable": false,
                    "targets": -1,
                    "searchable": false
                }
            ],
    
            //Pensonalizando as mensagens que por default so em ingls e formatao de valores
            language: {
                "sEmptyTable": "Nenhum registro encontrado",
                "sInfo": "",
                "sInfoEmpty": "",
                "sInfoFiltered": "",
                "sInfoPostFix": "",
                "sInfoThousands": ".",
                "sLengthMenu": "_MENU_",
                "sLoadingRecords": "Carregando...",
                "sProcessing": "Processando...",
                "sZeroRecords": "Nenhum registro encontrado",
                "sSearch": "Busca",
                "oPaginate": {
                    "sNext": "Prximo",
                    "sPrevious": "Anterior",
                    "sFirst": "Primeiro",
                    "sLast": "ltimo"
                },
                "oAria": {
                    "sSortAscending": ": Ordenar colunas de forma ascendente",
                    "sSortDescending": ": Ordenar colunas de forma descendente"
                },
    
                "decimal": ",",
                "thousands": "."
            }        
        });
        return table;
    }

    //Boto "Adicionar" da listagem de todas telas
    var btnAdicionar = '<a class="btn btn-success" href="?m=adm&c=transferencia&a=adicionar"><i class="fa fa-plus-circle"></i> Adicionar</a>';
    $("div.btnAdicionar").html(btnAdicionar);

});

function hide() {
    $('thead tr').last().toggle('1000');
}

function inputAvanc(table, first) {
    $(document).ready(function () {
        // Busca avanada
        $('#TabelaListar thead tr:eq(1) th').each(function (i) {
            title = $(this).text();
            if (title == 'Empreendimento' || title == 'Quadra' || title == 'Lote' || title == 'Cedente' || title == 'Cessionrio') {
                var search = '<input hide type="text" class="form-control input-sm" style="width:100%" placeholder="' + title + '" />';            
            } else {
                var search = '';
            }
            if (first) {
                $(this).html('');
            }
            // Apply the filter
            $(search).appendTo(this).keyup(function(){table.fnFilter($(this).val(),i)})
        });

        $('thead tr').last().hide();
        $('.dataTables_filter').after('<a href="#" class="btn btn-sm btn-default" onClick="hide()">Busca Avanada</a>');
    });
}

function gerarPago(id) {
    $('#idTipo').val(id);
    $('#idTransferencia').val(id);

    $('[name="modalTipoEmissao"]').on('ifChecked', function () {
        switch ($(this).val()) {
            case 'P':
                $('#divTransferenciaPago').show();
                $('#divArquivoWord').hide();
                $('#doGerarPago').show();
                $('#doGerarWord').hide();
                break;
            case 'A':
                $('#divArquivoWord').show();
                $('#divTransferenciaPago').hide();
                $('#doGerarPago').hide();
                $('#doGerarWord').show();
                break;
        }
    });
}
$('#doGerarWord').on('click', function (e) {
    var modeloWord = $('#cdArquivo option:selected').val();
    idTransferencia = $('#idTransferencia').val();

    window.open('index.php?m=adm&c=transferencia&a=imprimeWord&id='+ idTransferencia + '&modelo=' + modeloWord);
});

$('#doGerarPago').on('click', function (e) {
    var incluirPago = $("input[name='modalValorPago']:checked").val(),
        idTransferencia = $('#idTransferencia').val();
    
    window.open('index.php?m=adm&c=transferencia&a=imprime&id='+ idTransferencia 
    + '&incluirPago=' + incluirPago, '_blank');
        
});
function confirmarRecebimento(evento, id){
    evento.style.display="none";
    $("#status_"+id).html("Carregando...");
    $("#status_"+id)[0].style.backgroundColor="#6c757d";
    var form = new FormData();
    
    form.append("id", id);

    var settings = {
    "url": "?m=adm&c=transferencia&a=confirmaRecebimento",
    "method": "POST",
    "timeout": 0,
    "processData": false,
    "mimeType": "multipart/form-data",
    "contentType": false,
    "data": form
    };

    $.ajax(settings).done(function (response) {
        var obj = JSON.parse(response);
        if(obj.msg == "success"){
            $("#status_"+obj.id).html("Confirmado");
            $("#status_"+obj.id)[0].style.backgroundColor="#65BBD6";
        }
        else{
            $("#status_"+obj.id).html("Erro!");
            $("#status_"+obj.id)[0].style.backgroundColor="#dc3545";
        }
    }); 
}