$(document).ready(function () {

    $('#TabelaListar').DataTable({
        "processing": true,
        "ajax": {
            'url': "index.php?m=adm&c=relacionamentoAgendamento&a=listar",
            'type': "POST",
            'data': function (data) {
                data.keepIdEmpreendimento = $("#keepIdEmpreendimento").val();
            }
        },
        "columns": [
            {"data": 'data'},
            {"data": 'quadra'},
            {"data": 'lote'},
            {"data": 'contrato'},
            {"data": 'pessoa'},
            {"data": 'assunto'},
            {"data": 'acoes'}
        ],

        //Define a coluna default que ser ordenada quando abrir a pgina
        "order": [[0, "desc"]],

        //Organiza os botoes, paginao, campos e notificaes
        dom: '<"btnAdicionar">lfrtip',

        //Define as opes de quantidade de linhas que apareco na lista
        "lengthMenu": [[10, 25, 50], [10, 25, 50]],

        //Define as colunas que no tero ordenao
        "columnDefs": [
            {
                "orderable": false,
                "targets": -1,
                "searchable": false
            }
        ],

        //Pensonalizando as mensagens que por default so em ingls e formatao de valores
        language: {
            "sEmptyTable": "Selecione um empreendimento para listar os contatos",
            "sInfo": "",
            "sInfoEmpty": "",
            "sInfoFiltered": "",
            "sInfoPostFix": "",
            "sInfoThousands": ".",
            "sLengthMenu": "_MENU_",
            "sLoadingRecords": "Carregando...",
            "sProcessing": "Processando...",
            "sZeroRecords": "Nenhum registro encontrado",
            "sSearch": "Busca",
            "oPaginate": {
                "sNext": "Prximo",
                "sPrevious": "Anterior",
                "sFirst": "Primeiro",
                "sLast": "ltimo"
            },
            "oAria": {
                "sSortAscending": ": Ordenar colunas de forma ascendente",
                "sSortDescending": ": Ordenar colunas de forma descendente"
            },

            "decimal": ",",
            "thousands": "."
        }
    });

    $('#dataRet').on('changeDate blur', function () {
        $("#btnSalvaAgendamento").attr('href', $("#btnSalvaAgendamento").attr('href') + '&novaData=' + $('#dataRet').val());
    });

    var btnModelTutorial = ' <span data-toggle="modal" data-target=".mVisualizar" style="font-size: 22px;" data-toggle="tooltip" data-placement="top" title="Assista ao tutorial">'+
                            '<svg xmlns="" width="22" height="22" fill="currentColor" class="bi bi-youtube" viewBox="0 0 16 16">'+
                                '<path d="M8.051 1.999h.089c.822.003 4.987.033 6.11.335a2.01 2.01 0 0 1 1.415 1.42c.101.38.172.883.22 1.402l.01.104.022.26.008.104c.065.914.073 1.77.074 1.957v.075c-.001.194-.01 1.108-.082 2.06l-.008.105-.009.104c-.05.572-.124 1.14-.235 1.558a2.01 2.01 0 0 1-1.415 1.42c-1.16.312-5.569.334-6.18.335h-.142c-.309 0-1.587-.006-2.927-.052l-.17-.006-.087-.004-.171-.007-.171-.007c-1.11-.049-2.167-.128-2.654-.26a2.01 2.01 0 0 1-1.415-1.419c-.111-.417-.185-.986-.235-1.558L.09 9.82l-.008-.104A31 31 0 0 1 0 7.68v-.123c.002-.215.01-.958.064-1.778l.007-.103.003-.052.008-.104.022-.26.01-.104c.048-.519.119-1.023.22-1.402a2.01 2.01 0 0 1 1.415-1.42c.487-.13 1.544-.21 2.654-.26l.17-.007.172-.006.086-.003.171-.007A100 100 0 0 1 7.858 2zM6.4 5.209v4.818l4.157-2.408z"></path>'+
                            '</svg>'+
                        '</span>';
    
    $("div.dataTables_filter").after(btnModelTutorial);
});

function reagendar(id){
    $("#btnSalvaAgendamento").attr("href", "index.php?m=adm&c=relacionamentoAgendamento&a=reagendamentosalvar&id=");
    $("#btnSalvaAgendamento").attr('href', $("#btnSalvaAgendamento").attr('href') + id);
    $("#btnSalvaAgendamento").attr('href', $("#btnSalvaAgendamento").attr('href') + '&novaData=' + $('#dataRet').val());
    
    
    $.ajax({
        type: 'POST',
        url: '?m=adm&c=relacionamentoAgendamento&a=reagendar&id=' + id,
        dataType: 'json',
        success: function (data) {
            $('#cliente').html(data.data.nm_pessoa);
            $('#clienteContrato').html(data.data.idContrato);
            $('#clienteQuadra').html(data.data.quadra);
            $('#clienteLote').html(data.data.lote);
            $('#dtRetorno').html(data.data.dt_retorno);
            $('#assunto').html(data.data.assunto);
        }
    });

    $('#modalReagendar').modal('show');
}

//Funo para change do select2 funcionar mais tranquilamente
function selectChange(select) {
    if (select.hasClass('empreendimento_crm')) {
        carregaDados();
    }
    if (select.hasClass('usuario_crm')) {
        carregaDados();
    }
}

//Carregas os lotes ao selecionar uma quadra
function carregaDados() {
    var dTbVizualizar = $('#TabelaListar').DataTable();
    //se a tabela j tiver sido inicializada, recarrega ajax
    dTbVizualizar.destroy();

    dTbVizualizar = $("#TabelaListar").DataTable({
        "processing": true,
        "scrollCollapse": true,
        ajax: {
            'url': "?m=adm&c=relacionamentoAgendamento&a=crmByEmpreendimento",
            'type': "POST",
            'data': function (data) {
                data.usuario = $("#usuario").val();
                data.empreendimento = $("#id_empreendimento").val();
            }
        },
        "columns": [
            {"data": 'data'},
            {"data": 'quadra'},
            {"data": 'lote'},
            {"data": 'contrato'},
            {"data": 'pessoa'},
            {"data": 'assunto'},
            {"data": 'acoes'}
        ],
        //Define a coluna default que ser ordenada quando abrir a pgina
        "order": [[0, "desc"]],

        //Organiza os botoes, paginao, campos e notificaes
        dom: '<"btnAdicionar">lfrtip',

        //Define as opes de quantidade de linhas que apareco na lista
        "lengthMenu": [[10, 25, 50], [10, 25, 50]],

        //Define as colunas que no tero ordenao
        "columnDefs": [
            {
                "orderable": false,
                "targets": -1,
                "searchable": false
            }
        ],

        //Pensonalizando as mensagens que por default so em ingls e formatao de valores
        language: {
            "sEmptyTable": "Nenhum registro encontrado",
            "sInfo": "",
            "sInfoEmpty": "",
            "sInfoFiltered": "",
            "sInfoPostFix": "",
            "sInfoThousands": ".",
            "sLengthMenu": "_MENU_",
            "sLoadingRecords": "Carregando...",
            "sProcessing": "Processando...",
            "sZeroRecords": "Nenhum registro encontrado",
            "sSearch": "Busca",
            "oPaginate": {
                "sNext": "Prximo",
                "sPrevious": "Anterior",
                "sFirst": "Primeiro",
                "sLast": "ltimo"
            },
            "oAria": {
                "sSortAscending": ": Ordenar colunas de forma ascendente",
                "sSortDescending": ": Ordenar colunas de forma descendente"
            },

            "decimal": ",",
            "thousands": "."
        }
    });
}
