$(document).ready(function () {

    /**
     * Listar
     *
     */
    $.when( carregaDados() ).done(function( thisTable ) {
        inputAvanc(thisTable, true)
    });

    //Carregas os contratos ao selecionar o filtro
    function carregaDados() {
        //se a tabela j tiver sido inicializada, recarrega ajax
        var table = $('#TabelaListar').dataTable({
            "ajax":$('#TabelaListar').dataTable.pipeline({
                "url" : "index.php?m=adm&c=relacionamento&a=listar",
                "pages":5
            }),
            destroy: true,
            orderCellsTop: true,
            "columns": [
                {"data": 'empreendimento'},
                {"data": 'quadra'},
                {"data": 'lote'},
                {"data": 'contrato'},
                {"data": 'pessoa'},
                {"data": 'cpfCnpj'},
                {"data": 'acoes'}
            ],
    
            //Define a coluna default que ser ordenada quando abrir a pgina
            "order": [[3, "desc"]],
    
            //Organiza os botoes, paginao, campos e notificaes
            dom: '<"btnAdicionar">lfrtip',
    
            //Define as opes de quantidade de linhas que apareco na lista
            "lengthMenu": [[10, 25, 50], [10, 25, 50]],
    
            //Define as colunas que no tero ordenao
            "columnDefs": [
                {
                    "orderable": false,
                    "targets": -1,
                    "searchable": false
                }
            ],
    
            //Pensonalizando as mensagens que por default so em ingls e formatao de valores
            language: {
                "sEmptyTable": "Nenhum registro encontrado",
                "sInfo": "",
                "sInfoEmpty": "",
                "sInfoFiltered": "",
                "sInfoPostFix": "",
                "sInfoThousands": ".",
                "sLengthMenu": "_MENU_",
                "sLoadingRecords": "Carregando...",
                "sProcessing": "Processando...",
                "sZeroRecords": "Nenhum registro encontrado",
                "sSearch": "Busca",
                "oPaginate": {
                    "sNext": "Prximo",
                    "sPrevious": "Anterior",
                    "sFirst": "Primeiro",
                    "sLast": "ltimo"
                },
                "oAria": {
                    "sSortAscending": ": Ordenar colunas de forma ascendente",
                    "sSortDescending": ": Ordenar colunas de forma descendente"
                },
    
                "decimal": ",",
                "thousands": "."
            }
        });
        return table;
    }

    //Boto "Adicionar" da listagem de todas telas
    var btnAdicionar = '<a class="btn btn-success" href="?m=adm&c=relacionamento&a=adicionar"><i class="fa fa-plus-circle"></i> Adicionar</a>';
    $("div.btnAdicionar").html(btnAdicionar);
    
});

function hide() {
    $('thead tr').last().toggle('1000');
}

function inputAvanc(table, first) {
    $(document).ready(function () {
        // Busca avanada
        $('#TabelaListar thead tr:eq(1) th').each(function (i) {
            title = $(this).text();
            if (title == 'Empreendimento' || title == 'Quadra' || title == 'Lote' || title == 'Cliente' || title == 'CPF/CNPJ') {
                var search = '<input hide type="text" class="form-control input-sm" style="width:100%" placeholder="' + title + '" />';            
            } else {
                var search = '';
            }
            if (first) {
                $(this).html('');
            }
            // Apply the filter
            $(search).appendTo(this).keyup(function(){table.fnFilter($(this).val(),i)})
        });

        $('thead tr').last().hide();
        $('.dataTables_filter').after('<a href="#" class="btn btn-sm btn-default" onClick="hide()">Busca Avanada</a>');
    });
}