$(document).ready(function () {

    carregaDados();

    $('[name="tipoContrato"]').on('change', () => {
        carregaDados($('#tipoContrato').val());
    });

    //Busca informaes para exibir no Modal Visualizar
    $(document).on('click', '#btnVisualizar', function () {
        var cdItem = $(this).val();

        $.ajax({
            type: 'POST',
            'url': "?m=adm&c=juridico&a=visualizar",
            dataType: 'json',
            data: {cdItem: cdItem},
            success: function (retorno) {
                $('#btnEditarRegistro').attr('href', '?m=adm&c=juridico&a=editar&id=' + retorno.id_juridico);

                var tipo = 'Ru';
                if (retorno.fl_tipo == 'A')
                    tipo = 'Autor';

                $('#cliente').html(retorno.nm_pessoa);
                $('#tipo').html(tipo);
                $('#quadra').html(retorno.quadra);
                $('#lote').html(retorno.lote);
                $('#contrato').html(retorno.id_contrato);
                $('#dtNotificacao').html(getDate(retorno.dt_notificacao));
                if (retorno.dt_audiencia && retorno.dt_audiencia != '0000-00-00')
                    $('#dtAudiencia').html(getDate(retorno.dt_audiencia));
                else
                    $('#dtAudiencia').html('-');
                $('#tpAudiencia').html(retorno.descricao);
                $('#processo').html(retorno.ds_processo);
                $('#local').html(retorno.ds_local);
                $('#resumo').html(retorno.ds_resumo);

            }
        });

    });
});

//Funo para change do select2 funcionar mais tranquilamente
function selectChange(select) {
    if (select.hasClass('empreendimento_crm')) {
        carregaDados();
    }
}

//Carregas os lotes ao selecionar uma quadra
function carregaDados(tipoContrato = 0) {
    var dTbVizualizar = $('#TabelaListar').DataTable();
    //se a tabela j tiver sido inicializada, recarrega ajax
    dTbVizualizar.destroy();

    $("#TabelaListar").DataTable({
        "processing": true,
        "scrollCollapse": true,
        ajax: {
            'url': "?m=adm&c=juridico&a=processosByEmpreendimento",
            'type': "POST",
            'data': function (data) {
                data.usuario = $("#usuario").val();
                data.empreendimento = $("#id_empreendimento").val();
                data.tipoContrato = tipoContrato;
            }
        },
        "columns": [
            {"data": 'pessoa'},
            {"data": 'quadra'},
            {"data": 'lote'},
            {"data": 'contrato'},
            {"data": 'notificacao'},
            {"data": 'audiencia'},
            {"data": 'dsLocal'},
            {"data": 'acoes'}
        ],
        //Define a coluna default que ser ordenada quando abrir a pgina
        "order": [[5, "desc"]],

        //Organiza os botoes, paginao, campos e notificaes
        dom: 'lfrtip',

        //Define as opes de quantidade de linhas que apareco na lista
        "lengthMenu": [[10, 25, 50], [10, 25, 50]],

        //Define as colunas que no tero ordenao
        "columnDefs": [
            {
                "orderable": false,
                "targets": -1,
                "searchable": false
            }
        ],

        //Pensonalizando as mensagens que por default so em ingls e formatao de valores
        language: {
            "sEmptyTable": "Nenhum registro encontrado",
            "sInfo": "",
            "sInfoEmpty": "",
            "sInfoFiltered": "",
            "sInfoPostFix": "",
            "sInfoThousands": ".",
            "sLengthMenu": "_MENU_",
            "sLoadingRecords": "Carregando...",
            "sProcessing": "Processando...",
            "sZeroRecords": "Nenhum registro encontrado",
            "sSearch": "Busca",
            "oPaginate": {
                "sNext": "Prximo",
                "sPrevious": "Anterior",
                "sFirst": "Primeiro",
                "sLast": "ltimo"
            },
            "oAria": {
                "sSortAscending": ": Ordenar colunas de forma ascendente",
                "sSortDescending": ": Ordenar colunas de forma descendente"
            },

            "decimal": ",",
            "thousands": "."
        }

    });
}
