$(document).ready(function () {
    /**
     * Listar
     *
     */
    $.when( carregaDados() ).done(function( thisTable ) {
        inputAvanc(thisTable, true)
    })

    //Carrega os distratos
    function carregaDados() {
        var table = $('#TabelaListar').dataTable({
            "ajax": $('#TabelaListar').dataTable.pipeline({
                "url": "index.php?m=adm&c=distrato&a=listar",
                "pages": 5
            }),
            destroy: true,
            orderCellsTop: true,
            "columns": [
                {"data": 'contrato'},
                {"data": 'empreendimento'},
                {"data": 'quadra'},
                {"data": 'lote'},
                {"data": 'pessoa'},
                {"data": 'data'},
                {"data": 'termos'},
                {"data": 'status'},
                {"data": 'acoes'}
            ],
    
            //Define a coluna default que ser ordenada quando abrir a pgina
            "order": [[5, "desc"]],
    
            //Organiza os botoes, paginao, campos e notificaes
            dom: '<"btnGerar"><"btnAdicionar">lfrtip',
    
            //Define as opes de quantidade de linhas que apareco na lista
            "lengthMenu": [[10, 25, 50], [10, 25, 50]],
    
            //Define as colunas que no tero ordenao
            "columnDefs": [
                {
                    "orderable": false,
                    "targets": -1,
                    "searchable": false
                }
            ],
    
            //Pensonalizando as mensagens que por default so em ingls e formatao de valores
            language: {
                "sEmptyTable": "Nenhum registro encontrado",
                "sInfo": "",
                "sInfoEmpty": "",
                "sInfoFiltered": "",
                "sInfoPostFix": "",
                "sInfoThousands": ".",
                "sLengthMenu": "_MENU_",
                "sLoadingRecords": "Carregando...",
                "sProcessing": "Processando...",
                "sZeroRecords": "Nenhum registro encontrado",
                "sSearch": "Busca",
                "oPaginate": {
                    "sNext": "Prximo",
                    "sPrevious": "Anterior",
                    "sFirst": "Primeiro",
                    "sLast": "ltimo"
                },
                "oAria": {
                    "sSortAscending": ": Ordenar colunas de forma ascendente",
                    "sSortDescending": ": Ordenar colunas de forma descendente"
                },
    
                "decimal": ",",
                "thousands": "."
            }
        });

        return table;
    }

    //Boto "Adicionar" da listagem de todas telas
    var btnAdicionar = '<a class="btn btn-success" href="?m=adm&c=distrato&a=adicionar"><i class="fa fa-plus-circle"></i> Adicionar</a>';
    $("div.btnAdicionar").html(btnAdicionar);

});

//Select de tipos de carta distrato nova
function tipoCarta(id) {
    var tpCarta = $("#termo_"+id).val();

    if (id != '') {
        for (var i = 1; i <= 3; i++) {
            var link = $('#link_' + id).attr('href');
            var res = link.split('&');
            var oLink = res[0] + '&' + res[1] + '&' + res[2] + '&' + res[3] + '&tpcarta=' + tpCarta;
            $('#link_' + id).attr('href', oLink);
        }
    }
}

function imprimeWord(id) {
    var termo = $("#termo_"+id).find(':selected').attr('fileType');
    var termoValue = $("#termo_"+id).find(':selected').val();
    m = (getUrl('m')?getUrl('m'):'adm');
    if(termo != null || termo != undefined) {
        if (termo === 'MW') {
            $('#modalModeloWord').modal('show');
    
            $.ajax({
                type: 'GET',
                url: '?m=' + m + '&c=' + getUrl('c') + '&a=imprimeWord',
                dataType: 'json',
    
                success: function (data) {
                    $("select.modeloWord").html('<option value="">Selecione ...</option>');
                    $('.modeloWord').append($('<option>', {
                        value: '',
                        text: 'Selecione...'
                    })).prop('selected', 'selected').trigger('change');
                    $.each(data['arquivos'], function (i, item) {
                        var option = new Option(item.text, item.value, true, true)
                        $('.modeloWord').append(option).trigger('change');
                    });
                    $('.modeloWord').val(null).trigger('change');

                    $('<input>').attr({
                        type: 'hidden',
                        id: 'contrato',
                        value: id
                    }).appendTo('#form');
                }
            });
        } else {
            window.open('index.php?m=adm&c=distrato&a=imprime&tpcarta=' + termoValue + '&id=' + id, '_blank');
        }
    }
}

$('#doModalWord').on('click', function (e) {
    var modeloWord = $('#arquivo option:selected').val()
    var contrato = $('#contrato').val();

    if(modeloWord == undefined) {
        alert("Escolha um modelo word!");
    } else {
        window.open('index.php?m=adm&c=distrato&a=imprime&tpcarta=' + modeloWord + '&id=' + contrato + '&w=w', '_blank')
    }
});

$('#doModalWord').on('hidden.bs.modal', function () {
    $('#arquivo option:selected').empty().trigger('change');
});

function hide() {
    $('thead tr').last().toggle('1000');
}

function inputAvanc(table, first) {
    $(document).ready(function () {
        // Busca avanada
        $('#TabelaListar thead tr:eq(1) th').each(function (i) {
            title = $(this).text();
            if (title == 'Empreendimento' || title == 'Quadra' || title == 'Lote' || title == 'Cliente' || title == 'Data') {
                var search = '<input hide type="text" class="form-control input-sm" style="width:100%" placeholder="' + title + '" />';            
            } else {
                var search = '';
            }
            if (first) {
                $(this).html('');
            }
            // Apply the filter
            $(search).appendTo(this).keyup(function(){table.fnFilter($(this).val(),i)})
        });

        $('thead tr').last().hide();
        $('.dataTables_filter').after('<a href="#" class="btn btn-sm btn-default" onClick="hide()">Busca Avanada</a>');
    });
}