$(document).ready(function () {
    $("#CNPJFavorecido").hide();

    $("input[name='tp_conta']").on('ifChecked', function(){
        if ($(this).val() == 'X') {
            $('#bancoDiv, #opDiv, #dadosBancoDiv').addClass('hidden');
            $('#pixDiv').removeClass('hidden').attr('disabled', false);
            $('#chavePix').attr('disabled', false);
            $('#pixTipo').removeClass('hidden').attr('disabled', false);
            $('#tipoPix').attr('disabled', false);
            $('.tipoConta').hide();
            $('#banco, #operacao, #dadosBancoDiv input').attr('disabled', false);
        } else {
            $('#bancoDiv, #opDiv, #dadosBancoDiv').removeClass('hidden');
            $('#pixDiv').addClass('hidden').attr('disabled', false);
            $('#chavePix').attr('disabled', false);
            $('#pixTipo').addClass('hidden').attr('disabled', false);
            $('#tipoPix').attr('disabled', false);
            $('.tipoConta').show();
            $('#banco, #operacao, #dadosBancoDiv input').attr('disabled', false);
        }
    });

    $("#qtdeParcelaDistrato").change(function () {
        var qtdeParcelaDistrato = $("#qtdeParcelaDistrato").val();
        if (qtdeParcelaDistrato != ""){
            $("#dtPrimeiraParcela").removeAttr("disabled");
        }
        else {
            $("#dtPrimeiraParcela").attr("disabled", "disabled");
        }
    });
    $("#qtdeParcelaDistrato").blur(function () {
        var qtdeParcelaDistrato = $('#qtdeParcelaDistrato').val();
        var vlTotalDistrato = replaceAll(replaceAll($('#vlTotalDistrato').val(), ".", ""), ",", ".");
        if (qtdeParcelaDistrato != "" && vlTotalDistrato != "") {
            var novoVlParcelaDistrato = (vlTotalDistrato / qtdeParcelaDistrato);
            $('#vlParcelaDistrato').val(float2moeda(novoVlParcelaDistrato));
            $('#vlParcelaDistratoH').val(float2moeda(novoVlParcelaDistrato));
        }
    });

    $("#vlParcelaDistrato").click(function () {
        $('#qtdeParcelaDistrato').attr('disabled', 'disabled');
    });

    $("#vlParcelaDistrato").blur(function () {
        $('#qtdeParcelaDistrato').removeAttr('disabled', 'disabled');

        var qtdeParcelaDistrato = $('#qtdeParcelaDistrato').val();
        var vlParcelaDistrato = replaceAll($('#vlParcelaDistrato').val(), ".", "");
        var vlDistrato = parseFloat(moeda2float($("#vlDistrato").val()));
        var vlParcelaDistrato = replaceAll(vlParcelaDistrato, ",", ".");

        if (qtdeParcelaDistrato != "" && vlParcelaDistrato != "") {
            var novoVlTotalDistrato = vlParcelaDistrato * qtdeParcelaDistrato;
            $('#vlTotalDistrato').val(float2moeda(novoVlTotalDistrato));
            $('#vlTotalDistratoH').val(float2moeda(novoVlTotalDistrato));
            $('#vlDiferenca').val(float2moeda(vlDistrato - novoVlTotalDistrato));
        }
    });

    $("#vlTotalDistrato").click(function () {
        $('#qtdeParcelaDistrato').attr('disabled', 'disabled');
    });

    $("#vlTotalDistrato").blur(function () {
        $('#qtdeParcelaDistrato').removeAttr('disabled', 'disabled');

        var qtdeParcelaDistrato = $('#qtdeParcelaDistrato').val();
        var vlTotalDistrato = replaceAll($('#vlTotalDistrato').val(), ".", "");
        var vlTotalDistrato = replaceAll(vlTotalDistrato, ",", ".");
        var valorDistrato = parseFloat(moeda2float($("#vlDistrato").val()));

        if (qtdeParcelaDistrato != "" && vlTotalDistrato != "") {
            var novoVlTotalDistrato = vlTotalDistrato / qtdeParcelaDistrato;
            var vlRestante = valorDistrato - vlTotalDistrato;

            $('#vlParcelaDistrato').val(float2moeda(novoVlTotalDistrato));
            $('#vlParcelaDistratoH').val(float2moeda(novoVlTotalDistrato));
            $('#vlDiferenca').val(float2moeda(vlRestante));
        }
    });
    $(".radioFavorecido").on('ifClicked', function () {
        if ($(this).val() == '1') {
            $("#CPFFavorecido").val($("#CPFFavorecidoH").val()).removeAttr('disabled');
            $("#nomeFavorecido").val($("#nomeFavorecidoH").val()).removeAttr('disabled');
        } else {
            $("#CPFFavorecido").val($("#CPFFavorecidoM").val()).attr('disabled', true);
            $("#nomeFavorecido").val($("#nomeFavorecidoM").val()).attr('disabled', true);
        }
    });

    $(".favorecidoOpcao").on('ifClicked', function () {
        
        if ($(this).val() == '1') {
            $(".tipoPessoaDistrato").show("slow");
        } else {
            $(".tipoPessoaDistrato").hide("slow");
        }
    });

    $(".radioTipoPessoa").on('ifClicked', function () {
    
        if ($(this).val() == 'J')
        { 
            $("#CPFFavorecido").hide()
            $("#CNPJFavorecido").show();
            $(".labelTipoPessoa").html("CNPJ Favorecido");
            $("#CPFFavorecido").val(null);
        } else {
            $(".labelTipoPessoa").html("CPF Favorecido");
            $("#CPFFavorecido").show()
            $("#CNPJFavorecido").hide();
            $("#CNPJFavorecido").val(null);
        }
    });

    $(".radioSinal").on('ifChecked', function () {
        var valorSinal = parseFloat($("#SinalValor").val());
        var SinalComDesconto = valorSinal * parseFloat($("#vlPorcDev").val()) * 0.01;
        var valorParcelas = parseFloat(moeda2float($("#vlTotalDistrato").val()));
        var qtdParcelas = parseFloat($("#qtdeParcelaDistrato").val());
        var vlTotalHidden = parseFloat(moeda2float($("#vlTotalPago").val()));
        var valorDistrato = parseFloat(moeda2float($("#vlDistrato").val()));
        var quantSinal = parseFloat(moeda2float($("#quantSinal").val()));

        if ($(this).val() == 'S') {
            if (valorSinal > 0) {
                if ((valorParcelas + valorSinal) > 0) {
                    $("#qtdeParcelaDistrato").val(qtdParcelas + quantSinal);
                    $("#vlTotalDistrato").val(float2moeda(SinalComDesconto + valorParcelas));
                    $("#vlTotalDistratoH").val(float2moeda(SinalComDesconto + valorParcelas));
                    $("#vlDistrato").val('R$ ' + float2moeda(SinalComDesconto + valorDistrato) + ' (' + (qtdParcelas + quantSinal) + ' parcelas)');
                    $("#vlParcelaDistrato").val(float2moeda((valorParcelas + SinalComDesconto) / (qtdParcelas+quantSinal)));
                    $("#vlParcelaDistratoH").val(float2moeda((valorParcelas + SinalComDesconto) / (qtdParcelas+quantSinal)));
                    $("#vlTotalPago").val('R$ ' + float2moeda(vlTotalHidden + valorSinal) + ' (' + (qtdParcelas + quantSinal ) + ' parcelas)');
                    $('#vlDiferenca').val(float2moeda(valorDistrato - valorParcelas));
                } else {
                    $("#qtdeParcelaDistrato").val(quantSinal);
                    $("#vlTotalDistrato").val(float2moeda(SinalComDesconto));
                    $("#vlTotalDistratoH").val(float2moeda(SinalComDesconto));
                    $("#vlDistrato").val('R$ ' + float2moeda(SinalComDesconto));
                    $("#vlParcelaDistrato").val(float2moeda(SinalComDesconto));
                    $("#vlParcelaDistratoH").val(float2moeda(SinalComDesconto));
                    $("#vlTotalPago").val(float2moeda(SinalComDesconto));
                }
            }
        }
        if ($(this).val() == 'N') {
            if (valorSinal) {
                if ((valorParcelas - valorSinal) > 0) {
                    $("#qtdeParcelaDistrato").val(qtdParcelas - quantSinal);
                    $("#vlTotalDistrato").val(float2moeda(valorParcelas - SinalComDesconto));
                    $("#vlTotalDistratoH").val(float2moeda(valorParcelas - SinalComDesconto));
                    $("#vlDistrato").val('R$ ' + float2moeda(valorDistrato - SinalComDesconto) + ' (' + (qtdParcelas - quantSinal) + ' parcelas)');
                    $("#vlParcelaDistrato").val(float2moeda((valorParcelas - SinalComDesconto) / (qtdParcelas - quantSinal)));
                    $("#vlParcelaDistratoH").val(float2moeda((valorParcelas - SinalComDesconto) / (qtdParcelas - quantSinal)));
                    $("#vlTotalPago").val('R$ ' + float2moeda(vlTotalHidden - valorSinal) + ' (' + (qtdParcelas - quantSinal) + ' parcelas)');
                    $('#vlDiferenca').val(float2moeda(valorDistrato - valorParcelas));
                } else {
                    $("#qtdeParcelaDistrato").val(qtdParcelas - quantSinal);
                    $("#vlTotalDistrato").val(float2moeda(valorParcelas - SinalComDesconto));
                    $("#vlTotalDistratoH").val(float2moeda(valorParcelas - SinalComDesconto));
                    $("#vlDistrato").val('R$ ' + float2moeda(valorDistrato - SinalComDesconto) + ' (' + (qtdParcelas - quantSinal) + ' parcelas)');
                    $("#vlParcelaDistrato").val(float2moeda((valorParcelas - SinalComDesconto) / (qtdParcelas - quantSinal)));
                    $("#vlParcelaDistratoH").val(float2moeda((valorParcelas - SinalComDesconto) / (qtdParcelas - quantSinal)));
                    $("#vlTotalPago").val('R$ ' + float2moeda(vlTotalHidden - valorSinal) + ' (' + (qtdParcelas - quantSinal) + ' parcelas)');
                    $('#vlDiferenca').val(float2moeda(valorDistrato - valorParcelas));
                }
            }
        }
    });
    //Constante que salva os valores da view
    const parc = $('#qtdeParcelaDistrato').val(), 
        valor = $('#vlParcelaDistrato').val(),
        total = $('#vlTotalDistrato').val();
    //Recalculo de valores
    $(".recalc").on('ifChecked', function () {
        var valorParcelas = parseFloat(moeda2float($("#vlTotalDistrato").val()));
        var recalcValorTotal = parseFloat(moeda2float($("#recalcValor").val()));

        if ($(this).val() == 'S') {
            if($('#radioSinalS')[0].checked){
                alert('Ateno: Os valores de sinais foram resetados.');
                $('#radioSinalNLabel').click();
            }
            if ((valorParcelas) > 0) {
                $.ajax({
                    type: "POST",
                    url: "?m=adm&c=distrato&a=dadosContrato",
                    data: {
                        empreendimento_distrato: $("select.empreendimento_distrato").val(),
                        contrato_id: $("select.contrato_distrato").val()
                    },
                    success: function (json) {
                        var data = JSON.parse(json);
                        var calcVlTotalDis = (parseFloat(data['porcDev']) * recalcValorTotal) / 100;
                        var qtdParc = parseFloat(data['parcelasHistoric']['qtdParcelaPagasHist']);
                        $("#qtdeParcelaDistrato").val(qtdParc);
                        $("#vlTotalDistrato").val(float2moeda(calcVlTotalDis));
                        $("#vlParcelaDistrato").val(float2moeda(calcVlTotalDis / qtdParc));
                    }
                });                    
            }           
        }
        if ($(this).val() == 'N') {
            if($('#radioSinalS')[0].checked){
                alert('Ateno: Os valores de sinais foram resetados.');
                $('#radioSinalNLabel').click();
            }
            if ((valorParcelas) > 0) {
                $("#qtdeParcelaDistrato").val(parc);
                $("#vlTotalDistrato").val(total);
                $("#vlParcelaDistrato").val(valor);
            }            
        }
    });

    $("#CPFFavorecido").on('blur', function () {
        if ($(this).val() != '') {
            $.ajax({
                type: "POST",
                url: "index.php?m=adm&c=ajax&a=pessoaNomeByCPF",
                data: {
                    cpf: $(this).val()
                },
                success: function (json) {
                    var nome = JSON.parse(json);
                    if (nome != true && nome != false) {
                        $("#nomeFavorecido").val(nome);
                    } else if (nome == false) {
                        alert('CPF invlido');
                    }
                }
            })
        }
    });

    $('#tpDistrato').on('change', function () {
        if($(this).val() == 'V'){
            $('#motivoDistrato').show();
            $('#dsMotivoDistrato').attr('required', 'required');
        } else {
            $('#motivoDistrato').hide();
            $('#dsMotivoDistrato').removeAttr('required');
        }
    });

    $("select.contrato_distrato").change(function(){
        var contrato = $(this).children("option:selected").val();
        
        $.ajax({
            type: "POST",
            url: "?m=adm&c=distrato&a=validaLote",
            data: "idContrato=" + contrato,
            success: function (response) {
                var json = JSON.parse(response);
                
                if (json.fl_construcao) {
                    $(".hidden-construcao").show('slow');
                } else {
                    $(".hidden-construcao").hide('slow');
                }
                if (json.fl_caucionado) {
                    $(".hidden-caucionado").show('slow');
                } else {
                    $(".hidden-caucionado").hide('slow');
                }

                if (json.juridico) {
                    $(".hidden-juridico").show('slow');
                } else {
                    $(".hidden-juridico").hide('slow');
                }
            }
        });
    });
});

//Funo para change do select2 funcionar mais tranquilamente
function selectChange(select) {
    if (select.hasClass('empreendimento_distrato')) {
        $("select.contrato_distrato").html('<option value="">Selecione ...</option>');
        $.ajax({
            type: "POST",
            url: "?m=adm&c=distrato&a=contratoByEmpreendimento",
            data: "id_empreendimento=" + select.val(),
            success: function (response) {
                var json = JSON.parse(response);
                if (json) {
                    $("#id_contrato").prop('disabled', false);
                    $("#id_contrato").select2({
                        'data': json,
                        'placeholder': 'Escolha o Contrato',
                        'allowClear': true,
                        'language': {
                            "noResults": function () {
                                return "Nenhum resultado encontrado";
                            },
                            "searching": function () {
                                return "Pesquisando...";
                            }
                        }
                    });
                }
            }
        });
    }
    if (select.hasClass('contrato_distrato')) {
        $.ajax({
            type: "POST",
            url: "?m=adm&c=distrato&a=dadosContrato",
            data: {
                empreendimento_distrato: $("select.empreendimento_distrato").val(),
                contrato_id: select.val()
            },
            success: function (json) {
                var json = JSON.parse(json),
                    checkSinal = $("#radioSinalN");
                checkSinal.iCheck('check');
                $("#vlDistrato").val('R$ ' + float2moeda(json['valor']) + ' (' + json['qtdparcelas'] + ' parcelas)');
                $("#local_assinatura").val(json['cidade']);
                $("#vlTotalParcelaPaga").val(json['valor']);
                $("#vlTotalDistrato").val(float2moeda(json['valor']));
                $("#vlTotalDistratoH").val(float2moeda(json['valor']));
                $("#qtdeParcelaDistrato").val(json['qtdparcelas']);
                $("#vlParcelaDistrato").val(float2moeda(json['valorParcela']));
                $("#vlParcelaDistratoH").val(float2moeda(json['valorParcela']));
                $("#SinalValor").val(json['sinal']);
                $("#vlPorcDev").val(json['porcDev']);
                $("#fruicaoDistrato").val(float2moeda(json['fruicao']));
                $("#mesesFruicao").val(json['mFruicao']);
                $("#taxaFruicao").val(json['txFruicao'] + '%');
                $("#taxaAdm").val(json['txAdmin'] + '%');
                $("#vlTotalContrato").val(float2moeda(json['vlTotalContrato']));
                $("#vlTxAdm").val(float2moeda(json['vlTxAdmin']));
                
                if ($("input[name='favorecido']:checked").val() != 1)
                {
                    $("#CPFFavorecido").val(json['cpf']).attr('disabled', true);
                    $("#nomeFavorecido").val(json['nome']).attr('disabled', true);
                }

                $("#CPFFavorecidoM").val(json['cpf']);
                $("#nomeFavorecidoM").val(json['nome']);
                $("#vlTotalPago").val('R$ ' + float2moeda(json['vlTotalPaga']) + ' (' + json['qtdParcelaPagas'] + ' parcelas)');
                $("#quantSinal").val(json['quantSinal']);
            }
        });
    }
    //Criada condio para exibir mensagem, quando for escolhido banco CEF
    if (select.hasClass('bancoDistrato')) {
        if ($('#banco').val() == '104'){
            $(".textoOperacao").show();
        } else {
            $(".textoOperacao").hide();
        }
    }
}