var dicionarioDocusign = [];
dicionarioDocusign["envelope-sent"] = "Contrato enviado";
dicionarioDocusign["envelope-resent"] = "Contrato reenviado";
dicionarioDocusign["envelope-delivered"] = "Contrato entregue para todos os usurios";
dicionarioDocusign["envelope-completed"] = "Contrato concludo com todas as assinaturas";
dicionarioDocusign["envelope-declined"] = "Contrato recusado";
dicionarioDocusign["envelope-voided"] = "Contrato anulado";
dicionarioDocusign["recipient-authenticationfailed"] = "Falha na autenticao do usurio";
dicionarioDocusign["recipient-autoresponded"] = "Falha ao enviar para o usurio";
dicionarioDocusign["recipient-declined"] = "Usurio recusou o contrato";
dicionarioDocusign["recipient-delivered"] = "Contrato entregue para o usurio";
dicionarioDocusign["recipient-completed"] = "Usurio assinou o contrato";
dicionarioDocusign["recipient-sent"] = "Contrato enviado para o usurio";
dicionarioDocusign["recipient-resent"] = "Contrato reenviado para o usurio";
dicionarioDocusign["template-created"] = "Modelo criado";
dicionarioDocusign["template-modified"] = "Modelo modificado";
dicionarioDocusign["template-deleted"] = "Modelo excludo";
dicionarioDocusign["envelope-corrected"] = "Contrato corrigido";
dicionarioDocusign["envelope-purge"] = "Limpeza de contrato";
dicionarioDocusign["envelope-deleted"] = "Contrato excludo";
dicionarioDocusign["envelope-discard"] = "Contrato descartado";
dicionarioDocusign["recipient-reassign"] = "Usurio reassinou";
dicionarioDocusign["recipient-delegate"] = "Usurio delegado";
dicionarioDocusign["recipient-finish-later"] = "Usurio terminar mais tarde";
dicionarioDocusign["click-agreed"] = "Clique em aceito";
dicionarioDocusign["click-declined"] = "Clique em recusado";

$(document).ready(function () {
    $('#tabelaListar').DataTable({
        ajax: '?m=adm&c=contrato&a=logDocusign&idContrato='+idContrato,
        responsive: true,
        processing: true,
        serverSide: true,
        lengthMenu: [[10, 25, 50, 100], [10, 25, 50,100]],
        columns: [
            { data: "id_contrato" },
            {
                data: "nm_empreendimento"
            },
            {
                data: "envelopeEvento",
                render: function (data) {
                    if(dicionarioDocusign[data]){
                        return dicionarioDocusign[data];
                    }
                    else{
                        return data;
                    }
                }
            },
            {
                data: "assinaturas",
                render: function (data) {
                    var data = JSON.parse(data)
                    var html = "";
                    data.forEach(function(assinatura){
                        var date = new Date(assinatura.data);
                        //return date.toLocaleDateString()+" "+date.toLocaleTimeString();
                        html+="<span style='display:block;' title='"+date.toLocaleDateString()+" "+date.toLocaleTimeString()+"'>"+assinatura.nome+"</span>"
                    });
                    return html;
                }
            },
            { data: "emails" }
        ],
        //Define a coluna default que ser ordenada quando abrir a pgina
        order: [],

        //Organiza os botes, paginao, campos e notificaes
        //dom: '<"btnAdicionar">lfrtip',
        dom: 'Blfrtip',
        buttons: [
            {
                text: 'My button',
                action: function ( e, dt, node, config ) {
                    alert( 'Button activated' );
                }
            }
        ],
        //Personalizando as mensagens que por default so em ingls e formatao de valores
        language: {
            "sEmptyTable": "Nenhum registro encontrado",
            "sInfo": "",
            "sInfoEmpty": "",
            "sInfoFiltered": "",
            "sInfoPostFix": "",
            "sInfoThousands": ".",
            "sLengthMenu": "_MENU_",
            "sLoadingRecords": "Carregando...",
            "sProcessing": "Processando...",
            "sZeroRecords": "Nenhum registro encontrado",
            "sSearch": "Busca",
            "oPaginate": {
                "sNext": "Prximo",
                "sPrevious": "Anterior",
                "sFirst": "Primeiro",
                "sLast": "ltimo"
            },
            "oAria": {
                "sSortAscending": ": Ordenar colunas de forma ascendente",
                "sSortDescending": ": Ordenar colunas de forma descendente"
            },

            "decimal": ",",
            "thousands": "."
        }
    });
});


function assinaturas(e){
    $('#tabelaListar').DataTable().search("recipient-completed").draw();
}