$(document).ready(function () {
    /**
     * Listar
     *
     */
    $.when( carregaDados(-1) ).done(function( thisTable ) {
        inputAvanc(thisTable, true)
    });

    $('[name="fl_tipo"]').on("ifChecked", function(e) {
        var check = $(this).val();
        $.when( carregaDados(check) ).done(function( thisTable ) {
            inputAvanc(thisTable, false)
        });
    });
});

//Carregas os contratos ao selecionar o filtro
function carregaDados(seletor) {
    //se a tabela j tiver sido inicializada, recarrega ajax
    var table = $('#TabelaListar').dataTable({
        "ajax": $('#TabelaListar').dataTable.pipeline({
            "url": "index.php?m=adm&c=contrato&a=listarDocusign&docusign="+seletor,
            "pages": 3
        }),
        destroy: true,
        orderCellsTop: true,
        "columns": [
            {"data": 'contrato'},
            {"data": 'empreendimento'},
            {"data": 'quadra'},
            {"data": 'lote'},
            {"data": 'pessoa'},
            {"data": 'acoes'}
        ],

        //Define a coluna default que ser ordenada quando abrir a pgina
        "order": [[0, "desc"]],

        //Organiza os botoes, paginao, campos e notificaes
        dom: '<"btnGerar"><"btnAdicionar"><"checkboxAprovar">lfrtip',

        //Define as opes de quantidade de linhas que apareco na lista
        "lengthMenu": [[10, 25, 50], [10, 25, 50]],

        //Define as colunas que no tero ordenao
        "columnDefs": [
            {
                "orderable": false,
                "targets": -1,
                "searchable": false
            }
        ],

        //Pensonalizando as mensagens que por default so em ingls e formatao de valores
        language: {
            "sEmptyTable": "Nenhum registro encontrado",
            "sInfo": "",
            "sInfoEmpty": "",
            "sInfoFiltered": "",
            "sInfoPostFix": "",
            "sInfoThousands": ".",
            "sLengthMenu": "_MENU_",
            "sLoadingRecords": "Carregando...",
            "sProcessing": "Processando...",
            "sZeroRecords": "Nenhum registro encontrado",
            "sSearch": "Busca",
            "oPaginate": {
                "sNext": "Prximo",
                "sPrevious": "Anterior",
                "sFirst": "Primeiro",
                "sLast": "ltimo"
            },
            "oAria": {
                "sSortAscending": ": Ordenar colunas de forma ascendente",
                "sSortDescending": ": Ordenar colunas de forma descendente"
            },

            "decimal": ",",
            "thousands": "."
        }
    });

    return table;
}

function hide() {
    $('thead tr').last().toggle('1000');
}

function inputAvanc(table, first) {
    $(document).ready(function () {
        // Busca avanada
        $('#TabelaListar thead tr:eq(1) th').each(function (i) {
            title = $(this).text();
            if (title == 'Empreendimento' || title == 'Qd' || title == 'Lt' || title == 'Cliente') {
                var search = '<input hide type="text" class="form-control input-sm" style="width:100%" placeholder="' + title + '" />';            
            } else {
                var search = '';
            }
            if (first) {
                $(this).html('');
            }
            // Apply the filter
            $(search).appendTo(this).keyup(function(){table.fnFilter($(this).val(),i)})
        });

        $('thead tr').last().hide();
        $('.dataTables_filter').after('<a href="#" class="btn btn-sm btn-default" onClick="hide()">Busca Avanada</a>');
    });
}