$(document).ready(function () {
    dadosLoteTabelaRequest();

    $(".porcentagemPrice").mask('00,000000', {reverse: true});

    if ($("#flNormalCheckbox").val() == 'S' || $("#flNormalCheckbox").val() == '')
        $('#divDescNormal').hide();
    if ($("#flSinalCheckbox").val() == 'S' || $("#flSinalCheckbox").val() == '')
        $('#divDescSinal').hide();
    if ($("#flIntercaladaCheckbox").val() == 'S' || $("#flIntercaladaCheckbox").val() == '')
        $('#divDescIntercalada').hide();
    if ($("#flChaveCheckbox").val() == 'S' || $("#flChaveCheckbox").val() == '')
        $('#divDescChave').hide();

    $('[name="desconto_tp_normal"]').on('ifChecked', function () {
        $('#divDescNormal').show();
        switch ($(this).val()) {
            case 'V':
                $('#spanDescNormal').html('Desconto (R$)');
                break;
            case 'P':
                $('#spanDescNormal').html('Desconto (%)');
                break;
            case 'S':
                $('#divDescNormal').hide();
                break;
        }
    });

    $('[name="desconto_tp_sinal"]').on('ifChecked', function (event) {
        $('#divDescSinal').show();
        switch ($(this).val()) {
            case 'V':
                $('#spanDescSinal').html('Desconto (R$)');
                break;

            case 'P':
                $('#spanDescSinal').html('Desconto (%)');
                break;

            case 'S':
                $('#divDescSinal').hide();
                break;
        }
    });

    $('[name="desconto_tp_intercalada"]').on('ifChecked', function (event) {
        $('#divDescIntercalada').show();
        switch ($(this).val()) {
            case 'V':
                $('#spanDescIntercalada').html('Desconto (R$)');
                break;

            case 'P':
                $('#spanDescIntercalada').html('Desconto (%)');
                break;

            case 'S':
                $('#divDescIntercalada').hide();
                break;
        }
    });

    $('[name="desconto_tp_chave"]').on('ifChecked', function (event) {
        $('#divDescChave').show();
        switch ($(this).val()) {
            case 'V':
                $('#spanDescChave').html('Desconto (R$)');
                break;

            case 'P':
                $('#spanDescChave').html('Desconto (%)');
                break;

            case 'S':
                $('#divDescChave').hide();
                break;
        }
    });
    

    $('[name="tp_parcelamento"]').on('ifChecked', function (event) {
        
        if ($(this).val() == 'P') {
            $('#tabPrice').show();
        } else {
            $('#tabPrice').hide();
        }
        if ($(this).val() == 'S') {
            $('#tabSacoc').show();
        } else {
            $('#tabSacoc').hide();
        }
    });

    //Validao de Sinal para o editar;
    validaDataSinal();
    $('.camposDataParcSinal, .camposValorParcSinal').blur(function () {
        validaDataSinal();
    });

    //autocomplete utilizando o plugin select2
    select2RemoteData(
        '#idCliente',
        false,
        true,
        'Digite o nome do Cliente',
        '?m=adm&c=ajax&a=findPessoasByNome'
    );

    select2RemoteData(
        '#outrosCompradores',
        false,
        true,
        'Digite o nome, cpf ou cnpj do Cliente',
        '?m=adm&c=ajax&a=findPessoasByNome'
    );

    $(".data").on('blur', function () {
        if (validaData($(this).val())) {
            $(this).val(null);
        }
    });

    function dadosLoteTabelaRequest() {
        var lote = $("#id_contrato").val();

        if(lote) {
            $.ajax({type: "POST", url: "?m=adm&c=contrato&a=dadosLoteTabela", 
                    data: "lote="+lote+"&idEmpreendimento="+$("#id_empreendimento").val(), 
                    success: function(result){
                    var result = JSON.parse(result);
                                    
                    if(result != '') {
                        for (var res in result[0]) {
                            if(result[0][res] == null){
                                result[0][res] = '-';
                            }
                        }
                        if($('#resultDadosLoteTabela').length){
                            $('#resultDadosLoteTabela').remove();
                            $('#TabelaVisualizarTabelaPrecosTitulo').html('-');
                        }

                        $('#TabelaVisualizarTabelaPrecosTitulo').html(result[0]['nm_tabela']);

                        let date = new Date(result[0]['dt_atualizacao']);

                        if(result[0]['tp_tabela'] == 'N') {
                            $('#tabelaDePreco').removeClass('hidden');
                            if($('.TabelaNormal').hasClass('hidden')){
                                $('.TabelaNormal').removeClass('hidden');
                                $('.TabelaPriceSacoc').addClass('hidden');
                            }
                            var html = '<tr id="resultDadosLoteTabela"> \n' +
                            '<th> R$' + result[0]['vl_total'].replace(".",",") + '</th>\n' +
                            '<th>' + result[0]['vl_sinal'] + '</th>\n' +
                            '<th>' + result[0]['vl_parcela'] + '</th>\n' +
                            '<th>' + result[0]['vl_intercalada'] + '</th>\n' +
                            '<th>' + result[0]['qt_intercalada'] + '</th>\n' +
                            '<th>' + result[0]['dt_atualizacao'] + '</th>\n' +
                            '</tr>';
                        } else if ((result[0]['tp_tabela'] == 'P') || (result[0]['tp_tabela'] == 'S')){
                            $('#tabelaDePreco').removeClass('hidden');
                            if($('.TabelaPriceSacoc').hasClass('hidden')){
                                $('.TabelaPriceSacoc').removeClass('hidden');
                                $('.TabelaNormal').addClass('hidden')
                            }
                            var html = '<tr id="resultDadosLoteTabela"> \n' +
                            '<th> R$' + result[0]['vl_total'].replace(".",",") + '</th>\n' +
                            '<th>' + result[0]['tx_juros'] + '</th>\n' +
                            '<th>' + result[0]['qt_meses'] + '</th>\n' +
                            '<th>' + result[0]['dt_atualizacao'] + '</th>\n' +
                            '</tr>';
                        }
                        
                        $('#TabelaVisualizarTabelaPrecos').append(html);
                    } else {
                        $('#tabelaDePreco').addClass('hidden');
                        if($('#resultDadosLoteTabela').length){
                            $('#resultDadosLoteTabela').remove();
                            // $('#TabelaVisualizarTabelaPrecosTitulo').html('-');
                        }
                    }
                }});
        }
    }

    $("#id_contrato").on('change', function () {
        var lote = $(this).val();

        dadosLoteTabelaRequest();

        $.ajax({
            type: "POST",
            url: "index.php?m=adm&c=contrato&a=dadosTabela",
            data: "lote=" + lote,
            success: function (json) {

                var response = JSON.parse(json),
                    vlParcelaNormal = (response.vl_parcela > 0?response.vl_parcela:0),
                    vlIntercalada = (response.vl_intercalada > 0?response.vl_intercalada:null),
                    vlSinal = (response.vl_sinal > 0?response.vl_sinal:0),
                    qtdIntercalada = (response.qt_intercalada > 0)?response.qt_intercalada: null,
                    maxParcelas = $('#maxParcelas').val();

                if (response) {
                    $("#vlParcelaNormal").val(float2moeda(vlParcelaNormal));
                    $("#qtdParcelaNormal").val(response.nr_parcela);
                    $("#vlIntercalada").val(vlIntercalada > 0 ? float2moeda(vlIntercalada) : vlIntercalada);
                    $("#qtdIntercalada").val(qtdIntercalada);

                    if (vlSinal > 0) {
                        $("#vlSinal").val(float2moeda(vlSinal));
                        $("#qtdSinal").val(1).trigger('change');
                    }
                } else {
                    $("#vlParcelaNormal").val(null);
                    $("#qtdParcelaNormal").val(null);
                    $("#vlIntercalada").val(null);
                    $("#qtdIntercalada").val(null);
                    $("#vlSinal").val(null);
                    $("#qtdSinal").val(0).trigger('change');
                }
                calculaValor();
            }
        });
    });

    $(".clientesContrato").on('change', function () {
        if ($(this).attr('name') == 'cliente') {
            $("#outrosCompradores option").each(function () {
                if ($("#idCliente").val() && $("#idCliente").val() == $(this).val()) {
                    alert('Cliente j adicionado.');
                    $("#idCliente").val([]).trigger('change');
                }
            });
        }
        if ($(this).attr('name') == 'pessoas_envolvidas[]') {
            if ($("#idCliente").val() == $("#outrosCompradores option:last").val()) {
                $("#msgCompradores").show();
                $("#outrosCompradores option:last").remove();
                $("#outrosCompradores").trigger('change');
            }
        }
    });

    $("#dtParcelaNormal").on('blur', function () {
        $("#dt_reajuste").val($(this).val());
    }).on('changeDate', function () {
        $("#dt_reajuste").val($(this).val());
    });

    $('.calculaValores').on('blur', function () {
        calculaValor();
    });

    $('.quantidadeParcela').on('blur', function () {
        maxParcelas($(this));
    });

    var templateNormal = $('#rowNormal').clone(),
        templateIntercalada = $('#rowIntercalada').clone(),
        templateChave = $('#rowChave').clone();

    //Adicionar mais compradores 
    $('#adicionarOutros').on('click', function() { 
        $('#participacaocomprador').show();
        $.ajax({
            type: "POST",
            url: "index.php?m=adm&c=contrato&a=findPessoa",
            data: "pessoa=" + $('#outrosCompradores').val(),
            success: function (json) {
                var json = JSON.parse(json),
                linhaTabela, outrosCompradores, participacao;
                outrosCompradores = $('#outrosCompradores').val() ?$('#outrosCompradores').val():'';
                participacao = $('#participacaoOutros').val() != ''?$('#participacaoOutros').val():'0,00';
                json.pessoa = json.pessoa?json.pessoa:'';
                if (!$("#btnPessoa_" + outrosCompradores).attr('id'))
                {
                    linhaTabela = '<tr id="indice'+$('#contador').val()+'">';
                    linhaTabela += '<td> '+json.pessoa+'</td>';
                    linhaTabela += '<td> '+participacao+'</td>';
                    linhaTabela += '<td><div align="center" style="width: 100%;"><button data-toggle="tooltip" title="REMOVER" class="btn btn-default btn-xs remIndice"  type="button" id="btnPessoa_'+outrosCompradores+'" value="'+$('#contador').val()+'"><i class="fa fa-times"></i></button></div></td>';
                    linhaTabela += '<input type="hidden" name="listaIndices[]" class="listaIndices" value="'+$('#contador').val()+'_'+json.pessoa+'_'+$('#participacaoOutros').val()+'_'+outrosCompradores+'" />';
                    linhaTabela += '</tr>';
                    $('#tableIndices').append(linhaTabela);
                    $('#divTabelaIndices').show();
                    $('#contador').val(parseInt($('#contador').val())+1);
                    $('.remIndice').tooltip({ trigger: "hover" });
                    $(".remIndice").unbind("click");
                    //Remover parcela da lista
                    remIndice();
                    //Reset inputs
                    $('#indice').val('').change();
                    $('#porcAdc').val('');
                    $('#periodoReajusteAdc').val('').change();
                }
            }
        });
    });
    remIndice();

    $("#adicionarNormal").on('click', function () {
        var nrNormais = parseInt($("#nrNormalAdicional").val()) + 1;
        $("#nrNormalAdicional").val(nrNormais);
        var rowId = nrNormais;
        var klon = templateNormal.clone();
        klon.attr('id', 'lineNormal_' + rowId)
            .insertBefore($("#rowNormal"))
            .removeClass('hide')
            .find('input')
            .each(function () {
                $(this)
                    .attr('id', $(this).attr('id').replace(/_(\d*)$/, "_" + rowId))
                    .on('blur', function () {
                        calculaValor();
                        if ($(this).hasClass('quantidadeParcela')) //Testa maximo de parcelas para o empreendimento
                            maxParcelas($(this));
                    });
                if ($(this).attr('name').indexOf('vl') != -1)
                    $(this).addClass('adicionais');
                if ($(this).attr('name').indexOf('reajustavel') != -1) {
                    $(this).attr('checked', 'checked').parent().on('click', icheckerClick).addClass('checked');
                }
                if ($(this).hasClass('money'))
                    $(this).maskMoney({
                        symbol: 'R$ ',
                        showSymbol: false,
                        decimal: ",",
                        thousands: "."
                    });
            });
        $(".soNumero").keyup(function () {
            this.value = this.value.replace(/\D/g, '');
        });
    });

    $("#removerNormal").on('click', function () {
        var nrNormais = $("#nrNormalAdicional").val();
        $("#lineNormal_" + nrNormais).remove();
        if (nrNormais >= 1)
            $("#nrNormalAdicional").val(parseInt(nrNormais) - 1);
        calculaValor()
    });

    $("#adicionarIntercalada").on('click', function () {
        var nrIntercaladas = parseInt($("#nrIntercaladaAdicional").val()) + 1;
        $("#nrIntercaladaAdicional").val(nrIntercaladas);
        var rowId = nrIntercaladas;
        var klon = templateIntercalada.clone();
        klon.attr('id', 'lineIntercalada_' + rowId)
            .insertBefore($("#rowIntercalada"))
            .removeClass('hide')
            .find('input')
            .each(function () {
                $(this)
                    .addClass('intercaladaAdicional_' + rowId)
                    .attr('id', $(this).attr('id').replace(/_(\d*)$/, "_" + rowId))
                    .on('blur', function () {
                        calculaValor()
                    });
                if ($(this).attr('name').indexOf('vl') != -1)
                    $(this).addClass('adicionais');
                if ($(this).attr('name').indexOf('reajustavel') != -1) {
                    $(this).on('click', icheckerClick);
                    $(this).attr('checked', 'checked').parent().on('click', icheckerClick).addClass('checked');
                }
                if ($(this).hasClass('money'))
                    $(this).maskMoney({
                        symbol: 'R$ ',
                        showSymbol: false,
                        decimal: ",",
                        thousands: "."
                    });
            });
        $(".data").mask("99/99/9999");
        $('.datepicker-input').datepicker({
            format: "dd/mm/yyyy",
            startDate: '-1d'
        });
        $(".soNumero").keyup(function () {
            this.value = this.value.replace(/\D/g, '');
        });
    });

    $("#removerIntercalada").on('click', function () {
        var nrIntercaladas = $("#nrIntercaladaAdicional").val();
        $("#lineIntercalada_" + nrIntercaladas).remove();
        if (nrIntercaladas >= 1)
            $("#nrIntercaladaAdicional").val(parseInt(nrIntercaladas) - 1);
        calculaValor()
    });

    $("#adicionarChave").on('click', function () {
        var nrChaves = parseInt($("#nrChaveAdicional").val()) + 1;
        $("#nrChaveAdicional").val(nrChaves);
        var rowId = nrChaves;
        var klon = templateChave.clone();
        klon.attr('id', 'lineChave_' + rowId)
            .insertBefore($("#rowChave"))
            .removeClass('hide')
            .find('input')
            .each(function () {
                $(this)
                    .attr('id', $(this).attr('id').replace(/_(\d*)$/, "_" + rowId))
                    .on('blur', function () {
                        calculaValor()
                    });
                if ($(this).attr('name').indexOf('vl') != -1)
                    $(this).addClass('adicionais');
                if ($(this).attr('name').indexOf('reajustavel') != -1) {
                    $(this).on('click', icheckerClick);
                    $(this).attr('checked', 'checked').parent().on('click', icheckerClick).addClass('checked');
                }
                if ($(this).hasClass('money'))
                    $(this).maskMoney({
                        symbol: 'R$ ',
                        showSymbol: false,
                        decimal: ",",
                        thousands: "."
                    });
            });
        $(".soNumero").keyup(function () {
            this.value = this.value.replace(/\D/g, '');
        });
    });

    $("#removerChave").on('click', function () {
        var nrChaves = $("#nrChaveAdicional").val();
        $("#lineChave_" + nrChaves).remove();
        if (nrChaves >= 1)
            $("#nrChaveAdicional").val(parseInt(nrChaves) - 1);
        calculaValor()
    });

    // Cria option automaticamente de acordo com a quantidade de parcelas sinal escolhidas
    $('[name="qtdSinal"]').on('change', function () {
        var qtdSinal = $(this).val(),
            conteudo = '',
            isEmpty = qtdSinal > 0,
            valorTotalParcela = moeda2float($('#vlSinal').val());

        if (!isEmpty) {
            $('#vlSinal').val('');
            $('#TabelaParcSinalMsg2').html('');
            $('#TabelaParcSinalMsg').html('');
            $('#flIncluirContratoSinalNao').iCheck('check');
        }

        if (qtdSinal > 0) {

            $('#tabelaParcSinais').show();

            //Cria os campos e insere na pagina html
            for (var i = 1; i <= qtdSinal; i++) {
                conteudo += '<tr>';
                conteudo += '<td align="center">' + i + '</td>';
                conteudo += '<td>';
                conteudo += '<div class="form-group col-sm-6">';
                conteudo += '<input type="text" class="form-control money camposValorParcSinal" name="vl_sinal[]" id="valor_' + i + ' onBlur="verificaValor();" value="' + float2moeda(valorTotalParcela / qtdSinal) + '" />';
                conteudo += '</div>';
                conteudo += '</td>';
                conteudo += '<td><input type="text" class="form-control data datepicker-input camposDataParcSinal" style="width:200px;" name="dt_sinal[]" id="dt_' + i + '" /></td>';
                conteudo += '</tr>';
            }

            $('#tabelaParcSinais > tbody').html(conteudo);

            validaDataSinal();

            // Soma os valores de todas parcelas sinais e compara com o valor total da parcela sinal
            $('.camposDataParcSinal, .camposValorParcSinal').blur(function () {
                validaDataSinal();
            });

        } else {
            $('[name="vl_sinal[]"]').remove();
            $('#tabelaParcSinais').hide();
            $('#btnSalvar').prop('disabled', false);
        }
        $(".data").mask("99/99/9999");
        $('.datepicker-input').datepicker({
            format: "dd/mm/yyyy",
            startDate: '-1d'
        });
    });

    $(".calculaPrice").on('blur', function (e) {
        var valor = $('#vlDivida').val(),
            qtd = $('#qtMeses').val(),
            juros = $('#txJuros').val(),
            parcela = 0;

        if (valor && qtd && juros) {
            $('#erroPrice').html('');
            juros = moeda2float(juros) / 100;
            parcela = (moeda2float(valor) * Math.pow(1 + juros, qtd) * juros) / (Math.pow(1 + juros, qtd) - 1);
            parcela = float2moeda(parcela);
            $('#vlParcelaNormal').val(parcela);
            $('#qtdParcelaNormal').val(qtd);
            calculaValor()
        } else {
            $('#erroPrice').html('Os campos Valor da Dvida, Meses de Financiamento e Taxa de Juros so Obrigatorios para realizar o clculo.')
        }
    });

    $(".calculaSacoc").on('blur',function (e) {
        var valorDivida = $('#vlrDivida').val(),
            quantMeses = $('#qtdMeses').val(),
            parcela = 0;

        if (valorDivida && quantMeses) {
            $('#erroSacoc').html('');
            parcela = (moeda2float(valorDivida) / quantMeses);
            parcela = float2moeda(parcela);
            $('#vlParcelaNormal').val(parcela);
            $('#qtdParcelaNormal').val(quantMeses);
            calculaValor();
        } else {
            $('#erroSacoc').html('Os campos Valor da Dvida e Meses de Financiamento so Obrigatorios para realizar o clculo.')
        }
    });

    //submit do formulrio de contrato
    $("#submitContrato").on('click', function (e) {
        var $form = $('#formContrato'),
            params = $form.serializeArray(),
            formData = {};

        $.each(params, function (i, val) {
            formData[val.name] = val.value;
        });
        e.preventDefault();
        $.ajax({
            type: "POST",
            data: {formData: formData},
            url: "index.php?m=adm&c=contrato&a=validar",
            success: function (json) {
                var json = JSON.parse(json)
                if (json[0] == true) {
                    $form.submit();
                }
                else {
                    $.each($(".error"), function () {
                        $(this).html('').hide();
                    });
                    $.each(json[1], function (i, val) {
                        $("#erro" + i).html(val).show().closest('tr').show();
                    });
                }
            }
        });
    });

});
function remIndice() {
    //Remover parcela da lista
    $(".remIndice").on("click", function () {
        console.log($('.listaIndices')[0]);
        if($(this).val() != '') {
            $('#indice' + $(this).val()).remove();
            autohidenotify('success', 'top center', 'Comprador removido com sucesso!');
            if (!$('.listaIndices')[0]) {
                $('#divTabelaIndices').hide();
            }
        } else {
            autohidenotify('error', 'top center', 'No foi possvel remover o comprador');
        }
    });
}

function aprovar(e) {
    e.preventDefault;
    document.getElementById("fl_aprovar_contrato").value = 1;
    document.getElementById("submitContrato").click();
}

function validaDataSinal() {
    var soma = 0,
        valorParcelas = 0,
        temCampoValorVazio = false,
        temCampoDataVazio = false,
        valorTotalParcela = parseFloat(replaceAll(replaceAll($('#vlSinal').val(), ".", ""), ",", ".")),
        qtdSinal = $('[name="qtdSinal"]').val();

    if (qtdSinal > 0) {
        // Percorre todos campos que possuem a classe camposValorParc e soma os valores dos mesmos
        $('.camposValorParcSinal').each(function () {
            if ($(this).val() != '') {
                valorParcelas = replaceAll($(this).val(), ".", "");
                valorParcelas = replaceAll(valorParcelas, ",", ".");
                if (valorParcelas > 0) soma = soma + parseFloat(valorParcelas);
            } else {
                temCampoValorVazio = true;
            }
        });

        //Percorre todos campos de datas das parcelas e verifica se algum est vazio
        $('.camposDataParcSinal').each(function () {
            if ($(this).val() == '') {
                temCampoDataVazio = true;
            }

        });
        //funo para alterar a data da parcela de sinal, caso o usurio selecione uma data invlida
        $('.camposDataParcSinal').on('blur', function () {
            
            if ($(this).val()) {
                
                if (!isValidDate($(this).val())) {

                    var data = $(this).val().split('/');
    
                    if (!Number.isNaN(data[0])) {
                        $(this).val(daysInMonth(data[1], data[2])+'/'+data[1]+'/'+data[2]);
                    }
                }
            } 
        });

        // Ativa os avisos de erros ou sucesso
        if (temCampoValorVazio) {
            $('#TabelaParcSinalDiv').attr('class', 'form-group col-sm-12 has-feedback has-error');
            $('small[id="TabelaParcSinalMsg3"]').attr('style', 'display:block;');
            $('small[id="TabelaParcSinalMsg"]').attr('style', 'display:none;');
            $('small[id="TabelaParcSinalMsg2"]').attr('style', 'display:none;');
            $('#btnSalvar').prop('disabled', true);
        } else if (temCampoDataVazio) {
            $('#TabelaParcSinalDiv').attr('class', 'form-group col-sm-12 has-feedback has-error');
            $('small[id="TabelaParcSinalMsg"]').attr('style', 'display:none;');
            $('small[id="TabelaParcSinalMsg2"]').attr('style', 'display:block;');
            $('small[id="TabelaParcSinalMsg3"]').attr('style', 'display:none;');
            $('#btnSalvar').prop('disabled', true);
        } else if (Math.round(soma * 100) != Math.round(valorTotalParcela * 100)) {
            $('#TabelaParcSinalDiv').attr('class', 'form-group col-sm-12 has-feedback has-error');
            $('small[id="TabelaParcSinalMsg"]').attr('style', 'display:block;');
            $('#valorTotalSinal').html('Soma das parcelas: R$ ' + float2moeda(soma));
            $('small[id="TabelaParcSinalMsg2"]').attr('style', 'display:none;');
            $('small[id="TabelaParcSinalMsg3"]').attr('style', 'display:none;');
            $('#btnSalvar').prop('disabled', true);
        } else {
            $('#TabelaParcSinalDiv').attr('class', 'form-group col-sm-12 has-feedback has-success');
            $('small[id="TabelaParcSinalMsg"]').attr('style', 'display:none;');
            $('small[id="TabelaParcSinalMsg2"]').attr('style', 'display:none;');
            $('#btnSalvar').prop('disabled', false);
        }
    } else {
        $('#btnSalvar').prop('disabled', false);
    }
}

//Funo para change do select2 funcionar mais tranquilamente
function selectChange(select) {
    if (select.hasClass('empreendimento_contrato')) {
        $("select.lotes").html('<option value="">Selecione ...</option>');
        $("select.bancos").html('<option value="">Selecione ...</option>');
        $("select.corretores").html('<option value="">Selecione ...</option>');
        $("#idIndice").html('<option value="">Selecione ...</option>');
        $('#maxParcelas').val($("#id_empreendimento :selected").attr('maxParcelas'));
        $.ajax({
            type: "POST",
            url: "index.php?m=adm&c=contrato&a=loteClienteByEmpreendimento",
            data: "id_empreendimento=" + select.val(),
            success: function (response) {
                $("select.lotes").select2({
                    'data': JSON.parse(response),
                    'placeholder': 'Escolha o Lote',
                    'allowClear': true
                });
            }
        });
        $.ajax({
            type: "POST",
            url: "index.php?m=adm&c=contrato&a=bancoByEmpreendimento",
            data: "id_empreendimento=" + select.val(),
            success: function (response) {
                $("select.bancos").select2({
                    'data': JSON.parse(response),
                    'placeholder': 'Escolha o Banco',
                    'allowClear': true
                });
            }
        });
        $.ajax({
            type: "POST",
            url: "index.php?m=adm&c=contrato&a=corretorByEmpreendimento",
            data: "id_empreendimento=" + select.val(),
            success: function (response) {
                $("select.corretores").select2({
                    'data': JSON.parse(response),
                    'placeholder': 'Escolha o Corretor',
                    'allowClear': true
                });
            }
        });
        $.ajax({
            type: "POST",
            url: "index.php?m=adm&c=contrato&a=getIndiceEmpreendimento",
            data: "idEmpreendimento=" + select.val(),
            success: function (json) {
                $('#idIndice').select2({
                    'data': JSON.parse(json),
                    'placeholder': 'Escolha o ndice',
                    'allowClear': true
                });
            }
        });
    }
}

function icheckerClick() {
    var input = $(this).find('input');
    if (input.is(":checked")) {
        input.prop("checked", false);
        $(this).removeClass('checked')
    } else {
        input.prop("checked", true);
        $(this).addClass('checked')
    }
}

function aprovarContrato() {
    $.ajax({
        type: "POST",
        url: "index.php?m=adm&c=contrato&a=aprovarContrato",
        data: "contrato=" + $("#contrato").val(),
        success: function (response) {
            if (response) {
                alert('Contrato Aprovado.');
                $('.naoAprovado').each(function () {
                    $(this).hide();
                });
            } else {
                alert('No foi possvel aprovar o contrato.');
            }
        }
    });
}

function calculaValor() {

    var vlParcelaNormal = moeda2float($('[name="vl_parcela"]').val()),
        qtParcelaNormal = $('[name="qtd_parcela"]').val(),
        vlSinal = moeda2float($('[name="vlSinal"]').val()),
        vlIntercalada = moeda2float($('[name="intercalada"]').val()),
        qtIntercalada = $('[name="qtd_parcela_intercalada"]').val(),
        vlChave = moeda2float($('[name="vl_chaves"]').val()),
        qtChave = $('[name="qtd_parcela_chaves"]').val(),
        vlAdicionais = 0;
    var soma;

    if (qtParcelaNormal != '') {
        qtParcelaNormal = parseInt(qtParcelaNormal)
    }
    if (qtIntercalada != '') {
        qtIntercalada = parseInt(qtIntercalada)
    }
    if (qtChave != '') {
        qtChave = parseInt(qtChave)
    }


    //Adiciona os valores de parcelas adicionais ao total
    $.each($(".adicionais"), function () {
        var id = $(this).attr('id'),
            otherId = id.replace('vl', 'qt'),
            other = $("#" + otherId),
            valor = moeda2float($(this).val()),
            qtd = parseInt(other.val());

        if (valor > 0 && qtd > 0) {
            vlAdicionais += (valor * qtd);
        }
    });
    soma = ((vlParcelaNormal * qtParcelaNormal) + (vlSinal) + (vlIntercalada * qtIntercalada) + (vlChave * qtChave));
    soma += vlAdicionais;

    if (soma > 0)
        $('#vlTotalLote').html(float2moeda(soma));
    else
        $('#vlTotalLote').html('0,00');
}

function maxParcelas(element) {
    var maximo = parseInt($('#maxParcelas').val()),
        total = 0;

    $(".quantidadeParcela").each(function () {
        var add = parseInt($(this).val());
        if (add)
            total = total + add;
    });

    if (maximo && maximo > 0)
        if (maximo < total) {
            alert('Valor superior ao mximo de parcelas do empreendimento (' + maximo + ').');
        }
}
//verifica se a data  vlida
function isValidDate(s) {
    var bits = s.split('/');
    var d = new Date(bits[2] + '/' + bits[1] + '/' + bits[0]);
    return !!(d && (d.getMonth() + 1) == bits[1] && d.getDate() == Number(bits[0]));
}
//retorna a quantidade de dias do ms
function daysInMonth(month, year) {
    return new Date(year, month, 0).getDate();
}