$(document).ready(function () {
    $('#TabelaListar').DataTable({
        "ajax": "?m=adm&c=acompanhamento&a=listaAcompanhamentos",
        "columns": [
            { "data": "codigo" },
            { "data": "nomeAcompanhamento" },
            { "data": "descricao" },
            { "data": "acoes" }
        ],
        dom: '<"btnAdicionar">lfrtip',
        "order": [[1, "asc"]],

        //Define as colunas que no tero ordenao
        "columnDefs": [
            {
                "targets": 0,
                "width": '80px',
                className: 'dt-center'
            },
            {
                "targets": 1,
                "width": "30%"
            },
            {
                "orderable": false,
                "targets": -1,
                "searchable": false,
                "width": '120px'
            }
        ],
        "lengthMenu": [[10, 25, 50], [10, 25, 50]],
        //Pensonalizando as mensagens que por default so em ingls e formatao de valores
        language: {
            "sEmptyTable": "Nenhum registro encontrado",
            "sInfo": "",
            "sInfoEmpty": "",
            "sInfoFiltered": "",
            "sInfoPostFix": "",
            "sInfoThousands": ".",
            "sLengthMenu": "_MENU_",
            "sLoadingRecords": "Carregando...",
            "sProcessing": "Processando...",
            "sZeroRecords": "Nenhum registro encontrado",
            "sSearch": "Busca",
            "oPaginate": {
                "sNext": "Prximo",
                "sPrevious": "Anterior",
                "sFirst": "Primeiro",
                "sLast": "ltimo"
            },
            "oAria": {
                "sSortAscending": ": Ordenar colunas de forma ascendente",
                "sSortDescending": ": Ordenar colunas de forma descendente"
            },

            "decimal": ",",
            "thousands": "."
        }
    });
    //Boto "Adicionar" da listagem de todas telas
    var btnAdicionar = '<a class="btn btn-success" href="?m=adm&c=acompanhamento&a=formulario"><i class="fa fa-plus-circle"></i> Adicionar</a>';
    $("div.btnAdicionar").html(btnAdicionar);
});

function deletar(element) {
    var id_acompanhamento = $(element).attr('value');
    if (confirm('Voc deseja continuar?')) {
        $.ajax({
            method: "POST",
            url: '?m=adm&c=acompanhamento&a=apagar',
            data: {
                id_acompanhamento: id_acompanhamento
            },
            success: function (response) {           
                try {
                    var response = JSON.parse(response);                    
                } catch (r){
                    alert("Voc no tem permisso para realizar esta ao");
                }
                
                if (response.response == 'true') {
                    alert('Operao realizada com sucesso');
                } else {
                    alert('No foi possvel realizar esta ao');
                } 
                location.reload();
            }
        });
    }
}