$(document).ready(function () {
    // Confere se existe $_GET com id
    const queryString = window.location.search;
    const urlParams = new URLSearchParams(queryString);
    const id = urlParams.get('id');
    // Modo editar
    if (id != null) {
        $.ajax({
            method: "POST",
            url: '?m=adm&c=acompanhamento&a=getInfo',
            data: {
                id: id
            },
            success: function (response) {
                var response = JSON.parse(response),
                    data = response.data;

                if (data[0].id != '') {
                    $('#nomeAcompanhamento').val(data[0].nm_acompanhamento);
                    $('#descricaoAcompanhamento').val(data[0].descricao);
                    gerarDados(data);
                }
                //Adiciona input id_acompanhamento
                $('<input>').attr({
                    type: 'hidden',
                    name: 'idAcompanhamento',
                    class: 'form-control',
                    value: data[0].id_acompanhamento
                }).appendTo('#form');

                //Redireciona o form para salvamento de edio
                $('#form').attr('action', '?m=adm&c=acompanhamento&a=salvarEdicao');
            }
        });
    }

    $('#adicionarContato').click(function () {
        var valContato = $('#contatos').val(),
            valPosicao = $('#posicao').val(),
            contatoNome = $("#contatos option:selected").html();

        adicionarDados(valContato, valPosicao, contatoNome);
    });

});

function gerarDados(data) {
    data.forEach(obj => {
        var valContato = obj.id_situacao,
            valPosicao = obj.id_ordem_sequencial,
            contatoNome = obj.agr_desc;

        adicionarDados(valContato, valPosicao, contatoNome);
    });
}

function adicionarDados(valContato, valPosicao, contatoNome) {
    if (valContato != '' && valPosicao != '') {
        //Validador
        if ($(`#contatosTd[value="${valContato}"]`).size() > 0) {
            alert('Este tipo de contato j est cadastrado!');
            return false;
        }

        if ($(`#posicoesTd[value="${valPosicao}"]`).size() > 0) {
            alert('Esta posio j est cadastrada!');
            return false;
        }

        //Adiciona input tipo contato
        $('<input>').attr({
            type: 'hidden',
            name: 'tipoContato[]',
            class: 'form-control',
            value: valContato
        }).appendTo('#form');

        //Adiciona input Posio
        $('<input>').attr({
            type: 'hidden',
            name: 'posicao[]',
            class: 'form-control',
            value: valPosicao
        }).appendTo('#form');

        // Adiciona linha na tabela
        $('#tabela tbody').append(`<tr><td id="contatosTd" value="${valContato}">${contatoNome}</td><td id="posicoesTd" value="${valPosicao}">${valPosicao}</td><td><a class='btn btn-default btn-sm' href="#" contato="${valContato}" pos="${valPosicao}"
            onclick="deletar(this);return false;"><i class='fa fa-times'></i></a></td></tr>`);
    } else {
        alert('Preencha todos os campos antes de adicionar');
    }
}

function deletar(element) {
    var valContato = $(element).attr('contato'),
        valPos = $(element).attr('pos');
    //Exclui a linha na tabela
    $(element).parents('tr').empty();
    //Exclui os inputs de registro
    $(`input[name='tipoContato[]'][value='${valContato}']`).remove();
    $(`input[name='posicao[]'][value='${valPos}']`).remove();
}

