/**
 *
 * @param settings
 * @returns {*}
 * exemplos:
 * $("#campo1").removeNot({ pattern: /[^0-9]+/g }); somente nmeros
 * $("#campo2").removeNot({ pattern: /[^a-z]+/g }); somente letras minsculas
 * $("#campo3").removeNot({ pattern: /[^a-z]+/gi }); somente letras maisculas e minsculas
 * $("#campo4").removeNot({ pattern: /[^a-z0-9]+/gi }); somente letras maisculas e minsculas e numeros
 * $("#campo5").removeNot({ pattern: /[^2468]+/g }); somente valores definidos (2,4,6,8)
 */
jQuery.fn.removeNot = function (settings) {
    var $this = jQuery(this);
    var defaults = {
        pattern: /[^0-9]/,
        replacement: ''
    }
    settings = jQuery.extend(defaults, settings);

    var new_value = $this.val().replace(settings.pattern, settings.replacement);

    return new_value;
}

function toggle_fullscreen() {
    var fullscreenEnabled = document.fullscreenEnabled || document.mozFullScreenEnabled || document.webkitFullscreenEnabled;
    if (fullscreenEnabled) {
        if (!document.fullscreenElement && !document.mozFullScreenElement && !document.webkitFullscreenElement && !document.msFullscreenElement) {
            launchIntoFullscreen(document.documentElement);
        } else {
            exitFullscreen();
        }
    }
}

function launchIntoFullscreen(element) {
    if (element.requestFullscreen) {
        element.requestFullscreen();
    } else if (element.mozRequestFullScreen) {
        element.mozRequestFullScreen();
    } else if (element.webkitRequestFullscreen) {
        element.webkitRequestFullscreen();
    } else if (element.msRequestFullscreen) {
        element.msRequestFullscreen();
    }
}

function exitFullscreen() {
    if (document.exitFullscreen) {
        document.exitFullscreen();
    } else if (document.mozCancelFullScreen) {
        document.mozCancelFullScreen();
    } else if (document.webkitExitFullscreen) {
        document.webkitExitFullscreen();
    }
}

function radiochange() {
    valor = $('#empreendimento_contrato_data_extrato').val();
    filtro = $("input[name='group1']:checked").val()
    $.ajax({
        type: "POST",
        url: "index.php?m=adm&c=contato&a=contrato_by_empreendimento_extrato",
        data: "id_empreendimento=" + valor + "&filtro=" + filtro,
        success: function (response) {
            $("#contrato_parcela_cliente option").remove();
            $("#contrato_parcela_restante option").remove();
            $("#contrato_parcela_cliente").append('<option value="*">Todos</option>' + response);
            $("#contrato_parcela_restante").append('<option value="">Selecione ...</option>' + response);
        }
    })
}

function add(obj1, obj2) {
    qtd = $(obj2).length - 1;
    rel = new String($(obj2).attr('title')).toString();
    max = rel.replace('max:', '');

    if (rel) {

        op = !$(obj1 + ' option:selected').remove().appendTo(obj2);

    } else {
        op = !$(obj1 + ' option:selected').remove().appendTo(obj2);
    }


}

function submeter(selectField) {
    $(selectField + ' option').each(function () {
        $(this).attr("selected", "selected");
    });
    return true;
}

//Valida o numero do cnpj
function validaCnpj(cnpj) {
    var r = cnpj;

    if (r == "") {
        return true
    }

    var exp = /\.|\-|\//g;
    r = r.toString().replace(exp, "");
    r = r.replace(".", "");
    r = r.replace(".", "");
    r = r.replace("-", "");
    var cnpj = r.replace("/", "");

    if (cnpj.length != 14) {
        return false
    }

    while (cnpj.length < 14)
        cnpj = "0" + cnpj;

    var z = /^0+$|^1+$|^2+$|^3+$|^4+$|^5+$|^6+$|^7+$|^8+$|^9+$/;
    var s = [6, 5, 4, 3, 2, 9, 8, 7, 6, 5, 4, 3, 2];
    var o = [];
    var u = new Number;

    for (i = 0; i < 12; i++) {
        o[i] = cnpj.charAt(i);
        u += o[i] * s[i + 1];
    }

    if ((x = u % 11) < 2) {
        o[12] = 0
    } else {
        o[12] = 11 - x
    }
    u = 0;

    for (var y = 0; y < 13; y++)
        u += o[y] * s[y];

    if ((x = u % 11) < 2) {
        o[13] = 0
    } else {
        o[13] = 11 - x
    }

    if (cnpj.charAt(12) != o[12] || cnpj.charAt(13) != o[13] || cnpj.match(z))
        return false;
    return true
}

function validaCPF(cpf) {

    cpf = cpf.replace(/[^\d]+/g, '');
    if (cpf != "") {

// Elimina CPFs invalidos conhecidos
        if (cpf.length != 11 || cpf == "00000000000" || cpf == "11111111111" || cpf == "22222222222" || cpf == "33333333333" || cpf == "44444444444" || cpf == "55555555555" || cpf == "66666666666" || cpf == "77777777777" || cpf == "88888888888" || cpf == "99999999999") {
            return false;
        }

// Valida 1o digito
        var add = 0;
        for (i = 0; i < 9; i++)
            add += parseInt(cpf.charAt(i)) * (10 - i);
        var rev = 11 - (add % 11);
        if (rev == 10 || rev == 11)
            rev = 0;
        if (rev != parseInt(cpf.charAt(9))) {
            return false;
        }

// Valida 2o digito
        add = 0;
        for (i = 0; i < 10; i++)
            add += parseInt(cpf.charAt(i)) * (11 - i);
        rev = 11 - (add % 11);
        if (rev == 10 || rev == 11)
            rev = 0;
        if (rev != parseInt(cpf.charAt(10))) {
            return false;
        }
    }
    return true;
}


function VerificaData(digData, iname) {
    var bissexto = 0;
    var data = digData;
    var tam = data.length;
    if (tam == 10) {
        var dia = data.substr(0, 2)
        var mes = data.substr(3, 2)
        var ano = data.substr(6, 4)
        if ((ano > 1900) || (ano < 2100)) {
            switch (mes) {
                case '01':
                case '03':
                case '05':
                case '07':
                case '08':
                case '10':
                case '12':
                    if (dia <= 31) {
                        return true;
                    }
                    break

                case '04':
                case '06':
                case '09':
                case '11':
                    if (dia <= 30) {
                        return true;
                    }
                    break
                case '02':
                    /* Validando ano Bissexto / fevereiro / dia */
                    if ((ano % 4 == 0) || (ano % 100 == 0) || (ano % 400 == 0)) {
                        bissexto = 1;
                    }
                    if ((bissexto == 1) && (dia <= 29)) {
                        return true;
                    }
                    if ((bissexto != 1) && (dia <= 28)) {
                        return true;
                    }
                    break
            }
        }
    }

    if (data != '__/__/____') {
        $('#' + iname).val('');
        alert("A Data " + data + "  invlida!");
        return false;
    }
    return true;
}

function validaData(data) {
    var dia = data.substring(0, 2);
    var mes = data.substring(3, 5);
    var ano = data.substring(6, 10);

    //Criando um objeto Date usando os valores ano, mes e dia.
    var novaData = new Date(ano, (mes - 1), dia);

    var mesmoDia = parseInt(dia, 10) === parseInt(novaData.getDate());
    var mesmoMes = parseInt(mes, 10) === parseInt(novaData.getMonth()) + 1;
    var mesmoAno = parseInt(ano) === parseInt(novaData.getFullYear());

    return (!((mesmoDia) && (mesmoMes) && (mesmoAno)));
}

// Register an API method that will empty the pipelined data, forcing an Ajax
// fetch on the next draw (i.e. `table.clearPipeline().draw()`)
$.fn.dataTable.Api.register('clearPipeline()', function () {
    return this.iterator('table', function (settings) {
        settings.clearCache = true;
    });
});


// Pipelining function for DataTables. To be used to the `ajax` option of DataTables
$.fn.dataTable.pipeline = function (opts) {
    // Configuration options
    var conf = $.extend({
        pages: 5,     // number of pages to cache
        url: '',      // script url
        data: null,   // function or object with parameters to send to the server
                      // matching how `ajax.data` works in DataTables
        method: 'POST' // Ajax HTTP method
    }, opts);

    // Private variables for storing the cache
    var cacheLower = -1;
    var cacheUpper = null;
    var cacheLastRequest = null;
    var cacheLastJson = null;

    return function (request, drawCallback, settings) {
        var ajax = false;
        var requestStart = request.start;
        var drawStart = request.start;
        var requestLength = request.length;
        var requestEnd = requestStart + requestLength;

        if (settings.clearCache) {
            // API requested that the cache be cleared
            ajax = true;
            settings.clearCache = false;
        }
        else if (cacheLower < 0 || requestStart < cacheLower || requestEnd > cacheUpper) {
            // outside cached data - need to make a request
            ajax = true;
        }
        else if (JSON.stringify(request.order) !== JSON.stringify(cacheLastRequest.order) ||
            JSON.stringify(request.columns) !== JSON.stringify(cacheLastRequest.columns) ||
            JSON.stringify(request.search) !== JSON.stringify(cacheLastRequest.search)) {
            // properties changed (ordering, columns, searching)
            ajax = true;
        }

        // Store the request for checking next time around
        cacheLastRequest = $.extend(true, {}, request);

        if (ajax) {
            // Need data from the server
            if (requestStart < cacheLower) {
                requestStart = requestStart - (requestLength * (conf.pages - 1));

                if (requestStart < 0) {
                    requestStart = 0;
                }
            }

            cacheLower = requestStart;
            cacheUpper = requestStart + (requestLength * conf.pages);

            request.start = requestStart;
            request.length = requestLength * conf.pages;

            // Provide the same `data` options as DataTables.
            if ($.isFunction(conf.data)) {
                // As a function it is executed with the data object as an arg
                // for manipulation. If an object is returned, it is used as the
                // data object to submit
                var d = conf.data(request);
                if (d) {
                    $.extend(request, d);
                }
            }
            else if ($.isPlainObject(conf.data)) {
                // As an object, the data given extends the default
                $.extend(request, conf.data);
            }

            settings.jqXHR = $.ajax({
                "type": conf.method,
                "url": conf.url,
                "data": request,
                "dataType": "json",
                "cache": false,
                "success": function (json) {
                    cacheLastJson = $.extend(true, {}, json);

                    if (cacheLower != drawStart) {
                        json.data.splice(0, drawStart - cacheLower);
                    }
                    if (requestLength >= -1) {
                        json.data.splice(requestLength, json.data.length);
                    }

                    drawCallback(json);
                }
            });
        }
        else {
            json = $.extend(true, {}, cacheLastJson);
            json.draw = request.draw; // Update the echo for each response
            json.data.splice(0, requestStart - cacheLower);
            json.data.splice(requestLength, json.data.length);

            drawCallback(json);
        }
    }
};

function removeAcento(newStringComAcento) {
    var string = newStringComAcento;
    var mapaAcentosHex = {
        a: /[\xE0-\xE6]/g,
        e: /[\xE8-\xEB]/g,
        i: /[\xEC-\xEF]/g,
        o: /[\xF2-\xF6]/g,
        u: /[\xF9-\xFC]/g,
        c: /\xE7/g,
        n: /\xF1/g
    };

    for (var letra in mapaAcentosHex) {
        var expressaoRegular = mapaAcentosHex[letra];
        string = string.replace(expressaoRegular, letra);
    }

    return string;
}
//Funo para pegar valor pelo GET via JavaScript
function getUrl(parameter) {
    var loc = location.search.substring(1, location.search.length);
    var param_value = false;
    var params = loc.split("&");
    for (i = 0; i < params.length; i++) {
        param_name = params[i].substring(0, params[i].indexOf('='));
        if (param_name == parameter) {
            param_value = params[i].substring(params[i].indexOf('=') + 1)
        }
    }
    if (param_value) {
        return param_value;
    } else {
        return false;
    }
}

/**
 *Exibe mensagem na tela
 * @param style
 * @param position
 * @param msg
 */
function autohidenotify(style, position, msg) {

    if (style == "error") {
        icon = "fa fa-exclamation";
    } else if (style == "warning") {
        icon = "fa fa-warning";
    } else if (style == "success") {
        icon = "fa fa-check";
    } else if (style == "info") {
        icon = "fa fa-question";
    } else {
        icon = "fa fa-circle-o";
    }

    $.notify({
        text: msg,
        image: '<i class="' + icon + '"></i>'
    }, {
        style: 'metro',
        className: style,
        globalPosition: position,
        showAnimation: "show",
        showDuration: 0,
        hideDuration: 0,
        autoHideDelay: 5000,
        autoHide: true,
        clickToHide: true
    });
}

/**
 * Funo para criar chamada ajax dinamicamente para preenchimento de outros campos select
 *
 * Colocar classe 'selectAjax' no campo select inicial que ir buscar informaes para preencher os outros
 *
 * Criar o atributos no campo inicial, se preciso:
 *         modulo = no obrigatrio, caso no exista a funo pega o do parametro 'm' da URL
 *         controller = no obrigatrio, caso no exista a funo pega o do parametro 'c' da URL
 *         acao = no obrigatrio, caso no exista a funo pega o do parametro 'a' da URL
 *         receptor = obrigatrio, colocar o ID dos campos select que iro receber a lista de dados
 */
function selectChange(select) {
    if (select.hasClass('selectAjax')) {
        if (select.val()) {
            var modulo = (select.attr('modulo'))?select.attr('modulo'):getUrl('m'),
                controller = (select.attr('controller'))?select.attr('controller'):getUrl('c'),
                acao = (select.attr('acao'))?select.attr('acao'):getUrl('a'),
                receptor = select.attr('receptor').split(' ');
            for (var i in receptor) {

                $('#'+receptor[i]).html('<option value="****" selected>Buscando Dados...</option>').trigger('change');
                $('#'+receptor[i]).attr('disabled',true);
            }
            $.ajax({
                type: "POST",
                url: "?m="+modulo+"&c="+controller+"&a="+acao,
                data: select.attr('name')+"="+select.val(),
                success: function (json) {
                    var json = JSON.parse(json);
                    for (var i in json) {
                        if (json[i].lista) {
                            $('#'+json[i].receptor).html('<option id=""></option>').trigger('change');
                            $('#'+json[i].receptor).attr('disabled', false);
                            $('#'+json[i].receptor).select2({
                                data: json[i].lista
                            });
                        } else {
                            $('#'+json[i].receptor).html('<option value="****" selected>Nenhum dado cadastrado.</option>').trigger('change');
                            $('#'+json[i].receptor).attr('disabled',true);
                        }
                    }
                }
            });
        }
    }
}

