$(document).ready(function () {
    // Esconde os tooltips apos click, ficavam
    // exibidos na tela na frente do modal
    $('[data-toggle="tooltip"]').click(function () {
        $('[data-toggle="tooltip"]').tooltip("hide");
    });

    // Funo para chamar o mtodo getData() e carregar mais avisos
    $(document).on('click', '.btnCarregaMais', function() {
        var ultimoId = parseFloat($('#ultimoId').val()) + 10;
        $.ajax({
            url: '?c=aviso&a=buscaAvisos',
            method: 'POST',
            dataType: 'json',
            data: {
                ultimoId : ultimoId
            },
            success : function (listaAvisos) {

                var qtdeAvisos = Object.keys(listaAvisos).length;

                if (qtdeAvisos == 10) {
                    lista_avisos(listaAvisos);
                } else if (qtdeAvisos > 0 && qtdeAvisos < 10) {
                    lista_avisos(listaAvisos);
                    $('.btnCarregaMais').hide();
                }
                $('#ultimoId').val(ultimoId);
            }
        });
    });

    // Busca mais avisos de atualizaes
    $(document).on('click', '.btnCarregaMaisAtualizacoes', function() {
        var ultimoIdAtualizacao = parseFloat($('#ultimoIdAtualizacao').val()) + 10;
        $.ajax({
            url: '?c=aviso&a=buscaTodosAvisosAtualizacoes',
            method: 'POST',
            dataType: 'json',
            data: {
                ultimoIdAtualizacao : ultimoIdAtualizacao
            },
            success : function (listaAvisos) {

                var qtdeAvisos = Object.keys(listaAvisos).length;

                if (qtdeAvisos == 10) {
                    lista_avisos(listaAvisos);
                } else if (qtdeAvisos > 0 && qtdeAvisos < 10) {
                    lista_avisos(listaAvisos);
                    $('.btnCarregaMaisAtualizacoes').hide();
                }
                $('#ultimoIdAtualizacao').val(ultimoIdAtualizacao);
            }
        });
    });

    // Verifica se no h nenhum aviso, caso sim,
    // esconde o cone para no exibir com zero
    if ($('#contaAvisos').html() < 1) {
        $('#contaAvisos').removeClass( "label-danger" );
        $('#contaAvisos').html('');
    }

    // Faz com que o dropdown permanea aberto aps clicar em algum aviso dentro do mesmo
    $(document).on('click','#dropdown-menu', function(event) {
        event.stopPropagation();
        if ($('#contaAvisos').html() < 1) {
            $('#contaAvisos').removeClass( "label-danger" );
            $('#contaAvisos').html('');
        }
    });

    // Marca o aviso como lido removendo a cor e bolinha vermelha
    $('.naoVisto').on('click', function() {
        var id_aviso = $(this).attr('idAviso');

        $.ajax({
            type: 'POST',
            url: '?m=&c=aviso&a=mensagemLida',
            dataType: 'json',
            data: { idAviso : id_aviso },
            success: function (response) {
                if ($('#contaAvisos').html() > 0) {
                    $('#bolinhaAtual_'+id_aviso).removeClass('fa-circle');
                    $('#mensagem_'+id_aviso).css("background", "white");
                    qtdAvisos = $('#contaAvisos').html() - 1;
                    $('#contaAvisos').html(qtdAvisos);
                    window.open('?m=sc&c=aviso&a=exibeAviso&idAviso='+id_aviso, '_blank');
                }
            }
        });
    });

    /*
     * VISUALIZAR
     * Funo global utilizada para exibir informaes do visualizar no modal
     */
    $(document).on('click', '.btn-visualizar', function () {
        var id = $(this).attr("value"),
            m = (getUrl('m')?getUrl('m'):'sc');
        $.ajax({
            type: 'POST',
            url: '?m=' + m + '&c=' + getUrl('c') + '&a=visualizar',
            dataType: 'html',
            data: {id: id},
            beforeSend: function () {
                $("#modalVisualizar .modal-body").html('<div align="center">Carregando. . . <a class="loading"></a></div>');
            },
            success: function (data) {
                $("#modalVisualizar .modal-body").html(data);
            }
        });
    });

    //Faz com que exiba a mensagem por 8s e suma depois
    setTimeout(function () {
        $("div.alert").slideUp('show');
    }, 8000);

    //Ativando o plugin para todos os select's normais com classe select2
    $('.select2').select2({
        allowClear: true,
        width: '100%', //Corrige tamanho dos select2's para tomar toda extensao do elemento
        language: {
            "noResults": function () {
                return "Nenhum resultado encontrado";
            },
            "searching": function () {
                return "Pesquisando...";
            }
        }
    }).on("change", function () {
        selectChange($(this));
    });

    $('.btn').tooltip({ trigger: "hover" });
    //Ativando o plugin para todos os select's normais com classe select2
    $('.fDesabilitaBtn').on('click', function(e) {
        var form = $('form'),
            campo = $(this),
            novoBotao = '<input type="button" disabled class="btn btn-primary col-sm-12 btnProccess" value="Aguarde...">';
        campo.hide();
        campo.parent().append(novoBotao);
        setTimeout(function () {
            $('.btnProccess').remove();
            campo.show();
        }, 3000);
    });

    /**
     * Remove acentos de strings
     * @param  {String} string acentuada
     * @return {String} string sem acento
     */
    var map = {
        "": "a",
        "": "A",
        "": "a",
        "": "A",
        "": "a",
        "": "A",
        "": "a",
        "": "A",
        "": "e",
        "": "E",
        "": "e",
        "": "E",
        "": "e",
        "": "E",
        "": "i",
        "": "I",
        "": "i",
        "": "I",
        "": "i",
        "": "I",
        "": "o",
        "": "O",
        "": "o",
        "": "O",
        "": "o",
        "": "O",
        "": "o",
        "": "O",
        "": "u",
        "": "U",
        "": "u",
        "": "U",
        "": "u",
        "": "U",
        "": "u",
        "": "U",
        "": "c",
        "": "C"
    };

    function removerAcentos(s) {
        return s.replace(/[\W\[\] ]/g, function (a) {
            return map[a] || a
        })
    }
    // Chamando tooltips explicativos para campos inputs
    $('.phone').mask("(00) 00000-0000");
    $(".cpf").mask("000.000.000-00");
    $(".cnpj").mask("00.000.000/0000-00");
    $(".hora").mask("00:00");

    /**
     * Service para buscar remotamente o endereo
     * https://viacep.com.br/
     */
    $(".cep").mask("00000-000").on('blur', function () {
        $.getJSON("//viacep.com.br/ws/" + $(this).val() + "/json/?callback=?", function (dados) {
            if (!("erro" in dados)) {
                //Atualiza os campos com os valores da consulta.
                $("#endereco").val(dados.logradouro);
                $("#nm_bairro").val(dados.bairro);
                $.ajax({
                    type: "GET",
                    url: "index.php?m=lo&c=ajax&a=find_cidade",
                    data: "term=" + removeAcento(dados.localidade)+'&uf='+dados.uf,
                    success: function (data) {
                        var obj = jQuery.parseJSON(data)[0];
                        $('#cidade').val(obj.id).trigger('change');
                        //Campos de pessoa fisia e jurdica - Modelo antigo
                        $('#dsCidade').val(dados.localidade);
                        $('#cd_cidade').val(obj.id);
                    }
                });
            } //end if.
            else {
                //CEP pesquisado no foi encontrado.
                $(this).val(null);
                alert("CEP no encontrado.");
            }
        });
    });

    $(".cepConjuge").mask("00000-000").on('blur', function () {
        $.getJSON("//viacep.com.br/ws/" + $(this).val() + "/json/?callback=?", function (dados) {
            if (!("erro" in dados)) {
                //Atualiza os campos com os valores da consulta.
                $("#enderecoConjuge").val(dados.logradouro);
                $("#nmBairroConjuge").val(dados.bairro);
                $.ajax({
                    type: "GET",
                    url: "index.php?m=lo&c=ajax&a=find_cidade",
                    data: "term=" + removeAcento(dados.localidade),
                    success: function (data) {
                        var obj = jQuery.parseJSON(data)[0];
                        $('#cidade').val(obj.id).trigger('change');
                        //Campos de pessoa fisia e jurdica - Modelo antigo
                        $('#cidadeConjuge').val(dados.localidade);
                        $('#cdCidadeConjuge').val(obj.id);
                    }
                });
            } //end if.
            else {
                //CEP pesquisado no foi encontrado.
                $(this).val(null);
                alert("CEP no encontrado.");
            }
        });
    });

    $(".data").mask("00/00/0000");
    $(".ano").mask("0000");
    $(".dataPeriodo").mask("00/0000");
    $(".soNumero").keyup(function () {
        this.value = this.value.replace(/\D/g, '');
    });
    $(".percent").keyup(function () {
        this.value = this.value.replace(/[^0-9\,\-]/g, '');
    });


    $(".money").mask('000.000.000.000.000,00', {reverse: true});
    $(".porcentagem").mask('00,0000', {reverse: true});
    //mascara exclusiva para o campo: Porc. Declarada (%) da tela Contbeis->Dados Contbeis
    $(".porcentagemDeclarada").mask('000,0000', {reverse: true});
    $(".tamanho").mask('00,000', {reverse: true});
    $(".numeroBaixa").mask('0000000000');

    $("#download").dataTable({
        "oLanguage": {
            "sPaginationType": "four_button",
            "sProcessing": "Processando...",
            "sLengthMenu": "Mostrar _MENU_ registros",
            "sZeroRecords": "No foram encontrados resultados",
            "sInfo": "Mostrando de _START_ at _END_ de _TOTAL_ registros",
            "sInfoEmpty": "Mostrando de 0 at 0 de 0 registros",
            "sInfoFiltered": "(filtrado de _MAX_ registros no total)",
            "sInfoPostFix": "",
            "sSearch": "Buscar:",
            "sUrl": "",
            "oPaginate": {
                "sFirst": "Primeiro",
                "sPrevious": "Anterior",
                "sNext": "Seguinte",
                "sLast": "ltimo"
            }
        }
    });

    //RECIBO (DESCONTO)
    $(".desconto").blur(function () {
        var vlDesconto = replaceAll($(this).val(), ".", "");
        vlDesconto = parseFloat(vlDesconto.replace(',', '.'));

        var valor = replaceAll($('.valor').val(), ".", "");
        valor = parseFloat(valor.replace(',', '.'));

        if ($(this).val() != "" && $(this).val() != 0) {
            if (vlDesconto > valor) {
                alert('O valor do desconto no pode ser maior que o valor do ttulo.');
                $(this).val(null);
            }

            if (vlDesconto < 0) {
                alert('O valor do desconto no pode ser nmero negativo.');
                $(this).val(null);
            }
        }
    });

    /**
     *  RELATORIO RECIBO
     */

    $("select.tipoReciboDe").change(function () {
        if ($(this).val() == "pj") {
            $("select.tipoReciboPara").html("<option value='ec'>Empreendimento</option><option value='ad'>Administrao</option>");
            $("#pf").hide();
            $("#pj").fadeIn();
        }
        if ($(this).val() == "pf") {
            $("select.tipoReciboPara").html("<option value='ec'>Empreendimento</option><option value='ad'>Administrao</option>");
            $("#pj").hide();
            $("#pf").fadeIn();
        }
        if ($(this).val() == "ec") {
            $("#idEmpreendimento").fadeIn();
            $("select.tipoReciboPara").html("<option value=''>Selecione...</option><option value='pf'>Pessoa Fsica</option><option value='pj'>Pessoa Jurdica</option>");
        }

        if ($(this).val() == "ad") {
            $("#idEmpreendimento").hide();
            $("select.tipoReciboPara").html("<option value=''>Selecione...</option><option value='pf'>Pessoa Fsica</option><option value='pj'>Pessoa Jurdica</option>");
        }

        if ($(this).val() == "") {
            $("select.tipoReciboPara").html("<option value=''>Selecione...</option><option value='ec'>Empreendimento</option><option value='ad'>Administrao</option><option value='pf'>Pessoa Fsica</option><option value='pj'>Pessoa Jurdica</option>");
            $("#pf").hide();
            $("#pj").hide();
            $("#idEmpreendimento").hide();
        }
    });

    $("select.tipoReciboPara").change(function () {
        if ($(this).val() == "pj") {
            $("#pf").hide();
            $("#pj").fadeIn();
        }
        if ($(this).val() == "pf") {
            $("#pj").hide();
            $("#pf").fadeIn();
        }
        if ($(this).val() == "ec") {
            $("#idEmpreendimento").fadeIn();
        }
        if ($(this).val() == "ad") {
            $("#idEmpreendimento").hide();
        }
        if ($(this).val() == "") {
            $("#pj").hide();
            $("#pf").hide();
        }
    });

    $("select.idEmpreendimento").change(function () {
        $.ajax({
            type: "POST",
            url: "index.php?m=fin&c=recibo&a=taxaByEmpreendimento",
            data: "idEmpreendimento=" + $(this).val(),
            success: function (json) {
                var options = '<option value="">Selecione ...</option>',
                    json = JSON.parse(json);
                $("select.id_taxa").html(options);
                $('[name="vl_recibo"]').val('');
                for (var i in json) {
                    options += '<option vltaxa="' + json[i].vl_taxa + '" value="' + json[i].id_taxas + '">' + json[i].descricao + '</option>'
                }
                $("select.id_taxa").html(options);
            }
        });

        $.ajax({
            type: "POST",
            url: "index.php?m=lo&c=ajax&a=lote_cliente_by_empreendimento_parcelas",
            data: "id_empreendimento=" + $(this).val(),
            success: function (json) {
                $("select.cliente").html('<option value=""> Selecione...</option>');
                var json = JSON.parse(json);
                for (var i in json) {
                    $("select.cliente").append('<option value="' + json[i].idPessoa + '">' + json[i].nm_pessoa + ' - Quadra:' + json[i].quadra + ' Lote:' + json[i].lote + ' - Contrato ' + json[i].id + '</option>');
                }
            }
        });

    });


    $(".id_taxa").change(function () {
        var vlTaxa = $(".id_taxa option:selected").attr('vltaxa');
        $('[name="vl_recibo"]').val(vlTaxa);
    });

    $(".tipoRel").change(function () {
        if ($(this).attr("value") == "carta") {
            $("#numeroCarta").hide();
            $("#cliente").hide();
            $("#empreendimento").fadeIn();
            $("#data").fadeIn();
            $("#carta").fadeIn();
        } else if ($(this).attr("value") == "numeroCarta") {
            $("#empreendimento").hide();
            $("#carta").hide();
            $("#data").hide();
            $("#cliente").hide();
            $("#numeroCarta").fadeIn();
        } else if ($(this).attr("value") == "cliente") {
            $("#numeroCarta").hide();
            $("#carta").hide();
            $("#data").fadeIn();
            $("#empreendimento").fadeIn();
            $("#cliente").fadeIn();
        }
    });

    //Funo para mostrar ou esconder os subitens do menu
    $(".masterLabel").click(function () {
        $('.masterLabel').each(function () {
            $(this).parent().children(".sub-menu").hide(350);
        });

        var subMenu = $(this).parent().children(".sub-menu");
        if (subMenu.is(":visible")) {
            subMenu.hide(350);
        } else {
            subMenu.show(350);
        }
    });

    $("#controller").click(function () {
        $.ajax({
            type: "GET",
            url: "index.php?c=ajax&a=actions",
            data: "controller=" + $(this).val(),
            success: function (response) {
                $("#action").html(response);
            }
        });
    });

    /**
     * CONTRATO
     */
    $("select.empreendimento").change(function () {
        $.ajax({
            type: "POST",
            url: "index.php?m=lo&c=ajax&a=loteByEmpreendimento",
            data: "id_empreendimento=" + $(this).val(),
            success: function (json) {
                $("select.lote").html('<option value=""> Selecione...</option>');
                var json = JSON.parse(json);
                for (var i in json) {
                    $("select.lote").append('<option value="' + json[i].id + '"> Quadra:' + json[i].quadra + ' Lote:' + json[i].lote + '</option>');
                }
            }
        });

        $.ajax({
            type: "POST",
            url: "index.php?m=lo&c=ajax&a=banco_by_empreendimento",
            data: "id_empreendimento=" + $(this).val(),
            success: function (response) {
                $("select.banco").html(response);
            }
        });

        $.ajax({
            type: "POST",
            url: "index.php?m=lo&c=ajax&a=corretor_by_empreendimento",
            data: "id_empreendimento=" + $(this).val(),
            success: function (response) {
                $("select.corretor").html(response);
            }
        });
    });

    /**
     * BAIXA DE PARCELA
     */

    $("select.empreendimento_contrato_gerado").change(function () {
        $("select.contrato_parcela").attr('disabled', true);
        $("select.parcelas_nao_pagas").attr('disabled', true);
        $.ajax({
            type: "POST",
            url: "index.php?m=lo&c=ajax&a=contrato_by_empreendimento_baixar_parcela",
            data: "id_empreendimento=" + $(this).val(),
            success: function (response) {

                $("select.contrato_parcela").html(response);
                $("select.contrato_parcela").attr('disabled', false);
            }
        });

        $.ajax({
            type: "POST",
            url: "index.php?m=lo&c=ajax&a=banco_by_empreendimento",
            data: "id_empreendimento=" + $(this).val(),
            success: function (response) {
                $("select.banco").html(response);
            }
        });
    });

    /**
     * DECLARACOES
     */

    $("select.empreendimento_contrato_gerado2").change(function () {
        $("select.contrato_parcela").attr('disabled', true);
        $.ajax({
            type: "POST",
            url: "index.php?m=lo&c=ajax&a=contrato_by_empreendimento_baixar_parcela",
            data: "id_empreendimento=" + $(this).val(),
            success: function (response) {
                $(".contrato_parcela").html(response);

            }
        });
    });

    /**
     * BAIXA MANUAL
     */

    $("select.parcelas_nao_pagas").change(function () {
        $.ajax({
            type: "POST",
            url: "index.php?m=lo&c=ajax&a=calculaMultaJurosParcela",
            data: "contrato=" + $('select.contrato_parcela').val() + '&parcela=' + $(this).val(),
            dataType: "json",
            success: function (response) {
                $("#total_baixa_parcela").html('<strong>R$ ' + response.valor + '</strong>');
                $("#total_baixa_parcela_desconto").html('<strong>R$ ' + response.valor + '</strong>');
                $("#valor_do_titulo").html('<strong>R$ ' + float2moeda(response.valorParcela) + '</strong>');
                $("#valor_acrescimo").html('<strong>R$ ' + response.acrescimo + '</strong>');
                $("#valor_do_tituloHidden").val(float2moeda(response.valorParcela));
                $("#valor_acrescimoHidden").val(moeda2float(response.acrescimo));
                $("#data_vencimento").html('<strong>' + response.dt_vencimento + '</strong>');
                $("#valor_total_baixa_parcela").val(response.valor);
                $("#vl_multa").val(response.multa);
                $("#vl_multaHidden").val(response.multa);
                $("#vl_juros").val(response.juros);
                $("#vl_jurosHidden").val(response.juros);
                $('#vlDesconto').val(response.desconto);

            }
        });
    });

    $("select.tpBaixa").change(function () {
        if ($(this).val() == 'B') {
            $("#bancoPagamento").show();
        } else {
            $("#bancoPagamento").hide();
        }
    });

    $("#vl_multa").blur(function () {

        var vlMulta = replaceAll($('#vl_multa').val(), ".", "");
        vlMulta = parseFloat(vlMulta.replace(',', '.'));

        if (vlMulta < 0.00) {
            alert("O valor da multa no pode ser negativo!");
            $('#vl_multa').focus();
        } else {
            $.ajax({
                type: "POST",
                url: "index.php?m=lo&c=ajax&a=calculaMultaJurosParcela",
                data: "multa=" + $('#vl_multa').val() + "&juros=" + $('#vl_juros').val() + "&desconto=" + $('#vlDesconto').val() + '&valor=' + $("#valor_total_baixa_parcela").val() + '&parcela=' + $("#id_parcela").val() + '&nrBaixa=' + $("#nr_baixa").val(),
                success: function (response) {
                    $("#total_baixa_parcela").html('<strong>R$ ' + response + '</strong>');
                }
            });
        }
    });

    $("#vl_juros").blur(function () {
        var vlJuros = replaceAll($('#vl_juros').val(), ".", "");
        vlJuros = parseFloat(vlJuros.replace(',', '.'));

        if (vlJuros < 0) {
            alert("O valor do juros no pode ser negativo!");
            $('#vl_juros').focus();
        } else {
            $.ajax({
                type: "POST",
                url: "index.php?m=lo&c=ajax&a=calculaMultaJurosParcela",
                data: "multa=" + $('#vl_multa').val() + "&juros=" + $('#vl_juros').val() + "&desconto=" + $('#vlDesconto').val() + '&valor=' + $("#valor_total_baixa_parcela").val() + '&parcela=' + $("#id_parcela").val() + '&nrBaixa=' + $("#nr_baixa").val(),
                success: function (response) {
                    $("#total_baixa_parcela").html('<strong>R$ ' + response + '</strong>');
                }
            });
        }
    });

    $("#btnRecalcula").click(function () {
        $.ajax({
            type: "POST",
            url: "index.php?m=lo&c=ajax&a=calculaMultaJurosParcela",
            dataType: "json",
            data: {
                contrato: $('select.contrato_parcela').val(),
                multa: $('#vl_multa').val(),
                juros: $('#vl_juros').val(),
                desconto: $('#vlDesconto').val(),
                valor: $("#valor_total_baixa_parcela").val(),
                parcela: $("#id_parcela").val(),
                nrBaixa: $("#nr_baixa").val(),
                dataPagamento: $("#dt_pagamento").val()
            },
            success: function (response) {
                $("#total_baixa_parcela").html('<strong>R$ ' + response.valor + '</strong>');
                $("#total_baixa_parcela_desconto").html('<strong>R$ ' + response.valor + '</strong>');
                $("#valor_do_titulo").html('<strong>R$ ' + float2moeda(response.valorParcela) + '</strong>');
                $("#valor_acrescimo").html('<strong>R$ ' + response.acrescimo + '</strong>');
                $("#valor_do_tituloHidden").val(float2moeda(response.valorParcela));
                $("#valor_acrescimoHidden").val(moeda2float(response.acrescimo));
                $("#data_vencimento").html('<strong>' + response.dt_vencimento + '</strong>');
                $("#valor_total_baixa_parcela").val(response.valor);
                $("#vl_multa").val(response.multa);
                $("#vl_multaHidden").val(response.multa);
                $("#vl_juros").val(response.juros);
                $("#vl_jurosHidden").val(response.juros);
                $('#vlDesconto').val(response.desconto);
            }
        });
    });

    $("input:radio[name=radioSinal]").change(function () {
        var valorSinal = parseFloat($("#SinalValor").val());
        var SinalComDesconto = valorSinal * parseFloat($("#vlPorcDev").val()) * 0.01;
        var valorParcelas = parseFloat(moeda2float($("#vlTotalDistrato").val()));
        var qtdParcelas = parseFloat($("#qtdeParcelaDistrato").val());

        if ($(this).val() == 'S') {
            if (valorSinal) {
                if (valorParcelas) {
                    $("#qtdeParcelaDistrato").val(qtdParcelas + 1);
                    $("#vlTotalDistrato").val(float2moeda(SinalComDesconto + valorParcelas));
                    $("#vlTotalDistratoH").val(float2moeda(SinalComDesconto + valorParcelas));
                    $("#vlParcelaDistrato").val(float2moeda((valorParcelas + SinalComDesconto) / (qtdParcelas + 1)));
                    $("#vlParcelaDistratoH").val(float2moeda((valorParcelas + SinalComDesconto) / (qtdParcelas + 1)));
                } else {
                    $("#qtdeParcelaDistrato").val(1);
                    $("#vlTotalDistrato").val(float2moeda(SinalComDesconto));
                    $("#vlTotalDistratoH").val(float2moeda(SinalComDesconto));
                    $("#vlParcelaDistrato").val(float2moeda(SinalComDesconto));
                    $("#vlParcelaDistratoH").val(float2moeda(SinalComDesconto));
                }
            }
        }
        if ($(this).val() == 'N') {
            if (valorSinal) {
                if (valorParcelas) {
                    $("#qtdeParcelaDistrato").val(qtdParcelas - 1);
                    $("#vlTotalDistrato").val(float2moeda(valorParcelas - SinalComDesconto));
                    $("#vlTotalDistratoH").val(float2moeda(valorParcelas - SinalComDesconto));
                    $("#vlParcelaDistrato").val(float2moeda((valorParcelas - SinalComDesconto) / (qtdParcelas - 1)));
                    $("#vlParcelaDistratoH").val(float2moeda((valorParcelas - SinalComDesconto) / (qtdParcelas - 1)));
                } else {
                    $("#qtdeParcelaDistrato").val(0);
                    $("#vlTotalDistrato").val(float2moeda(0));
                    $("#vlTotalDistratoH").val(float2moeda(0));
                    $("#vlParcelaDistrato").val(float2moeda(0));
                    $("#vlParcelaDistratoH").val(float2moeda(0));
                }
            }
        }
    });


    $("input:radio[name=opcao]").click(function () {
        if ($("input:radio[name=opcao]:checked").val() == 'N') {
            $(".campo_nr_baixa").css('display', '');
            $(".campo_buscar").css('display', 'none');
            $("#id_parcela").val('');
        } else {
            $(".campo_nr_baixa").css('display', 'none');
            $("#nr_baixa").val('');
            $('input[type="submit"]').removeAttr('disabled');
            $(".campo_buscar").css('display', '');
        }
    });

    $('#nr_baixa').blur(function () {
        $.ajax({
            type: "POST",
            url: "index.php?m=lo&c=ajax&a=pesquisaExibeTitulos",
            data: "numero=" + $('#nr_baixa').val(),
            dataType: "json",
            success: function (response) {
                if (!response) {
                    alert('Ttulo no encontrado!');
                } else {
                    if (response.pago == '1') {
                        $('input[type="submit"]').attr('disabled', 'disabled');
                        alert('Parcela j baixada.')
                    } else {
                        $('input[type="submit"]').removeAttr('disabled');
                    }

                    $('#empreendimento').val(" " + response.empreendimento);
                    $("#cliente").val(" " + response.cliente);
                    $("#lote").val(" " + response.lote);
                    $("#num_contrato").val(" " + response.num_contrato);
                    $("#num_parcela").val(" " + response.parcela);

                    $.ajax({
                        type: "POST",
                        url: "index.php?m=lo&c=ajax&a=banco_by_empreendimento",
                        data: "id_empreendimento=" + response.idEmpreendimento,
                        success: function (response) {
                            $("select.banco").html(response);
                        }
                    });
                }
            }
        });
    });

    $("#nr_baixa").blur(function () {
        $.ajax({
            type: "POST",
            url: "index.php?m=lo&c=ajax&a=calculaValorTotalBaixaParcelaPeloNumero",
            data: "numero=" + $('#nr_baixa').val(),
            dataType: "json",
            success: function (response) {
                $("#total_baixa_parcela").html('<strong>R$ ' + float2moeda(response.total) + '</strong>');
                $("#valor_do_titulo").html('<strong>R$ ' + response.valor + '</strong>');
                $("#data_vencimento").html('<strong>' + response.dt_vencimento + '</strong>');
                $("#valor_total_baixa_parcela").val(response.valor);
                $("#vl_multa").val(float2moeda(response.multa));
                $("#vl_juros").val(float2moeda(response.juros));
                $("#vlDesconto").attr('disabled', true);
                $("#valor_do_tituloHidden").val(response.valor);
            }
        });
    });

    $('#nr_titulo').blur(function () {
        $.ajax({
            type: "POST",
            url: "index.php?m=lo&c=ajax&a=pesquisaExibeTitulos",
            data: {
                numero: $('#nr_titulo').val(),
                migradas: $('[name="migradas"]:checked').val()
            },
            dataType: "json",
            success: function (response) {
                if (!response) {
                    alert('Ttulo no encontrado!');
                    $('#situacao').val(null);
                    $('#empreendimento').val(null);
                    $("#cliente").val(null);
                    $("#lote").val(null);
                    $("#quadra").val(null);
                    $("#num_contrato").val(null);
                    $("#num_parcela").val(null);
                    $("#data").val(null);
                    $("#valor").val(null);
                } else {
                    $('#situacao').val(" " + response.situacao);
                    $('#empreendimento').val(" " + response.empreendimento);
                    $("#cliente").val(" " + response.cliente);
                    $("#lote").val(" " + response.lote);
                    $("#quadra").val(" " + response.quadra);
                    $("#num_contrato").val(" " + response.num_contrato);
                    $("#num_parcela").val(" " + response.parcela);
                    $("#data").val(" " + response.data);
                    $("#valor").val(" R$ " + response.valor);
                }
            }
        });
    });

    //reserva de lote
    $("select.empreendimentoReserva").change(function () {
        $("select.loteReserva").html('<option value="">Selecione ...</option>');
        $.ajax({
            type: "POST",
            url: "index.php?m=lo&c=ajax&a=loteByEmpreendimento",
            data: "id_empreendimento=" + $(this).val(),
            success: function (json) {
                var json = JSON.parse(json);
                for (var i in json) {
                    $("select.loteReserva").append('<option value="' + json[i].id + '"> Quadra:' + json[i].quadra + ' Lote:' + json[i].lote + '</option>')
                }
            }
        });
        $("select.corretorReserva").html('<option value="">Selecione ...</option>');
        $.ajax({
            type: "POST",
            url: "index.php?m=lo&c=ajax&a=corretorByEmpreendimento",
            data: "id_empreendimento=" + $(this).val(),
            success: function (json) {
                var json = JSON.parse(json);
                for (var i in json) {
                    $("select.corretorReserva").append('<option value="' + json[i].id + '">' + json[i].nm_pessoa + '</option>')
                }
            }
        });
    });

    /**
     * REMESSA - NOVO MDULO
     */

    //boletos primeira via
    $("select.empreendimento_boleto").change(function () {
        $("select.ano").html('<option value="">Selecione ...</option>');
        $("select.banco_boleto").html('<option>Selecione ...</option>');
        $("select.contrato_ano").html('<option>Selecione ...</option>');
        $("select.parcelaContrato").html('<option>Selecione ...</option>');
        $.ajax({
            type: "POST",
            url: "index.php?m=lo&c=ajax&a=bancoByEmpreendimento",
            data: "id_empreendimento=" + $(this).val(),
            success: function (response) {
                $("select.banco_boleto").html(response);
                if ($(".banco_boleto option").size() == 2) {
                    $(".banco_boleto").trigger('change');
                }
            }
        });
    });

    $("select.banco_boleto").change(function () {
        $("select.contrato_ano").html('<option value="">Selecione ...</option>');
        $("select.parcelaContrato").html('<option>Selecione ...</option>');
        $.ajax({
            type: "POST",
            url: "index.php?m=lo&c=ajax&a=contratoByBancoEmpreendimento",
            data: "id_empreendimento=" + $("select.empreendimento_boleto").val() + "&idBanco=" + $(this).val(),
            success: function (response) {
                $("select.contrato_ano").html(response);
            }
        });
    });

    //boletos segunda via
    $("select.empreendimento_boleto2Via").change(function () {
        $("select.ano").html('<option value="">Selecione ...</option>');
        $("select.banco_boleto2Via").html('<option></option>');
        $("select.contrato_ano").html('<option>Selecione ...</option>');
        $("select.parcelaContrato").html('<option>Selecione ...</option>');
        $.ajax({
            type: "POST",
            url: "index.php?m=lo&c=ajax&a=contrato_by_empreendimento_gerado",
            data: "id_empreendimento=" + $(this).val(),
            success: function (response) {
                $("select.contrato_ano").html(response);
            }
        });
    });

    //Boletos da segunda via
    $("select.contrato_emp").change(function () {
        $("select.parcelaContrato").html('<option value="">Selecione ...</option>');
        $.ajax({
            type: "POST",
            url: "index.php?m=lo&c=ajax&a=parcelaByContrato2Via",
            data: "contrato_emp=" + $(this).val(),
            success: function (json) {
                var json = JSON.parse(json);
                for (var i in json) {
                    $("select.parcelaContrato").append('<option value="' + json[i].id_parcela_contrato + '"> Parcela:' + json[i].id_parcela + json[i].tp_parcela + ' - Data de Venc.:' + json[i].dt_parcela + '</option>')
                }
            }
        });
        $.ajax({
            type: "POST",
            url: "index.php?m=lo&c=ajax&a=bancoByContrato",
            data: "id_banco=" + $("select.contrato_emp option:selected").attr("banco"),
            success: function (response) {
                $("select.banco_boleto2Via").html(response);
                $(".banco_boleto2Via").trigger('change');
            }
        });
    });

    //Boletos da segunda via
    $("select.parcelaContrato").change(function () {
        $.ajax({
            type: "POST",
            url: "index.php?m=lo&c=ajax&a=parcelaById",
            data: "parcelaId=" + $(this).val(),
            success: function (json) {
                var json = JSON.parse(json);
                //preenche o valor da parcela fixo e a data da parcela original  guardada em um hidden dataParcelaOriginal
                if (json.vl_parcela) {
                    $("td.valor_do_titulo").html('<strong>R$ ' + float2moeda(json.vl_parcela) + '</strong>');
                    $("td.valor_do_titulo").val(json.vl_parcela);
                    $("#dataParcelaOriginal").val(json.dt_parcela);
                } else $("td.valor_do_titulo").html('<strong>R$ 0,00</strong>');

                //calcula o juros usando os dados do banco do empreendimento
                var multa = $('option:selected', $("select.banco_boleto2Via")).attr('multa');
                var juros = $('option:selected', $("select.banco_boleto2Via")).attr('juros');
                var dias = diferencaDatasDias(($("#dataVencimento").val()), json.dt_parcela);
                if (dias > 0) {
                    if (multa) {
                        multa = multa * 0.01 * json.vl_parcela;
                        $("#vl_multa2Boleto").val(float2moeda(multa));
                    } else $("#vl_multa2Boleto").val('0,00');
                    if (juros) {
                        juros = juros * json.vl_parcela;
                        juros = juros * 0.01 * dias;
                        $("#vl_juros2Boleto").val(float2moeda(juros));
                    } else {
                        $("#vl_juros2Boleto").val('0,00');
                    }
                } else {
                    $("#vl_juros2Boleto").val('0,00');
                    $("#vl_multa2Boleto").val('0,00');
                }

                //atualiza o campo valor atual com a soma dos valores
                if (json.vl_parcela) {
                    var valorTotal = parseFloat(json.vl_parcela);
                    if (multa) valorTotal += parseFloat(moeda2float($("#vl_multa2Boleto").val()));
                    if (juros) valorTotal += parseFloat(moeda2float($("#vl_juros2Boleto").val()));
                    $("td.valor_atual").html('<strong>R$ ' + float2moeda(valorTotal) + '</strong>');
                    $("#valor_atual").val(valorTotal);
                }
            }
        })
    });

    $("#dataVencimento").blur(function () {
        //calcula o juros usando os dados do banco do empreendimento
        var multa = $('option:selected', $("select.banco_boleto2Via")).attr('multa');
        var juros = $('option:selected', $("select.banco_boleto2Via")).attr('juros');
        var dias = diferencaDatasDias(($("#dataVencimento").val()), $("#dataParcelaOriginal").val());
        if (dias > 0) {
            if (multa) {
                multa = multa * 0.01 * parseFloat($("td.valor_do_titulo").val());
                $("#vl_multa2Boleto").val(float2moeda(multa));
            } else {
                $("#vl_multa2Boleto").val('0,00');
            }
            if (juros) {
                juros = juros * 0.01 * parseFloat($("td.valor_do_titulo").val());
                juros = juros * dias;
                $("#vl_juros2Boleto").val(float2moeda(juros));
            } else {
                $("#vl_juros2Boleto").val('0,00');
            }
        } else {
            $("#vl_juros2Boleto").val('0,00');
            $("#vl_multa2Boleto").val('0,00');
        }
        //recalcula o valor atual do titulo com novos valores de juros e multa
        var valorTotal = parseFloat($("td.valor_do_titulo").val());
        valorTotal += parseFloat(moeda2float($("#vl_multa2Boleto").val()));
        valorTotal += parseFloat(moeda2float($("#vl_juros2Boleto").val()));
        $("td.valor_atual").html('<strong>R$ ' + float2moeda(valorTotal) + '</strong>');
        $("#valor_atual").val(valorTotal);
    });

    //Boletos da segunda via
    $("#vl_multa2Boleto,#vl_juros2Boleto").blur(function () {

        var vlMulta = ($("#vl_multa2Boleto").val() == '' || $("#vl_multa2Boleto").val() == 0) ? 0 : moeda2float($("#vl_multa2Boleto").val()),
            vlJuros = ($("#vl_juros2Boleto").val() == '' || $("#vl_juros2Boleto").val() == 0) ? 0 : moeda2float($("#vl_juros2Boleto").val()),
            vlTitulo = ($("#valor_do_titulo").val() == '' || $("#valor_do_titulo").val() == 0) ? 0 : parseFloat($("#valor_do_titulo").val());

        if (vlMulta < 0) {
            alert('O valor da multa no pode ser negativo.');
            $("#vl_multa2Boleto").focus();
        } else {
            var vlTotal = vlMulta + vlJuros + vlTitulo;
            $("td.valor_atual").html('<strong>R$ ' + float2moeda(vlTotal) + '</strong>');
            $("#valor_atual").val(vlTotal);
        }
    });

    /**
     * Declaraes
     */
    $("select.empreendimento_declaracoes").change(function () {
        $("select.clientes").html('<option value="">Selecione ...</option>');
        $.ajax({
            type: "POST",
            url: "index.php?m=lo&c=ajax&a=cliente_by_empreendimento",
            data: "id_empreendimento=" + $(this).val(),
            success: function (response) {
                $("select.clientes").html(response);
            }
        });
    });

    $("select.empreendimento_declaracoes2").change(function () {
        $("select.clientes").html('<option value="">Selecione ...</option>');
        $.ajax({
            type: "POST",
            url: "index.php?m=lo&c=ajax&a=cliente_by_empreendimento2",
            data: "id_empreendimento=" + $(this).val(),
            success: function (response) {
                $("select.clientes").html(response);
            }
        });
    });


    $("select.empreendimento_lote_cliente").change(function () {
        $("select.contratos").html('<option value="">Selecione ...</option>');
        $.ajax({
            type: "POST",
            url: "index.php?m=lo&c=ajax&a=lote_cliente_by_empreendimento",
            data: "id_empreendimento=" + $(this).val(),
            success: function (response) {
                $("select.contratos").html(response);
            }
        });
        $.ajax({
            type: "POST",
            url: "index.php?m=lo&c=ajax&a=loteByEmpreendimento",
            data: "id_empreendimento=" + $(this).val(),
            success: function (json) {
                $("select.lote").html('<option value=""> Selecione...</option>');
                var json = JSON.parse(json);
                for (var i in json) {
                    $("select.lote").append('<option value="' + json[i].id + '"> Quadra:' + json[i].quadra + ' Lote:' + json[i].lote + '</option>');
                }
            }
        });
    });

    //Emitir contrato
    $("select.empreendimento_lote_cliente_gerar").change(function () {
        $("select.contratos").html('<option value="">Selecione ...</option>');
        $.ajax({
            type: "POST",
            url: "index.php?m=lo&c=ajax&a=lote_cliente_by_empreendimento_parcelas",
            data: {id_empreendimento: $(this).val(), gerado: false},
            success: function (json) {
                var json = JSON.parse(json);
                for (var i in json) {
                    $("select.contratos").append('<option value="' + json[i].id + '">' + json[i].nm_pessoa + ' - Quadra ' + json[i].quadra + ' - Lote ' + json[i].lote + ' - Contrato ' + json[i].id_contrato + '</option>');
                }
            }
        });
    });

    $("select.empreendimento_lote_quitacao").change(function () {
        $("select.contratos").html('<option value="">Selecione ...</option>');
        $.ajax({
            type: "POST",
            url: "index.php?m=lo&c=ajax&a=lote_quitacao_by_empreendimento",
            data: "id_empreendimento=" + $(this).val(),
            success: function (response) {
                $("select.contratos").html(response);
            }
        });
    });

    $("select.contratos").change(function () {
        if ($('#loteId').length != 0) {
            $('#loteId').val($("select.contratos > option[value=" + $(this).val() + "]").attr('loteId'));
        }
    });

    $("select.empreendimento_cliente").change(function () {
        $("select.clientes").html('<option value="">Selecione ...</option>');
        $.ajax({
            type: "POST",
            url: "index.php?m=lo&c=ajax&a=cliente_by_empreendimento",
            data: "id_empreendimento=" + $(this).val(),
            success: function (response) {
                $("select.clientes").html(response);
            }
        });
    });

    $("select.clientes").change(function () {
        $("select.lotes").html('<option value="">Selecione ...</option>');
        idEmpreendimento = $("select.empreendimento_cliente").val();
        $.ajax({
            type: "POST",
            url: "index.php?m=lo&c=ajax&a=lotes_by_cliente",
            data: "id_empreendimento=" + idEmpreendimento + "&id_pessoa=" + $(this).val(),
            success: function (response) {
                $("select.lotes").html(response);
            }
        });
    });

    $("select.contrato_ano").change(function () {
        $.ajax({
            type: "POST",
            url: "index.php?m=lo&c=ajax&a=contrato_per_year",
            data: "contrato=" + $(this).val(),
            success: function (response) {
                $("select.ano").html(response);
            }
        });
    });

    $("select.contrato_parcela").change(function () {
        $("select.parcelas_nao_pagas").attr('disabled', true);
        $.ajax({
            type: "POST",
            url: "index.php?m=lo&c=ajax&a=contrato_parcela_nao_paga",
            data: "contrato=" + $(this).val(),
            success: function (response) {
                $("select.parcelas_nao_pagas").html(response);
                $("select.parcelas_nao_pagas").attr('disabled', false);
            }
        });
    });

    //Exibir so parcelas pagas
    $("select.empreendimento_contrato_gerado_pagas").change(function () {
        $("select.contrato_parcela_paga").attr('disabled', true);
        $("select.parcelas_pagas_paga").attr('disabled', true);
        $.ajax({
            type: "POST",
            url: "index.php?m=lo&c=ajax&a=contrato_by_empreendimento_baixar_parcela",
            data: "id_empreendimento=" + $(this).val(),
            success: function (response) {
                $("select.contrato_parcela_paga").html(response);
                $("select.contrato_parcela_paga").attr('disabled', false);
            }
        });
    });

    //Exibir o subtotalizar se for selecionado ordenacao por data de credito em relatorio de parcelas pagas
    $("[name=ordem]").on('change', function () {
        if ($(this).val() == 'C') {
            $("#trSubtotalizar").show('slow');
        } else {
            $("#subtotalizarN").trigger('click');
            $("#trSubtotalizar").hide('slow');
        }
    });

    $("select.contrato_parcela_res").change(function () {
        $("select.parcelas_paga").attr('disabled', true);
        $.ajax({
            type: "POST",
            url: "index.php?m=lo&c=ajax&a=contrato_parcela_paga",
            data: "contrato=" + $(this).val(),
            success: function (response) {
                $("select.parcelas_paga").html(response);
                $("select.parcelas_paga").attr('disabled', false);
            }
        });
    });

    /**
     * CONTRATO FORM
     */
    //cadastro de contrato - Adicionar cliente a lista de pessoas envolvidas
    $('input.cliente_contrato_add').click(function () {
        var id = $('#envolvido').val(),
            cpf = $('#envolvidoCpf').val(),
            nome = $('#clientes_contrato').val(),
            exist = false;
        //testa se o valor no input hidden envolvido existe no select
        $('select.socios option').each(function () {
            if (id == $(this).val()) {
                exist = true;
            }
        });
        //testa se o valor existe no input hidden de responsvel
        if ($('#cliente').val() == id) {
            exist = true;
        }

        if (exist) {
            alert('Pessoa j adicionada!');
            $('#clientes_contrato').val('');
            $('#envolvido').val('');
            $('#envolvidoCpf').val('');
        } else {
            if (id == '' || nome == '') {
                alert('No existe ningum para adicionar!');
            } else {
                $.ajax({
                    type: "POST",
                    url: "index.php?m=lo&c=ajax&a=fetch_pessoa_fisica",
                    data: "pessoa=" + id,
                    success: function (response) {
                        $("select.pessoas_envolvidas").append(response);

                        $("select.pessoas_envolvidas option").each(function () {
                            var quant = 0,
                                id_exist = $(this).val();
                            $("select.pessoas_envolvidas option").each(function () {
                                if (id_exist == $(this).val()) {
                                    alert('Pessoa j adicionada!');
                                    quant++;
                                    if (quant > 1) {
                                        $(this).remove();
                                    }
                                }
                            });
                            quant = 0;
                        });
                    }
                });
                $('#clientes_contrato').val('');
                $('#envolvido').val('');
                $('#envolvidoCpf').val('');
            }
        }
    });

    //cadastro de contrato - Remover cliente a lista de pessoas envolvidas
    $('.cliente_contrado_rem').click(function () {
        $('select.pessoas_envolvidas option:selected').each(function () {
            if (confirm('Deseja remover esse item?')) {
                $(this).remove();
            }
        });

        $('select.pessoas_envolvidas option').each(function () {
            $.ajax({
                type: "POST",
                url: "index.php?m=lo&c=ajax&a=fetch_pessoa_fisica",
                data: "pessoa=" + $(this).val(),
                success: function (response) {
                    $("select.socios").append(response);

                    $("select.pessoas_envolvidas option").each(function () {
                        quant = 0;
                        id_exist = $(this).val();
                        $("select.pessoas_envolvidas option").each(function () {
                            if (id_exist == $(this).val()) {
                                quant++;
                                if (quant > 1) {
                                    $(this).remove();
                                }
                            }
                        });
                        quant = 0;
                    });
                }
            });
        });
        $('#clientes_contrato').val('');
    });

    //cadastro de contrato, autocomplete de adicionar cliente novo
    $("#clientes_contrato").autocomplete({
        source: "index.php?m=lo&c=ajax&a=find_pessoa",
        select: function (event, ui) {
            if (ui.item) {
                var pessoa = ui.item,
                    value = pessoa.value,
                    nome = pessoa.nome,
                    id = pessoa.id,
                    cpf = pessoa.cpf;

                if (cpf == '') {
                    alert('A pessoa envolvida selecionada no possui cpf cadastrado no sistema.');
                    $('#clientes_contrato').val('');
                    $('#envolvido').val('');
                    $('#envolvidoCpf').val('');
                    $(this).val(null);
                } else {
                    $('#clientes_contrato').attr('value', nome);
                    $('#envolvido').attr('value', id);
                    $('#envolvidoCpf').attr('value', cpf);
                    $(this).val(value)
                }
            }
            return false;
        }
    });

    $("#clientes").autocomplete({
        source: "index.php?m=lo&c=ajax&a=find_pessoa",
        select: function (event, ui) {
            if (ui.item) {
                var pessoa = ui.item,
                    value = pessoa.value,
                    nome = pessoa.nome,
                    id = pessoa.id,
                    cpf = pessoa.cpf;

                if (cpf == '') {
                    alert('A pessoa envolvida selecionada no possui cpf cadastrado no sistema.');
                    $('#clientes_contrato').val('');
                    $('#envolvido').val('');
                    $('#envolvidoCpf').val('');
                    $(this).val(null);
                } else {
                    var exist = false;
                    //testa se o valor no input hidden envolvido existe no select
                    $('select.pessoas_envolvidas option').each(function () {
                        if (id == $(this).val()) {
                            exist = true;
                        }
                    });

                    if (!exist) {
                        $('#clientes').val(value);
                        $('#cliente').val(id);
                    } else {
                        alert('Cliente j adicionado!');
                        $('#clientes').val(null);
                        $('#cliente').val(null);
                    }
                }
            }
            return false;
        }
    }).on('blur', function () {
        if ($(this).val() == '') {
            $('#clientes').attr('value', '');
            $('#cliente').attr('value', '');
        }
    });

    $('.cliente_add').click(function () {
        id = $('#cliente').val();
        nome = $('#clientes').val();

        exist = false;
        $('.clientes').each(function () {
            if (id == $(this).val()) exist = true;
        });
        $("select.pessoas_envolvidas option").each(function () {
            if (id == $(this).val()) exist = true;
        });

        if (exist) {
            alert('Cliente j adicionado!');
            $('#clientes').val('');
            $('#cliente').val('');
        } else {
            if (nome == '') {
                alert('No existe ningum para adicionar!');
            }
        }
    });

    $('.cliente_rem').click(function () {
        $('#clientes').each(function () {
            if ($('#cliente').val() && confirm('Deseja remover cliente?')) {
                $('#clientes').val('');
                $('#clientes').attr('disabled', false);
                $('#cliente').attr('value', '');
            }
        });
    });

    /**
     * CONFISSO FORM
     */

    $('#add_lote').click(function () {
        id = $('.lotes option:selected').val();
        txt = $('.lotes option:selected').html()

        exist = false;
        $(".multiple_lote option").each(function () {
            if (id == $(this).val()) exist = true;
        });
        if (exist) {
            alert('Lote j adicionado!');
        } else {
            $('.multiple_lote').append('<option selected value="' + id + '">' + txt + '</option>');
        }
    });

    $('#rmv_lote').click(function () {
        $(".multiple_lote option:selected").remove();
        $(".multiple_lote option").each(function () {
            $(this).attr('selected', 'selected');
        });
    });

    /**
     * PESSOA JURIDICA FORM
     */

    $("#nrepresentante").autocomplete({
        source: "index.php?m=lo&c=ajax&a=find_pessoa",
        select: function (event, ui) {
            if (ui.item) {
                var pessoa = ui.item,
                    value = pessoa.value,
                    nome = pessoa.nome,
                    id = pessoa.id,
                    cpf = pessoa.cpf;

                $('#hrepresentante').val(id);
                $(this).val(value);
            }
            return false;
        }
    });

    $('#representante_add').click(function () {
        var id = $('#hrepresentante').val(),
            nome = $('#nrepresentante').val(),
            exist = false;
        $('#representantes option').each(function () {
            if (id == $(this).val()) exist = true;
        });

        if (exist) {
            alert('Pessoa j adicionada!');
        } else {
            if (id == '' || nome == '') {
                alert('No existe ningum para adicionar!');
            } else {
                $('#representantes').html($('#representantes').html() + '<option value="' + id + '">' + nome + '</option>');
                $('#nrepresentante').val('');
                $('#hrepresentante').val('');
            }
        }
    });

    $('#representante_rem').click(function () {
        $('#representantes option:selected').each(function () {
            if (confirm('Deseja remover esse item?')) {
                $(this).remove();
            }
        });
    });

    /**
     * TRANSFERENCIAS
     */

    $("#cessionarios_transferencia").autocomplete({
        source: "index.php?m=lo&c=ajax&a=find_pessoa",
        select: function (event, ui) {
            if (ui.item) {
                var pessoa = ui.item,
                    value = pessoa.value,
                    id = pessoa.id,
                    cpf = pessoa.cpf;

                if (cpf == '') {
                    alert('A Pessoa selecionada no possui cpf cadastrado no sistema.');
                } else {
                    $('#cessionarios_transferencia').val(value);
                    $('#cessionario').val(id);
                }
            }
            return false;
        }
    });

    $('input.cessionarios_transferencia_add').click(function () {

        id = $('#cessionario').val();
        nome = $('#cessionarios_transferencia').val();
        exist = false;
        //testa se o valor no input hidden envolvido existe no select
        $('select.pessoas_envolvidas option').each(function () {
            if (id == $(this).val()) {
                exist = true;
            }
        });
        //testa se o valor existe no input hidden de responsvel
        if ($('#cliente').val() == id) {
            exist = true;
        }

        if (exist) {
            alert('Pessoa j adicionada!');
            $('#cessionarios_transferencia').val('');
            $('#cessionario').val('');
        } else {
            if (id == '' || nome == '') {
                alert('No existe ningum para adicionar!');
            } else {
                $.ajax({
                    type: "POST",
                    url: "index.php?m=lo&c=ajax&a=fetch_pessoa_fisica",
                    data: "pessoa=" + id,
                    success: function (response) {
                        $("select#cessionarios_envolvidas").append(response);

                        $("select#cessionarios_envolvidas option").each(function () {
                            quant = 0;
                            id_exist = $(this).val();
                            $("select#cessionarios_envolvidas option").each(function () {
                                if (id_exist == $(this).val()) {
                                    quant++;
                                    if (quant > 1) {
                                        $(this).remove();
                                    }
                                }
                            });
                            quant = 0;
                        });
                    }
                });
                $('#cessionarios_transferencia').val('');
                $('#cessionario').val('');
            }
        }
    });

    //cadastro de contrato - Remover cliente a lista de pessoas envolvidas
    $('input.cessionarios_transferencia_rem').click(function () {
        $('select.pessoas_envolvidas option:selected').each(function () {
            if (confirm('Deseja remover esse item?')) {
                $(this).remove();
            }
        });

        $('select.pessoas_envolvidas option').each(function () {
            $.ajax({
                type: "POST",
                url: "index.php?m=lo&c=ajax&a=fetch_pessoa_fisica",
                data: "pessoa=" + $(this).val(),
                success: function (response) {
                    $("select.socios").append(response);

                    $("select.pessoas_envolvidas option").each(function () {
                        quant = 0;
                        id_exist = $(this).val();
                        $("select.pessoas_envolvidas option").each(function () {
                            if (id_exist == $(this).val()) {
                                quant++;
                                if (quant > 1) {
                                    $(this).remove();
                                }
                            }
                        });
                        quant = 0;
                    });
                }
            });
        });
        $('#clientes_contrato').val('');
    });

    $("#nome_pessoa_reserva").autocomplete("index.php?m=lo&c=ajax&a=find_pessoa");

    $("#cidade").autocomplete({
        source: "index.php?m=lo&c=ajax&a=find_cidade",
        select: function (event, ui) {
            if (ui.item) {
                var obj = ui.item,
                    value = obj.value,
                    nome = obj.nome,
                    id = obj.id;

                $(this).val(nome)
                    .attr('disabled', true);
                $('#cd_cidade').val(id);
            }
            return false;
        }
    }).blur(function () {
        if ($(this).val() == "") {
            $('#cdCidade').val();
        }
    });

    $("#dsCidade").autocomplete({
        source: "index.php?m=lo&c=ajax&a=find_cidade",
        select: function (event, ui) {
            if (ui.item) {
                var obj = ui.item,
                    value = obj.value,
                    nome = obj.nome,
                    id = obj.id;

                $(this).val(nome)
                    .attr('disabled', true);
                $('#cd_cidade').val(id);
            }
            return false;
        }
    }).blur(function () {
        if ($(this).val() == "") {
            $('#cdCidade').val();
        }
    });

    $('.cidade_rem').click(function () {
        $('#cd_cidade').val('');
        $('#dsCidade').val('');
        $('#dsCidade').attr('disabled', false);
        $('#cidade').attr('disabled', false);
    });

    /**
     * RELATORIO DE PARCELAS PAGAS
     */

    //Ativa os chamados ajax para preencher o formulario
    $("select.empreendimento_relatorio_parcela_paga").change(function () {
        $("select.cliente_relatorio_parcela_paga").html('<option value="">Selecione ...</option>');
        if ($(this).val()) {
            $.ajax({
                type: "POST",
                url: "index.php?m=rl&c=ajax&a=cliente_by_parcelas_pagas",
                data: "id_empreendimento=" + $(this).val(),
                success: function (response) {
                    $("select.cliente_relatorio_parcela_paga").html(response);
                }
            });
            $.ajax({
                type: "POST",
                url: "index.php?m=lo&c=ajax&a=loteByEmpreendimentoContrato",
                data: "id_empreendimento=" + $(this).val(),
                success: function (response) {
                    $("select.quadra_relatorio_parcela_paga").html(response);
                }
            });
            $.ajax({
                type: "POST",
                url: "index.php?m=rl&c=ajax&a=bancoByEmpreendimento",
                data: "id_empreendimento=" + $(this).val(),
                success: function (response) {
                    $("select.banco_boleto").html(response);
                }
            });
        }
    });

    //Se alterar o valor do select de clientes volta o valor de quadra para o zero
    $("select.cliente_relatorio_parcela_paga").on('change', function () {
        if ($(this).val() != '') {
            $("select.quadra_relatorio_parcela_paga").val(null);
        }
    });

    //Se alterar o valor do select de quadras volta o valor de cliente para o zero
    $("select.quadra_relatorio_parcela_paga").on('change', function () {
        if ($(this).val() != '') {
            $("select.cliente_relatorio_parcela_paga").val(null);
        }
    });

    //Relatorio de INADIMPLENTES
    $("select#tipo").change(function () {
        if ($(this).val() == 'PNC')
            $("#radioProfissao").show();
        else
            $("#radioProfissao").hide();
    });

    //Relatrio de percentuais
    $("select.empreendimento_percentuais").change(function () {
        $("select.cliente_percentuais").html('<option value="">Selecione ...</option>');
        if ($(this).val()) {
            $.ajax({
                type: "POST",
                url: "index.php?m=rl&c=ajax&a=cliente_by_parcelas_pagas",
                data: "id_empreendimento=" + $(this).val(),
                success: function (response) {
                    $("select.cliente_percentuais").html(response);
                }
            });
        }
    });

    //Relatorio de Imposto de renda
    $("select.empreendimento_relatorio_imposto").change(function () {
        $("select.cliente_relatorio_imposto").html('<option value="">Selecione ...</option>');
        if ($(this).val()) {
            $.ajax({
                type: "POST",
                url: "index.php?m=rl&c=ajax&a=clienteRelatorioImpostoRenda",
                data: "id_empreendimento=" + $(this).val(),
                success: function (response) {
                    $("select.cliente_relatorio_imposto").html(response);
                }
            });
        }
    });

    $("#selectContratosAprovados").change(function () {
        document.location.replace('index.php?m=adm&c=contrato&a=pesquisar&filter=' + $(this).val())
    });

    $("select.empreendimento_alterar_parcela").change(function () {
        if ($(this).val()) {
            $.ajax({
                type: "POST",
                url: "index.php?m=lo&c=ajax&a=contrato_by_empreendimento_alterar_parcela",
                data: "id_empreendimento=" + $(this).val(),
                success: function (response) {
                    $("select.contrato_alterar_parcela").attr('disabled', false);
                    $("select.contrato_alterar_parcela").html(response);
                }
            });
        } else {
            $("select.contrato_alterar_parcela").html('<option value="">Todos os Contrato</option>');
            $("select.parcela_alterar_parcela").html('<option value="">Selecione ...</option>');
            $("select.contrato_alterar_parcela").attr('disabled', true);
            $("select.parcela_alterar_parcela").attr('disabled', true);
        }
    });

    /**
     * GERAO DO ARQUIVO REMESSA PARA O BANCO
     */
    $("select.banco_remessa").change(function () {
        $("select.contrato_parcela_cliente").html('<option value="">Selecione ...</option>');
        valor = $(this).val();
        $.ajax({
            type: "POST",
            url: "index.php?m=lo&c=ajax&a=contratoByBancoEmpreendimentoRemessa",
            data: "idBanco=" + valor + "&id_empreendimento=" + $("select.empreendimento_contrato_data").val(),
            success: function (response) {
                $("#contrato_parcela_cliente option").remove();
                $("#contrato_parcela_restante option").remove();
                $("#contrato_parcela_cliente").append('<option value="*">Todos</option>' + response);
                $("#contrato_parcela_restante").append(response);
            }
        })
    });

    $("select.empreendimento_contrato_data").change(function () {
        $("#contrato_parcela_cliente").html('<option value="">Selecione ...</option>');
        $("select.banco_remessa").html('<option value="">Selecione ...</option>');
        $.ajax({
            type: "POST",
            url: "index.php?m=lo&c=ajax&a=bancoByEmpreendimento",
            data: "id_empreendimento=" + $(this).val(),
            success: function (response) {
                $("select.banco_remessa").html(response);
                if ($(".banco_remessa option").size() == 2) {
                    $(".banco_remessa").trigger('change');
                }
            }
        });
    });

    $("#empreendimento_contrato_data").change(function () {
        valor = $(this).val();
        $.ajax({
            type: "POST",
            url: "index.php?m=adm&c=contato&a=contrato_by_empreendimento",
            data: "id_empreendimento=" + valor,
            success: function (response) {
                $("#contrato_parcela_cliente option").remove();
                $("#contrato_parcela_restante option").remove();
                $("#contrato_cliente option").remove();
                $("#contrato_parcela_cliente").append('<option value="*">Todos</option>' + response);
                $("#contrato_parcela_restante").append(response);
                $("#contrato_cliente").append(response);
            }
        })
    });

    //GERAO DE PARCELA
    $("#empreendimento_contrato_parcela").change(function () {
        valor = $(this).val();
        $.ajax({
            type: "POST",
            url: "index.php?m=lo&c=ajax&a=contrato_by_empreendimento",
            data: "id_empreendimento=" + valor,
            success: function (response) {
                $("#contrato option").remove();
                $("#contrato").append(response);
            }
        })
    });

    $("#empreendimento_contrato_data_extrato").change(function () {
        valor = $(this).val();
        filtro = $("input[name='group1']:checked").val();

        $.ajax({
            type: "POST",
            url: "index.php?m=rl&c=extrato&a=contratoByEmpreendimento",
            data: "id_empreendimento=" + valor + "&filtro=" + filtro,
            success: function (response) {

                $("#contrato_parcela_cliente option").remove();
                $("#contrato_parcela_restante option").remove();
                $("#contrato_parcela_cliente").append('<option value="*">Todos</option>' + response);
                $("#contrato_parcela_restante").append('<option value="">Selecione ...</option>' + response);
            }
        })
    });

    $("#empreendimento_contrato_extrato_historico").change(function () {
        valor = $(this).val();
        filtro = $("input[name='group1']:checked").val();

        $.ajax({
            type: "POST",
            url: "index.php?m=rl&c=extratoHistorico&a=contratoByEmpreendimento",
            data: "id_empreendimento=" + valor + "&filtro=" + filtro,
            success: function (response) {

                $("#contrato_parcela_cliente option").remove();
                $("#contrato_parcela_restante option").remove();
                $("#contrato_parcela_cliente").append('<option value="*">Todos</option>' + response);
                $("#contrato_parcela_restante").append('<option value="">Selecione ...</option>' + response);
            }
        })
    });

    $("#empreendimento_contrato_quitacao").change(function () {
        valor = $(this).val();
        $.ajax({
            type: "POST",
            url: "index.php?m=lo&c=ajax&a=contrato_by_empreendimento_quitacao",
            data: "id_empreendimento=" + valor,
            success: function (response) {
                $("#contrato_parcela_cliente_quitacao option").remove();
                $("#contrato_parcela_cliente_quitacao").append(response);

                $("#valor_total").html('<strong>R$ ' + float2moeda(null) + '</strong>');
                $("#valor_totalHidden").val(float2moeda(null));

                $('#valor_total_desconto').val(float2moeda(null));
                $("#valor_total_desconto").html('<strong>R$ ' + float2moeda(null) + '</strong>');
                $("#valor_total_descontoHidden").val(float2moeda(null));

                $('#vl_desconto_quitacao').val(null);
                $("#vl_desconto_quitacao").html('<strong>R$ ' + (null) + '</strong>');
                $("#vl_desconto_quitacao").val(null);

            }
        })
    });

    $("select.contrato_parcela_cliente_quitacao").change(function () {

        $.ajax({
            type: "POST",
            url: "index.php?m=adm&c=ajax&a=calculaTotalParcela",
            data: "contrato=" + $(this).val(),
            dataType: "json",

            success: function (response) {

                $("#valor_total").html('<strong>R$ ' + float2moeda(response.valorParcela) + '</strong>');
                $("#valor_totalHidden").val(float2moeda(response.valorParcela));

                $('#vl_desconto_quitacao').val(null);
                $("#vl_desconto_quitacao").html('<strong>R$ ' + (null) + '</strong>');
                $("#vl_desconto_quitacao").val(null);

                if (parseFloat(response.multa) > 0 || parseFloat(response.juros) > 0) {
                    $('#vlDesconto').attr('disabled', 'disabled');
                    $('#vl_multa').removeAttr('disabled', 'disabled');
                    $('#vl_juros').removeAttr('disabled', 'disabled');
                }

                if (parseFloat(response.desconto) > 0) {
                    $('#vl_multa').attr('disabled', 'disabled');
                    $('#vl_juros').attr('disabled', 'disabled');
                    $('#vlDesconto').removeAttr('disabled', 'disabled');
                }
            }
        })

    });


    $("#sinal").blur(function () {

        if ($('#valor_totalHidden').val()) {
            var vltotal = replaceAll($('#valor_totalHidden').val(), ".", "");
            vltotal = parseFloat(vltotal.replace(',', '.'));

            var sinal = replaceAll($('#sinal').val(), ".", "");

            if (sinal) {

                sinal = parseFloat(sinal.replace(',', '.'));

            }

            if (sinal != '') {

                if (sinal <= vltotal) {

                    var vl_calculo = vltotal - sinal;

                    $('#valor_total_desconto').val(float2moeda(vl_calculo));
                    $("#valor_total_desconto").html('<strong>R$ ' + float2moeda(vl_calculo) + '</strong>');
                    $("#valor_total_descontoHidden").val(float2moeda(vl_calculo));

                } else {
                    alert("O valor a pagar no pode ser maior que o saldo devedor.");
                    $('#sinal').val("");
                    $('#valor_total_desconto').html('<strong>R$ 0,00</strong>');
                    $(".money2").each(function () {
                        $(this).val('');
                    });
                }


                return false;
            }
        }
    });


    $("#vl_desconto_quitacao").blur(function () {

        var vltotal = replaceAll($('#valor_totalHidden').val(), ".", "");
        vltotal = parseFloat(vltotal.replace(',', '.'));

        var vl_desconto_quitacao = replaceAll($('#vl_desconto_quitacao').val(), ",", ".");
        vl_desconto_quitacao = parseFloat(vl_desconto_quitacao.replace(',', '.'));


        if (vl_desconto_quitacao < 100) {


            if (vl_desconto_quitacao < 0) {
                alert("O valor do desconto no pode ser negativo.");
                $('#vl_desconto_quitacao').focus();
            } else {
                var vl_calculo = vltotal - (vltotal * vl_desconto_quitacao) / 100;

                $('#valor_total_desconto').val(float2moeda(vl_calculo));
                $("#valor_total_desconto").html('<strong>R$ ' + float2moeda(vl_calculo) + '</strong>');
                $("#valor_total_descontoHidden").val(float2moeda(vl_calculo));

            }
        } else {
            alert("O valor do desconto no pode ser maior que 100%.");
            $('#vl_desconto_quitacao').focus();

        }
    });


    $("#parcelaInicial").change(function () {
        valor = $(this).val();
        $("#parcelaFinal option").each(function () {
            if (valor == $(this).val()) {
                $(this).attr("selected", true);
            }
        });

    });

    $("#parcelaFinal").change(function () {
        valorFinal = $(this).val();
        valorInicial = $("#parcelaInicial").val();
        if (parseInt(valorFinal) < parseInt(valorInicial)) {
            alert("A parcela final no pode ser menor que a inicial!");
            $("#parcelaFinal option").each(function () {
                if (valorInicial == $(this).val()) {
                    $(this).attr("selected", true);
                }
            });
        }
    });

    $("#contrato_parcela_restante").change(function () {
        valor = $(this).val();
        $.ajax({
            type: "POST",
            url: "index.php?m=adm&c=contato&a=cliente_by_contrato",
            data: "id_contrato=" + valor,
            success: function (response) {
                $("#cliente").val(response);
            }
        });
    });

    $("select.contrato_alterar_parcela").change(function () {
        $("select.parcela_alterar_parcela").html('<option value="">Selecione ...</option>');
        if ($(this).val()) {
            $("select.contrato_alterar_parcela").attr('disabled', true);
            $.ajax({
                type: "POST",
                url: "index.php?m=lo&c=ajax&a=parcela_by_empreendimento_alterar_parcela",
                data: "id_contrato=" + $(this).val(),
                success: function (response) {
                    $("select.contrato_alterar_parcela").attr('disabled', false);
                    $("select.parcela_alterar_parcela").attr('disabled', false);
                    $("select.parcela_alterar_parcela").html(response);
                }
            });
        } else {
            $("select.parcela_alterar_parcela").html('<option value="">Selecione ...</option>');
            $("select.parcela_alterar_parcela").attr('disabled', true);
        }
    });


    $("#botaoEstornarParc").click(function () {
        if (confirm('Tem certeza que deseja extornar essa parcela?')) {

            $.ajax({
                type: "POST",
                url: "index.php?m=lo&c=ajax&a=extornaParc",
                data: "empreendimento=" + $('#empreendimento_alterar_parcela').val() + '&contrato=' + $('#contrato_alterar_parcela').val() + '&parcela=' + $('#parcela_alterar_parcela').val() + '&valor=' + $('#valor').val() + '&local=' + $('#tipoBaixa').val(),
                dataType: "json",
                success: function (response) {
                    if (response) {
                        //alert('Parcela estornada com sucesso!');

                    }
                    return location.href = '?m=fin&c=alteraParcela&a=alterarParcela&ok=Parcela%20alterada%20com%20sucesso!';
                }
            });
        }
    });


    $("#empreendimento_usuario_login").change(function () {
        $(this).val($.trim($(this).val()));
        if ($(this).val()) {
            $.ajax({
                type: "POST",
                url: "index.php?m=lo&c=ajax&a=login_by_empreendimento",
                data: "login=" + $(this).val(),
                success: function (response) {
                    if (!response) {
                        alert('Este login j est em uso no sistema.');
                    }
                }
            });
        }
    });

    //Validacao de numero de dias para permanencia do boleto no cadastro de banco
    $("#qt_dias_permanencia").on('blur', function () {
        if ($(this).val() < 5 || $(this).val() > 120) {
            $(this).val(null);
            alert('O valor deve estar entre 5 e 120.')
        }
    });

    $("#empreendimento_usuario_senha,#empreendimento_usuario_confirmar").change(function () {
        $('#empreendimento_usuario_confirmar')
        if ($('#empreendimento_usuario_senha').val() && $('#empreendimento_usuario_confirmar').val() && $('#empreendimento_usuario_senha').val() != $('#empreendimento_usuario_confirmar').val()) {
            alert('A confirmacao da senha nao corresponde com a senha.');
        }
    });

    $("select.empreendimento_relatorio_empreendimentos").change(function () {
        $("select.cliente_relatorio_clientes").html('<option value="">Selecione ...</option>');
        if ($(this).val()) {
            $.ajax({
                type: "POST",
                url: "index.php?m=rl&c=ajax&a=relatorio_by_clientes",
                data: "id_empreendimento=" + $(this).val(),
                success: function (response) {
                    $("select.cliente_relatorio_clientes").html("<option value=''>Selecione ...</option>" + response);
                }
            });
        }
    });

    $(".empreendimento_relatorio_lote").change(function () {
        $('.lote_relatorio_lote').html('<option value="">Selecione ...</option>');
        $('.lote_relatorio_lote').attr('disabled', true);
        if ($(this).val()) {
            $.ajax({
                type: "POST",
                url: "index.php?m=rl&c=ajax&a=relatorio_by_lotes",
                data: "id_empreendimento=" + $(this).val(),
                success: function (response) {
                    if (response) {
                        $('.lote_relatorio_lote').html(response);
                        $('.lote_relatorio_lote').attr('disabled', false);
                    }
                }
            });
        }
    });

    //ao selecionar lote, selecionar o status
    $(".lote_relatorio_lote").change(function () {
        if ($(this).val() != "*") {
            var status = $(".lote_relatorio_lote option:selected").attr("data-status");
            $("#tipo").val(status);
        }
    });

    //Exibe os campos de empreendimentos apos escolher o perfil no cadastro de usuario
    $("#perfil").change(function () {
        if ($(this).val() != '') {
            $('#nm_empreendimento,#lista_empreendimento').show();
        } else {
            $('#nm_empreendimento,#lista_empreendimento').hide();
        }
    });

    $("select.etiquetas_empreendimento").change(function () {
        $("select.etiquetas_cliente").html('<option value="">Selecione ...</option>');
        if ($(this).val()) {
            $.ajax({
                type: "POST",
                url: "index.php?m=rl&c=ajax&a=etiquetas_by_clientes",
                data: "id_empreendimento=" + $(this).val(),
                success: function (response) {
                    $("select.etiquetas_cliente").html("<option value=''>Selecione ...</option>" + response);
                }
            });
        }
    });

    $("#addCliente").click(function () {
        var id = $("#cliente option:selected").val();
        var nome = $("#cliente option:selected").html();
        var existe = false;
        if (nome != 'Selecione ...') {
            if (id == "*") {
                alert("Para adicionar outros clientes, remova \"Todos\"");
                $("#addCliente, #cliente, .etiquetas_empreendimento").attr('disabled', true);
                $("#listaClientes").html("<option value='" + id + "'>" + nome + "</option>");
            } else {
                $(".etiquetas_empreendimento").attr('disabled', true);
                $("#listaClientes").append("<option value='" + id + "'>" + nome + "</option>");
            }
            $(".etiquetas_empreendimento").before("<input type='hidden' id='emp2' name='etiquetas_empreendimento' value='" + $(".etiquetas_empreendimento option:selected").attr("value") + "'/>")
        }
    });

    $("#delCliente").click(function () {
        var loopAtual = 0;
        $('#listaClientes option:selected').each(function () {
            var id = $(this).attr("value");
            var nome = $(this).html();
            if (id == "*") {
                $("#addCliente, #cliente, .empreendimento_relatorio_empreendimentos").attr('disabled', false);
            }
            if ($("#listaClientes option").length == 1) {
                $(".empreendimento_relatorio_empreendimentos").attr('disabled', false);
                $("#emp2").remove();
            }
            $(this).remove();
            if ($("#listaClientes option").length == 0) {
                $("select.etiquetas_empreendimento").attr('disabled', false);
            }
        });
    });

    //Select do Relatrio de Declaraes
    $("select.declaracoes_empreendimento").change(function () {
        $("select.declaracoes_cliente").html('<option value="">Selecione ...</option>');
        if ($(this).val()) {
            $.ajax({
                type: "POST",
                url: "index.php?m=rl&c=ajax&a=relatorio_by_contratos",
                data: "id_empreendimento=" + $(this).val(),
                success: function (response) {
                    $("select.declaracoes_cliente").html("<option value=''>Selecione ...</option>" + response);
                }
            });
        }
    });

    //Select do Relatrio de Declaraes
    $("#addClienteDeclaracoes").click(function () {
        var id = $("#declaracoes_cliente option:selected").attr('value'),
            nome = $("#declaracoes_cliente option:selected").html();
        if (nome != 'Selecione ...') {
            if (id == "*") {
                alert("Para adicionar outros clientes, remova \"Todos\"");
                $("#addClienteDeclaracoes, #declaracoes_cliente, .declaracoes_empreendimento").attr('disabled', true);
                $("#listaClientes").html("<option value='" + id + "'>" + nome + "</option>");
            } else {
                $(".declaracoes_empreendimento").attr('disabled', true);
                $("#listaClientes").append("<option value='" + id + "'>" + nome + "</option>");
            }
            $(".declaracoes_empreendimento").before("<input type='hidden' id='emp2' name='declaracoes_empreendimento' value='" + $(".declaracoes_empreendimento option:selected").attr("value") + "'/>")
        }
        $("#listaClientes option").each(function () {
            var quant = 0,
                id_exist = $(this).val();
            $("#listaClientes option").each(function () {
                if (id_exist == $(this).val()) {
                    quant++;
                    if (quant > 1) {
                        $(this).remove();
                    }
                }
            });
            quant = 0;
        });
    });

    //Select do Relatrio de Declaraes
    $("#delClienteDeclaracoes").click(function () {
        var loopAtual = 0;
        $('#listaClientes option:selected').each(function () {
            var id = $(this).attr("value");
            var nome = $(this).html();
            if (id == "*") {
                $("#addClienteDeclaracoes, #declaracoes_cliente, .declaracoes_empreendimento").attr('disabled', false);
            }
            if ($("#listaClientes option").length == 1) {
                $(".declaracoes_empreendimento").attr('disabled', false);
                $("#emp2").remove();
            }
            $(this).remove();
            if ($("#listaClientes option").length == 0) {
                $("select.declaracoes_empreendimento").attr('disabled', false);
            }
        });
    });

    /**
     * CADASTRO DE USUARIO FORM
     */

    $("#nomeEmpreendimento").autocomplete({
        source: "index.php?m=lo&c=ajax&a=corretor_by_empreendimentos",
        minLength: 1,
        select: function (event, ui) {
            if (ui.item) {
                var obj = ui.item,
                    nome = obj.nome,
                    id = obj.id;

                $(this).val(nome);
                $('#hnomeEmpreendimento').val(id);
            }
            return false;
        }
    });

    $('.nomeEmpreendimento_add').click(function () {

        var id = $('#hnomeEmpreendimento').val(),
            nome = $('#nomeEmpreendimento').val(),
            exist = false;

        $('#listaEmpreendimentos option').each(function () {
            if (id == $(this).val()) exist = true;
        });

        if (exist) {
            alert('Pessoa j adicionada!');
        }
        else {
            if (id == '' || nome == '') {
                alert('Nao existe ningum para adicionar!');
            } else {
                $('.listaEmpreendimentos').html($('.listaEmpreendimentos').html() + '<option value="' + id + '">' + nome + '</option>');
                $('#hnomeEmpreendimento').val('');
                $('#nomeEmpreendimento').val('');
            }
        }

    });

    $('.nomeEmpreendimento_rem').click(function () {
        $('#listaEmpreendimentos option:selected').each(function () {
            if (confirm('Deseja remover esse item?')) {
                $(this).remove();
            }
        });
    });

    //Corrige bug do javascript para reajuste
    $('#reajuste').blur(function () {
        $(this).attr("value", $(this).val());
    });

    /*
     * Preenche a data de reajuste ao modificar a data da primeira parcela
     * Usado em amd/Contrato/Adicionar e Editar
     */
    $("#dt_primeira").blur(function () {
        var dt_primeira = $('#dt_primeira').val();
        if (VerificaData(this.value, "dt_primeira"))
            $("#dt_reajuste").val(dt_primeira);
    });

    $("#dt_reajuste").blur(function () {
        if (this.value != '')
            VerificaData(this.value, 'dt_reajuste');
    });

    $(".calcularTotal").blur(function () {
        var vl_parcela = $('#vl_parcela').val(),
            qtd_parcela = $('#qtd_parcela').val(),
            vl_adicional_parcela = 0,
            vl_adicional_intercalada = 0,
            vl_adicional_chave = 0,
            sinal = $('.vl_sinal'),
            qtd_parcela_sinal = 0,
            intercalada = $('#intercalada').val(),
            qtd_parcela_intercalada = $('#qtd_parcela_intercalada').val(),
            vl_chave = $('#vl_chaves').val(),
            qt_chave = $('#qtd_parcela_chaves').val(),
            total;

        var vl_sinal = 0;
        sinal.each(function (key, value) {
            vl_sinal = vl_sinal + moeda2float(value.value);
            qtd_parcela_sinal++;
        });
        sinal = float2moeda(vl_sinal);

        $.ajax({
            type: "POST",
            url: "index.php?m=lo&c=ajax&a=calcula_total",
            data: "vl_parcela=" + vl_parcela + "&qtd_parcela=" + qtd_parcela + "&sinal=" + sinal + "&qtd_parcela_sinal=" + 1 + '&intercalada=' + intercalada + '&qtd_parcela_intercalada=' + qtd_parcela_intercalada + '&vl_chave=' + vl_chave + '&qt_chave=' + qt_chave,
            success: function (response) {
                total = moeda2float(response);

                $(".vl_adicional_parcela").each(function (key, value) {
                    var qtd_parcela = $("#qtd_parcela_" + (key + 1)).val();
                    if (qtd_parcela > 0)
                        vl_adicional_parcela += moeda2float(value.value) * qtd_parcela;
                });

                //Utiliza o numero no fim do id para evitar trazer o valor diferente da quantidade
                $(".vl_adicional_intercalada").each(function (key, value) {
                    var n = (value.id).split('_')[2];
                    var qtd_parcela = $("#qtd_intercalada_" + n).val();
                    if (qtd_parcela > 0)
                        vl_adicional_intercalada += moeda2float(value.value) * qtd_parcela;
                });

                $(".vl_adicional_chave").each(function (key, value) {
                    var qtd_parcela = $("#qtd_chave_" + (key + 1)).val();
                    if (qtd_parcela > 0)
                        vl_adicional_chave += moeda2float(value.value) * qtd_parcela;
                });

                $("td.total").html('R$ ' + float2moeda(total + vl_adicional_parcela + vl_adicional_intercalada + vl_adicional_chave));
            }
        });
    });

    $('#calcular').click(function () {
        $('#frmReajuste').attr('action', '?m=fin&c=reajuste&a=calcular');
    });

    $('#recalculo').click(function () {
        parcela = $('#parcelas').val().split(':');
        var total = 0;
        var vlr = 0;
        for (i = 0; i < parcela.length; i++) {
            if ($('#total_' + parcela[i]).val() != '') {
                vlr = $('#total_' + parcela[i]).val().replace('.', '');
                totalp = parseFloat(vlr.replace(',', '.'));
            } else {
                totalp = 0;
            }
            if ($('#desconto_' + parcela[i]).val() != '') {
                vlr = $('#desconto_' + parcela[i]).val().replace('.', '');
                desconto = parseFloat(vlr.replace(',', '.'));
            } else {
                desconto = 0;
            }
            if ($('#acrescimo_' + parcela[i]).val() != '') {
                vlr = $('#acrescimo_' + parcela[i]).val().replace('.', '');
                acrescimo = parseFloat(vlr.replace(',', '.'));
            } else {
                acrescimo = 0;
            }
            total2 = totalp + acrescimo - desconto;
            $('#tdTotal_' + parcela[i]).html(total2.toFixed(2).replace('.', ','));
            total += total2;
        }
        $('#total').html(total.toFixed(2).replace('.', ','));
        $('#hidden_total').val(total.toFixed(2).replace('.', ','));

    });

    $("#checkAll").click(function () {
        $(".chM").attr('checked', !$(".chM").attr('checked'));
    });

    $("#botaoConstrucao").click(function () {

        var selecionados = new Array();
        $(":checkbox").each(function () {
            if ($(this).is(":checked")) selecionados.push($(this).val());
        });
        if (selecionados.length >= 1) {
            if (confirm("Voc tem certeza que deseja marcar e/ou desmarcar construo esse(s) lote(s)?")) {
                $.ajax({
                    type: "POST",
                    url: "index.php?m=" + queryString("m") + "&c=" + queryString("c") + "&a=construir" + "&pageID=" + queryString("pageID"),
                    data: "ids[]=" + selecionados,
                    success: function (response) {
                        if (response == 1) {
                            if ((location.href.indexOf("&msg=ok") == -1))
                                location.href = location.href + "&msg=ok";
                            else location.reload(true);
                        } else {
                            location.href = location.href + "&msg=fail";
                        }
                    }
                });
            }
        } else {
            alert("Selecione pelo menos um item da lista");
        }

    });

    $("#botaoConstrucaoPaginacao").click(function () {

        var selecionados = new Array();

        var url = $('a', this).attr("href");

        $(":checkbox").each(function () {
            if ($(this).is(":checked")) selecionados.push($(this).val());
        });

        if (selecionados.length >= 1) {
            if (confirm("Voc tem certeza que deseja marcar e/ou desmarcar construo esse(s) lote(s)?")) {
                $.ajax({
                    type: "POST",
                    url: "index.php?m=" + queryString("m") + "&c=" + queryString("c") + "&a=construir",
                    data: "ids[]=" + selecionados,
                    success: function (response) {
                        if (response == 1) {
                            location.href = url + "&msg=OK";
                        } else {
                            location.href = url + "&msg=FAIL";

                        }
                    }
                });
            }
        }
    });

    /**
     * REMESSA - VERIFICAR CONTRATOS
     */

    //Check todos os checkboxes
    $("#ckbCheckAll").click(function () {
        $(".checkBoxClass").prop('checked', $(this).prop('checked'));
    });

    //Verifica se h checkbox da lista marcado, caso tenha, a funo ir desmarcar
    $('#checkPrincipal').on('click', function () {
        if ($('#checkPrincipal').is(":checked")) {
            $("tbody :checkbox").each(function () {
                $(this).prop('checked', true);
            });
        } else {
            $("tbody :checkbox").each(function () {
                $(this).prop('checked', false);
            });
        }
    });

    /**
     * QUITAO
     */
    $("#select_quitacao_parcelar").change(function () {
        if ($('#select_quitacao_parcelar').val() != 0) {
            sinal = $('#sinal').val()
            $.ajax({
                type: "POST",
                url: "index.php?m=fin&c=quitacao&a=parcelasValorAjax",
                data: "parcelas=" + $(this).val() + "&sinal=" + sinal,
                success: function (response) {
                    $("#tr_vlPagar").html(response);
                }
            });
        }
    });

    /**
     * MIGRAO
     */
    $("#buscaEmpreendimento").on('click', function () {
        $.ajax({
            type: "POST",
            url: "index.php?m=sc&c=migracao&a=connectar",
            data: "nmBanco=" + $("#nmBanco").val() + "&host=" + $("#host").val() + "&usuario=" + $("#usuario").val() + "&senha=" + $("#senha").val(),
            success: function (json) {
                $("select#empreendimento").html('<option value=""> Selecione...</option>');
                var json = JSON.parse(json);
                if (!json.erro) {
                    for (var i in json) {
                        $("select#empreendimento").append('<option value="' + json[i].id + '"> ' + json[i].nm_empreendimento + ' </option>');
                    }
                    $("#statusConnexao").html('<label  style="color:#008000">Connexao estabelecida com sucesso.</label>');
                }
                else {
                    $("#statusConnexao").html('<label style="color:#ff0000">Falha de connexo. Erro: ' + json.erro + '</label>');
                }
            }
        });
    });
});

function lista_avisos(listaAvisos) {

    for (var i in listaAvisos) {

        var dsTitulo = (listaAvisos[i].ds_titulo.lenght > 29) ? substr(listaAvisos[i].ds_titulo, 0, 30)+'...' : listaAvisos[i].ds_titulo;
        var dtAviso = listaAvisos[i].dt_aviso.replace(/(\d*)-(\d*)-(\d*).*/, '$3/$2/$1');

        if(!listaAvisos[i].flVisualizado) {
            $(
                "<li id='mensagem_" +listaAvisos[i].id_aviso+ "' idAviso='"+listaAvisos[i].id_aviso+ "' class='unread naoVisto' style='background-color: #EBEBEC;'>" +
                "<a href='#'>" +
                "<div class='row'>" +
                "<div class='col-sm-10'>" +
                "<br><p><strong>"+dsTitulo+"</strong></p>" +
                "</div>" +
                "<div class='col-sm-2'>" +
                "<i class='pull-right msg-time'>"+dtAviso+"</i><br>" +
                "<i class='posiciona-circulo fa fa-circle' id='bolinhaAtual_" +listaAvisos[i].id_aviso+ "'></i>" +
                "</div>" +
                "</div>" +
                "</a>" +
                "</li>"
            ).insertBefore('.dropdown-footer');
        } else {
            $(
                "<li class='unread visto'>" +
                "<a target='_blank' href='?m=sc&c=aviso&a=exibeAviso&idAviso=" +listaAvisos[i].id_aviso+ "'>" +
                "<i class='pull-right msg-time'>"+dtAviso+"</i><br />" +
                "<p><strong class='results'>"+dsTitulo+"</strong></p>" +
                "</a>" +
                "</li>"
            ).insertBefore('.dropdown-footer');
        }
    }


    $('.naoVisto').on('click', function() {
        var id_aviso = $(this).attr('idAviso');

        $.ajax({
            type: 'POST',
            url: '?m=&c=aviso&a=buscaMensagemAtualizacao',
            dataType: 'json',
            data: { idAviso : id_aviso },
            success: function (response) {
                if ($('#contaAvisos').html() > 0) {
                    $('#bolinhaAtual_'+id_aviso).removeClass('fa-circle');
                    $('#mensagem_'+id_aviso).css("background", "white");
                    qtdAvisos = $('#contaAvisos').html() - 1;
                    $('#contaAvisos').html(qtdAvisos);
                    window.open('?m=sc&c=aviso&a=exibeAviso&idAviso='+id_aviso, '_blank');
                }
            }
        });
    } );

    $('#ultimoId').val(listaAvisos[i].ultimoId);
}


function CalculaTotalContrato() {
    var vl_parcela = $('#vl_parcela').val(),
        qtd_parcela = $('#qtd_parcela').val(),
        vl_adicional_parcela = 0,
        vl_adicional_intercalada = 0,
        vl_adicional_chave = 0,
        sinal = $(".vl_sinal"),
        qtd_parcela_sinal = 0,
        intercalada = $('#intercalada').val(),
        qtd_parcela_intercalada = $('#qtd_parcela_intercalada').val(),
        vl_chave = $('#vl_chaves').val(),
        qt_chave = $('#qtd_parcela_chaves').val(),
        total;

    var vl_sinal = 0;
    sinal.each(function (key, value) {
        vl_sinal = vl_sinal + moeda2float(value.value);
        qtd_parcela_sinal++;
    });
    sinal = float2moeda(vl_sinal);

    $.ajax({
        type: "POST",
        url: "index.php?m=lo&c=ajax&a=calcula_total",
        data: "vl_parcela=" + vl_parcela + "&qtd_parcela=" + qtd_parcela + "&sinal=" + sinal + "&qtd_parcela_sinal=" + 1 + '&intercalada=' + intercalada + '&qtd_parcela_intercalada=' + qtd_parcela_intercalada + '&vl_chave=' + vl_chave + '&qt_chave=' + qt_chave,
        success: function (response) {
            total = moeda2float(response);

            $(".vl_adicional_parcela").each(function (key, value) {
                var qtd_parcela = $("#qtd_parcela_" + (key + 1)).val();
                if (qtd_parcela > 0)
                    vl_adicional_parcela += moeda2float(value.value) * qtd_parcela;
            });

            //Utiliza o numero no fim do id para evitar trazer o valor diferente da quantidade
            $(".vl_adicional_intercalada").each(function (key, value) {
                var n = (value.id).split('_')[2];
                var qtd_parcela = $("#qtd_intercalada_" + n).val();
                if (qtd_parcela > 0)
                    vl_adicional_intercalada += moeda2float(value.value) * qtd_parcela;
            });

            $(".vl_adicional_chave").each(function (key, value) {
                var qtd_parcela = $("#qtd_chave_" + (key + 1)).val();
                if (qtd_parcela > 0)
                    vl_adicional_chave += moeda2float(value.value) * qtd_parcela;
            });

            $("td.total").html('R$ ' + float2moeda(total + vl_adicional_parcela + vl_adicional_intercalada + vl_adicional_chave));
        }
    });
}

/**
 * Funo responsvel por realizar requisio ajax e retornar os dados em uma lista utilizando select2
 *
 * @param seletor = seletor do campo (nome, id, classe, etc)
 * @param multiple = true se o select for multiplo e false se for normal
 * @param placeholder = mensagem para ser exibida no placeholder
 * @param url = url com caminho da ao que vai ser utilizada
 *
 */
function select2RemoteData(seletor, multiple, allowClear, placeholder, url) {

    $(seletor).select2({
        multiple: multiple,
        allowClear: allowClear,
        minimumInputLength: 3,
        minimumResultsForSearch: 10,
        width: '100%',
        placeholder: placeholder,
        language: {
            inputTooShort: function () {
                return "Digite no mnimo 3 letras para pesquisar.";
            }
        },
        ajax: {
            url: url,
            dataType: "json",
            type: "GET",
            data: function (params) {
                return {
                    term: params.term
                };
            },
            processResults: function (data) {
                return {
                    results: $.map(data, function (item) {

                        return {
                            text: item.text,
                            id: item.value,
                            info: item.info
                        }

                    })
                };
            }
        }
    });
}


function fixNumber(inputNumber,digits){
    fact= Math.pow(10,digits)
    return Math.floor(inputNumber*fact)/fact
}

// Autocomplete
function autocomplete(inp, arr) {
    /*the autocomplete function takes two arguments,
    the text field element and an array of possible autocompleted values:*/
    var currentFocus;
    /*execute a function when someone writes in the text field:*/
    inp.addEventListener("input", function(e) {
        var a, b, i, val = this.value;
        /*close any already open lists of autocompleted values*/
        closeAllLists();
        if (!val) { return false;}
        currentFocus = -1;
        /*create a DIV element that will contain the items (values):*/
        a = document.createElement("DIV");
        a.setAttribute("id", this.id + "autocomplete-list");
        a.setAttribute("class", "autocomplete-items");
        /*append the DIV element as a child of the autocomplete container:*/
        this.parentNode.appendChild(a);
        /*for each item in the array...*/
        for (i = 0; i < arr.length; i++) {
          /*check if the item starts with the same letters as the text field value:*/
          if (arr[i].substr(0, val.length).toUpperCase() == val.toUpperCase()) {
            /*create a DIV element for each matching element:*/
            b = document.createElement("DIV");
            /*make the matching letters bold:*/
            b.innerHTML = "<strong>" + arr[i].substr(0, val.length) + "</strong>";
            b.innerHTML += arr[i].substr(val.length);
            /*insert a input field that will hold the current array item's value:*/
            b.innerHTML += "<input type='hidden' value='" + arr[i] + "'>";
            /*execute a function when someone clicks on the item value (DIV element):*/
                b.addEventListener("click", function(e) {
                /*insert the value for the autocomplete text field:*/
                inp.value = this.getElementsByTagName("input")[0].value; 
                if(inp.value.includes("Relacionamento")){ //Verifica se  Relacionamento
                    if(inp.value == "Relacionamento"){ //Se for relatrio Relacionamento
                        $(".dropdown-menu-left li a[href*='rl']:contains('" + inp.value.substring(0, inp.value.length - 4) + "')")[0].click();
                    }
                    else{ //Se for Relacionamento Cliente, Empreendimento ou Lote
                        $(".dropdown-menu-left li a:contains('" + inp.value + "')")[0].click();
                    }
                }else{
                    if (inp.value.includes("Rel")) { //Se tiver rl ele procura na aba de relatorios
                        $(".dropdown-menu-left li a[href*='rl']:contains('" + inp.value.substring(0, inp.value.length - 4) + "')")[0].click();
                    } else {
                        jQuery(".dropdown-menu-left li a").filter(function(){
                            return jQuery(this).text().trim() === $.trim(inp.value);
                        })[0].click();
                    }
                }
                /*close the list of autocompleted values,
                (or any other open lists of autocompleted values:*/
                closeAllLists();
            });
            a.appendChild(b);
          }
        }
    });
    /*execute a function presses a key on the keyboard:*/
    inp.addEventListener("keydown", function(e) {
        var x = document.getElementById(this.id + "autocomplete-list");
        if (x) x = x.getElementsByTagName("div");
        if (e.keyCode == 40) {
          /*If the arrow DOWN key is pressed,
          increase the currentFocus variable:*/
          currentFocus++;
          /*and and make the current item more visible:*/
          addActive(x);
        } else if (e.keyCode == 38) { //up
          /*If the arrow UP key is pressed,
          decrease the currentFocus variable:*/
          currentFocus--;
          /*and and make the current item more visible:*/
          addActive(x);
        } else if (e.keyCode == 13) {
          /*If the ENTER key is pressed, prevent the form from being submitted,*/
          e.preventDefault();
          if (currentFocus > -1) {
            /*and simulate a click on the "active" item:*/
            if (x) x[currentFocus].click();
          }
        }
    });
    function addActive(x) {
      /*a function to classify an item as "active":*/
      if (!x) return false;
      /*start by removing the "active" class on all items:*/
      removeActive(x);
      if (currentFocus >= x.length) currentFocus = 0;
      if (currentFocus < 0) currentFocus = (x.length - 1);
      /*add class "autocomplete-active":*/
      x[currentFocus].classList.add("autocomplete-active");
    }
    function removeActive(x) {
      /*a function to remove the "active" class from all autocomplete items:*/
      for (var i = 0; i < x.length; i++) {
        x[i].classList.remove("autocomplete-active");
      }
    }
    function closeAllLists(elmnt) {
      /*close all autocomplete lists in the document,
      except the one passed as an argument:*/
      var x = document.getElementsByClassName("autocomplete-items");
      for (var i = 0; i < x.length; i++) {
        if (elmnt != x[i] && elmnt != inp) {
        x[i].parentNode.removeChild(x[i]);
      }
    }
  }
  /*execute a function when someone clicks in the document:*/
  document.addEventListener("click", function (e) {
      closeAllLists(e.target);
  });
  } 
//   Adiciona rl aos itens/links duplicados
  function getDuplicateArrayElements(arr){
    var sorted_arr = arr.slice().sort();
    var results = [];
    for (var i = 0; i < sorted_arr.length - 1; i++) {
        if (sorted_arr[i + 1] === sorted_arr[i]) {
            var rl = ' Rel';
            sorted_arr[i] = sorted_arr[i] + rl;
            results.push(sorted_arr[i]);
        } else {
            results.push(sorted_arr[i]);
        }
    }
    return results;
}

var itensPick = $('.dropdown-menu-left li a');
var itensSearch = [];
for (let index = 0; index < itensPick.length; index++) {
    itensSearch.push(itensPick[index].innerText);
}
var itensSearchOutDuplicates = getDuplicateArrayElements(itensSearch);

autocomplete(document.getElementById("menuSearch"), itensSearchOutDuplicates);