<?php
require_once 'layout/includes/header.php';
require_once 'layout/includes/menu.php';

$perfis = $this->get('perfis');
$usuario = $this->get('usuario');
$imobiliarias = $this->get('imobiliarias');
$cliente = $this->get('cliente');
?>
    <div class="content">
        <div class="page-heading">
            <?= $this->getHeader(); ?>
        </div>
        <div class="widget">
            <div class="widget-content padding">
                <!-- MENSAGENS -->
                <?php if (count($this->_helper->getMensagens()) > 0): ?>
                    <div class="alert alert-danger alert-dismissable">
                        <?php foreach ($this->_helper->getMensagens() as $message): ?>
                            <?= $message ?><br>
                        <?php endforeach; ?>
                    </div>
                <?php endif; ?>
                <form action="" method="POST" id="form">
                    <fieldset>
                        <legend>Dados de Usurio <span style=" font-size: 10pt">(Campos com <span style=" color: red">*</span> so obrigatrios)</span>
                            <span data-toggle="modal" data-target=".mVisualizar" style="font-size: 22px;" data-toggle="tooltip" data-placement="top" title="Assista ao tutorial">
                                <svg xmlns="" width="22" height="22" fill="currentColor" class="bi bi-youtube" viewBox="0 0 16 16">
                                    <path d="M8.051 1.999h.089c.822.003 4.987.033 6.11.335a2.01 2.01 0 0 1 1.415 1.42c.101.38.172.883.22 1.402l.01.104.022.26.008.104c.065.914.073 1.77.074 1.957v.075c-.001.194-.01 1.108-.082 2.06l-.008.105-.009.104c-.05.572-.124 1.14-.235 1.558a2.01 2.01 0 0 1-1.415 1.42c-1.16.312-5.569.334-6.18.335h-.142c-.309 0-1.587-.006-2.927-.052l-.17-.006-.087-.004-.171-.007-.171-.007c-1.11-.049-2.167-.128-2.654-.26a2.01 2.01 0 0 1-1.415-1.419c-.111-.417-.185-.986-.235-1.558L.09 9.82l-.008-.104A31 31 0 0 1 0 7.68v-.123c.002-.215.01-.958.064-1.778l.007-.103.003-.052.008-.104.022-.26.01-.104c.048-.519.119-1.023.22-1.402a2.01 2.01 0 0 1 1.415-1.42c.487-.13 1.544-.21 2.654-.26l.17-.007.172-.006.086-.003.171-.007A100 100 0 0 1 7.858 2zM6.4 5.209v4.818l4.157-2.408z"></path>
                                </svg>
                            </span>
                        </legend>
                        <div class="row">
                            <div class="col-sm-12">
                                <div class="form-group col-sm-6">
                                    <label for="idCliente" class="control-label">Pessoa Fsica: <span
                                            class="text-danger" title="Este campo  obrigatrio.">*</span></label>
                                    <select class="form-control select2BigData"
                                            data-placeholder="Nome do usurio" name="cliente"
                                            id="idCliente"
                                            required="required">
                                        <?php if (isset($usuario)): ?>
                                            <option selected value="<?= $usuario['id_pessoa'] ?>">
                                                <?= $usuario['nm_pessoa'] . ' (' . $usuario['nr_cpf'] . ')' ?>
                                            </option>
                                        <?php endif; ?>
                                    </select>
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-sm-12">
                                <div class="form-group col-sm-6">
                                    <label class="control-label" for="perfil">
                                        Perfil:<span class="require" style="color: red">*</span>
                                    </label>
                                    <select class="form-control select2 perfil_imobiliaria" id="perfil" name="perfil" <?= ($usuario['perfilId']==1 && Login::getUsuario()->getSuper() == '0')?'disabled':''?> data-placeholder="Selecione o Perfil">
                                        <option value=""></option>
                                        <?php foreach ($perfis as $perfil) :
                                            if($perfil['id'] == 1 && $_GET['a']!='editar' && Login::getUsuario()->getSuper() == '0')continue; ?>
                                            <option
                                                value="<?= $perfil['id']; ?>"<?php if ($usuario['perfilId'] == $perfil['id']): ?> selected<?php endif; ?>>
                                                <?= $perfil['nome']; ?>
                                            </option>
                                        <?php endforeach; ?>
                                    </select>
                                </div>
                            </div>
                        </div>
                        <div class="row rowImobiliaria" hidden>
                            <div class="col-sm-12">
                                <div class="form-group col-sm-6">
                                    <label class="control-label" for="imobiliaria">
                                        Imobiliria:<span class="require" style="color: red">*</span>
                                    </label>
                                    <select class="form-control select2 imobiliaria" id="imobiliaria" name="imobiliaria" 
                                        data-placeholder="Selecione a imobiliria">
                                        <option value=""></option>
                                        <?php if($imobiliarias): ?>
                                            <?php foreach ($imobiliarias as $imobiliaria): ?>
                                                <option
                                                    value="<?= $imobiliaria['idPessoa']; ?>"
                                                    <?php if ($usuario['idImobiliaria'] == $imobiliaria['idPessoa']): ?> 
                                                        <?= 'selected' ?>
                                                    <?php endif; ?> 
                                                >
                                                    <?= $imobiliaria['nm_pessoa'] . "(" . $imobiliaria['nr_cnpj'] . ")"; ?>
                                                </option>
                                            <?php endforeach; ?>
                                        <?php endif; ?>
                                    </select>
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-sm-12">
                                <div class="form-group col-sm-6">
                                    <label for="login" class="control-label">Login:<span
                                            class="text-danger" title="Este campo  obrigatrio.">*</span></label>
                                    <input type="text" class="form-control" id="login" name="login"
                                           placeholder="Login"
                                           value="<?= $usuario['login'] ?>">
                                    <input type="hidden" name="loginAtual" value="<?= $usuario['login'] ?>">
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-sm-12">
                                <div class="form-group col-sm-3">
                                    <label for="nrProposta" class="control-label">Senha:<span
                                            class="text-danger" title="Este campo  obrigatrio.">*</span></label>
                                    <input type="password" class="form-control" id="senha" name="senha"
                                           placeholder="Senha"
                                           value="">
                                </div>
                                <div class="form-group col-sm-3">
                                    <label for="nrProposta" class="control-label">Repita a senha:<span
                                            class="text-danger" title="Este campo  obrigatrio.">*</span></label>
                                    <input type="password" class="form-control" id="senha2" name="senha2"
                                           placeholder="Confirme a Senha"
                                           value="">
                                </div>
                            </div>
                        </div>
                        <?php if($cliente['fl_acade_expert'] == '1'): ?>
                            <div class="row">
                                <div class="col-sm-12">
                                    <div class="form-group col-sm-6">
                                        <label for="email" class="control-label">E-mail:<span
                                        </label>
                                        <input type="email" class="form-control" id="email" name="email" placeholder="Informe seu e-mail" value="<?= $usuario['email'] ? $usuario['email'] : '' ?>">
                                    </div>
                                </div>
                            </div>
                        <?php endif; ?>
                        <div class="row">
                            <div class="col-sm-12">
                                <div class="form-group col-sm-2">
                                    <label for="horaInicio" class="control-label">Horario inicial:<span
                                            class="text-danger" title="Este campo  obrigatrio.">*</span></label>
                                    <input type="text" class="form-control hora" id="horaInicio" name="horaInicio"
                                           placeholder="Horario de Incio"
                                           value="<?= $usuario['horaInicio'] ?>">
                                </div>
                                <div class="form-group col-sm-2">
                                    <label for="horaTermino" class="control-label">Horario final:<span
                                            class="text-danger" title="Este campo  obrigatrio.">*</span></label>
                                    <input type="text" class="form-control hora" id="horaTermino" name="horaTermino"
                                           placeholder="Horario de Trmino"
                                           value="<?= $usuario['horaTermino'] ?>">
                                </div>
                                <div class="form-group col-sm-2">
                                    <label class="control-label" for="data">
                                        Data de Expirao:
                                    </label>
                                    <input type="text" class="form-control data datepicker-input" id="data"
                                           name="data"
                                           value="<?= Helper::getDate($usuario['dataExpiracao']) ?>"/>
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-sm-12">
                                <div class="form-group col-sm-6">
                                    <label for="empreendimento" class="control-label">Empreendimento: <span
                                            class="text-danger" title="Este campo  obrigatrio.">(Deixar em branco para dar acesso  todos)</span></label>
                                    <select class="form-control select2BigData"
                                            data-placeholder="" name="empreendimento[]"
                                            id="empreendimento" multiple="multiple">
                                        <?php if (isset($usuario['empreendimento'])): ?>
                                            <?php foreach ($usuario['empreendimento'] as $empreendimento) : ?>
                                                <option selected value="<?= $empreendimento['id'] ?>">
                                                    <?= $empreendimento['nm_empreendimento'] ?>
                                                </option>
                                            <?php endforeach; ?>
                                        <?php endif; ?>
                                    </select>
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-sm-12">
                                <?php if (Login::getUsuario()->getSuper() == '1') : ?>
                                    <div class="form-group col-sm-3">
                                        <label class="control-label">
                                            Super Usuario:
                                        </label><br>

                                        <div class="col-sm-6">
                                            <label for="superS">Sim</label>
                                            <input type="radio" id="superS" class="form-control icheck"
                                                   name="super" <?= ($usuario['super'] == '1') ? 'checked' : ''; ?>
                                                   value="1"/>
                                        </div>
                                        <div class="col-sm-6">
                                            <label for="superN">No</label>
                                            <input id="superN" class="form-control icheck"
                                                   style="margin-left: 20px" <?= ($usuario['super'] != '1') ? 'checked' : ''; ?>
                                                   type="radio" name="super" value="0"/>
                                        </div>
                                    </div>
                                <?php endif; ?>
                                <div class="form-group col-sm-3">
                                    <label class="control-label">
                                        Ativo:
                                    </label><br>

                                    <div class="col-sm-6">
                                        <label for="statusS">Sim</label>
                                        <input type="radio" id="statusS" class="form-control icheck"
                                               name="status" <?= ($usuario['status'] != '0') ? 'checked' : ''; ?>
                                               value="1"/>
                                    </div>
                                    <div class="col-sm-6">
                                        <label for="statusN">No</label>
                                        <input type="radio" id="statusN" class="form-control icheck"
                                               style="margin-left: 20px" <?= ($usuario['status'] == '0') ? 'checked' : ''; ?>
                                               name="status" value="0"/>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </fieldset>
                    <fieldset>
                        <legend>Operaes</legend>
                        <div class="row">
                            <div class="col-sm-12">
                                <div class="form-group col-sm-2">
                                    <input type="submit" class="btn btn-primary col-sm-12 fDesabilitaBtn" value="Salvar">
                                </div>
                                <div class="form-group col-sm-2">
                                    <a href="?m=seguranca&c=usuario&a=listar"
                                       class="btn btn-danger col-sm-12">Cancelar </a>
                                </div>
                            </div>
                        </div>
                    </fieldset>
                </form>
            </div>
        </div>
    </div>
<div class="modal fade mVisualizar " tabindex="-1" role="dialog" aria-labelledby="myLargeModalLabel"
    aria-hidden="true">
    <div class="modal-dialog modal-lg ">
        <div class="modal-content">

            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal"
                        aria-hidden="true">&times;</button>
                <h2 class="modal-title" id="myModalLabel" align="center"><i class="fa fa-book"></i>
                    Tutorial</h2>
            </div>

            <div class="modal-body tableFix" style="max-height:600px;">
                <fieldset >
                    <legend>Usurio - Cadastrar os acessos ao Sistema</legend>
                    <div class="row" style="margin-right: 0px;margin-left: 0px;">
                        <iframe width="560" height="500" src="https://www.youtube-nocookie.com/embed/fSr2VNe--Lk?si=vzKMpkDRYegJ8Gzf" title="YouTube video player" frameborder="0" allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture; web-share" referrerpolicy="strict-origin-when-cross-origin" allowfullscreen></iframe>
                    </div>
                    <div></div>
                </fieldset>
            </div>
        </div>
    </div>
</div>
<?php require_once 'layout/includes/footer.php'; ?>