<?php

class UsuarioController extends Controller
{
    private $tb_usuario;
    private $tb_usuario_empreendimento;

    function __construct($request)
    {
        parent::__construct($request);
        $this->tb_usuario = new Db_Usuario();
        $this->tb_usuario_empreendimento = new Usuario_Empreendimento();
    }


    public function indexAction()
    {
        $this->redir(array("modulo" => "seguranca", "controller" => "usuario", "action" => "listar"));
    }

    public function listarAction()
    {
        if ($this->isAjax()) {
            //Testa se deve exibir a lista com ou sem os super users
            if (Login::getUsuario()->getSuper() == '1')
                $listaItem = Db_Usuario::findListaSuperDados();
            else
                $listaItem = Db_Usuario::findListaDados();

            $lista = array();
            foreach ($listaItem as $item) {


                //Testa se o usuario  super, sendo no aparecer o seu perfil pra editar!
                if (Login::getUsuario()->getSuper() == '0' && Login::getUsuario()->getId() == $item['id']) {
                    continue;
                }
                
                //Condio para no listar o usurio do suporte ou desenvolvedor
                if ( $item['login'] == 'dev' || $item['login'] == 'suporte' || strpos($item['login'], 'suporte') !== false )
                    continue;

                $acoes = '<div style="width: 90px"></div><div align="center" style="width: 100%;">';
                $acoes .= '<a href="index.php?m=' . $this->modulo . '&c=' . $this->controller . '&a=editar&id=' . $item['id'] . '" data-toggle="tooltip" title="EDITAR" class="btn btn-default btn-sm" style="margin-right:5px"><i class="fa fa-edit"></i></a>';
                $title = "return confirm('Tem certeza que deseja remover o perfil " . $item['nome'] . "?')";
                $acoes .= '<a onclick="' . $title . '"  href="index.php?m=' . $this->modulo . '&c=' . $this->controller . '&a=deletar&id=' . $item['id'] . '" data-toggle="tooltip" title="REMOVER" class="btn btn-default btn-sm" style="margin-right:5px"><i class="fa fa-times"></i></a>';
                $acoes .= '</div>';
                $acoes .= '</div>';

                if ($item['status'] == 0)
                    $cor = 'style="color:red"';
                else
                    $cor = '';

                $lista[] = array(
                    'codigo' => "<div {$cor} align='center'>" . $item['id'] . '</div>',
                    'nome' => "<div {$cor}>" . utf8_encode($item['nm_pessoa']) . '</div>',
                    'login' => "<div {$cor}>" . utf8_encode($item['login']) . '</div>',
                    'perfil' => "<div {$cor}>" . utf8_encode($item['perfil']) . '</div>',
                    'acoes' => utf8_encode($acoes)
                );
            }

            echo json_encode(array(
                'draw' => 1,
                'recordsTotal' => count($lista),
                'recordsFiltered' => count($lista),
                'data' => $lista
            ));

        } else {
            $this->display('listar');
        }
    }
    public function adicionarAction()
    {
        $this->set("subtitulo", "Usurios");
        $this->set("perfis", Db_Perfil::findAll());
        $this->set("cliente", Db_Cliente::getCliente());
        
        if ($this->_isPost && $this->validar()) {
            try {
                $transaction = $this->tb_usuario->getAdapter()->beginTransaction();
                $usuario = $this->tb_usuario->createRow();

                $usuario->id = $_POST['cliente'];
                $usuario->login = $_POST['login'];
                if ($_POST['senha'] != '' && $_POST['senha'] == $_POST['senha2']) {
                    $usuario->senha = md5($_POST['senha']);
                    $nmDominio = "";
                    $url = explode('.', $_SERVER['HTTP_HOST']);
                    if ($url[0] == 'www') {
                        $nmDominio = $url[1];
                    } else {
                        $nmDominio = $url[0];
                    }
                    $curl = curl_init();

                    curl_setopt_array($curl, array(
                    CURLOPT_URL => 'https://api.acade.com.br/auth/atualizarSenha',
                    CURLOPT_RETURNTRANSFER => true,
                    CURLOPT_ENCODING => '',
                    CURLOPT_MAXREDIRS => 10,
                    CURLOPT_TIMEOUT => 0,
                    CURLOPT_FOLLOWLOCATION => true,
                    CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                    CURLOPT_CUSTOMREQUEST => 'POST',
                    CURLOPT_POSTFIELDS => array('id' => $_POST['cliente'],'cliente' => $nmDominio,'senha' => $_POST['senha']),
                    ));

                    $response = curl_exec($curl);
                    $error = curl_error($curl);


                    if ($error !== '') {
                        var_dump($error);
                        die;
                    }
                    curl_close($curl);
                }
                $usuario->horaInicio = $_POST['horaInicio'];
                $usuario->horaTermino = $_POST['horaTermino'];
                $usuario->dataExpiracao = Helper::getInputDate($_POST['data']);
                $usuario->super = isset($_POST['super'])?$_POST['super']:0;
                $usuario->status = $_POST['status'];
                $usuario->perfilId = $_POST['perfil'];

                $perfil = Db_Perfil::find($_POST['perfil']);
                
                if ($perfil->getNome() == "Imobiliria") {
                    $usuario->idImobiliaria = $_POST['imobiliaria'];
                }

                $usuario->log = (Login::getUsuario()->getLogin() . ' - ' . date('d/m/Y H:m:s') . ' - u');

                if ($usuario->save()) {
                    if (isset($_POST['empreendimento'])) {
                        foreach ($_POST['empreendimento'] as $empreendimento) {
                            $ue = $this->tb_usuario_empreendimento->createRow();
                            $ue->id_pessoa_fisica = $usuario->id;
                            $ue->id_empreendimento = $empreendimento;
                            $ue->save();
                        }
                    }
                }

                //Salva o email do usurio na tabela PESSOA.
                if ($_POST['email']) {
                    $usuario = (new Pessoa())->fetchRow('id = ' . $_POST['cliente']);

                    $usuario->email = $_POST['email'];
                    $usuario->save();
                                
                    $nmDominio = "";
                    $url = explode('.', $_SERVER['HTTP_HOST']);
                    if ($url[0] == 'www') {
                        $nmDominio = $url[1];
                    } else {
                        $nmDominio = $url[0];
                    }
                    $curl = curl_init();

                    curl_setopt_array($curl, array(
                    CURLOPT_URL => 'https://api.acade.com.br/auth/atualizarEmail',
                    CURLOPT_RETURNTRANSFER => true,
                    CURLOPT_ENCODING => '',
                    CURLOPT_MAXREDIRS => 10,
                    CURLOPT_TIMEOUT => 0,
                    CURLOPT_FOLLOWLOCATION => true,
                    CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                    CURLOPT_CUSTOMREQUEST => 'POST',
                    CURLOPT_POSTFIELDS => array('id' => $usuario->id,'cliente' => $nmDominio,'email' => $_POST['email'],'senha' => $_POST['senha']),
                    ));

                    $response = curl_exec($curl);
                    $error = curl_error($curl);


                    if ($error !== '') {
                        var_dump($error);
                        die;
                    }
                    curl_close($curl);

                }

                $transaction->commit();
                $this->redir(array("modulo" => "seguranca", "controller" => "usuario", "action" => "listar"), array("msg" => "success"));
            } catch (Exception $e) {
                if (isset($transaction))
                    $transaction->rollBack();
                $this->_helper->addMensagem("fail", "No foi possvel realizar a operao. Erro: " . $e->getMessage());
            }
        }
        $this->display("form");
    }

    public function editarAction()
    {
        $usuario = $this->tb_usuario->fetchRow('id = ' . $_GET["id"])->toArray();
        $pessoa = Pessoa_Fisica::findDadosPessoaFisica($_GET["id"]);
        $usuario = array_merge($usuario, $pessoa);
        
        $empreendimentos = Usuario_Empreendimento::findEmpreendimentosUsuario($_GET["id"]);
        $usuario['empreendimento'] = $empreendimentos;

        $imobiliarias = Pessoa::findAllPessoasJuridicas();
        
        $this->set("usuario", $usuario);
        $this->set("perfis", Db_Perfil::findAll());
        $this->set("imobiliarias", $imobiliarias);
        $this->set("cliente", Db_Cliente::getCliente());
        
        if ($this->_isPost && $this->validar()) {
            
            try {
                $transaction = $this->tb_usuario->getAdapter()->beginTransaction();
                $usuario = $this->tb_usuario->fetchRow('id = ' . $_GET["id"]);

                $usuario->id = $_POST['cliente'];
                $usuario->login = $_POST['login'];
                if ($_POST['senha'] != '' && $_POST['senha'] == $_POST['senha2']) {
                
                    $usuario->senha = md5($_POST['senha']);
                    $nmDominio = "";
                    $url = explode('.', $_SERVER['HTTP_HOST']);
                    if ($url[0] == 'www') {
                        $nmDominio = $url[1];
                    } else {
                        $nmDominio = $url[0];
                    }
                    $curl = curl_init();

                    curl_setopt_array($curl, array(
                    CURLOPT_URL => 'https://api.acade.com.br/auth/atualizarSenha',
                    CURLOPT_RETURNTRANSFER => true,
                    CURLOPT_ENCODING => '',
                    CURLOPT_MAXREDIRS => 10,
                    CURLOPT_TIMEOUT => 0,
                    CURLOPT_FOLLOWLOCATION => true,
                    CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                    CURLOPT_CUSTOMREQUEST => 'POST',
                    CURLOPT_POSTFIELDS => array('id' => $_POST['cliente'],'cliente' => $nmDominio,'senha' => $_POST['senha']),
                    ));

                    $response = curl_exec($curl);
                    $error = curl_error($curl);


                    if ($error !== '') {
                        var_dump($error);
                        die;
                    }
                    curl_close($curl);
                }
                $usuario->horaInicio = $_POST['horaInicio'];
                $usuario->horaTermino = $_POST['horaTermino'];
                $usuario->dataExpiracao = Helper::getInputDate($_POST['data']);
                //se no for super usurio, o campo 'super' recebe o valor 0 por padro.
                //Antes estava recebendo o valor null, o que impedia, o administrador de
                //editar as informaes de outro usurio.
                if (Login::getUsuario()->getSuper() != '1')
                    $usuario->super = 0;
                else {
                    $usuario->super = $_POST['super'];
                }

                $usuario->status = $_POST['status'];
                $usuario->perfilId = $_POST['perfil'];
                
                $perfil = Db_Perfil::find($_POST['perfil']);
                
                if ($perfil->getNome() == "Imobiliria") {
                    $usuario->idImobiliaria = $_POST['imobiliaria'];
                } elseif ($usuario->idImobiliaria) {
                    $usuario->idImobiliaria = null;
                }
                
                $usuario->log = (Login::getUsuario()->getLogin() . ' - ' . date('d/m/Y H:m:s') . ' - u');
                
                if ($usuario->save()) {

                    $this->tb_usuario_empreendimento->delete('id_pessoa_fisica = ' . $usuario->id);

                    if (isset($_POST['empreendimento'])) {
                        foreach ($_POST['empreendimento'] as $empreendimento) {
                            $ue = $this->tb_usuario_empreendimento->createRow();
                            $ue->id_pessoa_fisica = $usuario->id;
                            $ue->id_empreendimento = $empreendimento;
                            $ue->save();
                        }
                    }
                }

                //Salva o email do usurio na tabela PESSOA.
                if ($_POST['email']) {
                    $usuario = (new Pessoa())->fetchRow('id = ' . $_POST['cliente']);

                    $usuario->email = $_POST['email'];
                    $usuario->save();
                                        
                    $nmDominio = "";
                    $url = explode('.', $_SERVER['HTTP_HOST']);
                    if ($url[0] == 'www') {
                        $nmDominio = $url[1];
                    } else {
                        $nmDominio = $url[0];
                    }
                    $curl = curl_init();

                    curl_setopt_array($curl, array(
                    CURLOPT_URL => 'https://api.acade.com.br/auth/atualizarEmail',
                    CURLOPT_RETURNTRANSFER => true,
                    CURLOPT_ENCODING => '',
                    CURLOPT_MAXREDIRS => 10,
                    CURLOPT_TIMEOUT => 0,
                    CURLOPT_FOLLOWLOCATION => true,
                    CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                    CURLOPT_CUSTOMREQUEST => 'POST',
                    CURLOPT_POSTFIELDS => array('id' => $usuario->id,'cliente' => $nmDominio,'email' => $_POST['email'],'senha' => $_POST['senha']),
                    ));

                    $response = curl_exec($curl);
                    $error = curl_error($curl);


                    if ($error !== '') {
                        var_dump($error);
                        die;
                    }
                    curl_close($curl);

                }
                
                $transaction->commit();

            } catch (Exception $e) {
                if (isset($transaction))
                    $transaction->rollBack();
                $this->_helper->addMensagem("fail", "No foi possvel realizar a operao. Erro: " . $e->getMessage());
                $this->redir(array("modulo" => "seguranca", "controller" => "usuario", "action" => "listar"), array("msg" => "FAIL"));
            }
            $this->redir(array("modulo" => "seguranca", "controller" => "usuario", "action" => "listar"), array("msg" => "OK"));
        }

        $this->display('form');
    }

    public function deletarAction()
    {
        try {
            $this->tb_usuario_empreendimento->delete('id_pessoa_fisica = ' . $_GET["id"]);
            $this->tb_usuario->delete($_GET["id"]);

            $this->redir(array("modulo" => "seguranca", "controller" => "usuario", "action" => "listar"), array("msg" => "success"));
        } catch (Exception $e) {
            $this->redir(array("modulo" => "seguranca", "controller" => "usuario", "action" => "listar"), array("msg" => "FAIL"));
        }
    }

    private function validar()
    {
        //validao vazio
        $campos = array('cliente', 'login', 'status', 'horaInicio', 'horaTermino', 'data');
        foreach ($campos as $cp) {
            if ($_POST [$cp] == "") {
                switch ($cp) {
                    case "cliente" :
                        $msg = "O campo Nome  obrigatrio.";
                        break;
                    case "status" :
                        $msg = "O campo Status  obrigatrio.";
                        break;
                    case "login" :
                        $msg = "O login  obrigatrio.";
                        break;
                    case "horaInicio" :
                        $msg = "O horrio inicial  obrigatrio.";
                        break;
                    case "horaTermino" :
                        $msg = "O horrio final  obrigatrio.";
                        break;
                    case "data" :
                        $msg = "A data de expirao  obrigatrio.";
                        break;
                }
                $this->_helper->addMensagem($cp, $msg);
            }
        }

        if ($_GET['a'] != 'editar' && !$_POST ["senha"]) {
            $this->_helper->addMensagem("senha", "O campo senha  obrigatrio");
        }

        if ($_POST ["senha"] != $_POST ["senha2"]) {
            $this->_helper->addMensagem("senha", "As senhas devem ser semelhantes!");
        }

        if ((int)$_POST["perfil"] == 5 || (int)$_POST["perfil"] == 6) {
            if (!count($_POST["empreendimento"])) $this->_helper->addMensagem("empreendimento", "A lista de empreendimentos deve ser preenchida!");
        }

        //enfase
        if ($_POST['loginAtual'] != $_POST["login"])
            if (Db_Usuario::loginIsAvailable($_POST["login"]) == false) {
                $this->_helper->addMensagem("login", "Login indisponvel!");
            }

        return !(count($this->_helper->getMensagens()) > 0);
    }

}