<?php

class PerfilController extends Controller
{
    private $tb_perfil;
    private $tb_perfilActions;

    public function __construct($request)
    {
        parent::__construct($request);
        $this->tb_perfil = new Db_Perfil();
        $this->tb_perfilActions = new Db_ACL();
        $this->set("subtitulo", "Perfil");
        $this->set('nomeTela', "Perfil");
    }

    public function indexAction()
    {
        $this->redir(array("modulo" => "seguranca", "controller" => "perfil", "action" => "listar"));
    }

    public function listarAction()
    {
        if ($this->isAjax()) {
            $listaItem = $this->tb_perfil->findAll(false);

            $lista = array();
            foreach ($listaItem as $item) {

                //N�o lista o perfil do proprio usuario nem o perfil de administrador pra niguem
                if (Login::getUsuario()->getSuper() == '0' && (Login::getUsuario()->getPerfilId() == $item['id'] || $item['id'] == 1)){
                    continue;
                }

                $acoes = '<div style="width: 90px"></div><div align="center" style="width: 100%;">';
                $acoes .= '<a href="index.php?m=' . $this->modulo . '&c=' . $this->controller . '&a=editar&id=' . $item['id'] . '" data-toggle="tooltip" title="EDITAR" class="btn btn-default btn-sm" style="margin-right:5px"><i class="fa fa-edit"></i></a>';
                $title = "return confirm('Tem certeza que deseja remover o perfil " . $item['nome'] . "?')";
                $acoes .= '<a onclick="' . $title . '"  href="index.php?m=' . $this->modulo . '&c=' . $this->controller . '&a=deletar&id=' . $item['id'] . '" data-toggle="tooltip" title="REMOVER" class="btn btn-default btn-sm" style="margin-right:5px"><i class="fa fa-times"></i></a>';
                $acoes .= '</div>';
                $acoes .= '</div>';

                $lista[] = array(
                    'codigo' => '<div align="center">' . $item['id'] . '</div>',
                    'nome' => utf8_encode($item['nome']),
                    'acoes' => utf8_encode($acoes)
                );
            }

            echo json_encode(array(
                'draw' => 1,
                'recordsTotal' => count($lista),
                'recordsFiltered' => count($lista),
                'data' => $lista
            ));

        } else {
            $this->display('listar');
        }
        $this->set("botoes", array("Adicionar" => array("modulo" => "seguranca", "c" => "perfil", "a" => "adicionar")));

        if ($_GET["msg"] == "OK") {
            $this->_helper->addMensagem("ok", "Opera��o realizada com sucesso!");
        } elseif ($_GET["msg"] == "FAIL") {
            $this->_helper->addMensagem("fail", "Erro! N�o foi poss�vel continuar a opera��o!");
        }
    }

    public function adicionarAction()
    {
        //Busca os modulos de cada sistema, seus controllers e actions
        $actionsLotear = array();
        $actionsPainel = array();
        $actionsGED = array();
        $actionsExpert = array();
        
        foreach (Db_Modulo::findAllLotear() as $k => $m) {
            $actionsLotear[$k] = $m;
            $actionsLotear[$k]['controllers'] = Db_Controller::findAll($m['id']);
            foreach ($actionsLotear[$k]['controllers'] as $e => $c) {
                $actionsLotear[$k]['controllers'][$e] = $c;
                $actionsLotear[$k]['controllers'][$e]['actions'] = Db_Action::findAll($c['id']);
            }
        }
        foreach (Db_Modulo::findAllPainel() as $k => $m) {
            $actionsPainel[$k] = $m;
            $actionsPainel[$k]['controllers'] = Db_Controller::findAll($m['id']);
            foreach ($actionsPainel[$k]['controllers'] as $e => $c) {
                $actionsPainel[$k]['controllers'][$e] = $c;
                $actionsPainel[$k]['controllers'][$e]['actions'] = Db_Action::findAll($c['id']);
            }
        }
        foreach (Db_Modulo::findAllGED() as $k => $m) {
            $actionsGED[$k] = $m;
            $actionsGED[$k]['controllers'] = Db_Controller::findAll($m['id']);
            foreach ($actionsGED[$k]['controllers'] as $e => $c) {
                $actionsGED[$k]['controllers'][$e] = $c;
                $actionsGED[$k]['controllers'][$e]['actions'] = Db_Action::findAll($c['id']);
            }
        }
        foreach (Db_Modulo::findAllexpert() as $k => $m) {

            $actionsExpert[$k] = $m;
            $actionsExpert[$k]['controllers'] = Db_Controller::findAll($m['id']);
            foreach ($actionsExpert[$k]['controllers'] as $e => $c) {
                $actionsExpert[$k]['controllers'][$e] = $c;
                $actionsExpert[$k]['controllers'][$e]['actions'] = Db_Action::findAll($c['id']);
            }
        }
        $this->set("actionsExpert", $actionsExpert);
        $this->set("actionsGED", $actionsGED);
        $this->set("actionsLotear", $actionsLotear);
        $this->set("actionsPainel", $actionsPainel);

        $cliente = Db_Cliente::getCliente();
        $this->set("cliente", $cliente);

        if ($this->_isPost) {
            if ($this->validar()) {
                try {
                    $p = new Db_Perfil();
                    $p->setId($_POST["id"]);
                    $p->setNome($_POST ["nome"]);

                    $this->set("perfil", $p);

                    $p->setLog(Login::getUsuario()->getLogin() . " - " . date('d/m/Y') . " - i");
                    $p->save();

                    if (count($_POST["action"]))
                        foreach ($_POST["action"] as $ac) {
                            $acl = new Db_ACL();
                            $acl->setActionId($ac);
                            $acl->setPerfilId($p->getId());
                            $acl->save();
                        }

                    $this->redir(array("modulo" => "seguranca", "controller" => "perfil", "action" => "listar"), array("msg" => "OK"));
                } catch (Exception $e) {
                    $this->redir(array("modulo" => "seguranca", "controller" => "perfil", "action" => "adicionar"), array("exception" => $e->getMessage()));
                }
            }
        }
        $this->display("form");
    }

    public function editarAction()
    {
        //Busca os modulos de cada sistema, seus controllers e actions
        $actionsLotear = array();
        $actionsPainel = array();
        $actionsGED = array();
        $actionsExpert = array();
        
        foreach (Db_Modulo::findAllLotear() as $k => $m) {
            $actionsLotear[$k] = $m;
            $actionsLotear[$k]['controllers'] = Db_Controller::findAll($m['id']);
            foreach ($actionsLotear[$k]['controllers'] as $e => $c) {
                $actionsLotear[$k]['controllers'][$e] = $c;
                $actionsLotear[$k]['controllers'][$e]['actions'] = Db_Action::findAll($c['id']);
            }
        }
        foreach (Db_Modulo::findAllPainel() as $k => $m) {
            $actionsPainel[$k] = $m;
            $actionsPainel[$k]['controllers'] = Db_Controller::findAll($m['id']);
            foreach ($actionsPainel[$k]['controllers'] as $e => $c) {
                $actionsPainel[$k]['controllers'][$e] = $c;
                $actionsPainel[$k]['controllers'][$e]['actions'] = Db_Action::findAll($c['id']);
            }
        }
        foreach (Db_Modulo::findAllGED() as $k => $m) {
            $actionsGED[$k] = $m;
            $actionsGED[$k]['controllers'] = Db_Controller::findAll($m['id']);
            foreach ($actionsGED[$k]['controllers'] as $e => $c) {
                $actionsGED[$k]['controllers'][$e] = $c;
                $actionsGED[$k]['controllers'][$e]['actions'] = Db_Action::findAll($c['id']);
            }
        }
        foreach (Db_Modulo::findAllExpert() as $k => $m) {

            $actionsExpert[$k] = $m;
            $actionsExpert[$k]['controllers'] = Db_Controller::findAll($m['id']);
            foreach ($actionsExpert[$k]['controllers'] as $e => $c) {
                $actionsExpert[$k]['controllers'][$e] = $c;
                $actionsExpert[$k]['controllers'][$e]['actions'] = Db_Action::findAll($c['id']);
            }
        }
        $this->set("actionsExpert", $actionsExpert);
        $this->set("actionsGED", $actionsGED);
        $this->set("actionsLotear", $actionsLotear);
        $this->set("actionsPainel", $actionsPainel);

        $cliente = Db_Cliente::getCliente();
        $this->set("cliente", $cliente);

        $perfilActions = $this->tb_perfilActions->findAllByIdPerfil($_GET['id']);

        $this->set("perfil", Db_Perfil::findById($_GET["id"]));
        $this->set("actions", $perfilActions);

        if ($this->_isPost) {
            if ($this->validar()) {
                try {
                    $p = $this->tb_perfil->find($_GET["id"]);
                    $p->setNome($_POST ["nome"]);

                    $p->setLog(Login::getUsuario()->getLogin() . " - " . date('d/m/Y') . " - u");
                    $p->save();

                    if (count($_POST["action"])) {
                        Db_ACL::deleteAll($_GET["id"]);
                        foreach ($_POST["action"] as $ac) {
                            $acl = new Db_ACL();
                            $acl->setActionId($ac);
                            $acl->setPerfilId($p->getId());
                            $acl->save();
                        }
                    }

                    $this->redir(array("modulo" => "seguranca", "controller" => "perfil", "action" => "listar"), array("msg" => "OK"));
                } catch (Exception $e) {
                    $this->redir(array("modulo" => "seguranca", "controller" => "perfil", "action" => "listar"), array("exception" => $e->getMessage()));
                }
            }
        }
        $this->display("form");
    }

    private function validar()
    {
        //valida��o vazio
        $campos = array("nome");
        foreach ($campos as $cp) {
            if ($_POST [$cp] == "") {
                switch ($cp) {
                    case "nome" :
                        $msg = "O campo Nome � obrigat�rio.";
                        break;
                }
                $this->_helper->addMensagem($cp, $msg);
            }
        }

        return !(count($this->_helper->getMensagens()) > 0);
    }

    public function deletarAction()
    {
        try {
            Db_ACL::deleteAll($_GET["id"]);
            Db_Perfil::delete($_GET["id"]);
            $this->redir(array("modulo" => "seguranca", "controller" => "perfil", "action" => "listar"), array("msg" => "OK"));
        } catch (Exception $e) {
            $this->redir(array("modulo" => "seguranca", "controller" => "perfil", "action" => "listar"), array("exception" => $e->getMessage()));
        }
    }

}