<?php
require_once 'layout/includes/header.php';
require_once 'layout/includes/menu.php';

$perfis = $this->get('perfis');
$usuario = $this->get('usuario');
?>
    <div class="content">
        <div class="page-heading">
            <?= $this->getHeader(); ?>
        </div>
        <div class="widget">
            <div class="widget-content padding">
                <!-- MENSAGENS -->
                <?php if (count($this->_helper->getMensagens()) > 0): ?>
                    <div class="alert alert-danger alert-dismissable">
                        <?php foreach ($this->_helper->getMensagens() as $message): ?>
                            <?= $message ?><br>
                        <?php endforeach; ?>
                    </div>
                <?php endif; ?>
                <form action="" method="POST" id="form">
                    <fieldset>
                        <legend>Dados de Usuario </legend>
                        <div class="row">
                            <div class="col-sm-12">
                                <div class="form-group col-sm-6">
                                    <label for="idCliente" class="control-label">Pessoa Fsica: <span
                                            class="text-danger" title="Este campo  obrigatrio.">*</span></label>
                                    <select class="form-control select2BigData"
                                            data-placeholder="Nome do usurio" name="cliente"
                                            id="idCliente"
                                            required="required">
                                        <?php if (isset($usuario)): ?>
                                            <option selected value="<?= $usuario['id_pessoa'] ?>">
                                                <?= $usuario['nm_pessoa'] . ' (' . $usuario['nr_cpf'] . ')' ?>
                                            </option>
                                        <?php endif; ?>
                                    </select>
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-sm-12">
                                <div class="form-group col-sm-6">
                                    <label class="control-label" for="perfil">
                                        Perfil:<span class="require" style="color: red">*</span>
                                    </label>
                                    <select class="form-control select2" id="perfil" name="perfil">
                                        <option value="">Selecione ...</option>
                                        <?php foreach ($perfis as $perfil) : ?>
                                            <option
                                                value="<?= $perfil['id']; ?>"<?php if ($usuario['perfilId'] == $perfil['id']): ?> selected<?php endif; ?>>
                                                <?= $perfil['nome']; ?>
                                            </option>
                                        <?php endforeach; ?>
                                    </select>
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-sm-12">
                                <div class="form-group col-sm-6">
                                    <label for="login" class="control-label">Login:<span
                                            class="text-danger" title="Este campo  obrigatrio.">*</span></label>
                                    <input type="text" class="form-control" id="login" name="login"
                                           placeholder="Login"
                                           value="<?= $usuario['login'] ?>">
                                    <input type="hidden" name="loginAtual" value="<?= $usuario['login'] ?>">
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-sm-12">
                                <div class="form-group col-sm-3">
                                    <label for="nrProposta" class="control-label">Senha:<span
                                            class="text-danger" title="Este campo  obrigatrio.">*</span></label>
                                    <input type="password" class="form-control" id="senha" name="senha"
                                           placeholder="Senha"
                                           value="">
                                </div>
                                <div class="form-group col-sm-3">
                                    <label for="nrProposta" class="control-label">Repita a senha:<span
                                            class="text-danger" title="Este campo  obrigatrio.">*</span></label>
                                    <input type="password" class="form-control" id="senha2" name="senha2"
                                           placeholder="Confirme a Senha"
                                           value="">
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-sm-12">
                                <div class="form-group col-sm-2">
                                    <label for="horaInicio" class="control-label">Horario inicial:<span
                                            class="text-danger" title="Este campo  obrigatrio.">*</span></label>
                                    <input type="text" class="form-control hora" id="horaInicio" name="horaInicio"
                                           placeholder="Horario de Incio"
                                           value="<?= $usuario['horaInicio'] ?>">
                                </div>
                                <div class="form-group col-sm-2">
                                    <label for="horaTermino" class="control-label">Horario final:<span
                                            class="text-danger" title="Este campo  obrigatrio.">*</span></label>
                                    <input type="text" class="form-control hora" id="horaTermino" name="horaTermino"
                                           placeholder="Horario de Trmino"
                                           value="<?= $usuario['horaTermino'] ?>">
                                </div>
                                <div class="form-group col-sm-2">
                                    <label class="control-label" for="data">
                                        Data de Expirao:
                                    </label>
                                    <input type="text" class="form-control data datepicker-input" id="data"
                                           name="data"
                                           value="<?= Helper::getDate($usuario['dataExpiracao']) ?>"/>
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-sm-12">
                                <div class="form-group col-sm-6">
                                    <label for="empreendimento" class="control-label">Empreendimento: <span
                                            class="text-danger" title="Este campo  obrigatrio.">(Deixar em branco para dar acesso  todos)</span></label>
                                    <select class="form-control select2BigData"
                                            data-placeholder="" name="empreendimento[]"
                                            id="empreendimento" multiple="multiple">
                                        <?php if (isset($usuario['empreendimento'])): ?>
                                            <?php foreach ($usuario['empreendimento'] as $empreendimento) : ?>
                                                <option selected value="<?= $empreendimento['id'] ?>">
                                                    <?= $empreendimento['nm_empreendimento'] ?>
                                                </option>
                                            <?php endforeach; ?>
                                        <?php endif; ?>
                                    </select>
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-sm-12">
                                <?php if (Login::getUsuario()->getSuper() == '1') : ?>
                                    <div class="form-group col-sm-3">
                                        <label class="control-label">
                                            Super Usuario:
                                        </label><br>

                                        <div class="col-sm-6">
                                            <label for="superS">Sim</label>
                                            <input type="radio" id="superS" class="form-control icheck"
                                                   name="super" <?= ($usuario['super'] == '1') ? 'checked' : ''; ?>
                                                   value="1"/>
                                        </div>
                                        <div class="col-sm-6">
                                            <label for="superN">No</label>
                                            <input id="superN" class="form-control icheck"
                                                   style="margin-left: 20px" <?= ($usuario['super'] != '1') ? 'checked' : ''; ?>
                                                   type="radio" name="super" value="0"/>
                                        </div>
                                    </div>
                                <?php endif; ?>
                                <div class="form-group col-sm-3">
                                    <label class="control-label">
                                        Ativo:
                                    </label><br>

                                    <div class="col-sm-6">
                                        <label for="statusS">Sim</label>
                                        <input type="radio" id="statusS" class="form-control icheck"
                                               name="status" <?= ($usuario['status'] != '0') ? 'checked' : ''; ?>
                                               value="1"/>
                                    </div>
                                    <div class="col-sm-6">
                                        <label for="statusN">No</label>
                                        <input type="radio" id="statusN" class="form-control icheck"
                                               style="margin-left: 20px" <?= ($usuario['status'] == '0') ? 'checked' : ''; ?>
                                               name="status" value="0"/>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </fieldset>
                    <fieldset>
                        <legend>Operaes</legend>
                        <div class="row">
                            <div class="col-sm-12">
                                <div class="form-group col-sm-2">
                                    <input type="submit" class="btn btn-primary col-sm-12 fDesabilitaBtn" value="Salvar">
                                </div>
                                <div class="form-group col-sm-2">
                                    <a href="?m=sc&c=usuario&a=listar"
                                       class="btn btn-danger col-sm-12">Cancelar </a>
                                </div>
                            </div>
                        </div>
                    </fieldset>
                </form>
            </div>
        </div>
    </div>
<?php require_once 'layout/includes/footer.php'; ?>