<?php
require_once 'layout/includes/header.php';
require_once 'layout/includes/menu.php';
$listaAgrupada = $this->get('listaAgrupada');
$dadosAgrupada = $this->get('dadosAgrupada');
?>
    <div class="content">
        <div class="page-heading">
            <?= $this->getHeader(); ?>
        </div>
        <div class="widget">
            <div class="widget-content padding">
                <!-- MENSAGENS -->
                <?= ($_GET["msg"] == "success") ? '<div class="alert alert-success alert-dismissable">Operao realizada com sucesso.</div>'
                    : (($_GET['exception'] != '') ? '<div class="alert alert-danger alert-dismissable">' . $_GET['exception'] . '</div>' : '');
                ?>
                <?php if (count($this->_helper->getMensagens()) > 0): ?>
                    <div class="alert alert-danger alert-dismissable">
                        <?php foreach ($this->_helper->getMensagens() as $message): ?>
                            <?= $message ?><br>
                        <?php endforeach; ?>
                    </div>
                <?php endif; ?>
                <form action="" method="POST">
                    <fieldset>
                        <legend>Informaes da Tabela Agrupada <span style=" font-size: 10pt">(Campos com <span style=" color: red">*</span> so obrigatrios)</span></legend>
                        <div class="row">
                            <div class="col-sm-12">
                                <div class="form-group col-sm-6">
                                    <label class="control-label" for="idAgrupada">
                                        Tabela:<span class="require" style="color: red">*</span>
                                    </label>
                                    <select class="form-control select2 tbAgrupada" <?= ($_GET['id'])? 'disabled' : '' ?>
                                            id="idAgrupada" name="idAgrupada"
                                            data-placeholder="Selecione a Tabela">
                                        <option value=""></option>
                                        <?php foreach ($listaAgrupada as $agrupada): ?>
                                            <option value="<?= $agrupada['idCampo'];?>"<?=($_GET['id'] == $agrupada['idCampo']) ? 'selected' : '' ?>>
                                                <?= $agrupada['descricao']; ?>
                                            </option>
                                        <?php endForeach ?>
                                    </select>
                                </div>
                                <div class="form-group col-sm-6">
                                    <label class="control-label" for="descricao">
                                        Descrio:<span class="require" style="color: red">*</span>
                                    </label>
                                    <input type="text" class="form-control" id="descricao"
                                           name="descricao" placeholder="Digite a Descrio"
                                           value="<?= $dadosAgrupada['descricao']; ?>"/>
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-sm-12">
                                <div class="form-group col-sm-3">
                                    <label class="control-label" for="cdCampo">
                                        Cdigo de Campo:<span class="require" style="color: red">*</span>
                                    </label>
                                    <input type="text" class="form-control" id="cdCampo" maxlength="3"
                                           name="cdCampo" placeholder="Digite o Cdigo"
                                           value="<?= $dadosAgrupada['idCampo']; ?>"/>
                                </div>
                                <div class="form-group col-sm-3">
                                    <label class="control-label" for="complemento">
                                        Complemento:
                                    </label>
                                    <input type="text" class="form-control" id="complemento"
                                           name="complemento" placeholder="Digite o Complemento"
                                           value="<?= $dadosAgrupada['complemento']; ?>"/>
                                </div>
                            </div>
                        </div>
                    </fieldset>
                    <fieldset>
                        <legend>Operaes</legend>
                        <div class="row">
                            <div class="col-sm-12">
                                <div class="form-group col-sm-2">
                                    <input type="submit" class="btn btn-primary col-sm-12 fDesabilitaBtn" value="Salvar">
                                </div>
                                <div class="form-group col-sm-2">
                                    <a href="?c=tabelaAgrupada&a=listar"
                                       class="btn btn-danger col-sm-12">Cancelar </a>
                                </div>
                            </div>
                        </div>
                    </fieldset>
                </form>
            </div>
        </div>
    </div>
<?php require_once 'layout/includes/footer.php';?>