<?php
require_once 'layout/includes/header.php';
require_once 'layout/includes/menu.php';

$dadosVariavel = $this->get('dadosVariavel');

?>

<div class="content">
    <div class="page-heading">
        <?= $this->getHeader('Criar', 'Cadastro de variveis da Remessa de Banco'); ?>
    </div>
    <div class="widget">
        <div class="widget-content padding">
            <!-- MENSAGENS -->
            <?php if (count($this->_helper->getMensagens()) > 0) : ?>
                <div class="alert alert-danger alert-dismissable">
                    <?php foreach ($this->_helper->getMensagens() as $message) : ?>
                        <?= $message ?><br>
                    <?php endforeach; ?>
                </div>
            <?php endif; ?>

            <form action="" method="POST" id="formModeloBanco" enctype="multipart/form-data">
                <fieldset>
                    <legend class="">Informaes da varivel <span style="font-size: 10pt">(Campos com <span style="color:red;">*</span> so obrigatrios)</span></legend>
                    <div class="row">
                        <div class="col-sm-12">
                           
                            <div class="form-group col-sm-6">
                                <label for="nmNome" class="control-label">
                                    Nome da varivel:<span class="require" style="color:red">*</span>
                                </label>
                                <input type="text" class="form-control" name="variavel" id="variavel" required="required" maxlength="100" placeholder="Digite o ttulo do modelo" 
                                    value="<?= ($dadosVariavel['variavel']) ? $dadosVariavel['variavel'] : ''; ?>"/>
                            </div>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-sm-12">
                     
                            <div class="form-group col-sm-6">
                                <label for="nmNome" class="control-label">
                                    Descrio:<span class="require" style="color:red">*</span>
                                </label>
                                <input type="text" class="form-control" name="descricao" id="descricao" required="required" maxlength="100" placeholder="Digite o ttulo do modelo" 
                                    value="<?= ($dadosVariavel['descricao']) ? $dadosVariavel['descricao'] : ''; ?>"/>
                                    <input type="hidden" class="form-control" name="inserir" id="inserir"  value="<?= ($dadosVariavel['id']) ? 'no' : 'sim'; ?>"/>
                                    <input type="hidden" class="form-control" name="id" id="id"  value="<?= ($dadosVariavel['id']) ? $dadosVariavel['id'] : ''; ?>"/>
                            </div>
                        </div>
                    </div>
                    
                </fieldset>

                <fieldset>
                    <legend>Operaes</legend>
                    <div class="row">
                        <div class="col-sm-12">
                            <div class="form-group col-sm-2">
                                <input type="submit" value="<?= ($dadosVariavel['id']) ? 'Atualizar' : 'Adicionar'; ?>" class="btn btn-primary col-sm-12"/>
                            </div>
                            <div class="form-group col-sm-2">
                                <a href="?m=sc&c=modeloBanco&a=variaveis" class="btn btn-danger col-sm-12">Cancelar</a>
                            </div>
                        </div>
                    </div>
                </fieldset>
            </form>
        </div>
    </div>
</div>
<?php require_once 'layout/includes/footer.php'; ?>