<?php

require_once 'layout/includes/header.php';
require_once 'layout/includes/menu.php';

$tabelaPreco = $this->get('tabelaPreco');
$listaLayout = $this->get('listaLayout');
?>
    <div class="content">
        <div class="page-heading">
            <?= $this->getHeader('Editar', 'Layout do Arquivo de Remessa'); ?>
        </div>
 <div class="widget">  
    <div class="widget-content padding"> 
        <fieldset>
            <form id="editarTabelaPrecoLotes" enctype="multipart/form-data" class="form" role="form">
                <fieldset>
                    <legend>Edio de Layout</legend>
                    <div class="row">
                        <div class="col-sm-12">
                            <div class="form-group col-sm-6" style="max-width: 50%">
                                <label for="Empreendimento" class="control-label cl-xs-3">Nome do Layout:</label>
                                <select name="Empreendimento" id="Empreendimento" class="form-control" title="Escolha o Empreendimento" emptyText="Escolha o Empreendimento" useEmpty="true" disabled>
                                    <?= '<option value="' . $tabelaPreco['id_layout'] . '">' . $tabelaPreco['nm_layout'] . '</option>'; ?>
                                </select>
                                <input type="hidden" id="empreendimentoHidden" name="empreendimentoHidden">
                            </div>                                 
                        </div>
                    </div>
                    <div class="row">
                        <div class="form-group col-sm-12">
                            <div class="form-group col-sm-6">
                                <label for="quadra" class="control-label">Listar tipos:</label>
                                <select class="form-control" name="quadra" id="quadra" placeholder="Selecione o tipo de Layout">
                                    <option></option>
                                    <option value="*">Todos</option>
                                    <option value="N">Nenhum</option>
                                    
                                </select>
                            </div>         
                            <div class="form-group col-sm-6">
                                <h4 style="font-weight: 800;">Instrues:</h4>
                                <ul style="font-size: 12px">
                                    <li>Os valores com a linha <span style="color: #0C71E0">azul</span> em baixo são editáveis ao clicar.</li>
                                    <li>Boxes selecionados serão editados com o mesmo valor a todos clicando em <span style="color: #68C39F">Editar Selecionados</span>.</li>
                                </ul>                     
                            </div>             
                        </div>
                        <div class="col-sm-12">
                            <table id="tableValues" class="table table-hover table-condensed order-column" style="width:100%;">
                                <thead class="tb-center">
                                    <tr>
                                        <th id="tabelaPreco" value="<?= $tabelaPreco['id'] ?>" tipo="<?= $tabelaPreco['tipo_layout'] ?>" colspan="13"><?= $tabelaPreco['nm_layout'] ?></th>
                                    </tr>
                                    <tr style="height: auto;">
                                        <th></th>
                                        <th width="200px">Linha/Descrio</th>
                                        <th>Expresso Regular</th>
                                        <th width="120px">Ao</th>
                                    </tr>
                                </thead>
                            </table>
                        </div>
                    </div>
            </form>
        </fieldset>
    </div>
</div>

<!-- MODAL -->
<div id="modalEditarTb" class="modal fade" role="dialog">
    <div class="modal-dialog modal-lg">
        <!-- Modal content-->
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal">&times;</button>
                <h3 class="modal-title"><i class="icon-edit"></i>Editar Layout Selecionado</h3>
            </div>
            <div class="modal-body">
                <fieldset>
                    <form class="form" role="form" id="formModal" enctype="multipart/form-data">
                        <?php if ($tabelaPreco['tp_tabela'] = 'REM') : ?>
                            <div class="row">
                                <div class="col-sm-12">
                                    <div class="form-group col-sm-6">
                                        <label for="vlTotal">Linha do arquivo</label>
                                        <input name="vlTotal" required="required" class="form-control input-sm maskMoney" type="text">
                                    </div>
                                    <div class="form-group col-sm-3">
                                        <label for="txJuros">Expresso Regular</label>
                                        <input name="txJuros" required="required" class="form-control input-sm" type="text">
                                    </div>
                                </div>
                            </div>
                        <?php else : ?>
                            <div class="row">
                                <div class="col-sm-12">
                                    <div class="form-group col-sm-6">
                                        <label for="vlTotal">Valor Total Lote</label>
                                        <input name="vlTotal" required="required" class="form-control input-sm maskMoney" type="text">
                                    </div>
                                    <div class="form-group col-sm-6">
                                        <label for="vlSinal">Valor Sinal</label>
                                        <input name="vlSinal" class="form-control input-sm maskMoney" type="text">
                                    </div>
                                </div>
                            </div>
                            <div class="row">
                                <div class="col-sm-12">
                                    <div class="form-group col-sm-6">
                                        <label for="vlParcela">Valor Parc. Mensal</label>
                                        <input name="vlParcela" class="form-control input-sm maskMoney" type="text">
                                    </div>
                                    <div class="form-group col-sm-6">
                                        <label for="qtdeMensalParc">Quant. Mensal</label>
                                        <input name="qtdeMensalParc" class="form-control input-sm" type="text">
                                    </div>
                                </div>
                            </div>
                            <div class="row">
                                <div class="col-sm-12">
                                    <div class="form-group col-sm-6">
                                        <label for="vlIntercalada">Valor Intercalada</label>
                                        <input name="vlIntercalada" class="form-control input-sm maskMoney" type="text">
                                    </div>
                                    <div class="form-group col-sm-3">
                                        <label for="qtIntercalada">Quant. Intercalada</label>
                                        <input name="qtIntercalada" class="form-control input-sm" type="text">
                                    </div>
                                    <div class="form-group col-sm-3">
                                        <label for="perIntercalada">Period. Intercalada</label>
                                        <input name="perIntercalada" class="form-control input-sm" type="text">
                                    </div>
                                </div>
                            </div>
                        <?php endif; ?>

                        <div class="row">
                            <div class="col-sm-12">
                                <div class="form-group col-sm-3">
                                    <button type="submit" id="editarNovo" class="btn btn-primary col-sm-12">Salvar</button>
                                </div>
                                <div class="form-group col-sm-3">
                                    <button type="button" class="btn btn-danger col-sm-12" data-dismiss="modal">Cancelar</button>
                                </div>
                                <div class="form-group col-sm-6">
                                    <span>OBS: Serão alterados apenas os valores preenchidos.</span>
                                </div>
                            </div>
                        </div>
                    </form>
                </fieldset>
            </div>
        </div>
    </div>
</div>
<!-- FIM MODAL -->

<?php require_once 'layout/includes/footer.php'; ?>