<?php
require_once 'layout/includes/header.php';
require_once 'layout/includes/menu.php';
?>
<style>
    @media screen and (max-width:720px) {
    .dddTelefoneCss{
        width: 43px;
        margin-bottom: 5px;
    }
    .logoImg{
        width: 190px;
    }
    .inforCliente{
        font-size: 17px;
    }
}
</style>
    <div class="content">
        <div class="page-heading">
            <?= $this->getHeader(); ?>
        </div>
        <div class="widget">
            <?php
            $cliente = $this->get("cliente");
            $cidade = $this->get("cidade");
            $planos = $this->get("planos");
            $arquivo = $this->get('arquivo');
            $nmDominio = $this->get('nmDominio');
            ?>
            <div class="widget-content padding">
                <!-- MENSAGENS -->
                <?php if (count($this->_helper->getMensagens()) > 0): ?>
                    <div class="alert alert-danger alert-dismissable">
                        <?php foreach ($this->_helper->getMensagens() as $message): ?>
                            <?= $message ?><br>
                        <?php endforeach; ?>
                    </div>
                <?php endif; ?>
                <?php if (isset($_GET['msg']) AND $_GET['msg'] == "OK"): ?>
                    <div class="alert alert-success alert-dismissable">
                        Operao realizada com sucesso!
                    </div>
                <?php endif; ?>
                <?php if (isset($_GET['erro'])): ?>
                    <div class="alert alert-danger alert-dismissable">
                        <?=$_GET['erro']?>
                    </div>
                <?php endif; ?>
                <form action="" method="POST" id="form" enctype="multipart/form-data">
                    <input type="hidden" name="id" id="id" value="<?= $cliente['cd_cliente']; ?>" required/>

                    <fieldset>
                        <legend class="inforCliente">Informaes Plano do Cliente <span style=" font-size: 10pt">(Campos com <span style=" color: red">*</span> so obrigatrios)</span></legend>
                        <div class="row">
                            <div class="col-sm-12">
                                <div class="form-group col-sm-2">
                                    <label for="cdPlanoCliente" class="control-label">Plano Cliente:<label class="require" style="color: red">*</label></label>
                                    <select class="form-control select2" name="cdPlanoCliente"
                                            data-placeholder="Escolha o Tipo de Audincia"
                                            id="cdPlanoCliente" required>
                                        <option value="">Selecione ...</option>
                                        <?php foreach ($planos as $plano): ?>
                                            <option
                                                value="<?= $plano['idCampo']; ?>" <?= ($plano['idCampo'] == $cliente['cd_plano_cliente']) ? 'selected' : '' ?>>
                                                <?= $plano['descricao'] ?>
                                            </option>
                                        <?php endforeach; ?>
                                    </select>
                                </div>
                                <div class="form-group col-sm-2">
                                    <label class="control-label">
                                        Painel de Vendas:
                                    </label><br>
                                    <div class="col-sm-2">
                                        <label for="flPainelVendaS">Sim</label>
                                        <input id="flPainelVendaS" class="form-control icheck"
                                               <?= ($cliente['fl_painel_venda'] == '1') ? 'checked' : ''; ?>
                                               type="radio" name="flPainelVenda" value="1"/>
                                    </div>
                                    <div class="col-sm-2">
                                        <label for="flPainelVendaN">No</label>
                                        <input id="flPainelVendaN" class="form-control icheck"
                                               <?= ($cliente['fl_painel_venda'] == '0') ? 'checked' : ''; ?>
                                               type="radio" name="flPainelVenda" value="0"/>
                                    </div>

                                    <div class="col-sm-3">
                                        <label for="flPlantaVenda">Planta</label>
                                        <input id="flPlantaVenda" name="flPlantaVenda" type="hidden" value="0">
                                        <input id="flPlantaVenda" class="form-control icheck"
                                            <?= ($cliente['fl_planta_venda'] == '1') ? 'checked' : ''; ?>
                                            type="checkbox" name="flPlantaVenda" value="1"/>
                                    </div>

                                </div>
                                <div class="form-group col-sm-2">
                                    <label class="control-label">
                                        Acade GED:
                                    </label><br>
                                    <div class="col-sm-3">
                                        <label for="flAcadeGedS">Sim</label>
                                        <input id="flAcadeGedS" class="form-control icheck"
                                               style="margin-left: 20px" <?= ($cliente['fl_acade_ged'] == '1') ? 'checked' : ''; ?>
                                               type="radio" name="flAcadeGed" value="1"/>
                                    </div>
                                    <div class="col-sm-3">
                                        <label for="flAcadeGedN">No</label>
                                        <input id="flAcadeGedN" class="form-control icheck"
                                               style="margin-left: 20px" <?= ($cliente['fl_acade_ged'] == '0') ? 'checked' : ''; ?>
                                               type="radio" name="flAcadeGed" value="0"/>
                                    </div>
                                </div>
                                <div class="form-group col-sm-2">
                                    <label class="control-label">
                                        Acade Finan:
                                    </label><br>
                                    <div class="col-sm-3">
                                        <label for="flAcadeFinanS">Sim</label>
                                        <input id="flAcadeFinanS" class="form-control icheck"
                                               style="margin-left: 20px" <?= ($cliente['fl_acade_finan'] == '1') ? 'checked' : ''; ?>
                                               type="radio" name="flAcadeFinan" value="1"/>
                                    </div>
                                    <div class="col-sm-3">
                                        <label for="flAcadeFinanN">No</label>
                                        <input id="flAcadeFinanN" class="form-control icheck"
                                               style="margin-left: 20px" <?= ($cliente['fl_acade_finan'] == '0') ? 'checked' : ''; ?>
                                               type="radio" name="flAcadeFinan" value="0"/>
                                    </div>                                   
                                </div>
                                
                                <div class="form-group col-sm-2">
                                    <label class="control-label">
                                        Portal Acade:
                                    </label><br>
                                    <div class="col-sm-3">
                                        <label for="flAcadeGedS">Sim</label>
                                        <input id="flAcadeGedS" class="form-control icheck"
                                               style="margin-left: 20px" <?= ($cliente['fl_senhaportal'] == '1') ? 'checked' : ''; ?>
                                               type="radio" name="flAcadePortal" value="1"/>
                                    </div>
                                    <div class="col-sm-3">
                                        <label for="flAcadeGedN">No</label>
                                        <input id="flAcadeGedN" class="form-control icheck"
                                               style="margin-left: 20px" <?= ($cliente['fl_senhaportal'] == '0') ? 'checked' : ''; ?>
                                               type="radio" name="flAcadePortal" value="0"/>
                                    </div>
                                </div>

                                <div class="form-group col-sm-2">
                                    <label class="control-label">
                                        Acade Expert:
                                    </label><br>
                                    <div class="col-sm-3">
                                        <label for="flAcadeExpertS">Sim</label>
                                        <input id="flAcadeExpertS" class="form-control icheck"
                                               style="margin-left: 20px" <?= ($cliente['fl_acade_expert'] == '1') ? 'checked' : ''; ?>
                                               type="radio" name="flAcadeExpert" value="1"/>
                                    </div>
                                    <div class="col-sm-3">
                                        <label for="flAcadeExpertN">No</label>
                                        <input id="flAcadeExpertN" class="form-control icheck"
                                               style="margin-left: 20px" <?= ($cliente['fl_acade_expert'] == '0') ? 'checked' : ''; ?>
                                               type="radio" name="flAcadeExpert" value="0"/>
                                    </div>
                                </div>
                                
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-sm-12">
                                <div class="form-group col-sm-2">
                                    <label for="qtdDownload" class="control-label">
                                        Quantidade de Downloads
                                    </label><br>
                                    <input type="text" class="form-control soNumero" id="qtdDownload"
                                        name="qtdDownload" value="<?= $cliente["qtd_download"] ? $cliente["qtd_download"] : '' ?>"/>
                                </div>
                                <div class="form-group col-sm-2">
                                    <label for="qtdDownload" class="control-label">
                                        Limite de envios dirio
                                    </label><br>
                                    <input type="text" class="form-control soNumero" id="qtd_envio_email"
                                        name="qtd_envio_email" value="<?= $cliente["qtd_envio_email"] ? $cliente["qtd_envio_email"] : '0' ?>"/>
                                </div>
                                <div class="form-group col-sm-2">
                                    <label class="control-label" style="font-weight: 700;">
                                        Sistema de e-mail:
                                    </label><br>
                                    <div class="col-sm-3">
                                        <label for="flAcadeGedS">Sim</label>
                                        <input id="flAcadeGedS" class="form-control icheck"
                                               style="margin-left: 20px" <?= ($cliente['fl_comunicacao'] == '1') ? 'checked' : ''; ?>
                                               type="radio" name="flComunicacao" value="1"/>
                                    </div>
                                    <div class="col-sm-3">
                                        <label for="flAcadeGedN">No</label>
                                        <input id="flAcadeGedN" class="form-control icheck"
                                               style="margin-left: 20px" <?= ($cliente['fl_comunicacao'] == '0') ? 'checked' : ''; ?>
                                               type="radio" name="flComunicacao" value="0"/>
                                    </div>
                                </div>
                                <div class="form-group col-sm-2">
                                    <label for="contratoDigital" class="control-label">
                                        Contrato Digital:
                                    </label></br>
                                    <div class="col-sm-3">
                                        <label for="contratoDigitalSim" class="control-label">Sim </label>
                                        <input type="radio" class="form-control icheck" <?= ($cliente['fl_contrato_digital'] == '1') ? 'checked' : ''; ?> name="contratoDigital" value="1" />
                                    </div>
                                    <div class="col-sm-3">
                                        <label for="contratoDigitalNao" class="control-label">No </label>
                                        <input type="radio" class="form-control icheck" <?= ($cliente['fl_contrato_digital'] == '0') ? 'checked' : ''; ?> name="contratoDigital" value="0" />
                                    </div>
                                </div>
                                <div class="form-group col-sm-2">
                                    <label for="oportunidades" class="control-label">
                                        Oportunidades:
                                    </label></br>
                                    <div class="col-sm-3">
                                        <label for="oportunidadesSim" class="control-label">Sim </label>
                                        <input type="radio" class="form-control icheck" <?= ($cliente['fl_oportunidades'] == '1') ? 'checked' : ''; ?> name="oportunidades" value="1" />
                                    </div>
                                    <div class="col-sm-3">
                                        <label for="oportunidadesNao" class="control-label">No </label>
                                        <input type="radio" class="form-control icheck" <?= ($cliente['fl_oportunidades'] == '0') ? 'checked' : ''; ?> name="oportunidades" value="0" />
                                    </div>
                                </div>
                            </div>
                        </div>
                    </fieldset>

                    <fieldset>
                        <legend>Dados do Cliente</legend>
                        <div class="row">
                            <div class="col-sm-12">
                                <div class="form-group col-sm-3">
                                    <label for="cdTipo" class="control-label">Situao de Acesso:<label class="require" style="color: red">*</label></label>
                                    <select class="form-control select2" name="cdTipo"
                                            data-placeholder="Escolha a Situao de Acesso"
                                            id="cdTipo" required>
                                        <option value="N" <?= ($cliente['fl_situacao'] == 'N') ? 'selected="selected"' : '' ?>>
                                            Normal
                                        </option>
                                        <option value="S" <?= ($cliente['fl_situacao'] == 'S') ? 'selected="selected"' : '' ?>>
                                            Suspenso
                                        </option>
                                        <option value="M" <?= ($cliente['fl_situacao'] == 'M') ? 'selected="selected"' : '' ?>>
                                            Manuteno
                                        </option>
                                    </select>
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-sm-12">
                                <div class="form-group col-sm-3">
                                    <label class="control-label" for="cdAcade">
                                        Cdigo:
                                    </label>
                                    <input type="text" class="form-control soNumero" id="cdAcade"
                                           name="cdAcade" value="<?= $cliente["cd_cliente"] ?>"/>
                                </div>
                                <div class="col-sm-3 form-group">
                                    <label for="dtContrato" class="control-label">Data do Contrato:</label>
                                    <input type="text" id="dtContrato" name="dtContrato"
                                           class="data datepicker-input form-control"
                                           value="<?= Helper::getDate($cliente['dt_contrato']); ?>"/>
                                </div>
                                <div class="form-group col-sm-3">
                                    <label class="control-label">
                                        Exibir Parcelas Migradas:
                                    </label><br>
                                    <div class="col-sm-4">
                                        <label for="flParcelaMigradas1">Sim</label>
                                        <input id="flParcelaMigradas1" class="form-control icheck"
                                               style="margin-left: 20px" <?= ($cliente['fl_parcelas_migradas'] == '1') ? 'checked' : ''; ?>
                                               type="radio" name="flParcelaMigradas" value="1"/>
                                    </div>
                                    <div class="col-sm-4">
                                        <label for="flParcelaMigradas0">No</label>
                                        <input id="flParcelaMigradas0" class="form-control icheck"
                                               style="margin-left: 20px" <?= ($cliente['fl_parcelas_migradas'] == '0') ? 'checked' : ''; ?>
                                               type="radio" name="flParcelaMigradas" value="0"/>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-sm-12">
                                <div class="form-group col-sm-6">
                                    <label class="control-label" for="nmRazaoSocial">
                                        Razo Social / Nome:<label class="require" style="color: red">*</label>
                                    </label>
                                    <input type="text" class="form-control" id="nmRazaoSocial"
                                           name="nmRazaoSocial" value="<?= $cliente["nm_razao_social"] ?>"
                                           required maxlength="50"/>
                                </div>
                                <div class="form-group col-sm-6">
                                    <label for="nmFantasia" class="control-label">Nome Fantasia:</label>
                                    <input type="text" id="nmFantasia" name="nmFantasia"
                                           class="form-control" value="<?= $cliente['nm_fantasia']; ?>"
                                    maxlength="50"/>
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-sm-12">
                                <div class="form-group col-sm-4">
                                    <label class="control-label" for="nrCnpjCpf">
                                        CNPJ / CPF:<label class="require" style="color: red">*</label>
                                    </label>
                                    <input type="text" class="form-control" id="nrCnpjCpf"
                                           name="nrCnpjCpf" value="<?= $cliente["nr_cnpj"]?>" required/>
                                </div>
                                <div class="form-group col-sm-4">
                                    <label for="nrInscricaoMunicipal" class="control-label">Inscrio
                                        Municipal / RG:</label>
                                    <input type="text" id="nrInscricaoMunicipal" name="nrInscricaoMunicipal"
                                           class="form-control" value="<?= $cliente['nr_inscricao_municipal']; ?>"/>
                                </div>
                                <div class="form-group col-sm-4">
                                    <label for="nrInscricaoEstadual" class="control-label">Inscrio
                                        Estadual:</label>
                                    <input type="text" id="nrInscricaoEstadual" name="nrInscricaoEstadual"
                                           class="form-control" value="<?= $cliente['nr_inscricao_estadual']; ?>"/>
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-sm-12">
                                <div class="form-group col-sm-6">
                                    <label class="control-label" for="dsUrl">
                                        URL:
                                    </label>
                                    <input type="text" class="form-control" id="dsUrl"
                                           name="dsUrl" value="<?= $cliente["ds_url"] ?>"/>
                                </div>
                                <div class="form-group col-sm-6">
                                    <label for="dsEmail" class="control-label">E-Mail:</label>
                                    <input type="text" id="dsEmail" name="dsEmail"
                                           class="form-control" value="<?= $cliente['ds_email']; ?>"/>
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-sm-12">
                                <div class="form-group col-sm-4">
                                    <label class="control-label">
                                        Telefone:
                                    </label>
                                    <br>
                                    <div class="col-sm-3">
                                        <input type="text" class="form-control dddTel dddTelefoneCss" id="nrUfTelefone"
                                               name="nrUfTelefone" value="<?= $cliente["nr_uf_telefone"] ?>"/>
                                    </div>
                                    <div class="col-sm-9">
                                        <input type="text" class="form-control nrTel" id="nrTelefone"
                                               name="nrTelefone" value="<?= $cliente["nr_telefone"] ?>"/>
                                    </div>
                                </div>
                                <div class="form-group col-sm-4">
                                    <label class="control-label">
                                        Telefone 2:
                                    </label>
                                    <br>
                                    <div class="col-sm-3">
                                        <input type="text" class="form-control dddTel dddTelefoneCss" id="nrUfTelefone2"
                                               name="nrUfTelefone2" value="<?= $cliente["nr_uf_telefone2"] ?>"/>
                                    </div>
                                    <div class="col-sm-9">
                                        <input type="text" class="form-control nrTel" id="nrTelefone2"
                                               name="nrTelefone2" value="<?= $cliente["nr_telefone2"] ?>"/>
                                    </div>
                                </div>
                                <div class="form-group col-sm-4">
                                    <label for="nrCep" class="control-label">Cep:</label>
                                    <input type="text" id="nrCep" name="nrCep"
                                           class="form-control cep" value="<?= $cliente['nr_cep']; ?>"/>
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-sm-12">
                                <div class="form-group col-sm-6">
                                    <label class="control-label" for="endereco">
                                        Endereo:
                                    </label>
                                    <input type="text" class="form-control" id="endereco"
                                           name="dsEndereco" value="<?= $cliente["ds_endereco"] ?>"/>
                                </div>
                                <div class="form-group col-sm-3">
                                    <label for="nm_bairro" class="control-label">Bairro:</label>
                                    <input type="text" id="nm_bairro" name="nmBairro"
                                           class="form-control" value="<?= $cliente['nm_bairro']; ?>"/>
                                </div>
                                <div class="form-group col-sm-3">
                                    <label for="cidade" class="control-label">Cidade:</label>
                                    <select class="form-control select2 cidade"
                                            data-placeholder="Cidade" name="cd_cidade"
                                            id="cidade">
                                        <?php if (isset($cidade)): ?>
                                            <option selected
                                                    value="<?= $cidade->getId() ?>"><?= $cidade->getNome().' - '.$cidade->getUf() ?></option>
                                        <?php endif; ?>
                                    </select>
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-sm-12">
                                <div class="form-group col-sm-3">
                                    <label class="control-label">
                                        Optante Simples:
                                    </label><br>

                                    <div class="col-sm-4">
                                        <label for="flOptanteSimples1">Sim</label>
                                        <input id="flOptanteSimples1" class="form-control icheck"
                                               style="margin-left: 20px" <?= ($cliente['fl_optante_simples'] == '1') ? 'checked' : ''; ?>
                                               type="radio" name="flOptanteSimples" value="1"/>
                                    </div>
                                    <div class="col-sm-4">
                                        <label for="flOptanteSimples0">No</label>
                                        <input id="flOptanteSimples0" class="form-control icheck"
                                               style="margin-left: 20px" <?= ($cliente['fl_optante_simples'] == '0') ? 'checked' : ''; ?>
                                               type="radio" name="flOptanteSimples" value="0"/>
                                    </div>
                                </div>
                                <div class="form-group col-sm-3">
                                    <label class="control-label">
                                        Moeda:
                                    </label><br>

                                    <select class="form-control select2 cidade"
                                            data-placeholder="Moeda" name="moeda"
                                            id="moeda">
                                        <!-- Moedas mais populares -->
                                        <option value="brl">Real Brasileiro (BRL)</option>
                                        <option value="usd">Dlar Americano (USD)</option>
                                        <option value="eur">Euro (EUR)</option>
                                        <option value="gbp">Libra Esterlina (GBP)</option>
                                        <option value="jpy">Iene Japons (JPY)</option>
                                        <option value="aud">Dlar Australiano (AUD)</option>
                                        <option value="cad">Dlar Canadense (CAD)</option>
                                        <option value="chf">Franco Suo (CHF)</option>
                                        <option value="cny">Yuan Chins (CNY)</option>
                                        <option value="inr">Rupia Indiana (INR)</option>
                                        <option value="rub">Rublo Russo (RUB)</option>
                                        <option value="zar">Rand Sul-Africano (ZAR)</option>
                                        <option value="sgd">Dlar de Singapura (SGD)</option>
                                        <option value="nzd">Dlar Neozelands (NZD)</option>
                                        <option value="mxn">Peso Mexicano (MXN)</option>

                                        <!-- Moedas da Amrica do Sul -->
                                        <option value="ars">Peso Argentino (ARS)</option>
                                        <option value="bob">Boliviano (BOB)</option>
                                        <option value="clp">Peso Chileno (CLP)</option>
                                        <option value="cop">Peso Colombiano (COP)</option>
                                        <option value="pyg">Guarani Paraguaio (PYG)</option>
                                        <option value="pen">Sol Peruano (PEN)</option>
                                        <option value="uyu">Peso Uruguaio (UYU)</option>
                                        <option value="ves">Bolvar Venezuelano (VES)</option>
                                        <option value="gyd">Dlar da Guiana (GYD)</option>
                                        <option value="fkp">Libra das Ilhas Malvinas (FKP)</option>
                                    </select>
                                </div>
                            </div>
                        </div>
                    </fieldset>

                    <fieldset>
                        <legend>Outorgante</legend>
                        <div class="row">
                            <div class="col-sm-12">
                                <div class="form-group col-sm-6">
                                    <label class="control-label" for="nome_outorgante">
                                        Nome:
                                    </label>
                                    <input type="text" class="form-control" id="nome_outorgante"
                                           name="nome_outorgante" placeholder="Digite o nome do outorgante" value="<?= $cliente['nome_outorgante'];?>"/>
                                </div>
                                <div class="form-group col-sm-3">
                                    <label class="control-label" for="telefone_outorgante">
                                        Telefone:
                                    </label>
                                    <input type="text" class="form-control" id="telefone_outorgante"
                                           name="telefone_outorgante" placeholder="Digite o telefone do outorgante" value="<?= $cliente['telefone_outorgante'];?>"/>
                                </div>
                                <div class="form-group col-sm-3">
                                    <label class="control-label" for="email_outorgante">
                                        Email:
                                    </label>
                                    <input type="text" class="form-control" id="email_outorgante"
                                           name="email_outorgante" placeholder=" Digite o email do outorgante" value="<?= $cliente['email_outorgante'];?>"/>
                                </div>
                            </div>
                        </div>
                    </fieldset>

                    <fieldset>
                        <legend>Logomarca</legend>
                        <div class="row">
                            <div class="col-sm-12">
                                <div class="col-sm-6">
                                    <label for="dsEndLogomarca" class="control-label">Anexar Arquivo: </label>
                                    <input title="Selecionar ..." name="dsEndLogomarca" id="dsEndLogomarca"
                                           type="file" class="fileinput" accept="image/*" onchange="validateImagem()"/>
                                </div>
                                <div class="col-sm-6">
                                    <label for="dsEndLogomarca" class="control-label">Imagem: </label>
                                    <div class="col-sm-12">
                                        <img class="logoImg" height="100px" width="300px" src="<?= $arquivo['caminho']; ?>"
                                             alt="<?= $arquivo['arquivo']; ?>"/>
                                        <br>
                                        <a id="rem_arquivoCliente" href="<?= $arquivo['caminho']; ?>" download="">Baixar
                                            Imagem</a>
                                        <a id="rem_arquivoCliente"
                                           href="?m=sc&c=cliente&a=excluirImagem&id=<?= $cliente['cd_cliente']; ?>">Excluir
                                            Imagem</a>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </fieldset>
                    <fieldset>
                        <legend>Docusign</legend>
                        
                        <div class="row" id="divTabelaAssinaturas">
                            <div class="col-sm-12">
                                <div class="col-sm-12 form-group">
                                    <div class="table-responsive">
                                        <table class="table  table-hover table-condensed order-column"
                                            cellspacing="0" width="100%">
                                            <thead>
                                            <tr>
                                                <th>Empreendimento</th>
                                                <th>ID do cliente</th>
                                                <th>Chave de Integrao</th>
                                                <th>Aes</th>
                                            </tr>
                                            </thead>
                                            <tbody id="tabelaDocusign">
                                            
                                            </tbody>
                                        </table>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </fieldset>
                    <fieldset>
                        <legend>API</legend>
                        
                        <div class="row" id="divTabelaAssinaturas">
                            <div class="col-sm-12">
                                <div class="col-sm-8" style="font-size: large;">
                                    Token: <b id="tokenCliente"><?= $cliente['tokenApi']; ?></b>
                                </div>
                                <div class="col-sm-4" style="text-align: right;">
                                    <button type="button" onclick="gerarNovoToken()" class="btn btn-success">Gerar novo token</button>
                                </div>
                            </div>
                        </div>
                    </fieldset>
                    <fieldset>
                        <legend>Operaes</legend>
                        <div class="row">
                            <div class="col-sm-12">
                                <div class="form-group col-sm-3">
                                    <input type="submit" class="btn btn-primary col-sm-12 fDesabilitaBtn" value="Salvar">
                                </div>
                                <div class="form-group col-sm-3">
                                    <button type="button" onclick="$('#docusign_id').val('');" class="btn btn-success col-sm-12" data-toggle="modal" data-target="#docusignModal">
                                        Adicionar Docusign
                                    </button>
                                </div>
                            </div>
                        </div>
                    </fieldset>
                </form>

            </div>
        </div>
    </div>

    <div class="modal fade" id="docusignModal" tabindex="-1" role="dialog" aria-labelledby="docusignModalLabel" aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
            <div class="modal-header">
                <span class="modal-title">Configurao do Docusign</span>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body">
                <div class="row">
                    <div class="col-sm-12">
                        <div class="form-group col-sm-10">
                            <label class="control-label" for="docusign_id_cliente">
                                Configurao do link de redicionamento: <i title="na criao do app" class="fa fa-question-circle"></i>
                            </label>
                            <input type="text" class="form-control" id="linkDocusign"
                                    name="docusign_id_cliente" value="https://<?= $nmDominio?>.acadeone.com.br/acadelotear/docusign.php"/>
                        </div>
                        <div class="form-group col-sm-2">
                            <input type="button" class="form-control"  id="copy-button" style="margin-top: 20px;" value="Copiar">
                        </div>
                    </div> <div class="col-sm-12">
                        <div class="form-group col-sm-10">
                            <label class="control-label" for="linkDocusignEvento">
                                Configurao do notificao (Webhook): <i title="Integrations > Connect > Add > Custom > URL to Publish" class="fa fa-question-circle"></i>
                            </label>
                            <input type="text" class="form-control" id="linkDocusignEvento"
                                    name="linkDocusignEvento" value="https://<?= $nmDominio?>.acadeone.com.br/acadelotear/docusignEvento.php"/>
                        </div>
                        <div class="form-group col-sm-2">
                            <input type="button" class="form-control"  id="copy-button1" style="margin-top: 20px;" value="Copiar">
                        </div>
                    </div>
                </div>
                <div class="row">
                    <div class="col-sm-12">
                        <div class="form-group col-sm-4">
                            <label class="control-label" for="docusign_id_cliente">
                                ID do cliente:
                            </label>
                            <input type="number" class="form-control" id="docusign_id_cliente"
                                    name="docusign_id_cliente"/>
                        </div>
                        <div class="form-group col-sm-4">
                            <label for="docusign_integration_key" class="control-label">Inscrio
                                Chave de Integrao:</label>
                            <input type="text" id="docusign_integration_key" name="docusign_integration_key"
                                    class="form-control"/>
                        </div>
                        <div class="form-group col-sm-4">
                            <label for="docusign_secret_key" class="control-label">Inscrio
                                Chave secreta:</label>
                            <input type="text" id="docusign_secret_key" name="docusign_secret_key"
                                    class="form-control"/>
                        </div>
                        <div class="form-group col-sm-4" id="autorizarDocusign">
                            <button disabled class="btn btn-success" title="Salve os tokens do Docusign!" style="width:100%" >Autorizar Docusign</button>
                        </div>
                        <div class="form-group col-sm-4" id="homologarDocusign">
                            <button disabled class="btn btn-success" title="Faa a autorizao do Docusign!" style="width:100%">Homologao da API</button>
                        </div>
                        <div class="form-group col-sm-4">
                            <div class="progress" style="height:34px">
                                <div id="progressoHomologacao" class="progress-bar progress-bar-striped" style="padding-top: 7px;background-color: #68C39F;animation: progress-bar-stripes 1s linear infinite;" role="progressbar">0 %</div>
                            </div>         
                        </div>
                    </div>
                </div>
                <div class="row">
                    <div class="form-group col-sm-4">
                        <label class="control-label" for="id_empreendimento">
                            Empreendimento:
                        </label>
                        <select class="form-control empreendimento"
                                required="required"
                                id="empreendimento" name="empreendimento"
                                data-placeholder="Escolha o Empreendimento">
                            <option value="-1">Todos</option>
                        </select>
                    </div>
                    <div class="form-group col-sm-4">
                        <label for="docusign_nome" class="control-label">
                            Nome
                        </label>
                        <input type="text" id="docusign_nome" name="docusign_nome" class="form-control"/>
                    </div>
                    <div class="form-group col-sm-4">
                        <label for="docusign_email" class="control-label">
                            E-mail 
                        </label>
                        <input type="text" id="docusign_email" name="docusign_email" class="form-control"/>
                    </div>
                </div>
                <div class="modal-footer">
                    
                    <input type="hidden" id="docusign_id" name="docusign_id" value=""/>
                    <button type="button" class="btn btn-primary" onclick="atualizarDocusign()">Salvar</button>
                    <button type="button" class="btn btn-secondary" data-dismiss="modal">Fechar</button>
                </div>
            </div>
        </div>
    </div>
    <script>
        var dominio = "<?=$nmDominio?>";
        <?= $cliente['moeda']?"document.getElementById('moeda').value = '".$cliente['moeda']."'":"";?>
    </script>
<?php require_once 'layout/includes/footer.php'; ?>