<?php
require_once 'layout/includes/header.php';
require_once 'layout/includes/menu.php';

$cliente = $this->get("cliente");
$contratos = $this->get('contratos');
$distratos = $this->get('distratos');
$inadimplentes = $this->get('inadimplentes');
$agendamentos = $this->get('agendamentos');
$juridicos = $this->get('juridicos');
$permissoes = $this->get('permissoesPainel');

$larguraVendas = 6;
$larguraParcelas = 6;
$larguraDistratos = 6;
$larguraLotes = 6;

if (!$permissoes['graficoParcelasPagas']) {
    $larguraLotes = 12;
    $hiddenParcelas = "hidden";
}

if (!$permissoes['graficoLotes']) {
    $larguraParcelas = 12;
    $hiddenLotes = "hidden";
}

if (!$permissoes['graficoVendas']) {
    $larguraDistratos = 12;
    $hiddenVendas = "hidden";
}

if (!$permissoes['graficoDistratos']) {
    $larguraVendas = 12;
    $hiddenDistratos = "hidden";
}
?>
<!-- Modal reagendar -->
<style type="text/css">
    .datepicker{ z-index:99999 !important; }
</style>
<style>
  .cardDosGraficos,
  html,
  body {
    width: auto;
  }
  .cardDosGraficos {
    height: 400px;
  }
</style>
<script src="library/echarts-5.4.2/dist/echarts.js"></script>
<link href="https://fonts.googleapis.com/icon?family=Material+Icons+Round" rel="stylesheet">
<div id="modalReagendar" class="modal fade modalReagendar" tabindex="-1" role="dialog" data-backdrop="static">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                <h2 class="modal-title" style="text-align: center">Reagendamento</h2>
            </div>
            <div class="modal-body">
                <form action="" method="POST" id="form" enctype="multipart/form-data" target="_blank">
                    <fieldset>
                        <legend>Contrato</legend>
                        <div class="row">
                            <div class="form-group col-sm-6">
                                <label class="control-label">Cliente: <strong><span id="cliente"></span></strong></label>
                            </div>
                        </div>
                        <div class="row">
                            <div class="form-group col-sm-3">
                                <label class="control-label">Contrato: <strong><span id="clienteContrato"></span></strong></label>
                            </div>
                            <div class="form-group col-sm-3">
                                <label class="control-label">Quadra: <strong><span id="clienteQuadra"></span></strong></label>
                            </div>
                            <div class="form-group col-sm-3">
                                <label class="control-label">Lote: <strong><span id="clienteLote"></span></strong></label>
                            </div>
                        </div>
                        <legend>Agendamento</legend>
                        <div class="row">
                            <div class="form-group col-sm-3">
                                <label class="control-label">Retorno: <strong><span id="dtRetorno"></span></strong></label>
                            </div>
                            <div class="form-group col-sm-7">
                                <label class="control-label">Assunto: <strong><span id="assunto"></span></strong></label>
                            </div>
                        </div>
                        <legend>Reagendar</legend>
                        <div class="form-group col-sm-6">
                            <label class="control-label" for="data">
                                Nova data de retorno:<span class="require" style="color: red">*</span>
                            </label>
                            <input type="text" class="form-control data datepicker-input datepicker" id="dataRet" name="dataRet" value="<?= date('d/m/Y'); ?>" />
                        </div>
                    </fieldset>
                </form>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-default" data-dismiss="modal">Cancelar</button>
                <a href="index.php?m=&c=admin&a=reagendamentosalvar&id=<?= $dadosAgendamento['id'] ?>" class="btn btn-primary" name="Salvar" id="btnSalvaAgendamento" style="margin-right:5px">Salvar</a>
            </div>
        </div>
    </div>
</div>

<div class="content">
    <?php if ($_GET["msg"]): ?>
        <script>
            alert('<?php echo $_GET["msg"]; ?>');
        </script>
    <?php endif; ?>        
    <div class="row top-summary">
        <form id="formPost" class="row" action="" method="post" style="margin-bottom: 25px;">
            <div class="col-sm-12">
                <div class="form-group col-sm-3"> 
                    <span class="formPost">empreendimento</span>
                    <div id="select" style="white-space: nowrap">                
                        <select class="form-control" name="idEmp"
                                id="empreendimento" style="display: inline;">                            
                            <option value="0">Todos</option>
                            <?php foreach ($this->get("empreendimentos") as $emp): ?>
                                <option value="<?= $emp["id"]; ?>" <?= ($_POST["idEmp"] == $emp["id"]) ? 'selected' : ''; ?>><?= $emp["nm_empreendimento"]; ?></option>
                            <?php endforeach; ?>
                        </select>
                    </div>
                </div> 
            </div>
        </form>

        <?php echo $permissoes['painelLotesDisponiveis'] ? $permissoes['larguraCards'] : "<div hidden>" ?>
            <div class="card-novo">
                <div class="card-header-novo p-3-novo pt-2-novo">
                    <div class="icon-novo icon-lg-novo icon-shape-novo bg-gradient-dark-lote shadow-dark-novo text-center-novo border-radius-xl-novo mt-n4-novo position-absolute-novo">
                        <i class="material-icons-novo opacity-10-novo">store</i>
                    </div>
                    <div class="text-end-novo pt-1-novo">
                        <p class="text-sm-novo mb-0-novo text-capitalize-novo" style="color:#999;">Lotes disponveis</p>
                        <h4 class="mb-0-novo lotes-disponiveis" style="font-size: 20px;"><b></b></h4>
                    </div>
                </div>
                <hr class="dark-novo horizontal-novo my-0-novo">
            </div>
        </div>
    
        <?php echo $permissoes['painelTotalContratos'] ? $permissoes['larguraCards'] : "<div hidden>" ?>
            <div class="card-novo">
                <div class="card-header-novo p-3-novo pt-2-novo">
                    <div class="icon-novo icon-lg-novo icon-shape-novo bg-gradient-dark-contrato shadow-dark-novo text-center-novo border-radius-xl-novo mt-n4-novo position-absolute-novo">
                    <i class="material-icons-novo opacity-10-novo">content_copy</i>
                    </div>
                    <div class="text-end-novo pt-1-novo">
                    <p class="text-sm-novo mb-0-novo text-capitalize-novo" style="color:#999;">Total de contratos</p>
                    <h4 class="mb-0-novo" style="font-size: 20px;"><b><?= $contratos['qtdMesAtual']; ?></b></h4>
                    </div>
                </div>
                <hr class="dark-novo horizontal-novo my-0-novo">
            </div>
        </div>

        <?php echo $permissoes['painelTotalDistratos'] ? $permissoes['larguraCards'] : "<div hidden>" ?>
            <div class="card-novo">
                <div class="card-header-novo p-3-novo pt-2-novo">
                    <div class="icon-novo icon-lg-novo icon-shape-novo bg-gradient-dark-distrato shadow-dark-novo text-center-novo border-radius-xl-novo mt-n4-novo position-absolute-novo">
                    <i class="material-icons-novo opacity-10-novo">money_off</i>
                    </div>
                    <div class="text-end-novo pt-1-novo">
                    <p class="text-sm-novo mb-0-novo text-capitalize-novo" style="color:#999;">Total de distratos</p>
                    <h4 class="mb-0-novo" style="font-size: 20px;"><b><?= $distratos['qtdMesAtual']; ?></b></h4>
                    </div>
                </div>
                <hr class="dark-novo horizontal-novo my-0-novo">
            </div>
        </div>

        <?php echo $permissoes['painelTotalInadimplentes'] ? $permissoes['larguraCards'] : "<div hidden>" ?>
            <div class="card-novo">
                <div class="card-header-novo p-3-novo pt-2-novo">
                    <div class="icon-novo icon-lg-novo icon-shape-novo bg-gradient-dark-inadimplente shadow-dark-novo text-center-novo border-radius-xl-novo mt-n4-novo position-absolute-novo">
                    <i class="material-icons-novo opacity-10-novo">warning</i>
                    </div>
                    <div class="text-end-novo pt-1-novo">
                    <p class="text-sm-novo mb-0-novo text-capitalize-novo" style="color:#999;">Inadimplentes</p>
                    <h4 class="mb-0-novo" style="font-size: 20px;"><b><?= Helper::getMoney($inadimplentes['qtdMesAtual']); ?>%</b></h4>
                    </div>
                </div>
                <hr class="dark-novo horizontal-novo my-0-novo">
            </div>
        </div>
</div>
<div class="row">
    <div class="col-sm-12">
        
        <?php echo "<div class='form-group col-sm-" . $larguraLotes . " " . $hiddenLotes . "'>" ?>
            <div class="widget" style="border-top-left-radius: 6px; border-top-right-radius: 6px;">
                <div class="cardDosGraficos" id="lotes"></div>
            </div>
        </div>

        <?php echo "<div class='form-group col-sm-" . $larguraParcelas . " " . $hiddenParcelas . "'>" ?>
            <div class="widget" style="border-top-left-radius: 6px; border-top-right-radius: 6px;">
                <div class="cardDosGraficos" id="parcelas"></div>
            </div>
        </div>
    </div>
</div>

<div class="row">
    <div class="col-sm-12">
        
        <?php echo "<div class='form-group col-sm-" . $larguraDistratos . " " . $hiddenDistratos . "'>" ?>
            <div class="widget" style="border-top-left-radius: 6px; border-top-right-radius: 6px;">
                <div class="cardDosGraficos" id="distratos"></div>
            </div>
        </div>
        
        <?php echo "<div class='form-group col-sm-" . $larguraVendas . " " . $hiddenVendas . "'>" ?>
            <div class="widget" style="border-top-left-radius: 6px; border-top-right-radius: 6px;">
                <div class="cardDosGraficos" id="vendas"></div>
            </div>
        </div>
    </div>
</div>

<div class="row">
    <div class="col-sm-12">
        <div class="form-group col-sm-6">
            <div class="card-agendas">
                <div class="card-header-agendas card-header-text-agendas card-header-warning-agendas">
                    <div class="card-text-agendas">
                        <h4 style="font-size: 16px; color: #fff;">Agenda do dia</h4>
                    </div>
                </div>

                <div class="card-body-agendas table-responsive">
                    <table id="TabelaListar" class="table table-hover">
                        <thead class="thead-agendas">
                            <tr>
                                <th>Cadastro</th>
                                <th>Contrato/Quadra/Lote</th>
                                <th>Empreendimento</th>
                                <th>Cliente</th>
                                <th>Aes</th>
                            </tr>
                        </thead>

                        <tbody>
                        <?php if ($agendamentos): ?>
                            <?php foreach ($agendamentos as $agendamento): ?>
                                <tr>
                                    <td><?= Helper::getDate($agendamento['data']) ?></td>
                                    <td><?= $agendamento['id_contrato'].' / '.$agendamento['quadra'].' / '.$agendamento['lote'] ?></td>
                                    <td><?= $agendamento['nm_empreendimento'] ?></td>
                                    <td><?= $agendamento['nm_pessoa'] ?></td>
                                    <td>
                                        <span data-toggle="modal" data-target=".modalVisualizar"><button type="button" value="<?= $agendamento['idRelacionamento'].'_A'; ?>" data-toggle="tooltip" title="VISUALIZAR" class="btn btn-default btn-sm btn-visualizar" style="margin-right:2px"><i class="fa fa-eye"></i> </button></span>
                                        <span><a data-target='.modalReagendar' id='link_" . <?= $agendamento['id_contrato']; ?> . "' onClick='reagendar("<?= $agendamento['idRelacionamento']; ?> ") ' data-toggle='tooltip' title='REAGENDAR' style='margin-right:5px' class='btn btn-default btn-sm'><i class='fa fa-calendar'></i></a></span>
                                    </td>
                                </tr>
                            <?php endforeach; ?>
                        <?php else: ?>
                            <tr>
                                <td colspan="6" class="text-center">No h agenda para hoje</td>
                            </tr>
                        <?php endif; ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>

        <div class="form-group col-sm-6">
            <div class="card-agendas">
                <div class="card-header-agendas card-header-text-agendas card-header-warning-agendas">
                    <div class="card-text-agendas">
                        <h4 style="font-size: 16px; color: #fff;">Agenda jurdica do dia</h4>
                    </div>
                </div>

                <div class="card-body-agendas table-responsive">
                    <table id="TabelaListar" class="table table-hover">
                        <thead class="thead-agendas">
                            <tr>
                                <th>Cliente</th>
                                <th>Contrato/Quadra/Lote</th>
                                <th>Empreendimento</th>
                                <th>Notificao</th>
                                <th>Audincia</th>
                                <th>Aes</th>
                            </tr>
                        </thead>

                        <tbody>
                        <?php if ($juridicos): ?>
                            <?php foreach ($juridicos as $juridico): ?>
                                <tr>
                                    <td><?= $juridico['nm_pessoa'] ?></td>
                                    <td><?= $juridico['id_contrato'] ?> / <?= $juridico['quadra'] ?> / <?= $juridico['lote'] ?></td>
                                    <td><?= $juridico['nm_empreendimento'] ?></td>
                                    <td><?= Helper::getDate($juridico['dt_notificacao']) ?></td>
                                    <td><?= Helper::getDate($juridico['dt_audiencia']) ?></td>
                                    <td><span data-toggle="modal" data-target=".modalVisualizar"><button type="button" value="<?= $juridico['id_juridico'].'_J'; ?>" data-toggle="tooltip" title="VISUALIZAR" class="btn btn-default btn-sm btn-visualizar" style="margin-right:5px"><i class="fa fa-eye"></i> </button></span></td>
                                </tr>
                            <?php endforeach; ?>
                        <?php else: ?>
                            <tr>
                                <td colspan="7" class="text-center">No h agenda jurdica para hoje</td>
                            </tr>
                        <?php endif; ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>

</div>

<div id="modalAtualizacao" class="modal fade" tabindex="-1" role="dialog" data-backdrop="static">
    <div class="modal-dialog" role="document">
        <div class="modal-content modal2">
            <div class="modal-body-atualizacao">
                <div class="row">
                    <div class="col-sm-12">
                        <div class="form-group col-sm-12">
                            <img src="upload/imagemTopoModal.png" alt="Logo topo atualiza??o" class="imagemTopoModal">
                            <h1 style="text-align:center;" id="tituloAtualizacao"></h1>
                            <p id="conteudoAtualizacao"></p>
                        </div>
                    </div>
                </div>
                <input type="text" id="idAvisoTelaInicial" hidden>
                <div class="row">
                    <div class="col-sm-12">
                        <div class="form-group col-sm-12">
                        </div>
                    </div>
                </div>
            </div>
            <div class="modal-footer">
                <div class="row">
                    <a class="btn custom-btn btn-avisoTelaInicial btnAtualizacaoLida" name="Entendido" id="btnAtualizacaoLida">Entendido</a>
                </div>
                <div class="row">
                    <img src="upload/imagemModalFooter.png" style="margin-right: 5%" alt="Imagem footer atualizao">
                </div>
            </div>
        </div>
    </div>
</div>
<?php require_once 'layout/includes/footer.php'; ?>
