<?php

class UsuarioEmpreendimentoController extends Controller {

    private $emps;

 public function __construct($request) {

        parent::__construct($request);
        $this->emps = new Empreendimento();
        $this->set("titulo", "Usurio Empreendimento");

        $this->set("cidades", $this->cidades = Db_Cidade::fetchAll(null, "nome"));
    }

  public function indexAction() {
        if (isset($_GET['msg']) && $_GET["msg"] == "OK") {
            $this->_helper->addMensagem("ok", "Operao realizada com sucesso!");
        } else if (isset($_GET['msg']) == "fail") {
            $this->_helper->addMensagem("fail", "Erro! No foi possvel prosseguir com a operao!");
        }
		
		//nome da tela a ser exibida no rodap da pgina
		$this->set('nomeTela', "Usu&aacute;rio Empreendimento");
		//nome da verso atual da tela a ser exibida
		$this->set('versao', "v1.01.9041");

        $usuariosEmpreendimento = new Usuario_Empreendimento();
        
        $termoPesquisado = (! empty($_GET['termo'])) ? $_GET['termo'] : '';
        
        $usuarios = $usuariosEmpreendimento->getAllUsuariosEmpreendimento($termoPesquisado);
        
        $pager_options = array(
            'mode' => 'Sliding', // Sliding or Jumping mode. See below.
            'perPage' => 10, // Total rows to show per page
            'delta' => 4, // See below
            'totalItems' => count($usuarios),
        );

        // Instancia o paginador
        $pager = Pager::factory($pager_options);
        // Seta o offset para colocar na query
        list($from, $to) = $pager->getOffsetByPageId();
        // Ajuste para MySQL que come?a o offset com 0
        $from = $from - 1;
        // A quantidade de linhas por query
        $perPage = $pager_options['perPage'];
        $usuarios = array_slice($usuarios, $from, $perPage);

        $this->set('usuarios', $usuarios);
        $this->set("botoes", array(
            "Adicionar" => array("m" => "sc", "c" => "usuarioEmpreendimento", "a" => "adicionar")
        ));
        $this->set('paginacao', $pager->links);
        $this->set("action", array('m' => 'sc', "c" => "usuarioEmpreendimento", "a" => "index"));
        $this->display('listar');
    }

    public function adicionarAction() {
	
		//nome da tela a ser exibida no rodap da pgina
		$this->set('nomeTela', " Adicionar Usu&aacute;rio Empreendimento");
		//nome da verso atual da tela a ser exibida
		$this->set('versao', "v1.01.9041");
		
        if (isset($_GET['msg']) && $_GET["msg"] == "OK") {
            $this->_helper->addMensagem("ok", "Opera&ccedil;&atilde;o realizada com sucesso!");
        } elseif (isset($_GET['msg']) && $_GET["msg"] == "FAIL") {
            $this->_helper->addMensagem("fail", "Erro! N&atilde;o foi poss&iacute;vel continuar a opera&ccedil;&atilde;o!");
        }
        $this->set("subtitulo", "Usu&aacute;rio Empreendimento");

        if ($this->_isPost) {
            $usuario['usuario'] = $_POST['empreendimento_usuario_usuarios'];
            $usuario['id'] = $_POST['empreendimento_usuario_id'];            
            $usuario['login'] = $_POST['empreendimento_usuario_login'];
            $usuario['senha'] = $_POST['empreendimento_usuario_senha'];
            $usuario['confirmar_senha'] = $_POST['empreendimento_usuario_confirmar'];
            if ($this->validar()) {
                $user = new Db_Usuario();

                $p = new Db_Pessoa();
                $p->setId($usuario['id']);

                $user->setId($p);
                $user->setPerfilId(5);
                $user->setLogin($usuario['login']);
                $user->setSenha(md5($usuario['senha']));
                $user->setDataExpiracao(Helper::getInputDate('01/01/2050'));
                $user->setHoraInicio('00:00:00');
                $user->setHoraTermino('23:59:00');
                $user->setLog(Login::getUsuario()->getLogin() . ' - ' . date('d/m/Y H:m:s') . ' - i');
                $user->setStatus(1);
                $user->setSuper(0);

                $user->save();

                $instanceUsuarioEmpreendimento = new Usuario_Empreendimento();

                $instanceUsuarioEmpreendimento->delete("id_pessoa_fisica = {$usuario['id']}");
                $idEmpreendimentos = array();
                if(count($_POST['listaEmpreendimentos']) && is_array($_POST['listaEmpreendimentos'])) $idEmpreendimentos = $_POST['listaEmpreendimentos'];
                foreach($idEmpreendimentos AS $idEmpreendimento) {
                    $usuarioEmpreendimento = $instanceUsuarioEmpreendimento->createRow();
                    $usuarioEmpreendimento->id_pessoa_fisica = $usuario['id'];
                    $usuarioEmpreendimento->id_empreendimento = $idEmpreendimento;
                    $usuarioEmpreendimento->save();
                }
                $this->redirect(array('modulo' => 'sc', 'controller' => 'usuarioEmpreendimento'), array("msg" => "OK"));
            }
        } elseif ($this->_isGet) {
            
        }

        $this->display('usuario');
    }
    public function editarAction() {
        if (isset($_GET['msg']) && $_GET["msg"] == "OK") {
            $this->_helper->addMensagem("ok", "Operao realizada com sucesso!");
        } elseif (isset($_GET['msg']) && $_GET["msg"] == "FAIL") {
            $this->_helper->addMensagem("fail", "Erro! No foi possvel continuar a operao!");
        }
        $this->set("subtitulo", "Usu&aacute;rio Empreendimento");

        if (isset($_GET['id']) && !empty($_GET['id'])) {

        	 
            $instancePessoa = new Pessoa();
            $instancePessoa = $instancePessoa->getDefaultAdapter();
            $pessoas = $instancePessoa->select()->distinct('p.id')->from(array('p' => TB_PESSOA), array('p.*'))
                            ->join(array('pf' => TB_PESSOA_FISICA), 'p.id = pf.id_pessoa', array('pf.*'))
                            ->where('p.id = "'.$_GET['id'].'"')
                            ->order('p.nm_pessoa')->query()->fetchAll();

            $this->set('pessoas', $pessoas);
            $user = new Db_Usuario();

            if ($this->_isPost) {
            	            	
                $usuario['usuario'] = $_POST['empreendimento_usuario_usuarios'];
                $usuario['id'] = $_POST['empreendimento_usuario_id'];
                $usuario['login'] = $_POST['empreendimento_usuario_login'];
               
                if ($this->validar(true)) {
                    $user = $user->find($usuario['id']);
                    $user->setLogin($usuario['login']);
                    $user->setLog(Login::getUsuario()->getLogin() . ' - ' . date('d/m/Y H:m:s') . ' - u');
                    $user->save();
                    $instanceUsuarioEmpreendimento = new Usuario_Empreendimento();
                    $instanceUsuarioEmpreendimento->delete("id_pessoa_fisica = {$usuario['id']}");
                    $idEmpreendimentos = array();
                    if (count($_POST['listaEmpreendimentos']) && is_array($_POST['listaEmpreendimentos']))
                        $idEmpreendimentos = $_POST['listaEmpreendimentos'];
                    foreach ($idEmpreendimentos AS $idEmpreendimento) {
                        $usuarioEmpreendimento = $instanceUsuarioEmpreendimento->createRow();
                        $usuarioEmpreendimento->id_pessoa_fisica = $usuario['id'];
                        $usuarioEmpreendimento->id_empreendimento = $idEmpreendimento;
                        $usuarioEmpreendimento->save();
                    }
                    
                    $this->redirect(array('modulo' => 'sc', 'controller' => 'usuarioEmpreendimento'), array("msg" => "OK"));
                }
            } else if ($this->_isGet) {
                $usuario = $user->find($_GET['id']);
                if ($usuario) {
                    $this->set('usuario', $usuario);
                }
            }
        }
        $this->set('edit', true);
        $this->display('usuario');
    }
    
    public function deletarAction() {
        $instanceUsuarioEmpreendimento = new Usuario_Empreendimento();
        $rows = $instanceUsuarioEmpreendimento->delete("id_pessoa_fisica = {$_GET['id']}");
        $msg  = $rows ? "OK" : "FAIL";
        $this->redirect(array('modulo' => 'sc', 'controller' => 'usuarioEmpreendimento'), array("msg" => $msg));
    }

    private function validar($edit = false) {

    	    $msg = "";
    	    $cont = 0;
            $campos = array('empreendimento_usuario_usuarios', 'empreendimento_usuario_login', 'empreendimento_usuario_senha', 'empreendimento_usuario_confirmar', 'listaEmpreendimentos');
    	    if ($edit) {
                $campos = array( 'empreendimento_usuario_login');
            }
            foreach ($campos AS $campo) {
                if ($_POST[$campo] == '') {
                	$cont = $cont + 1;
                }              
            }
            if ($cont > 0){
            	 $msg = "Necessario preencher todos os campos.";
                 $this->_helper->addMensagem('empreendimento_usuario_usuarios', $msg);
                 return  false;
            }else
               return true;

    }

}