<?php
class TipoLoteamentoController extends Controller {

    public function indexAction()
    {
        $this->redir(array("modulo" => "", "controller" => "tipoLoteamento", "action" => "listar"));
    }

    public function listarAction()
    {
        if ($this->isAjax()) {
            $listaTipo = TipoLoteamento::findTipo($_POST);
            $totalTipo = TipoLoteamento::findTipo($_POST, true);

            $lista = array();
            foreach ($listaTipo as $tipo) {
                $acoes = '<div style="width: 90px"></div><div align="center" style="width: 100%;">';
                $acoes .= '<a href="?m=' . $this->modulo . '&c=' . $this->controller . '&a=editar&id=' . $tipo['id_tipo_loteamento'] . '" data-toggle="tooltip" title="EDITAR" class="btn btn-default btn-sm" style="margin-right:5px"><i class="fa fa-edit"></i></a>';
                $title = "return confirm('Tem certeza que deseja excluir esse tipo de loteamento " . $tipo['id_tipo_loteamento'] . "?')";
                $acoes .= '<a onclick="' . $title . '"  href="?m=' . $this->modulo . '&c=' . $this->controller . '&a=deletar&id=' . $tipo['id_tipo_loteamento'] . '" data-toggle="tooltip" title="DELETAR" class="btn btn-default btn-sm" style="margin-right:5px"><i class="fa fa-times"></i></a>';
                $acoes .= '</div>';

                $lista[] = array(
                    'codigo' => '<div align="center">' . $tipo['id_tipo_loteamento'] . '</div>',
                    'descricao' => '<div>' . utf8_encode($tipo['ds_tipo_loteamento']) . '</div>',
                    'grupo' => '<div>' . utf8_encode($tipo['ds_grupo']) . '</div>',
                    'subgrupo' => '<div>' . utf8_encode($tipo['ds_subgrupo']) . '</div>',
                    'acoes' => utf8_encode($acoes)
                );
            }
            echo json_encode(array(
                'draw' => $_POST['draw'],
                'recordsTotal' => count($totalTipo),
                'recordsFiltered' => count($totalTipo),
                'data' => $lista
            ));
        } else {
            $this->display('listar');
        }
    }

    public function adicionarAction()
    {
        if ($this->_isPost) {
            $db = Zend_Db_Table::getDefaultAdapter();
            $db->beginTransaction();

            try {
                $tipoLoteamento = new TipoLoteamento();
                $tipo = $tipoLoteamento->createRow();
                $tipo->ds_tipo_loteamento = $_POST['ds_tipo_loteamento'];
                $tipo->ds_grupo = $_POST['ds_grupo'];
                $tipo->ds_subgrupo = $_POST['ds_subgrupo'];
                $tipo->ds_log = (Login::getUsuario()->getLogin() . ' - ' . date('d/m/Y H:m:s') . ' - u');
                $tipo->save();

                $db->commit();
                $this->redir(array('modulo' => 'sc', 'controller' => 'tipoLoteamento', 'action' => 'listar'), array("msg" => "success"));
            } catch (Exception $e) {
                $db->rollBack();
                $this->redir(array('modulo' => 'sc', 'controller' => 'tipoLoteamento', 'action' => 'adicionar'), array('msg' => 'fail', 'exception' => $e->getMessage()));
            }
        }
        $this->display('form');
    }

    public function editarAction()
    {
        $tbTipo = new TipoLoteamento();
        $infoTipo = $tbTipo->getDefaultAdapter()->select()
            ->from(array('t' => TB_TIPO_LOTEAMENTO), '*')
            ->where('id_tipo_loteamento = ?' , $_GET['id'])->query()->fetch();

        $this->set('infoTipo', $infoTipo);

        if ($this->_isPost) {
            $db = Zend_Db_Table::getDefaultAdapter();
            $db->beginTransaction();

            try {
                $tipo = array(
                    'ds_tipo_loteamento' => $_POST['ds_tipo_loteamento'],
                    'ds_grupo' => $_POST['ds_grupo'],
                    'ds_subgrupo' => $_POST['ds_subgrupo'],
                    'ds_log' =>  (Login::getUsuario()->getLogin() . ' - ' . date('d/m/Y H:m:s') . ' - u')
                );
                $db->update(TB_TIPO_LOTEAMENTO, $tipo, 'id_tipo_loteamento = '.$_GET['id']);
                $db->commit();
                $this->redir(array('modulo' => 'sc', 'controller' => 'tipoLoteamento', 'action' => 'listar'), array("msg" => "success"));
            } catch (Exception $e) {
                $db->rollBack();
                $this->redir(array('modulo' => 'sc', 'controller' => 'tipoLoteamento', 'action' => 'listar'), array('msg' => 'fail', 'exception' => $e->getMessage()));
            }
        }
        $this->display('form');

    }

    public function deletarAction()
    {
        $db = Zend_Db_Table::getDefaultAdapter();
        $db->beginTransaction();
        $tpEmpreendimento = new Empreendimento();
        $tpLoteamento = new TipoLoteamento();

        try {
            $idTpEmpreendimento = $tpEmpreendimento->fetchRow('id_tipo_loteamento = "'.$_GET['id'].'"');
            if ($idTpEmpreendimento) {
                $this->redir(array('modulo' => 'sc', 'controller' => 'tipoLoteamento', 'action' => 'listar'), array("exception" => 'O registro no pode ser deletado pois ele est sendo utilizado no empreendimento.'));
            } else {
                $tpLoteamento->delete('id_tipo_loteamento = '.$_GET['id']);
                $this->redir(array('modulo' => 'sc', 'controller' => 'tipoLoteamento', 'action' => 'listar'), array("msg" => "success"));
            }
            $db->commit();
        } catch (Exception $e) {
            $db->rollBack();
            $this->redir(array('modulo' => 'sc', 'controller' => 'tipoLoteamento', 'action' => 'listar'), array("exception" => $e->getMessage()));
        }
    }
}