<?php
class TabelaAgrupadaController extends Controller {

    public function indexAction() {
        $this->redir(array("controller" => "tabelaAgrupada", "action" => "listar"));
    }

    public function listarAction() {
        $tbAgrupada = new TabelaAgrupada();
        $listaAgrupada = $tbAgrupada->fetchAll('idTabela = "99"', 'descricao ASC');
        $this->set('listaAgrupada', $listaAgrupada);
        $this->display('listar');
    }

    public function adicionarAction() {
        $tbAgrupada = new TabelaAgrupada();
        $listaAgrupada = $tbAgrupada->fetchAll('idTabela = "99"', 'descricao ASC');
        $this->set('listaAgrupada', $listaAgrupada);

        if ($this->_isPost && $this->validar()) {
            try {
                //Inicia a transao com banco de dados
                $db = Zend_Db_Table::getDefaultAdapter();
                $db->beginTransaction();

                $agrupada = $tbAgrupada->createRow();
                $agrupada->idTabela = $_POST['idAgrupada'];
                $agrupada->idCampo = $_POST['cdCampo'];
                $agrupada->descricao = $_POST['descricao'];
                $agrupada->complemento = $_POST['complemento'];
                $agrupada->fixo = 1;
                $agrupada->log = (Login::getUsuario()->getLogin() . ' - ' . date('d/m/Y H:m:s') . ' - i');
                $agrupada->save();
                $db->commit();
                $this->redir(array("modulo" => "sc", "controller" => "tabelaAgrupada", "action" => "listar"), array("msg" => "success"));
            } catch (Exception $e) {
                $this->redir(array("modulo" => "sc", "controller" => "tabelaAgrupada"), array('msg' => 'fail', 'exception' => $e->getMessage()));
            }
        }
        $this->display("form");
    }

    public function inativarAction()
    {
        $tbAgrupada = new TabelaAgrupada();
        $campoAgrupada = $tbAgrupada->fetchRow('idTabela = "'.$_POST['idTabela'].'" AND idCampo = "' . $_POST['idCampo'].'"');

        if ($campoAgrupada['fixo'] == '1') {
            $campoAgrupada->fixo = 0;
        } else {
            $campoAgrupada->fixo = 1;
        }
        $campoAgrupada->save();
        echo json_encode($campoAgrupada->fixo);
    }

    public function editarAction() {
        $tbAgrupada = new TabelaAgrupada();
        $agrupada = $tbAgrupada->fetchRow('idTabela = "'.$_GET['id'].'" AND idCampo = "' . $_GET['idCampo'].'"');
        $listaAgrupada = $tbAgrupada->fetchAll('idTabela = "99"', 'descricao ASC');

        $this->set('listaAgrupada', $listaAgrupada);
        $this->set('dadosAgrupada', $agrupada);

        if ($this->_isPost && $this->validar()) {
            try {
                //Inicia a transao com banco de dados
                $db = Zend_Db_Table::getDefaultAdapter();
                $db->beginTransaction();

                $agrupada->idCampo = $_POST['cdCampo'];
                $agrupada->descricao = $_POST['descricao'];
                $agrupada->complemento = $_POST['complemento'];
                $agrupada->log = (Login::getUsuario()->getLogin() . ' - ' . date('d/m/Y H:m:s') . ' - i');
                $agrupada->save();

                $db->commit();
                $this->redir(array("modulo" => "sc", "controller" => "tabelaAgrupada", "action" => "listar"), array("msg" => "success"));
            } catch (Exception $e) {
                $this->redir(array("modulo" => "sc", "controller" => "tabelaAgrupada"), array('msg' => 'fail', 'exception' => $e->getMessage()));
            }
        }
        $this->display("form");
    }

    public function listaByAgrupadaAction()
    {
        $lista = array();
        $listaAgrupadasTotal = 0;
        if (isset($_POST['agrupadas']) && $_POST['agrupadas'] != '') {
            $listaAgrupada = TabelaAgrupada::findListaAgrupada($_POST, false, $_POST['agrupadas']);
            $listaAgrupadasTotal = TabelaAgrupada::findListaAgrupada($_POST, true);

            foreach ($listaAgrupada as $agrupadas) {
                $status = '<span class="label label-success">Ativo</span>';
                $iconInativar = '<i id="icon_' . $agrupadas['idCampo'] . '" class="fa fa-lock"></i>';
                $title = 'INATIVAR';

                if ($agrupadas['fixo'] == '0') {
                    $status = '<span class="label label-danger">Inativo</span>';
                    $iconInativar = '<i id="icon_' . $agrupadas['idCampo'] . '" class="fa fa-unlock-alt"></i>';
                    $title = 'ATIVAR"';
                }
                $idCampo = "'".$agrupadas['idCampo']."'";
                $idAgrupada = "'".$agrupadas['idTabela']."'";

                $acoes =  '<div style="width: 90px"></div><div align="center" style="width: 100%;">';
                $acoes .= '<a href="?m=' . $this->modulo . '&c=' . $this->controller . '&a=editar&id=' . $agrupadas['idTabela'] .'&idCampo=' . $agrupadas['idCampo'] .'" data-toggle="tooltip" title="EDITAR" class="btn btn-default btn-xs" style="margin-right:5px"><i class="fa fa-edit"></i></a>';
                $acoes .= '<a onclick="inativar(' . $idCampo . ','. $idAgrupada . ')" data-toggle="tooltip" title="' . $title . '" type="button" id="button_' . $agrupadas['idCampo'] . '"  class="btn btn-default btn-xs btnInativar" style="margin-right:5px">' . $iconInativar . '</a>';
                $title = "return confirm('Tem certeza que deseja excluir o campo: " . $agrupadas['descricao'] . " ?')";
                $acoes .= '<a onclick="' . $title . '"  href="index.php?m=' . $this->modulo . '&c=' . $this->controller . '&a=deletar&id=' . $agrupadas['idTabela'] .'&idCampo=' . $agrupadas['idCampo'] .'" data-toggle="tooltip" title="DELETAR" class="btn btn-default btn-sm" style="margin-right:5px"><i class="fa fa-times"></i></a>';
                $acoes .= '</div>';
                $acoes .= '</div>';

                $lista[] = array(
                    'tabela' => '<div>' . $agrupadas['idCampo'] . '</div>',
                    'descricao' => '<div>' . utf8_encode($agrupadas['descricao']) . '</div>',
                    'complemento' => '<div>' . $agrupadas['complemento'] . '</div>',
                    'fixo' => '<div id="status_' . $agrupadas['idCampo'] . '">' . $status . '</div>',
                    'acoes' => utf8_encode($acoes)
                );
            }
        }
        echo json_encode(array(
            'draw' => $_POST['draw'],
            'recordsTotal' => count($listaAgrupadasTotal),
            'recordsFiltered' => count($listaAgrupadasTotal),
            'data' => $lista
        ));
    }

    public function deletarAction()
    {
        try {
            $db = Zend_Db_Table::getDefaultAdapter();
            $db->beginTransaction();
            $tbAgrupada = new TabelaAgrupada();
            $tbAgrupada->delete('idTabela = "'.$_GET['id'].'" AND idCampo = "' . $_GET['idCampo'].'"');
            $db->commit();
            $this->redir(array("modulo" => "sc", "controller" => "tabelaAgrupada", "action" => "listar"), array("msg" => "success"));
        } catch (Exception $e) {
            $db->rollBack();
            $this->redir(array("modulo" => "", "controller" => "tabelaAgrupada", 'action' => 'listar'), array("exception" => $e->getMessage()));
        }
    }

    private function validar()
    {
        if (!$_GET['id']) {
            $campos = array("idAgrupada", "descricao", "cdCampo");

            foreach ($campos as $cp) {
                if ($_POST [$cp] == "") {
                    switch ($cp) {
                        case "idAgrupada" :
                            $msg = "Selecione a Tabela.";
                            break;
                        case "descricao" :
                            $msg = "Selecione a Descrio.";
                            break;
                        case "cdCampo" :
                            $msg = "Selecione o Cdigo do Campo";
                            break;
                        case "conta_corrente" :
                            $msg = "O campo Conta corrente  obrigatrio.";
                            break;
                    }
                    $this->_helper->addMensagem($cp, $msg);
                }
            }
        }
        return !(count($this->_helper->getMensagens()) > 0);
    }

}