<?php
class SlideshowController extends Controller {

    public function indexAction()
    {
        $this->redir(array("modulo" => "", "controller" => "slideshow", "action" => "listar"));
    }

    public function listarAction() {

        if ($this->isAjax()) {
            $listaSlide = Slideshow::findSlide($_POST);
            $totalSlide = Slideshow::findSlide($_POST, true);

            $lista = array();
            foreach ($listaSlide as $slide) {
                $status = '<span class="label label-success">Ativo</span>';
                $iconInativar = '<i id="icon_' . $slide['id_slideshow'] . '" class="fa fa-lock"></i>';
                $titleToggle = 'INATIVAR';

                if ($slide['fl_ativo'] == '0') {
                    $status = '<span class="label label-danger">Inativo</span>';
                    $iconInativar = '<i id="icon_' . $slide['id_slideshow'] . '" class="fa fa-unlock-alt"></i>';
                    $titleToggle = 'ATIVAR"';
                }

                $acoes = '<div style="width: 90px"></div><div align="center" style="width: 100%;">';
                $acoes .= '<span data-toggle="modal" data-target=".modalVisualizar"><button type="button" value="' . $slide['id_slideshow'] . '" data-toggle="tooltip" title="VISUALIZAR" class="btn btn-default btn-sm btn-visualizar" style="margin-right:5px"><i class="fa fa-eye"></i> </button></span>';
                $acoes .= '<a href="?m=' . $this->modulo . '&c=' . $this->controller . '&a=editar&id=' . $slide['id_slideshow'] . '" data-toggle="tooltip" title="EDITAR" class="btn btn-default btn-sm" style="margin-right:5px"><i class="fa fa-edit"></i></a>';
                $acoes .= '<button data-toggle="tooltip" title="'.$titleToggle.'" type="button" value="' . $slide['id_slideshow'] . '" id="button_' . $slide['id_slideshow'] . '"  class="btn btn-default btn-sm btnInativar" style="margin-right:5px">' . $iconInativar . '</button>';
                $title = "return confirm('Tem certeza que deseja excluir o slideshow " . $slide['id_slideshow'] . "?')";
                $acoes .= '<a onclick="' . $title . '"  href="?m=' . $this->modulo . '&c=' . $this->controller . '&a=deletar&id=' . $slide['id_slideshow'] . '" data-toggle="tooltip" title="DELETAR" class="btn btn-default btn-sm" style="margin-right:5px"><i class="fa fa-times"></i></a>';
                $acoes .= '</div>';

                $lista[] = array (
                    'codigo' => '<div align="center">' . $slide['id_slideshow'] . '</div>',
                    'descricao' => '<div>' . utf8_encode($slide['ds_slideshow']) . '</div>',
                    'status' => '<label id="status_' . $slide['id_slideshow'] . '">' . $status . '</label>',
                    'acoes' => utf8_encode($acoes)
                );
            }
            echo json_encode(array(
                'draw' => $_POST['draw'],
                'recordsTotal' => count($totalSlide),
                'recordsFiltered' => count($totalSlide),
                'data' => $lista
            ));
        } else {
            $this->display('listar');
        }
    }

    public function adicionarAction()
    {
        $tbSlide = new Slideshow();
        $listaSistemaSlide = Controller::getAdapterAcadeGeral()->select()
            ->from(array('s' => TB_SISTEMA), '*')
            ->query()->fetchAll();

        $this->set('listaSistemaSlide', $listaSistemaSlide);

        if ($this->_isPost && $this->validar()) {
            try {
                //Inicia a transao com banco de dados
                $dbAcadeGeral = $this->getAdapterAcadeGeral();
                $dbAcadeGeral->beginTransaction();
                $filepath="";
                $filepath_4_3="";
                $filepath_21_9="";
                //Pegando o arquivo
                if ($_FILES['dsPath']['name']) {

                    // Arquivo
                    $up = new Filesystem();

                    //alterar o nome do arquivo
                    $name = $this->_helper->removeAcentos($_FILES['dsPath']['name']);
                    $name = explode(".", $name);
                    $name = 'img_' . date('dmY_his') . '.' . $name[1];

                    // Armazena o arquivo fsico
                    $tmp = $_FILES['dsPath']['tmp_name'];

                    $path = explode('.', $_SERVER['HTTP_HOST']);
                    if ($path[0] == 'www') {
                        $path = $path[1];
                    } else {
                        $path = $path[0];
                    }

                    //Criando a pasta caso no tenha
                    $slidePath = DIRETORIO_DOWNLOAD ."slideshow";
                    $filepath = $slidePath.'/'.$path;
                    if (!is_dir($slidePath)) {
                        mkdir($slidePath, 0777);
                    } else if (!is_dir($filepath)) {
                        mkdir($filepath, 0777);
                    }

                    $filepath = $filepath . '/'. $name;

                    $up->upload($tmp, $filepath);
                }
                if ($_FILES['imagem4x3']['name']) {
                    $up = new Filesystem();
                    //alterar o nome do arquivo
                    $name = $this->_helper->removeAcentos($_FILES['imagem4x3']['name']);
                    $name = explode(".", $name);
                    $name = 'img_' . date('dmY_his') . '.' . $name[1];

                    // Armazena o arquivo fsico
                    $tmp = $_FILES['imagem4x3']['tmp_name'];

                    $path = explode('.', $_SERVER['HTTP_HOST']);
                    if ($path[0] == 'www') {
                        $path = $path[1];
                    } else {
                        $path = $path[0];
                    }

                    //Criando a pasta caso no tenha
                    $slidePath = DIRETORIO_DOWNLOAD ."slideshow";
                    $filepath2 = $slidePath.'/'.$path;
                    if (!is_dir($slidePath)) {
                        mkdir($slidePath, 0777);
                    } else if (!is_dir($filepath)) {
                        mkdir($filepath, 0777);
                    }

                    $filepath_4_3 = $filepath2 . '/4x3'. $name;

                    $up->upload($tmp, $filepath_4_3);

                    $camposTbSlide['ds_path_4_3'] = $filepath_4_3;

                }
                if ($_FILES['imagem21x9']['name']) {
                    $up = new Filesystem();
                    //alterar o nome do arquivo
                    $name = $this->_helper->removeAcentos($_FILES['imagem21x9']['name']);
                    $name = explode(".", $name);
                    $name = 'img_' . date('dmY_his') . '.' . $name[1];

                    // Armazena o arquivo fsico
                    $tmp = $_FILES['imagem21x9']['tmp_name'];

                    $path = explode('.', $_SERVER['HTTP_HOST']);
                    if ($path[0] == 'www') {
                        $path = $path[1];
                    } else {
                        $path = $path[0];
                    }

                    //Criando a pasta caso no tenha
                    $slidePath = DIRETORIO_DOWNLOAD ."slideshow";
                    $filepath3 = $slidePath.'/'.$path;
                    if (!is_dir($slidePath)) {
                        mkdir($slidePath, 0777);
                    } else if (!is_dir($filepath)) {
                        mkdir($filepath, 0777);
                    }

                    $filepath_21_9 = $filepath3 . '/21x9'. $name;

                    $camposTbSlide['ds_path_21_9'] = $filepath_21_9;
                    $up->upload($tmp, $filepath_21_9);
                }
                // Verifica se est preenchido e informa valor
                $dsUrl = $_POST['dsUrl']
                    ? $dsUrl = $_POST['dsUrl']
                    : $dsUrl = null;

                //Salvando os arquivos no banco acade_geral
                $camposTbSlide = array(
                    'ds_slideshow' => $_POST['dsSlideShow'],
                    'ds_path' => $filepath,
                    'ds_path_4_3' => $filepath_4_3,
                    'ds_path_21_9' => $filepath_21_9,
                    'ds_url' => $dsUrl,
                    'ds_log' => (Login::getUsuario()->getLogin() . ' - ' . date('d/m/Y H:m:s') . ' - i'),
                );

                $dbAcadeGeral->insert(TB_SLIDESHOW, $camposTbSlide);
                $idSlideShow =  $dbAcadeGeral->lastInsertId();
                foreach ($_POST['dsSistema'] as $dsSistema) {
                    $dbAcadeGeral->insert(TB_SLIDESHOW_SISTEMA, array(
                        'id_slideshow' => $idSlideShow,
                        'id_sistema' => $dsSistema,
                    ));
                }

                $dbAcadeGeral->commit();
                $this->redir(array("modulo" => "", "controller" => "slideshow", "action" => "listar"), array("msg" => "success"));
            } catch (Exception $e) {
                $this->redir(array("modulo" => "", "controller" => "slideshow", "action" => "listar"), array('msg' => 'fail', 'exception' => $e->getMessage()));
            }
        }
        $this->display('form');
    }

    public function editarAction()
    {
        //Para exibir a informao do campo Descrio
        $slideshowInfo = Controller::getAdapterAcadeGeral()->select()
            ->from(array('s' => TB_SLIDESHOW), '*')
            ->where('id_slideshow = "'.$_GET['id'].'"')
            ->query()->fetch();
        $this->set('slideshowInfo', $slideshowInfo);

        //Para exibir os sistemas selecionados pelo cliente
        $listaSistemaSelec = Controller::getAdapterAcadeGeral()->select()
            ->from(array('s' => TB_SLIDESHOW_SISTEMA), '*')
            ->where('id_slideshow = "'.$_GET['id'].'"')
            ->query()->fetchAll();

        $this->set('listaSistemaSelec', $listaSistemaSelec);

        $lista = array();
        foreach ($listaSistemaSelec as $sistema) {
            $lista[] = $sistema['id_sistema'];
        }
        $this->set('lista', $lista);
        //Para exibir os sistemas cadastrado no banco de dados
        $listaSistemaSlide = Controller::getAdapterAcadeGeral()->select()
            ->from(array('s' => TB_SISTEMA), '*')
            ->query()->fetchAll();
        $this->set('listaSistemaSlide', $listaSistemaSlide);


        //Exibio da imagem selecionada
        if ($slideshowInfo['ds_path']) {
            $paths = explode('/', $slideshowInfo['ds_path']);
            $arquivo['arquivo'] = end($paths);
            $arquivo['isImage'] = false;
            $arquivo['caminho'] = $slideshowInfo['ds_path'];
            $extensoes = array('.jpg', '.jpg', '.gif', '.bpm', '.png');
            foreach ($extensoes as $ext) {
                if (strstr(strtolower($arquivo['arquivo']), $ext)) {
                    $arquivo['isImage'] = true;
                    break;
                }
            }
            $this->set('arquivo', $arquivo);
        }

        if ($this->_isPost && $this->validar()) {
            try {
                //Inicia a transao com banco de dados
                $dbAcadeGeral = $this->getAdapterAcadeGeral();
                $dbAcadeGeral->beginTransaction();

                //Salvando os arquivos no banco acade_geral
                $camposTbSlide = array(
                    'ds_slideshow' => $_POST['dsSlideShow'],
                );
                //Pegando o arquivo
                if ($_FILES['dsPath']['name']) {

                    // Arquivo
                    $up = new Filesystem();

                    //alterar o nome do arquivo
                    $name = $this->_helper->removeAcentos($_FILES['dsPath']['name']);
                    $name = explode(".", $name);
                    $name = 'img_' . date('dmY_his') . '.' . $name[1];

                    // Armazena o arquivo fsico
                    $tmp = $_FILES['dsPath']['tmp_name'];

                    $path = explode('.', $_SERVER['HTTP_HOST']);
                    if ($path[0] == 'www') {
                        $path = $path[1];
                    } else {
                        $path = $path[0];
                    }

                    //Criando a pasta caso no tenha
                    $slidePath = DIRETORIO_DOWNLOAD ."slideshow";
                    $filepath = $slidePath.'/'.$path;
                    if (!is_dir($slidePath)) {
                        mkdir($slidePath, 0777);
                    } else if (!is_dir($filepath)) {
                        mkdir($filepath, 0777);
                    }

                    $filepath = $filepath . '/'. $name;

                    $up->upload($tmp, $filepath);

                    $camposTbSlide['ds_path'] = $filepath;
                }
                if ($_FILES['imagem4x3']['name']) {
                    $up = new Filesystem();
                    //alterar o nome do arquivo
                    $name = $this->_helper->removeAcentos($_FILES['imagem4x3']['name']);
                    $name = explode(".", $name);
                    $name = 'img_' . date('dmY_his') . '.' . $name[1];

                    // Armazena o arquivo fsico
                    $tmp = $_FILES['imagem4x3']['tmp_name'];

                    $path = explode('.', $_SERVER['HTTP_HOST']);
                    if ($path[0] == 'www') {
                        $path = $path[1];
                    } else {
                        $path = $path[0];
                    }

                    //Criando a pasta caso no tenha
                    $slidePath = DIRETORIO_DOWNLOAD ."slideshow";
                    $filepath = $slidePath.'/'.$path;
                    if (!is_dir($slidePath)) {
                        mkdir($slidePath, 0777);
                    } else if (!is_dir($filepath)) {
                        mkdir($filepath, 0777);
                    }

                    $filepath_4_3 = $filepath . '/4x3'. $name;

                    $up->upload($tmp, $filepath_4_3);

                    $camposTbSlide['ds_path_4_3'] = $filepath_4_3;

                }
                if ($_FILES['imagem21x9']['name']) {
                    $up = new Filesystem();
                    //alterar o nome do arquivo
                    $name = $this->_helper->removeAcentos($_FILES['imagem21x9']['name']);
                    $name = explode(".", $name);
                    $name = 'img_' . date('dmY_his') . '.' . $name[1];

                    // Armazena o arquivo fsico
                    $tmp = $_FILES['imagem21x9']['tmp_name'];

                    $path = explode('.', $_SERVER['HTTP_HOST']);
                    if ($path[0] == 'www') {
                        $path = $path[1];
                    } else {
                        $path = $path[0];
                    }

                    //Criando a pasta caso no tenha
                    $slidePath = DIRETORIO_DOWNLOAD ."slideshow";
                    $filepath = $slidePath.'/'.$path;
                    if (!is_dir($slidePath)) {
                        mkdir($slidePath, 0777);
                    } else if (!is_dir($filepath)) {
                        mkdir($filepath, 0777);
                    }

                    $filepath_21_9 = $filepath . '/21x9'. $name;

                    $camposTbSlide['ds_path_21_9'] = $filepath_21_9;
                    $up->upload($tmp, $filepath_21_9);
                }

                $dbAcadeGeral->update(TB_SLIDESHOW, $camposTbSlide, 'id_slideshow = '.$_GET['id']);

                $dbAcadeGeral->delete(TB_SLIDESHOW_SISTEMA, 'id_slideshow = '.$_GET['id']);

                foreach ($_POST['dsSistema'] as $dsSistema) {
                    $camposTbSlideSistema = array(
                        'id_slideshow' => $_GET['id'],
                        'id_sistema' => $dsSistema,
                    );
                    $dbAcadeGeral->insert(TB_SLIDESHOW_SISTEMA, $camposTbSlideSistema, 'id_slideshow = '.$_GET['id']);
                }
                $dbAcadeGeral->commit();
                $this->redir(array("modulo" => "", "controller" => "slideshow", "action" => "listar"), array("msg" => "success"));
            } catch (Exception $e) {
                $this->redir(array("modulo" => "", "controller" => "slideshow", "action" => "listar"), array('msg' => 'fail', 'exception' => $e->getMessage()));
            }
        }
        $this->display('form');
    }

    public function deletarAction()
    {
        try {
            $dbAcadeGeral = $this->getAdapterAcadeGeral();
            $dbAcadeGeral->beginTransaction();

            $dbAcadeGeral->delete(TB_SLIDESHOW_SISTEMA, 'id_slideshow = "'.$_GET['id'].'"');
            $dbAcadeGeral->delete(TB_SLIDESHOW, 'id_slideshow = "'.$_GET['id'].'"');

            $dbAcadeGeral->commit();
            $this->redir(array("modulo" => "", "controller" => "slideshow", "action" => "listar"), array("msg" => "success"));
        } catch (Exception $e) {
            $dbAcadeGeral->rollBack();
            $this->redir(array("modulo" => "", "controller" => "slideshow", "action" => "listar"), array('msg' => 'fail', 'exception' => $e->getMessage()));
        }
    }

    public function excluirImagemAction()
    {
        $dbAcadeGeral = $this->getAdapterAcadeGeral();
        $slideshow = $dbAcadeGeral->fetchRow('SELECT * FROM '.TB_SLIDESHOW.' WHERE id_slideshow = '.$_GET['id']);

        //remove o aquivo
        if (file_exists($slideshow['ds_path']))
            Filesystem::delete($slideshow['ds_path']);

        //Limpando valor de campo ds_path
        $dbAcadeGeral->update(TB_SLIDESHOW,array('ds_path' => ''), 'id_slideshow = '.$_GET['id']);

        $this->redir(array("modulo" => "", "controller" => "slideshow", "action" => "editar"), array("id" => $_GET['id']));
    }

    public function inativarAction()
    {

        $slide =  Controller::getAdapterAcadeGeral()->select()
            ->from(array('s' => TB_SLIDESHOW), '*')
            ->where('id_slideshow = "'.$_POST['id_slideshow'].'"')
            ->query()->fetch();
        try {
            //Inicia a transao com banco de dados
            $dbAcadeGeral = $this->getAdapterAcadeGeral();
            $dbAcadeGeral->beginTransaction();

            if ($slide['fl_ativo'] == '1') {
                $slide['fl_ativo'] = 0;
            } else {
                $slide['fl_ativo'] = 1;
            }

            $flAtivo = array(
                'fl_ativo' => $slide['fl_ativo']
            );

            $dbAcadeGeral->update(TB_SLIDESHOW, $flAtivo, 'id_slideshow = '.$_POST['id_slideshow']);
            $dbAcadeGeral->commit();
            echo json_encode($flAtivo);

        } catch (Exception $e) {
            $this->redir(array("modulo" => "", "controller" => "slideshow", "action" => "listar"), array('msg' => 'fail', 'exception' => $e->getMessage()));
        }
    }

    public function visualizarAction()
    {
        $slideshow = Controller::getAdapterAcadeGeral()->select()
            ->from(array('s' => TB_SLIDESHOW), '*')
            ->join(array('ss' => TB_SLIDESHOW_SISTEMA), 'ss.id_slideshow = s.id_slideshow', '*')
            ->join(array('si' => TB_SISTEMA), 'si.id_sistema = ss.id_sistema')
            ->where('ss.id_slideshow = "'.$_POST['id'].'"')
            ->query()->fetchAll();

        $this->set('slideshow', $slideshow);
        $this->display();
    }

    public function validar()
    {
        $campos = array("dsSlideShow", "dsSistema");
        foreach ($campos as $cp) {
            if ($_POST [$cp] == "") {
                switch ($cp) {
                    case "dsSlideShow" :
                        $msg = "A Descrio  obrigatria.";
                        break;
                    case "dsSistema" :
                        $msg = "Deve ser selecionado pelo menos uma opo de sistema.";
                        break;

                }
                $this->_helper->addMensagem($cp, $msg);
            }
        }

        $name = $this->_helper->removeAcentos($_FILES['dsPath']['name']);
        $name = explode(".", $name);
        $ext = end($name);

        if (!$_GET['id'] && $_POST['dsPath'] !='') {
            if ($ext != 'png' && $ext != 'jpg' && $ext != 'jpge' && $ext != 'gif')
                $this->_helper->addMensagem('danger', "S  permitido arquivos .png .jpg .jpge .gif.");

        }

        if (!$_GET['id'] && !$_FILES['dsPath']['name']) {
            $this->_helper->addMensagem('danger', "Deve ser selecionado um arquivo");

        }
        return !(count($this->_helper->getMensagens()) > 0);
    }

}