<?php
class ProgramaController extends Controller {
	
	public function indexAction(){
		$this->redir(array("controller" => "programa", "action" => "listar"));
	}

	public function adicionarAction(){
		$this->display("form");
	}
	
	public function editarAction(){
		$this->set("programa",Db_Modulo::find($_GET["id"]));
		$this->display("form");
	}
	
	public function saveAction(){
		
		if (Login::isLogado () && ACL::hasPermission ( Login::getUsuario (), Db_Action::findByNome ( "adicionar", Db_Controller::findByName ( __CLASS__ ) ) )) {
			$p = new Db_Modulo();
			$p->setId($_POST["id"]);
			$p->setNome($_POST["programa"]);
			$p->setPath($_POST["diretorio"]);
						
			$this->set("programa",$p);
			
			if($this->validar()){
				$p->save();	
				$this->redir(array("controller" => "programa", "action" => "listar"),array("msg" => "OK"));
			}else{
				$this->adicionarAction();				
			}
	
		}else{
			throw new Exception("O usurio no tem permisso de acessar essa action.");
		}
	}
	
	private function validar(){
		//validao vazio
		$campos = array("programa","diretorio");
		foreach ( $campos as $cp ) {
			if ($_POST [$cp] == "") {
				switch ($cp) {
					case "programa" :
						$msg = "O campo programa deve ser preenchido.";
						break;
					case "diretorio" :
						$msg = "O diretrio do modulo deve ser preechido.";
						break;						
				}
				$this->_helper->addMensagem($cp,$msg);
			}
		}

		return !(count($this->_helper->getMensagens()) > 0);
	}
	
	public function listarAction(){
		$this->set("botoes",array("Adicionar" => array("c" => "programa", "a" => "adicionar")));

		if($_GET["msg"] == "OK"){
			$this->_helper->addMensagem("ok","Operao realizada com sucesso!");
		}elseif($_GET["msg"] == "FAIL"){
			$this->_helper->addMensagem("fail","Erro! No foi possvel continuar a operao!");
		}
		
		$this->set("subtitulo","Programas");
		$this->set("programas",Db_Modulo::fetchAll());
		$this->display();
	}
	
	public function deletarAction(){
		try{
			Db_Modulo::delete($_GET["id"]);
			$this->redir(array("controller" => "programa", "action" => "listar"),array("msg" => "OK"));
		}catch (Exception $e){
			$this->redir(array("controller" => "programa", "action" => "listar"),array("msg" => "FAIL"));	
		}		
	}			
}