<?php
class ModuloController extends Controller {
	
	public function indexAction(){
		$this->redir(array("controller" => "modulo", "action" => "listar"));
	}

	public function adicionarAction(){
		$this->display("form");
	}
	
	public function editarAction(){
		$this->set("modulo",Db_Modulo::find($_GET["id"]));
		$this->display("form");
	}
	
	public function saveAction(){
		
		if (Login::isLogado () && ACL::hasPermission ( Login::getUsuario (), Db_Action::findByNome ( "adicionar", Db_Controller::findByName ( __CLASS__ ) ) )) {
			$m = new Db_Modulo();
			$m->setId($_POST["id"]);
			$m->setNome($_POST["modulo"]);
			$m->setPath($_POST["diretorio"]);
			$acao = 'i';						
			if (!$_POST["id"]=="")
				$acao = 'u';
			
			$this->set("modulo",$m);
			
			if($this->validar()){
				$m->setLog(Login::getUsuario()->getLogin().' - '.date('d/m/Y').' - '.$acao);
				$m->save();	
				$this->redir(array("controller" => "modulo", "action" => "listar"),array("msg" => "OK"));
			}else{
				$this->adicionarAction();				
			}
	
		}else{
			throw new Exception("O usurio no tem permisso de acessar essa action.");
		}
	}
	
	private function validar(){
		//validao vazio
		$campos = array("modulo","diretorio");
		foreach ( $campos as $cp ) {
			if ($_POST [$cp] == "") {
				switch ($cp) {
					case "modulo" :
						$msg = "O campo Modulo  obrigatrio.";
						break;
					case "diretorio" :
						$msg = "O diretrio do modulo  obrigatrio.";
						break;						
				}
				$this->_helper->addMensagem($cp,$msg);
			}
		}

		return !(count($this->_helper->getMensagens()) > 0);
	}
	
	public function listarAction(){
		$this->set("botoes",array("Adicionar" => array("c" => "modulo", "a" => "adicionar")));

		if($_GET["msg"] == "OK"){
			$this->_helper->addMensagem("ok","Operao realizada com sucesso!");
		}elseif($_GET["msg"] == "FAIL"){
			$this->_helper->addMensagem("fail","Erro! No foi possvel continuar a operao!");
		}

        $count = Db_Modulo::fetchAll(true);
        /*Total de linhas*/
        $totalItems = $count[0]->count;

        /*Seta as opes do paginador*/
        $pager_options = array(
                'mode'       => 'Sliding',   // Sliding or Jumping mode. See below.
                'perPage'    => 10,   // Total rows to show per page
                'delta'      => 4,   // See below
                'totalItems' => $totalItems,
        );

        /*Instancia o paginador*/
        $pager = Pager::factory($pager_options);
        /* The following code will retreive the result using the pager options */

        /*Seta o offset para colocar na query*/
        list($from, $to) = $pager->getOffsetByPageId();

        /*Ajuste para MySQL que comea o offset com 0*/
        $from = $from - 1;

        /*A quanditade de linhas por query*/
        $perPage = $pager_options['perPage'];
		
		$this->set("action",array("c" => "modulo", "a" => "pesquisar"));	
		$this->set("subtitulo","Modulos");
        $modulos = Db_Modulo::fetchAll(false, $from, $perPage);
		$this->set("modulos",$modulos);
        $this->set('paginacao',$pager->links);
		$this->display();
	}
	
	public function pesquisarAction(){
        $count = Db_Modulo::fullSearch($_GET["termo"], true);

        /*Total de linhas*/
        $totalItems = $count[0]->count;

        /*Seta as opes do paginador*/
        $pager_options = array(
                'mode'       => 'Sliding',   // Sliding or Jumping mode. See below.
                'perPage'    => 10,   // Total rows to show per page
                'delta'      => 4,   // See below
                'totalItems' => $totalItems,
        );

        /*Instancia o paginador*/
        $pager = Pager::factory($pager_options);
        /* The following code will retreive the result using the pager options */

        /*Seta o offset para colocar na query*/
        list($from, $to) = $pager->getOffsetByPageId();

        /*Ajuste para MySQL que comea o offset com 0*/
        $from = $from - 1;

        /*A quanditade de linhas por query*/
        $perPage = $pager_options['perPage'];

		$modulos = Db_Modulo::fullSearch($_GET["termo"], false, $from, $perPage);
		$this->set("action",array("c" => "modulo", "a" => "pesquisar"));	
		$this->set("subtitulo","Modulos");
		$this->set("modulos",$modulos);
        $this->set('paginacao',$pager->links);
		$this->set("botoes",array("voltar" => array("c" => "modulo", "a" => "listar")));
		$this->display();
	}
	
	public function deletarAction(){
		try{
			Db_Modulo::delete($_GET["id"]);
			$this->redir(array("controller" => "modulo", "action" => "listar"),array("msg" => "OK"));
		}catch (Exception $e){
			$this->redir(array("controller" => "modulo", "action" => "listar"),array("msg" => "FAIL"));	
		}		
	}			
}