<?php

class ModeloBancoController extends Controller {
    protected $dicionario;

    public function __construct($request) 
    {
        parent::__construct($request);
        $this->dicionario = new DicionarioIB();
    }

    public function indexAction() 
    {
        $this->redir(array("modulo" => "sc", "controller" => "modeloBanco", "action" => "listar"));
    }

    public function listarAction() 
    {
        if ($this->isAjax()) {
            $listaItem = DicionarioIB::listar();
            
            $lista = array();
            foreach ($listaItem as $item) {
                $acoes= '<a class="btn btn-default btn-sm" href="?m=sc&c=modeloBanco&a=editarV&id='.utf8_encode($item['id']).'" data-toggle="tooltip" title="EDITAR" style="margin-right:5px"><i class="fa fa-edit"></i></a>';
                $title = "return confirm('Tem certeza que deseja excluir a varivel " . $item['variavel'] . "?')";
                $acoes .= '<a onclick="' . $title . '"  href="?m=' . $this->modulo . '&c=' . $this->controller . '&a=deletarV&id=' . $item['id'] . '" data-toggle="tooltip" title="EXCLUIR" class="btn btn-default btn-sm" style="margin-right:5px"><i class="fa fa-times"></i></a>';
                $lista[] = array(
                    'variavel' => '${' . utf8_encode($item['variavel']) . '}',
                    'descricao' => utf8_encode($item['descricao']),
                    'nlayout' => utf8_encode($item['descricao']),
                    'acoes' => utf8_encode($acoes)
                );
            }
            echo json_encode(array(
                'data' => $lista
            ));
        } else {
            $this->display('listar');
        }
    }

    public function adicionarVAction() 
    {
        //Verifica se o formulrio est no modo edio ou insero
        if ($this->_isPost && $_POST['inserir']='sim') {
            
            $adapter = DicionarioIB::setInsertVariavel($_POST['variavel'],$_POST['descricao']);

            $this->redir(array('modulo' => 'sc', 'controller' => 'modeloBanco', 'action' => 'variaveis'), array('msg' => 'success'));
        }
        if ($this->_isPost && $_POST['inserir']<>'sim'){
            $adapter = DicionarioIB::setUpdateVariavel($_GET["id"],$_POST['variavel'],$_POST['descricao']);

            $this->redir(array('modulo' => 'sc', 'controller' => 'modeloBanco', 'action' => 'variaveis'), array('msg' => 'success'));
        }

        $this->display('form');
    }

    public function deletarVAction() 
    {
        //Exclui a varivel e exibe mensagem de sucesso      
            
        $adapter = DicionarioIB::deleteVariavel($_GET["id"]);

        $this->redir(array('modulo' => 'sc', 'controller' => 'modeloBanco', 'action' => 'variaveis'), array('msg' => 'success'));

        $this->display('form');
    }

    public function editarVAction()
    { 

        //Verifica se o formulrio est no modo insero
        if ($this->_isPost && $_POST['inserir']==='sim') {
            
            $adapter = DicionarioIB::setInsertVariavel($_POST['variavel'],$_POST['descricao']);

            $this->redir(array('modulo' => 'sc', 'controller' => 'modeloBanco', 'action' => 'variaveis'), array('msg' => 'success'));
        }

        //Verifica se o formulrio est no modo edio
        if ($this->_isPost && $_POST['inserir']==='no'){
            $adapter = DicionarioIB::setUpdateVariavel($_POST['id'],$_POST['variavel'],$_POST['descricao']);

            $this->redir(array('modulo' => 'sc', 'controller' => 'modeloBanco', 'action' => 'variaveis'), array('msg' => 'success'));
        }

        $adapter = DicionarioIB::getVariavelporId($_GET["id"]);
        $this->set('dadosVariavel', $adapter);
        $this->display('form');
    }

    public function variaveisAction()
    {
        if ($this->isAjax()) {
            $listaItem = DicionarioIB::listarvariaveis();
            
            $lista = array();
            foreach ($listaItem as $item) {
                $acoes= '<a class="btn btn-default btn-sm" href="?m=sc&c=modeloBanco&a=editarV&id='.utf8_encode($item['id']).'" data-toggle="tooltip" title="EDITAR" style="margin-right:5px"><i class="fa fa-edit"></i></a>';
                $title = "return confirm('Tem certeza que deseja excluir a varivel " . $item['variavel'] . "?')";
                $acoes .= '<a onclick="' . $title . '"  href="?m=' . $this->modulo . '&c=' . $this->controller . '&a=deletarV&id=' . $item['id'] . '" data-toggle="tooltip" title="EXCLUIR" class="btn btn-default btn-sm" style="margin-right:5px"><i class="fa fa-times"></i></a>';
                $lista[] = array(
                    'variavel' => '${' . utf8_encode($item['variavel']) . '}',
                    'descricao' => utf8_encode($item['descricao']),
                    'acoes' => utf8_encode($acoes)
                );
            }
            echo json_encode(array(
                'data' => $lista
            ));
        } else {
            $this->display('variaveis');
        }
    }
}