<?php

class MigracaoController extends Controller
{

    public function __construct($request)
    {
        parent::__construct($request);
        $this->set("subtitulo", "Migrao");
    }

    public function indexAction()
    {

        $this->redir(array("controller" => "migracao", "action" => "adicionar"));
    }

    public function adicionarAction()
    {
        $this->set('action', $this->_helper->getLink(array('c' => 'migracao', 'a' => 'adicionar')));

        if ($this->_isPost && $this->validar()) {
            try {
                set_time_limit(0);
                $dadosConexao = array(
                    'dbname' => $_POST['nmBanco'],
                    'host' => $_POST['host'],
                    'username' => $_POST['usuario'],
                    'password' => $_POST['senha'],
                    'options' => [\PDO::ATTR_CASE => \PDO::CASE_LOWER, \PDO::ATTR_PERSISTENT => TRUE, \PDO::ATTR_DEFAULT_FETCH_MODE => \PDO::FETCH_ASSOC]
                );

                $filename = 'upload/LogMigracao' . date('his_dmY') . '.txt';
                $log = fopen($filename, 'a');

                //Registro de Log
                fwrite($log, "-----------------------------------------------------------------------------:\n");
                fwrite($log, "INICIANDO MIGRAO" . ":\n");
                fwrite($log, "-----------------------------------------------------------------------------:\n");
                fwrite($log, "BANCO DE DADOS = " . $dadosConexao['dbname'] . "\n");
                fwrite($log, "HOST = " . $dadosConexao['host'] . "\n");
                fwrite($log, "USUARIO = " . $dadosConexao['username'] . "\n");

                //Chama funes que realizaro as buscas e inseres dos dados do banco migrado
                $idEmpreendimento = $this->migrarEmpreendimento($_POST['empreendimento'], $dadosConexao, $log);
                $this->migrarLotes($_POST['empreendimento'], $dadosConexao, $log, $idEmpreendimento);
                $this->migrarPessoas($_POST['empreendimento'], $dadosConexao, $log, $idEmpreendimento);
                $arrayBancos = $this->migrarBancos($_POST['empreendimento'], $dadosConexao, $log, $idEmpreendimento);
                $arrayCorretores = $this->migrarCorretores($_POST['empreendimento'], $dadosConexao, $log, $idEmpreendimento);
                $this->migrarContratos($_POST['empreendimento'], $dadosConexao, $log, $idEmpreendimento, $arrayCorretores, $arrayBancos);
                $this->migrarContratosHistorico($_POST['empreendimento'], $dadosConexao, $log, $idEmpreendimento, $arrayCorretores, $arrayBancos);
                $this->migrarContratoItens($_POST['empreendimento'], $dadosConexao, $log);
                $this->migrarDistratos($_POST['empreendimento'], $dadosConexao, $log);
                $arrayNegociacoes = $this->migrarNegociacoes($_POST['empreendimento'], $dadosConexao, $log, $idEmpreendimento);
                $this->migrarParcelas($dadosConexao, $log, $arrayBancos, $arrayNegociacoes);
                $this->migrarParcelasHistorico($dadosConexao, $log, $arrayBancos, $arrayNegociacoes);
                $this->migrarRemessas($_POST['empreendimento'], $dadosConexao, $log, $idEmpreendimento);
                $this->migrarUsuarios($dadosConexao, $log);
                $this->migrarParcerias($_POST['empreendimento'], $dadosConexao, $log, $idEmpreendimento);
                $this->migrarAssinaturas($_POST['empreendimento'], $dadosConexao, $log, $idEmpreendimento);
                $this->migrarIndicacoes($_POST['empreendimento'], $dadosConexao, $log, $idEmpreendimento);
                $this->migrarTransferencias($_POST['empreendimento'], $dadosConexao, $log);
                $this->migrarContatos($_POST['empreendimento'], $dadosConexao, $log);
                $this->migrarTabelasPainel($_POST['empreendimento'], $dadosConexao, $log, $idEmpreendimento);
                $this->migrarSecundarias($_POST['empreendimento'], $dadosConexao, $log, $idEmpreendimento);

                //Fecha o arquivo de log
                fclose($log);

                $_GET['filename'] = $filename;
                $this->_helper->addMensagem('sucesso', 'Operao Realizada com sucesso.');
            } catch (Exception $e) {
                $this->set('erro', $e->getMessage());
                $this->redir(array("controller" => "migracao", "action" => "adicionar"), array("msg" => "fail"));
            }
        }
        $this->display('form');
    }

    //Migra os dados do empreendimento selecionado e retorna o novo id
    private function migrarEmpreendimento($id, $dadosConexao, $log)
    {
        $connexao = new Zend_Db_Adapter_Pdo_Mysql($dadosConexao);

        $connexao = $connexao->beginTransaction();
        $item = $connexao->select()->from(array('e' => TB_EMPREENDIMENTO))
            ->where('e.id = ?', $id)
            ->query()->fetch();

        //Registro de Log
        fwrite($log, "-----------------------------------------------------------------------------:\n");
        fwrite($log, "MIGRANDO EMPREENDIMENTO " . strtoupper(utf8_encode($item['nm_empreendimento'])) . ":\n");
        fwrite($log, "-----------------------------------------------------------------------------:\n");
        foreach ($item as $k => &$dado) {
            fwrite($log, $k . " = " . $dado . "\n");
            if ($k == 'id')
                $dado = null;
        }

        $newEmpreendimento = new Empreendimento();
        $newEmpreendimento = $newEmpreendimento->createRow($item);
        $idEmpreendimento = $newEmpreendimento->save();

        //Limpa as tabelas temporarias para migracao
        $tmpLotes = new TmpLote();
        $tmpLotes->delete('1');
        $tmpPessoa = new TmpPessoa();
        $tmpPessoa->delete('1');
        $tmpContrato = new TmpContrato();
        $tmpContrato->delete('1');
        $tmpContrato = new TmpContratoHistorico();
        $tmpContrato->delete('1');

        if ($idEmpreendimento)
            $connexao->commit();
        else {
            $connexao->rollBack();
            fwrite($log, "=========== Erro ============ \n");
        }
        return $idEmpreendimento;
    }

    private function migrarLotes($id, $dadosConexao, $log, $novoId)
    {
        $connexao = new Zend_Db_Adapter_Pdo_Mysql($dadosConexao);
        $connexao = $connexao->beginTransaction();

        try {
            $lotes = $connexao->select()->from(array('l' => TB_LOTES))
                ->where('l.id_empreendimento = ?', $id)
                ->query()->fetchAll();

            $tmplote = new TmpLote();

            //Registro de Log
            fwrite($log, "-----------------------------------------------------------------------------:\n");
            fwrite($log, "MIGRANDO LOTES (" . count($lotes) . "):\n");
            fwrite($log, "-----------------------------------------------------------------------------:\n");
            foreach ($lotes as $lote) {
                fwrite($log, $lote['id'] . ' - Quadra: ' . $lote['quadra'] . ' Lote: ' . $lote['lote'] . "\n");

                $idAntigo = $lote['id'];
                $lote['id'] = null;
                $lote['id_empreendimento'] = $novoId;
                $new = new Lote();
                $new = $new->createRow($lote);
                $idNovo = $new->save();

                $tmplote->createRow(array(
                    'id_empreendimento' => $novoId,
                    'id_lote_antigo' => $idAntigo,
                    'id_lote_novo' => $idNovo
                ))->save();
            }

            $transferencias = $connexao->select()->from(array('tl' => TB_TRANSFERENCIA_LOTE), '*')
                ->join(array('c' => TB_CONTRATO), 'c.id = tl.id_contrato', null)
                ->join(array('l' => TB_LOTES), 'c.id_lote = l.id', null)
                ->where('l.id_empreendimento = ?', $id)
                ->query()->fetchAll();

            //Registro de Log
            fwrite($log, "-----------------------------------------------------------------------------:\n");
            fwrite($log, "MIGRANDO TRANSFERENCIA DE LOTES (" . count($transferencias) . "):\n");
            fwrite($log, "-----------------------------------------------------------------------------:\n");
            foreach ($transferencias as $transferencia) {
                fwrite($log, $transferencia['id_transferencia_lote'] . ' Origem: ' . $transferencia['id_lote_origem'] . ' Destino: ' . $transferencia['id_lote_destino'] . "\n");

                $transferencia['id_transferencia_lote'] = null;
                $transferencia['id_contrato'] = TmpContrato::findById($transferencia['id_contrato']);
                $transferencia['id_lote_origem'] = TmpLote::findById($transferencia['id_lote_origem']);
                $transferencia['id_lote_destino'] = TmpLote::findById($transferencia['id_lote_destino']);
                $new = new TransferenciaLote();
                $new = $new->createRow($transferencia);
                $new->save();
            }

            $connexao->commit();
        } catch (Exception $e) {
            $connexao->rollBack();
            fwrite($log, "=========== Erro : " . $e->getMessage() . " ============== \n");
            return false;
        }
        return true;
    }

    private function migrarPessoas($id, $dadosConexao, $log, $novoId)
    {
        $connexao = new Zend_Db_Adapter_Pdo_Mysql($dadosConexao);
        $connexao = $connexao->beginTransaction();

        try {
            //Busca pessoas com contratos ativos
            $pessoas = $connexao->select()->distinct()->from(array('p' => TB_PESSOA), '*')
                ->join(array('c' => TB_CONTRATO), 'c.id_pessoa = p.id', null)
                ->join(array('l' => TB_LOTES), 'c.id_lote = l.id', null)
                ->where('l.id_empreendimento = ?', $id)
                ->query()->fetchAll();

            //Busca pessoas com contratos quitados ou cancelados
            $pessoasHistorico = $connexao->select()->distinct()->from(array('p' => TB_PESSOA), '*')
                ->join(array('c' => TB_CONTRATO_HISTORICO), 'c.id_pessoa = p.id', null)
                ->join(array('l' => TB_LOTES), 'c.id_lote = l.id', null)
                ->where('l.id_empreendimento = ?', $id)
                ->query()->fetchAll();

            //Busca as pessoas secundarias de contrato
            $pessoasContrato = $connexao->select()->distinct()->from(array('p' => TB_PESSOA), '*')
                ->join(array('cp' => TB_CONTRATO_PESSOA), 'cp.id_pessoa = p.id', null)
                ->join(array('c' => TB_CONTRATO), 'c.id = cp.id_contrato', null)
                ->join(array('l' => TB_LOTES), 'c.id_lote = l.id', null)
                ->where('l.id_empreendimento = ?', $id)
                ->query()->fetchAll();

            $clientes = array_merge($pessoas, $pessoasHistorico, $pessoasContrato);

            //Busca as pessoas em parceria com o empreendimento e comissao
            $pessoasParceriaCom = $connexao->select()->distinct()->from(array('p' => TB_PESSOA), '*')
                ->join(array('pc' => TB_PARCERIA_COMISSAO), 'pc.id_pessoa = p.id', null)
                ->where('pc.id_empreendimento = ?', $id)
                ->query()->fetchAll();
            $pessoasParceria = $connexao->select()->distinct()->from(array('p' => TB_PESSOA), '*')
                ->join(array('pa' => TB_PARCERIA), 'pa.id_pessoa = p.id', null)
                ->where('pa.id_empreendimento = ?', $id)
                ->query()->fetchAll();

            //Busca scios do empreendimento
            $pessoasSocio = $connexao->select()->distinct()->from(array('p' => TB_PESSOA), '*')
                ->join(array('a' => TB_ASSINATURA), 'a.id_pessoa = p.id', null)
                ->where('a.id_empreendimento = ?', $id)
                ->query()->fetchAll();

            $associados = array_merge($pessoasParceria, $pessoasParceriaCom, $pessoasSocio);

            //Busca as pessoas em parceria com o empreendimento
            $pessoasIndicacao = $connexao->select()->distinct()->from(array('p' => TB_PESSOA), '*')
                ->join(array('i' => TB_INDICACAO), 'i.id_cliente = p.id', null)
                ->where('i.id_empreendimento = ?', $id)
                ->query()->fetchAll();

            //Busca scios do empreendimento
            $pessoasReserva = $connexao->select()->distinct()->from(array('p' => TB_PESSOA), '*')
                ->join(array('rl' => TB_RESERVA_LOTE), 'rl.corretor = p.id', null)
                ->join(array('l' => TB_LOTES), 'rl.cod_lote = l.id', null)
                ->where('l.id_empreendimento = ?', $id)
                ->query()->fetchAll();

            //Busca as pessoas relacionadas com usuario
            $pessoasUsuario = $connexao->select()->distinct()->from(array('p' => TB_PESSOA), '*')
                ->join(array('u' => TB_USUARIO), 'u.id = p.id', null)
                ->query()->fetchAll();

            //Busca as pessoas relacionadas as transferencias
            $pessoasTransfCed = $connexao->select()->distinct()->from(array('p' => TB_PESSOA), '*')
                ->join(array('t' => TB_TRANSFERENCIA), 't.idReceptor = p.id', null)
                ->join(array('c' => TB_CONTRATO), 'c.id_pessoa = t.idContrato', null)
                ->join(array('l' => TB_LOTES), 'c.id_lote = l.id', null)
                ->where('l.id_empreendimento = ?', $id)
                ->query()->fetchAll();
            $pessoasTransfRec = $connexao->select()->distinct()->from(array('p' => TB_PESSOA), '*')
                ->join(array('t' => TB_TRANSFERENCIA), 't.idCedente = p.id', null)
                ->join(array('c' => TB_CONTRATO), 'c.id_pessoa = t.idContrato', null)
                ->join(array('l' => TB_LOTES), 'c.id_lote = l.id', null)
                ->where('l.id_empreendimento = ?', $id)
                ->query()->fetchAll();
            $pessoasTransfCes = $connexao->select()->distinct()->from(array('p' => TB_PESSOA), '*')
                ->join(array('tc' => TB_TRANSFERENCIA_CESSIONARIOS), 'tc.id_cessionario = p.id', null)
                ->join(array('t' => TB_TRANSFERENCIA), 't.id = tc.id_transferencia', null)
                ->join(array('c' => TB_CONTRATO), 'c.id_pessoa = t.idContrato', null)
                ->join(array('l' => TB_LOTES), 'c.id_lote = l.id', null)
                ->where('l.id_empreendimento = ?', $id)
                ->query()->fetchAll();

            //Busca representantes das pessoas juridicas
            $representantes = $connexao->select()->distinct()->from(array('p' => TB_PESSOA), '*')
                ->join(array('r' => TB_REPRESENTANTE), 'r.id_pessoa = p.id', null)
                ->join(array('c' => TB_CONTRATO), 'c.id_pessoa = r.id_pessoa_juridica', null)
                ->join(array('l' => TB_LOTES), 'c.id_lote = l.id', null)
                ->where('l.id_empreendimento = ?', $id)
                ->query()->fetchAll();

            //Une os arrays de relacionadas
            $relacionados = array_merge(
                $pessoasIndicacao,
                $pessoasReserva,
                $representantes,
                $pessoasUsuario,
                $pessoasTransfCes,
                $pessoasTransfCed,
                $pessoasTransfRec
            );

            //Une todos os grupos de pessoas para a migrao e remove as repeties pelo id
            $pessoas = array();
            foreach (array_merge($clientes, $associados, $relacionados) as $pessoa) {
                $pessoas[$pessoa['id']] = $pessoa;
            }

            $tmpPessoa = new TmpPessoa();

            //Registro de Log
            fwrite($log, "-----------------------------------------------------------------------------:\n");
            fwrite($log, "MIGRANDO PESSOAS (" . count($pessoas) . "):\n");
            fwrite($log, "-----------------------------------------------------------------------------:\n");
            foreach ($pessoas as $pessoa) {
                fwrite($log, $pessoa['id'] . ' - ' . $pessoa['nm_pessoa'] . "\n");

                //Salva os dados migrados, reiniciando o id
                $idAntigo = $pessoa['id'];
                $pessoa['id'] = null;
                $new = new Pessoa();
                $new = $new->createRow($pessoa);
                $idNovo = $new->save();

                //Migra para a tabela de pessoa fisica com os dados pesquisados
                if ($pessoa['tp_pessoa'] == 'F') {
                    $pf = $connexao->select()->from(array('pf' => TB_PESSOA_FISICA), '*')
                        ->where('pf.id_pessoa = ?', $idAntigo)->query()->fetch();
                    $pf['id_pessoa'] = $idNovo;
                    $idConjuge = $pf['cd_conjuge'];
                    $pf['cd_conjuge'] = null;
                    $newPf = new Pessoa_Fisica();
                    $newPf = $newPf->createRow($pf);
                    $newPf->save();

                    fwrite($log, '  * ' . $pf['id_pessoa'] . ' - F' . "\n");
                }
                //Migra para a tabela de pessoa juridica com os dados pesquisados
                if ($pessoa['tp_pessoa'] == 'J') {
                    $pj = $connexao->select()->from(array('pj' => TB_PESSOA_JURIDICA), '*')
                        ->where('pj.id_pessoa = ?', $idAntigo)->query()->fetch();
                    $pj['id_pessoa'] = $idNovo;
                    $newPj = new Pessoa_Juridica();
                    $newPj = $newPj->createRow($pj);
                    $newPj->save();

                    fwrite($log, '  * ' . $pj['id_pessoa'] . ' - J' . "\n");
                }

                //Adiciona os documentos das pessoas migradas
                $documento = $connexao->select()->from(array('doc' => TB_DOCUMENTO), '*')
                    ->where('doc.id_pessoa = ?', $idAntigo)->query()->fetch();

                if ($documento) {
                    $documento['id'] = null;
                    $documento['id_pessoa'] = $idNovo;
                    $newDoc = new Documento();
                    $newDoc = $newDoc->createRow($documento);
                    $newDoc->save();

                    fwrite($log, '  Documento: ' . $documento['nm_documento'] . "\n");
                }

                $tmpPessoa->createRow(array(
                    'id_empreendimento' => $novoId,
                    'id_pessoa_antigo' => $idAntigo,
                    'id_pessoa_novo' => $idNovo,
                    'id_conjuge' => isset($idConjuge) ? $idConjuge : null
                ))->save();
            }

            //Migra a tabela de representantes
            $representantes = $connexao->select()->distinct()->from(array('r' => TB_REPRESENTANTE), '*')
                ->join(array('c' => TB_CONTRATO), 'c.id_pessoa = r.id_pessoa_juridica', null)
                ->join(array('l' => TB_LOTES), 'c.id_lote = l.id', null)
                ->where('l.id_empreendimento = ?', $id)
                ->query()->fetchAll();

            if (count($representantes)) {
                //Registro de Log
                fwrite($log, "-----------------------------------------------------------------------------:\n");
                fwrite($log, "MIGRANDO TABELA DE REPRESENTANTES (" . count($representantes) . "):\n");
                fwrite($log, "-----------------------------------------------------------------------------:\n");

                foreach ($representantes as $representante) {
                    $representante['id'] = null;
                    $representante['id_pessoa'] = TmpPessoa::findById($representante['id_pessoa']);
                    $representante['id_pessoa_juridica'] = TmpPessoa::findById($representante['id_pessoa_juridica']);
                    $newRep = new Representante();
                    $newRep = $newRep->createRow($representante);
                    $newRep->save();
                }
            }

            $conjuges = $tmpPessoa->findListaConjuge();

            if (count($conjuges)) {
                //Registro de Log
                fwrite($log, "-----------------------------------------------------------------------------:\n");
                fwrite($log, "MIGRANDO DADOS DE CONJUGE (" . count($conjuges) . "):\n");
                fwrite($log, "-----------------------------------------------------------------------------:\n");

                foreach ($conjuges as $conj) {
                    $pessoaConj = $tmpPessoa->findById($conj['id_conjuge']);

                    //Busca se o conjuge foi migrado tambm, senao migra-o
                    if ($pessoaConj) {
                        $idNovoConj = $pessoaConj;
                    } else {
                        $conjuge = $connexao->select()->from(array('p' => TB_PESSOA), '*')
                            ->where('p.id = ?', $conj['id_conjuge'])->query()->fetch();

                        fwrite($log, "=== Adicionando pessoa  migrao ===" . "\n");
                        fwrite($log, $conjuge['id'] . ' - ' . $conjuge['nm_pessoa'] . "\n");

                        //Salva os dados migrados, reiniciando o id
                        $idAntigo = $conjuge['id'];
                        $conjuge['id'] = null;
                        $new = new Pessoa();
                        $new = $new->createRow($conjuge);
                        $idNovoConj = $new->save();

                        $pf = $connexao->select()->from(array('pf' => TB_PESSOA_FISICA), '*')
                            ->where('pf.id_pessoa = ?', $idAntigo)->query()->fetch();
                        $pf['id_pessoa'] = $idNovoConj;
                        $pf['cd_conjuge'] = null;
                        $newPf = new Pessoa_Fisica();
                        $newPf = $newPf->createRow($pf);
                        $newPf->save();

                        $tmpPessoa->createRow(array(
                            'id_empreendimento' => $novoId,
                            'id_pessoa_antigo' => $idAntigo,
                            'id_pessoa_novo' => $idNovoConj,
                            'id_conjuge' => isset($conj['id_pessoa_antigo']) ? $conj['id_pessoa_antigo'] : null
                        ))->save();
                    }

                    //Salva os ids novos nas pessoas correspondentes
                    $pessoas = new Pessoa_Fisica();
                    $p = $pessoas->fetchRow($pessoas->select()->where('id_pessoa = ?', $conj['id_pessoa_novo']));
                    $c = $pessoas->fetchRow($pessoas->select()->where('id_pessoa = ?', $idNovoConj));

                    $p->cd_conjuge = $idNovoConj;
                    $c->cd_conjuge = $conj['id_pessoa_novo'];

                    $p->save();
                    $c->save();

                    fwrite($log, $conj['id_pessoa_novo'] . ' - ' . $idNovoConj . "\n");
                }
            }
            $connexao->commit();
        } catch (Exception $e) {
            $connexao->rollBack();
            fwrite($log, "=========== Erro : " . $e->getMessage() . " ============== \n");
            return false;
        }
        return true;
    }

    private function migrarBancos($id, $dadosConexao, $log, $novoId)
    {
        $connexao = new Zend_Db_Adapter_Pdo_Mysql($dadosConexao);
        $connexao = $connexao->beginTransaction();

        $arrayBancos = array();
        try {
            $bancos = $connexao->select()->from(array('b' => TB_BANCO))
                ->where('b.id_empreendimento = ?', $id)
                ->query()->fetchAll();

            //Registro de Log
            fwrite($log, "-----------------------------------------------------------------------------:\n");
            fwrite($log, "MIGRANDO BANCOS (" . count($bancos) . "):\n");
            fwrite($log, "-----------------------------------------------------------------------------:\n");
            foreach ($bancos as $banco) {
                fwrite($log, $banco['id'] . ' - ' . $banco['cd_banco'] . "\n");

                //Salva os dados migrados, reiniciando o id
                $idAntigo = $banco['id'];
                $banco['id'] = null;
                $banco['id_empreendimento'] = $novoId;
                $new = new Banco();
                $new = $new->createRow($banco);
                $idNovo = $new->save();

                $arrayBancos[$idAntigo] = $idNovo;
            }
            $connexao->commit();
        } catch (Exception $e) {
            $connexao->rollBack();
            fwrite($log, "=========== Erro : " . $e->getMessage() . " ============== \n");
            return false;
        }
        return $arrayBancos;
    }

    private function migrarCorretores($id, $dadosConexao, $log, $novoId)
    {
        $connexao = new Zend_Db_Adapter_Pdo_Mysql($dadosConexao);
        $connexao = $connexao->beginTransaction();

        $arrayCorretores = array();
        try {
            $tmpPessoa = new TmpPessoa();
            $corretores = $connexao->select()->from(array('ce' => TB_CORRETOR_EMPREENDIMENTO), '*')
                ->join(array('c' => TB_CORRETOR), '', array('*'))
                ->where('ce.id_empreendimento = ?', $id)
                ->group('ce.id_corretor')
                ->query()->fetchAll();

            //Registro de Log
            fwrite($log, "-----------------------------------------------------------------------------:\n");
            fwrite($log, "MIGRANDO CORRETORES (" . count($corretores) . "):\n");
            fwrite($log, "-----------------------------------------------------------------------------:\n");
            foreach ($corretores as $corretor) {
                $pessoaCorretor = $tmpPessoa->findById($corretor['id_corretor']);

                //Testa se j existe no registro de pessoas
                if ($pessoaCorretor) {
                    $idAntigo = $corretor['id_corretor'];
                    $idNovo = $pessoaCorretor;

                    fwrite($log, $corretor['id_corretor'] . ' - ' . $pessoaCorretor . "\n");
                } else {
                    $pessoa = $connexao->select()->from(array('p' => TB_PESSOA), '*')
                        ->where('p.id = ?', $corretor['id_corretor'])
                        ->query()->fetch();

                    $idAntigo = $pessoa['id'];
                    $pessoa['id'] = null;
                    $newP = new Pessoa();
                    $newP = $newP->createRow($pessoa);
                    $idNovo = $newP->save();

                    //Migra para a tabela de pessoa fisica com os dados pesquisados
                    if ($pessoa['tp_pessoa'] == 'F') {
                        $pf = $connexao->select()->from(array('pf' => TB_PESSOA_FISICA), '*')
                            ->where('pf.id_pessoa = ?', $idAntigo)->query()->fetch();
                        $pf['id_pessoa'] = $idNovo;
                        $newPf = new Pessoa_Fisica();
                        $newPf = $newPf->createRow($pf);
                        $newPf->save();
                    }

                    $tmpPessoa->createRow(array(
                        'id_empreendimento' => $novoId,
                        'id_pessoa_antigo' => $idAntigo,
                        'id_pessoa_novo' => $idNovo
                    ))->save();

                    fwrite($log, $corretor['id_corretor'] . ' - ' . $pessoa['nm_pessoa'] . "\n");
                }

                $arrayCorretores[$idAntigo] = $idNovo;

                $corretorEmpreendimento['id_empreendimento'] = $novoId;
                $corretorEmpreendimento['id_corretor'] = $idNovo;
                $newCE = new Corretor_Empreendimento();
                $newCE = $newCE->createRow($corretorEmpreendimento);
                $newCE->save();
            }
            $connexao->commit();
        } catch (Exception $e) {
            $connexao->rollBack();
            fwrite($log, "=========== Erro : " . $e->getMessage() . " ============== \n");
            return false;
        }
        return $arrayCorretores;
    }

    private function migrarContratos($id, $dadosConexao, $log, $idNovo, $corretores, $bancos)
    {
        $connexao = new Zend_Db_Adapter_Pdo_Mysql($dadosConexao);
        $connexao = $connexao->beginTransaction();

        try {
            $contratos = $connexao->select()->from(array('c' => TB_CONTRATO), '*')
                ->join(array('l' => TB_LOTES), 'c.id_lote = l.id', null)
                ->where('l.id_empreendimento = ?', $id)
                ->query()->fetchAll();
            $tmpContrato = new TmpContrato();

            //Registro de Log
            fwrite($log, "-----------------------------------------------------------------------------:\n");
            fwrite($log, "MIGRANDO CONTRATOS (" . count($contratos) . "):\n");
            fwrite($log, "-----------------------------------------------------------------------------:\n");
            foreach ($contratos as $contrato) {
                $idAntigo = $contrato['id'];
                $contrato['id'] = null;
                $contrato['id_lote'] = TmpLote::findById($contrato['id_lote']);
                $contrato['id_pessoa'] = TmpPessoa::findById($contrato['id_pessoa']);
                $contrato['id_banco'] = $bancos[$contrato['id_banco']];
                $contrato['id_corretor'] = $corretores[$contrato['id_corretor']];
                $new = new Contrato();
                $new = $new->createRow($contrato);
                $novoId = $new->save();

                //Salva os dados de contratos novos e antigos na tabela temporaria
                $tmpContrato->createRow(array(
                    'id_empreendimento' => $idNovo,
                    'id_contrato_antigo' => $idAntigo,
                    'id_contrato_novo' => $novoId
                ))->save();

                //Registro de Log
                fwrite($log, $idAntigo . " -  Contrato \n");
            }
            $connexao->commit();
        } catch (Exception $e) {
            $connexao->rollBack();
            fwrite($log, "=========== Erro : " . $e->getMessage() . " ============== \n");
            return false;
        }
        return true;
    }

    private function migrarContratosHistorico($id, $dadosConexao, $log, $idNovo, $corretores, $bancos)
    {
        $connexao = new Zend_Db_Adapter_Pdo_Mysql($dadosConexao);
        $connexao = $connexao->beginTransaction();

        try {
            $contratos = $connexao->select()->from(array('c' => TB_CONTRATO_HISTORICO), '*')
                ->join(array('l' => TB_LOTES), 'c.id_lote = l.id', null)
                ->where('l.id_empreendimento = ?', $id)
                ->query()->fetchAll();
            $tmpContrato = new TmpContratoHistorico();

            //Registro de Log
            fwrite($log, "-----------------------------------------------------------------------------:\n");
            fwrite($log, "MIGRANDO CONTRATOS DO HISTORICO (" . count($contratos) . "):\n");
            fwrite($log, "-----------------------------------------------------------------------------:\n");
            foreach ($contratos as $contrato) {
                $idAntigo = $contrato['id'];
                $contrato['id'] = null;
                $contrato['id_lote'] = TmpLote::findById($contrato['id_lote']);
                $contrato['id_pessoa'] = TmpPessoa::findById($contrato['id_pessoa']);
                $contrato['id_banco'] = $bancos[$contrato['id_banco']];
                $idCorretor = $corretores[$contrato['id_corretor']];
                $contrato['id_corretor'] = ($idCorretor) ? $idCorretor : null;
                $new = new ContratoHistorico();
                $new = $new->createRow($contrato);
                $novoId = $new->save();

                //Salva os dados de contratos novos e antigos na tabela temporaria
                $tmpContrato->createRow(array(
                    'id_empreendimento' => $idNovo,
                    'id_contrato_antigo' => $idAntigo,
                    'id_contrato_novo' => $novoId
                ))->save();

                //Registro de Log
                fwrite($log, $idAntigo . " -  Contrato Histrico \n");
            }
            $connexao->commit();
        } catch (Exception $e) {
            $connexao->rollBack();
            fwrite($log, "=========== Erro : " . $e->getMessage() . " ============== \n");
            return false;
        }
        return true;
    }

    private function migrarContratoItens($id, $dadosConexao, $log)
    {
        $connexao = new Zend_Db_Adapter_Pdo_Mysql($dadosConexao);
        $connexao = $connexao->beginTransaction();

        try {
            $contratoItens = $connexao->select()->from(array('ci' => TB_CONTRATO_ITENS), '*')
                ->join(array('c' => TB_CONTRATO), 'c.id = ci.id_contrato', null)
                ->join(array('l' => TB_LOTES), 'c.id_lote = l.id', null)
                ->where('l.id_empreendimento = ?', $id)
                ->query()->fetchAll();

            //Registro de Log
            fwrite($log, "-----------------------------------------------------------------------------:\n");
            fwrite($log, "MIGRANDO ITENS ADICIONAIS CONTRATOS (" . count($contratoItens) . "):\n");
            fwrite($log, "-----------------------------------------------------------------------------:\n");
            foreach ($contratoItens as $contratoItem) {
                //Registro de Log
                fwrite($log, 'Item: ' . $contratoItem['id_contrato_itens'] . " -  Contrato: " . $contratoItem['id_contrato'] . "\n");

                $contratoItem['id_contrato_itens'] = null;
                $contratoItem['id_contrato'] = TmpContrato::findById($contratoItem['id_contrato']);
                $new = new ContratoItens();
                $new = $new->createRow($contratoItem);
                $new->save();
            }
            $connexao->commit();
        } catch (Exception $e) {
            $connexao->rollBack();
            fwrite($log, "=========== Erro : " . $e->getMessage() . " ============== \n");
            return false;
        }
        return true;
    }

    private function migrarDistratos($id, $dadosConexao, $log)
    {
        $connexao = new Zend_Db_Adapter_Pdo_Mysql($dadosConexao);
        $connexao = $connexao->beginTransaction();

        $arrayNegociacoes = array();
        try {
            //Busca negociaes de acordo com os contratos ativos
            $distratos = $connexao->select()->from(array('d' => TB_DISTRATO))
                ->join(array('c' => TB_CONTRATO), 'c.id = d.id_contrato', null)
                ->join(array('l' => TB_LOTES), 'c.id_lote = l.id', null)
                ->where('l.id_empreendimento = ?', $id)
                ->query()->fetchAll();

            //Registro de Log
            fwrite($log, "-----------------------------------------------------------------------------:\n");
            fwrite($log, "MIGRANDO DISTRATOS (" . count($distratos) . "):\n");
            fwrite($log, "-----------------------------------------------------------------------------:\n");
            foreach ($distratos as $distrato) {
                fwrite($log, 'Contrato: ' . $distrato['id_contrato'] . "\n");

                //Salva os dados migrados, reiniciando o id
                $idOld = $distrato['id_contrato'];
                $distrato['id_contrato'] = TmpContrato::findById($distrato['id_contrato']);
                $new = new Distrato();
                $new = $new->createRow($distrato);
                $new->save();

                $parcelasDistrato = $connexao->select()->from(array('pd' => TB_PARCELA_DISTRATO))
                    ->where('pd.id_contrato = ?', $idOld)
                    ->query()->fetchAll();

                if ($parcelasDistrato)
                    foreach ($parcelasDistrato as $parcela) {
                        fwrite($log, '  > Parcela: ' . $parcela['id_parcela_contrato'] . "\n");

                        $parcela['id_parcela_contrato'] = null;
                        $parcela['id_contrato'] = TmpContrato::findById($idOld);
                        $newP = new ParcelaDistrato();
                        $newP = $newP->createRow($parcela);
                        $newP->save();
                    }
            }
            $connexao->commit();
        } catch (Exception $e) {
            $connexao->rollBack();
            fwrite($log, "=========== Erro : " . $e->getMessage() . " ============== \n");
            return false;
        }
        return $arrayNegociacoes;
    }

    private function migrarNegociacoes($id, $dadosConexao, $log)
    {
        $connexao = new Zend_Db_Adapter_Pdo_Mysql($dadosConexao);
        $connexao = $connexao->beginTransaction();

        $arrayNegociacoes = array();
        try {
            //Busca negociaes de acordo com os contratos ativos
            $negociacoes = $connexao->select()->from(array('n' => TB_NEGOCIACAO))
                ->join(array('c' => TB_CONTRATO), 'c.id = n.id_contrato', null)
                ->join(array('l' => TB_LOTES), 'c.id_lote = l.id', null)
                ->where('l.id_empreendimento = ?', $id)
                ->query()->fetchAll();

            //Busca negociaes de acordo com os contratos inativos
            $negociacoesHistorico = $connexao->select()->from(array('n' => TB_NEGOCIACAO))
                ->join(array('c' => TB_CONTRATO_HISTORICO), 'c.id = n.id_contrato', null)
                ->join(array('l' => TB_LOTES), 'c.id_lote = l.id', null)
                ->where('l.id_empreendimento = ?', $id)
                ->query()->fetchAll();

            $negociacoes = array_merge($negociacoes, $negociacoesHistorico);

            $tmpContrato = new TmpContrato();

            //Registro de Log
            fwrite($log, "-----------------------------------------------------------------------------:\n");
            fwrite($log, "MIGRANDO NEGOCIAES (" . count($negociacoes) . "):\n");
            fwrite($log, "-----------------------------------------------------------------------------:\n");
            foreach ($negociacoes as $negociacao) {
                fwrite($log, $negociacao['id'] . ' - Contrato ' . $negociacao['id_contrato'] . "\n");

                //Salva os dados migrados, reiniciando o id
                $idAntigo = $negociacao['id'];
                $negociacao['id'] = null;
                $negociacao['id_contrato'] = $tmpContrato->findById($negociacao['id_contrato']);
                $new = new Negociacao();
                $new = $new->createRow($negociacao);
                $idNovo = $new->save();

                $arrayNegociacoes[$idAntigo] = $idNovo;
            }
            $connexao->commit();
        } catch (Exception $e) {
            $connexao->rollBack();
            fwrite($log, "=========== Erro : " . $e->getMessage() . " ============== \n");
            return false;
        }
        return $arrayNegociacoes;
    }

    private function migrarParcelas($dadosConexao, $log, $bancos, $negociacoes)
    {
        $connexao = new Zend_Db_Adapter_Pdo_Mysql($dadosConexao);
        $connexao = $connexao->beginTransaction();

        try {
            $tmpContrato = new TmpContrato();
            $contratos = $tmpContrato->findContratos();

            //Registro de Log
            fwrite($log, "-----------------------------------------------------------------------------:\n");
            fwrite($log, "MIGRANDO PARCELAS DOS CONTRATOS:\n");
            fwrite($log, "-----------------------------------------------------------------------------:\n");
            foreach ($contratos as $contrato) {
                $parcelas = $connexao->select()->from(array('par' => TB_PARCELA), '*')
                    ->where('par.id_contrato = ?', $contrato['id_contrato_antigo'])
                    ->query()->fetchAll();

                foreach ($parcelas as $parcela) {
                    $parcela['id_parcela_contrato_antigo'] = $parcela['id_parcela_contrato'];
                    $parcela['id_parcela_contrato'] = null;
                    $parcela['id_contrato'] = $contrato['id_contrato_novo'];
                    $parcela['id_banco'] = $bancos[$parcela['id_banco']];
                    $parcela['id_negociacao'] = $negociacoes[$parcela['id_negociacao']];
                    $new = new Parcela();
                    $new = $new->createRow($parcela);
                    $new->save();
                }
                fwrite($log, 'Contrato = ' . $contrato['id_contrato_antigo'] . ' - Parcelas: ' . count($parcelas) . "\n");
            }

            //Registro de Log
            fwrite($log, "-----------------------------------------------------------------------------:\n");
            fwrite($log, "MIGRANDO PARCELAS 2A VIA DOS CONTRATOS:\n");
            fwrite($log, "-----------------------------------------------------------------------------:\n");
            foreach ($contratos as $contrato) {
                $parcelas = $connexao->select()->from(array('par' => TB_PARCELA_2VIA), '*')
                    ->where('par.id_contrato = ?', $contrato['id_contrato_antigo'])->query()->fetchAll();
                //Se no possui parcelas continua
                if (count($parcelas) > 0) {
                    foreach ($parcelas as $parcela) {
                        $parcela['id_parcela_contrato_antigo'] = $parcela['id_parcela_contrato'];
                        $parcela['id_parcela_contrato'] = null;
                        $parcela['id_contrato'] = $contrato['id_contrato_novo'];
                        $parcela['id_banco'] = $bancos[$parcela['id_banco']];
                        $parcela['id_negociacao'] = $negociacoes[$parcela['id_negociacao']];
                        $new = new Parcela2Via();
                        $new = $new->createRow($parcela);
                        $new->save();
                    }
                    fwrite($log, 'Contrato 2a Via = ' . $contrato['id_contrato_antigo'] . ' - Parcelas: ' . count($parcelas) . "\n");
                }
            }
            $connexao->commit();
        } catch (Exception $e) {
            $connexao->rollBack();
            fwrite($log, "=========== Erro : " . $e->getMessage() . " ============== \n");
            return false;
        }
        return true;
    }

    private function migrarParcelasHistorico($dadosConexao, $log, $bancos, $negociacoes)
    {
        $connexao = new Zend_Db_Adapter_Pdo_Mysql($dadosConexao);
        $connexao = $connexao->beginTransaction();

        try {
            $tmpContrato = new TmpContratoHistorico();
            $contratos = $tmpContrato->findContratos();

            //Registro de Log
            fwrite($log, "-----------------------------------------------------------------------------:\n");
            fwrite($log, "MIGRANDO PARCELAS DOS CONTRATOS NO HISTRICO:\n");
            fwrite($log, "-----------------------------------------------------------------------------:\n");
            foreach ($contratos as $contrato) {
                $parcelas = $connexao->select()->from(array('par' => TB_PARCELA_HISTORICO), '*')
                    ->where('par.id_contrato = ?', $contrato['id_contrato_antigo'])->query()->fetchAll();

                foreach ($parcelas as $parcela) {
                    $parcela['id_parcela_contrato_antigo'] = $parcela['id_parcela_contrato'];
                    $parcela['id_parcela_contrato'] = null;
                    $parcela['id_contrato'] = $contrato['id_contrato_novo'];
                    $parcela['id_banco'] = $bancos[$parcela['id_banco']];
                    $parcela['id_negociacao'] = $negociacoes[$parcela['id_negociacao']];
                    $new = new ParcelaHistorico();
                    $new = $new->createRow($parcela);
                    $new->save();
                }

                fwrite($log, 'Contrato Histrico = ' . $contrato['id_contrato_antigo'] . ' - Parcelas: ' . count($parcelas) . "\n");
            }

            //Registro de Log
            fwrite($log, "-----------------------------------------------------------------------------:\n");
            fwrite($log, "MIGRANDO PARCELAS 2A VIA DO HISTORICO:\n");
            fwrite($log, "-----------------------------------------------------------------------------:\n");
            foreach ($contratos as $contrato) {
                $parcelas = $connexao->select()->from(array('par' => TB_PARCELA_2VIA), '*')
                    ->where('par.id_contrato = ?', $contrato['id_contrato_antigo'])->query()->fetchAll();

                //Se no possui parcelas continua
                if (count($parcelas) > 0) {
                    foreach ($parcelas as $parcela) {
                        $parcela['id_parcela_contrato'] = null;
                        $parcela['id_contrato'] = $contrato['id_contrato_novo'];
                        $parcela['id_banco'] = $bancos[$parcela['id_banco']];
                        $parcela['id_negociacao'] = $negociacoes[$parcela['id_negociacao']];
                        $new = new Parcela2Via();
                        $new = $new->createRow($parcela);
                        $new->save();
                    }
                    fwrite($log, 'Contrato Histrico 2a Via = ' . $contrato['id_contrato_antigo'] . ' - Parcelas: ' . count($parcelas) . "\n");
                }
            }
            $connexao->commit();
        } catch (Exception $e) {
            $connexao->rollBack();
            fwrite($log, "=========== Erro : " . $e->getMessage() . " ============== \n");
            return false;
        }
        return true;
    }

    private function migrarRemessas($id, $dadosConexao, $log, $novoId)
    {
        $connexao = new Zend_Db_Adapter_Pdo_Mysql($dadosConexao);
        $connexao = $connexao->beginTransaction();

        try {
            $remessas = $connexao->select()->from(array('r' => TB_REMESSA))
                ->where('r.id_empreendimento = ?', $id)
                ->query()->fetchAll();

            //Registro de Log
            fwrite($log, "-----------------------------------------------------------------------------:\n");
            fwrite($log, "MIGRANDO REMESSAS (" . count($remessas) . "):\n");
            fwrite($log, "-----------------------------------------------------------------------------:\n");
            foreach ($remessas as $remessa) {
                fwrite($log, $remessa['id'] . ' - ' . $remessa['arquivo'] . "\n");

                $remessa['id'] = null;
                $remessa['id_empreendimento'] = $novoId;
                $new = new RemessaBoleto();
                $new = $new->createRow($remessa);
                $new->save();
            }
            $connexao->commit();
        } catch (Exception $e) {
            $connexao->rollBack();
            fwrite($log, "=========== Erro : " . $e->getMessage() . " ============== \n");
            return false;
        }
        return true;
    }

    private function migrarParcerias($id, $dadosConexao, $log, $novoId)
    {
        $connexao = new Zend_Db_Adapter_Pdo_Mysql($dadosConexao);
        $connexao = $connexao->beginTransaction();

        try {
            $parceriasComissao = $connexao->select()->from(array('pc' => TB_PARCERIA_COMISSAO))
                ->where('pc.id_empreendimento = ?', $id)
                ->query()->fetchAll();

            //Registro de Log
            fwrite($log, "-----------------------------------------------------------------------------:\n");
            fwrite($log, "MIGRANDO PARCERIAS COMISSAO (" . count($parceriasComissao) . "):\n");
            fwrite($log, "-----------------------------------------------------------------------------:\n");
            foreach ($parceriasComissao as $parceria) {
                fwrite($log, $parceria['id_parceria_comissao'] . ' - Pessoa: ' . $parceria['id_pessoa'] . "\n");

                $parceria['id_parceria_comissao'] = null;
                $parceria['id_empreendimento'] = $novoId;
                $parceria['id_pessoa'] = TmpPessoa::findById($parceria['id_pessoa']);
                $new = new ParceriaComissao();
                $new = $new->createRow($parceria);
                $new->save();
            }

            $parcerias = $connexao->select()->from(array('pc' => TB_PARCERIA))
                ->where('pc.id_empreendimento = ?', $id)
                ->query()->fetchAll();

            //Registro de Log
            fwrite($log, "-----------------------------------------------------------------------------:\n");
            fwrite($log, "MIGRANDO PARCERIAS (" . count($parcerias) . "):\n");
            fwrite($log, "-----------------------------------------------------------------------------:\n");
            foreach ($parcerias as $parceria) {
                fwrite($log, 'Pessoa: ' . $parceria['id_pessoa'] . "\n");

                $parceria['id_empreendimento'] = $novoId;
                $parceria['id_pessoa'] = TmpPessoa::findById($parceria['id_pessoa']);
                $new = new Parceria();
                $new = $new->createRow($parceria);
                $new->save();
            }

            $connexao->commit();
        } catch (Exception $e) {
            $connexao->rollBack();
            fwrite($log, "=========== Erro : " . $e->getMessage() . " ============== \n");
            return false;
        }
        return true;
    }

    private function migrarAssinaturas($id, $dadosConexao, $log, $novoId)
    {
        $connexao = new Zend_Db_Adapter_Pdo_Mysql($dadosConexao);
        $connexao = $connexao->beginTransaction();

        try {
            $assinaturas = $connexao->select()->from(array('a' => TB_ASSINATURA))
                ->where('a.id_empreendimento = ?', $id)
                ->query()->fetchAll();

            //Registro de Log
            fwrite($log, "-----------------------------------------------------------------------------:\n");
            fwrite($log, "MIGRANDO SOCIOS DO EMPREENDIMENTO (" . count($assinaturas) . "):\n");
            fwrite($log, "-----------------------------------------------------------------------------:\n");
            foreach ($assinaturas as $assinatura) {
                fwrite($log, $assinatura['id'] . ' - Pessoa: ' . $assinatura['id_pessoa'] . "\n");

                $assinatura['id'] = null;
                $assinatura['id_empreendimento'] = $novoId;
                $idPessoa = TmpPessoa::findById($assinatura['id_pessoa']);
                $assinatura['id_pessoa'] = ($idPessoa) ? $idPessoa : null;
                $new = new Assinatura();
                $new = $new->createRow($assinatura);
                $new->save();
            }
            $connexao->commit();
        } catch (Exception $e) {
            $connexao->rollBack();
            fwrite($log, "=========== Erro : " . $e->getMessage() . " ============== \n");
            return false;
        }
        return true;
    }

    private function migrarIndicacoes($id, $dadosConexao, $log, $novoId)
    {
        $connexao = new Zend_Db_Adapter_Pdo_Mysql($dadosConexao);
        $connexao = $connexao->beginTransaction();

        try {
            $indicacoes = $connexao->select()->from(array('i' => TB_INDICACAO))
                ->where('i.id_empreendimento = ?', $id)
                ->query()->fetchAll();

            //Registro de Log
            fwrite($log, "-----------------------------------------------------------------------------:\n");
            fwrite($log, "MIGRANDO INDICAES (" . count($indicacoes) . "):\n");
            fwrite($log, "-----------------------------------------------------------------------------:\n");
            foreach ($indicacoes as $indicacao) {
                fwrite($log, $indicacao['id_indicacao'] . ' - Cliente: ' . $indicacao['id_cliente'] . ' - Usuario: ' . $indicacao['id_usuario'] . "\n");

                $indicacao['id_indicacao'] = null;
                $indicacao['id_empreendimento'] = $novoId;
                if ($indicacao['id_contrato'])
                    $indicacao['id_contrato'] = TmpContrato::findById($indicacao['id_contrato']);
                $indicacao['id_cliente'] = TmpPessoa::findById($indicacao['id_cliente']);
                $indicacao['id_usuario'] = TmpPessoa::findById($indicacao['id_usuario']);
                $new = new Indicacao();
                $new = $new->createRow($indicacao);
                $new->save();
            }
            $connexao->commit();
        } catch (Exception $e) {
            $connexao->rollBack();
            fwrite($log, "=========== Erro : " . $e->getMessage() . " ============== \n");
            return false;
        }
        return true;
    }

    private function migrarUsuarios($dadosConexao, $log)
    {
        $connexao = new Zend_Db_Adapter_Pdo_Mysql($dadosConexao);
        $connexao = $connexao->beginTransaction();

        try {
            $usuarios = $connexao->select()->from(array('u' => TB_USUARIO), '*')
                ->query()->fetchAll();

            //Registro de Log
            fwrite($log, "-----------------------------------------------------------------------------:\n");
            fwrite($log, "MIGRANDO USUARIOS (" . count($usuarios) . "):\n");
            fwrite($log, "-----------------------------------------------------------------------------:\n");
            foreach ($usuarios as $usuario) {
                $usuario['id'] = TmpPessoa::findById($usuario['id']);
                $new = new Db_Usuario();
                $new->createRow($usuario);

                //Registro de Log
                fwrite($log, "Usuario: " . $usuario['login'] . "\n");
            }
            $connexao->commit();
        } catch (Exception $e) {
            $connexao->rollBack();
            fwrite($log, "=========== Erro : " . $e->getMessage() . " ============== \n");
            return false;
        }
        return true;
    }

    //Migra os contatos realizados (relacionamento)
    private function migrarContatos($id, $dadosConexao, $log)
    {
        $connexao = new Zend_Db_Adapter_Pdo_Mysql($dadosConexao);
        $connexao = $connexao->beginTransaction();

        try {
            $contatos = $connexao->select()->from(array('con' => TB_RELACIONAMENTO), '*')
                ->join(array('c' => TB_CONTRATO), 'c.id = con.idContrato', null)
                ->join(array('l' => TB_LOTES), 'c.id_lote = l.id', null)
                ->where('l.id_empreendimento = ?', $id)
                ->query()->fetchAll();

            //Registro de Log
            fwrite($log, "-----------------------------------------------------------------------------:\n");
            fwrite($log, "MIGRANDO RELACIONAMENTOS (CONTATOS) (" . count($contatos) . "):\n");
            fwrite($log, "-----------------------------------------------------------------------------:\n");
            foreach ($contatos as $contato) {
                //Registro de Log
                fwrite($log, "Contato: " . $contato['id'] . ' - Contrato: ' . $contato['idContrato'] . ' - Assunto: ' . $contato['assunto'] . "\n");

                $contato['id'] = null;
                $contato['idContrato'] = TmpContrato::findById($contato['idContrato']);
                $contato['usuario'] = TmpPessoa::findById($contato['usuario']);
                $new = new Relacionamento();
                $new->createRow($contato);
            }
            $connexao->commit();
        } catch (Exception $e) {
            $connexao->rollBack();
            fwrite($log, "=========== Erro : " . $e->getMessage() . " ============== \n");
            return false;
        }
        return true;
    }

    //Migra as transferencias (e de lote)
    private function migrarTransferencias($id, $dadosConexao, $log)
    {
        $connexao = new Zend_Db_Adapter_Pdo_Mysql($dadosConexao);
        $connexao = $connexao->beginTransaction();

        try {

            $transferencias = $connexao->select()->from(array('t' => TB_TRANSFERENCIA), '*')
                ->join(array('c' => TB_CONTRATO), 'c.id_pessoa = t.idContrato', null)
                ->join(array('l' => TB_LOTES), 'c.id_lote = l.id', null)
                ->where('l.id_empreendimento = ?', $id)
                ->query()->fetchAll();

            //Registro de Log
            fwrite($log, "-----------------------------------------------------------------------------:\n");
            fwrite($log, "MIGRANDO TRANSFERENCIAS (" . count($transferencias) . "):\n");
            fwrite($log, "-----------------------------------------------------------------------------:\n");
            foreach ($transferencias as $transferencia) {
                //Registro de Log
                fwrite($log, "Transferencia: " . $transferencia['id'] . ' - Cedente: ' . $transferencia['idCedente']
                    . ' - Receptor: ' . $transferencia['idReceptor'] . "\n");

                $idTransOld = $transferencia['id'];
                $transferencia['id'] = null;
                $transferencia['idContrato'] = TmpContrato::findById($transferencia['idContrato']);
                $transferencia['idCedente'] = TmpPessoa::findById($transferencia['idCedente']);
                $transferencia['idReceptor'] = TmpPessoa::findById($transferencia['idReceptor']);
                $new = new Transferencia();
                $idTransNew = $new->createRow($transferencia);

                $transfCes = $connexao->select()->from(array('tc' => TB_TRANSFERENCIA_CESSIONARIOS), '*')
                    ->where('tc.id_transferencia = ?', $idTransOld)
                    ->query()->fetchAll();

                if (count($transfCes)) {
                    foreach ($transfCes as $transferenciaCedente) {
                        //Registro de Log
                        fwrite($log, "  >  Transferencia Cedente: " . $transferenciaCedente['id_transferencia'] . ' - Pessoa: ' . $transferenciaCedente['id_cessionario'] . "\n");

                        $transferenciaCedente['id'] = $idTransNew;
                        $transferenciaCedente['id_cessionario'] = TmpPessoa::findById($transferenciaCedente['id_cessionario']);

                        $new = new TransferenciaCessionarios();
                        $idTransNew = $new->createRow($transferenciaCedente);
                    }
                }
            }

            $transferenciasLote = $connexao->select()->from(array('t' => TB_TRANSFERENCIA_LOTE), '*')
                ->join(array('c' => TB_CONTRATO), 'c.id_pessoa = t.id_contrato', null)
                ->join(array('l' => TB_LOTES), 'c.id_lote = l.id', null)
                ->where('l.id_empreendimento = ?', $id)
                ->query()->fetchAll();

            //Registro de Log
            fwrite($log, "-----------------------------------------------------------------------------:\n");
            fwrite($log, "MIGRANDO TRANSFERENCIAS DE LOTE (" . count($transferenciasLote) . "):\n");
            fwrite($log, "-----------------------------------------------------------------------------:\n");
            foreach ($transferenciasLote as $transferencia) {
                //Registro de Log
                fwrite($log, "Transferencia: " . $transferencia['id_transferencia_lote'] . ' - Origem: ' . $transferencia['id_lote_origem']
                    . ' - Destino: ' . $transferencia['id_lote_destino'] . "\n");

                $transferencia['id_transferencia_lote'] = null;
                $transferencia['id_contrato'] = TmpContrato::findById($transferencia['id_contrato']);
                $transferencia['id_lote_origem'] = TmpLote::findById($transferencia['id_lote_origem']);
                $transferencia['id_lote_destino'] = TmpLote::findById($transferencia['id_lote_destino']);
                $new = new TransferenciaLote();
                $new->createRow($transferencia);
            }

            $connexao->commit();
        } catch (Exception $e) {
            $connexao->rollBack();
            fwrite($log, "=========== Erro : " . $e->getMessage() . " ============== \n");
            return false;
        }
        return true;
    }

    // Migra as tabelas menos utilizadas: TAXAS, DOWNLOADS
    private function migrarSecundarias($id, $dadosConexao, $log, $novoId)
    {
        $connexao = new Zend_Db_Adapter_Pdo_Mysql($dadosConexao);
        $connexao = $connexao->beginTransaction();

        try {
            $taxas = $connexao->select()->from(array('t' => TB_TAXA_VALOR))
                ->where('t.id_empreendimento = ?', $id)
                ->query()->fetchAll();
            $arrayTaxas = array();

            //Registro de Log
            fwrite($log, "-----------------------------------------------------------------------------:\n");
            fwrite($log, "MIGRANDO TAXAS (" . count($taxas) . "):\n");
            fwrite($log, "-----------------------------------------------------------------------------:\n");
            foreach ($taxas as $taxa) {
                fwrite($log, $taxa['id_taxas'] . ' - ' . $taxa['id_tipo_taxa'] . "\n");

                $idAntigo = $taxa['id_taxas'];
                $taxa['id_taxas'] = null;
                $taxa['id_empreendimento'] = $novoId;
                $new = new TaxaValor();
                $new = $new->createRow($taxa);
                $idNovo = $new->save();

                $arrayTaxas[$idAntigo] = $idNovo;
            }

            $taxas = array();
            foreach ($arrayTaxas as $k => $taxa) {
                $taxas[] = $k;
            }

            if (count($taxas)) {
                $recibos = $connexao->select()->from(array('r' => TB_RECIBO))
                    ->where('r.id_taxa IN (?)', $taxas)
                    ->query()->fetchAll();

                //Registro de Log
                fwrite($log, "-----------------------------------------------------------------------------:\n");
                fwrite($log, "MIGRANDO RECIBOS (" . count($recibos) . "):\n");
                fwrite($log, "-----------------------------------------------------------------------------:\n");
                foreach ($recibos as $recibo) {
                    fwrite($log, $recibo['id_recibo'] . ' - Taxa: ' . $recibo['id_taxa'] . " - Valor: " . $recibo['vl_recibo'] . "\n");

                    $recibo['id_recibo'] = null;
                    $recibo['id_taxa'] = $arrayTaxas[$recibo['id_taxa']]['id_taxas'];
                    $recibo['id_pessoa'] = TmpPessoa::findById($recibo['id_pessoa']);
                    $new = new Recibo();
                    $new = $new->createRow($recibo);
                    $new->save();
                }
            }

            $confissoes = $connexao->select()->from(array('con' => TB_CONFISSAO_LOTE), null)
                ->join(array('l' => TB_LOTES), 'con.idLote = l.id', null)
                ->join(array('c' => TB_CONFISSAO), 'con.idConfissao = c.id', '*')
                ->where('l.id_empreendimento = ?', $id)
                ->group('c.id')
                ->query()->fetchAll();
            $auxConfissoes = array();

            //Registro de Log
            fwrite($log, "-----------------------------------------------------------------------------:\n");
            fwrite($log, "MIGRANDO CONFISSOES (" . count($confissoes) . "):\n");
            fwrite($log, "-----------------------------------------------------------------------------:\n");
            foreach ($confissoes as $confissao) {
                fwrite($log, $confissao['id'] . ' - Valor: ' . $confissao['valor'] . ' - Garantia: ' . $confissao['garantia'] . "\n");

                $idAntigo = $confissao['id'];
                $confissao['id'] = null;
                $new = new Confissao();
                $new = $new->createRow($confissao);
                $idNovo = $new->save();

                $auxConfissoes[$idAntigo] = $idNovo;
            }

            $confissoesLote = $connexao->select()->from(array('con' => TB_CONFISSAO_LOTE), '*')
                ->join(array('l' => TB_LOTES), 'con.idLote = l.id', null)
                ->where('l.id_empreendimento = ?', $id)
                ->query()->fetchAll();

            //Registro de Log
            fwrite($log, "-----------------------------------------------------------------------------:\n");
            fwrite($log, "MIGRANDO CONFISSOES LOTE (" . count($confissoesLote) . "):\n");
            fwrite($log, "-----------------------------------------------------------------------------:\n");
            foreach ($confissoesLote as $confissao) {
                fwrite($log, $confissao['id'] . ' - Lote: ' . $confissao['idLote'] . ' Confissao: ' . $confissao['idConfissao'] . "\n");

                $confissao['id'] = null;
                $confissao['idLote'] = TmpLote::findById($confissao['idLote']);
                $confissao['idConfissao'] = $auxConfissoes[$confissao['idConfissao']];
                $new = new ConfissaoLote();
                $new = $new->createRow($confissao);
                $new->save();
            }

            $cartas = $connexao->select()->from(array('c' => TB_CARTA_COBRANCA), '*')
                ->query()->fetchAll();

            $newCartas = array();

            //Registro de Log
            fwrite($log, "-----------------------------------------------------------------------------:\n");
            fwrite($log, "MIGRANDO MODELOS DE CARTA COBRANA (" . count($cartas) . "):\n");
            fwrite($log, "-----------------------------------------------------------------------------:\n");
            foreach ($cartas as $carta) {
                fwrite($log, 'Carta: ' . $carta['cd_carta_cobranca'] . ' ' . $carta['nm_titulo_carta'] . "\n");

                $idAntigo = $carta['cd_carta_cobranca'];
                $carta['cd_carta_cobranca'] = null;
                $new = new Carta_Cobranca();
                $new = $new->createRow($carta);
                $idNovo = $new->save();

                $newCartas[$idAntigo] = $idNovo;
            }

            $historicoCartas = $connexao->select()->from(array('hc' => TB_CARTA_HISTORICO), '*')
                ->join(array('c' => TB_CONTRATO), 'c.id = hc.id_contrato', null)
                ->join(array('l' => TB_LOTES), 'c.id_lote = l.id', null)
                ->where('l.id_empreendimento = ?', $id)
                ->query()->fetchAll();

            //Registro de Log
            fwrite($log, "-----------------------------------------------------------------------------:\n");
            fwrite($log, "MIGRANDO CARTAS ENVIADAS (" . count($historicoCartas) . "):\n");
            fwrite($log, "-----------------------------------------------------------------------------:\n");
            foreach ($historicoCartas as $hCarta) {
                fwrite($log, 'Carta: ' . $hCarta['id_carta_cobranca'] . ' - Contrato ' . $hCarta['id_contrato'] . "\n");

                $hCarta['id_contrato'] = TmpContrato::findById($hCarta['id_contrato']);
                $hCarta['id_carta_cobranca'] = isset($newCartas[$hCarta['id_carta_cobranca']]) ? $newCartas[$hCarta['id_carta_cobranca']] : $hCarta['id_carta_cobranca'];
                $new = new CartaHistorico();
                $new = $new->createRow($hCarta);
                $new->save();
            }

            $reajustes = $connexao->select()->from(array('h' => TB_HISTORICO_REAJUSTE), '*')
                ->join(array('c' => TB_CONTRATO), 'c.id = h.idContrato', null)
                ->join(array('l' => TB_LOTES), 'c.id_lote = l.id', null)
                ->where('l.id_empreendimento = ?', $id)
                ->query()->fetchAll();

            //Registro de Log
            fwrite($log, "-----------------------------------------------------------------------------:\n");
            fwrite($log, "MIGRANDO REAJUSTES (" . count($reajustes) . "):\n");
            fwrite($log, "-----------------------------------------------------------------------------:\n");
            foreach ($reajustes as $reajuste) {
                fwrite($log, 'Reajuste: ' . $reajuste['id'] . ' - Contrato ' . $reajuste['idContrato'] . "\n");

                $reajuste['id'] = null;
                $reajuste['idContrato'] = TmpContrato::findById($reajuste['idContrato']);
                $new = new HistoricoReajuste();
                $new = $new->createRow($reajuste);
                $new->save();
            }

            $sinais = $connexao->select()->from(array('s' => TB_SINAL), '*')
                ->join(array('c' => TB_CONTRATO), 'c.id = s.idContrato', null)
                ->join(array('l' => TB_LOTES), 'c.id_lote = l.id', null)
                ->where('l.id_empreendimento = ?', $id)
                ->query()->fetchAll();

            //Registro de Log
            fwrite($log, "-----------------------------------------------------------------------------:\n");
            fwrite($log, "MIGRANDO SINAIS (" . count($sinais) . "):\n");
            fwrite($log, "-----------------------------------------------------------------------------:\n");
            foreach ($sinais as $sinal) {
                fwrite($log, 'Sinal: ' . $sinal['id'] . ' - Contrato: ' . $sinal['idContrato'] . "\n");

                $sinal['id'] = null;
                $sinal['idContrato'] = TmpContrato::findById($sinal['idContrato']);
                $new = new Sinal();
                $new = $new->createRow($sinal);
                $new->save();
            }

            $contratoPessoas = $connexao->select()->from(array('cp' => TB_CONTRATO_PESSOA), '*')
                ->join(array('c' => TB_CONTRATO), 'c.id = cp.id_contrato', null)
                ->join(array('l' => TB_LOTES), 'c.id_lote = l.id', null)
                ->where('l.id_empreendimento = ?', $id)
                ->query()->fetchAll();

            //Registro de Log
            fwrite($log, "-----------------------------------------------------------------------------:\n");
            fwrite($log, "MIGRANDO CONTRATO PESSOAS (" . count($contratoPessoas) . "):\n");
            fwrite($log, "-----------------------------------------------------------------------------:\n");
            foreach ($contratoPessoas as $contratoPessoa) {
                fwrite($log, 'Pessoa: ' . $contratoPessoa['id_pessoa'] . ' - Contrato: ' . $contratoPessoa['id_contrato'] . "\n");

                $contratoPessoa['id_contrato_pessoa'] = null;
                $contratoPessoa['id_contrato'] = TmpContrato::findById($contratoPessoa['id_contrato']);
                $contratoPessoa['id_pessoa'] = TmpPessoa::findById($contratoPessoa['id_pessoa']);
                $new = new ContratoPessoa();
                $new = $new->createRow($contratoPessoa);
                $new->save();
            }

            $aditivos = $connexao->select()->from(array('a' => TB_ADITIVO), '*')
                ->join(array('c' => TB_CONTRATO), 'c.id = a.id_contrato', null)
                ->join(array('l' => TB_LOTES), 'c.id_lote = l.id', null)
                ->where('l.id_empreendimento = ?', $id)
                ->query()->fetchAll();

            //Registro de Log
            fwrite($log, "-----------------------------------------------------------------------------:\n");
            fwrite($log, "MIGRANDO ADITIVOS (" . count($aditivos) . "):\n");
            fwrite($log, "-----------------------------------------------------------------------------:\n");
            foreach ($aditivos as $aditivo) {
                fwrite($log, 'Aditivo: ' . $aditivo['id_aditivo'] . ' - Contrato: ' . $aditivo['id_contrato'] . "\n");

                $aditivo['id_aditivo'] = null;
                $aditivo['id_contrato'] = TmpContrato::findById($aditivo['id_contrato']);
                $new = new ContratoPessoa();
                $new = $new->createRow($aditivo);
                $new->save();
            }

            $downloads = $connexao->select()->from(array('d' => TB_DOWNLOAD))
                ->where('d.id_emp = ?', $id)
                ->query()->fetchAll();

            //Registro de Log
            fwrite($log, "-----------------------------------------------------------------------------:\n");
            fwrite($log, "MIGRANDO DOWNLOADS (" . count($downloads) . "):\n");
            fwrite($log, "-----------------------------------------------------------------------------:\n");
            foreach ($downloads as $download) {
                fwrite($log, $download['id'] . ' - ' . $download['nm_download'] . "\n");

                $download['id'] = null;
                $download['id_emp'] = $novoId;
                $new = new Download();
                $new = $new->createRow($download);
                $new->save();
            }

            $connexao->commit();
        } catch (Exception $e) {
            fwrite($log, "=========== Erro : " . $e->getMessage() . " ============== \n");
            $connexao->rollBack();
            return false;
        }
        return true;
    }

    // Migra as tabelas usadas pelo painel de vendas
    private function migrarTabelasPainel($id, $dadosConexao, $log, $novoId)
    {
        $connexao = new Zend_Db_Adapter_Pdo_Mysql($dadosConexao);
        $connexao = $connexao->beginTransaction();

        try {
            $tabelasPreco = $connexao->select()->from(array('t' => TB_TABELA_PRECO))
                ->where('t.id_empreendimento = ?', $id)
                ->query()->fetchAll();

            //Registro de Log
            fwrite($log, "-----------------------------------------------------------------------------:\n");
            fwrite($log, "MIGRANDO TABELAS DE PRECO (" . count($tabelasPreco) . "):\n");
            fwrite($log, "-----------------------------------------------------------------------------:\n");
            foreach ($tabelasPreco as $tabela) {
                fwrite($log, $tabela['id_tabela_preco'] . ' - ' . $tabela['nm_tabela'] . "\n");

                $tabelasPrecoLotes = $connexao->select()->from(array('t' => TB_TABELA_PRECO_LOTES))
                    ->where('t.id_tabela_preco = ?', $tabela['id_tabela_preco'])
                    ->query()->fetchAll();

                $tabela['id_tabela_preco'] = null;
                $tabela['id_empreendimento'] = $novoId;
                $new = new TabelaPreco();
                $new = $new->createRow($tabela);
                $idTabela = $new->save();

                foreach ($tabelasPrecoLotes as $tabelaLote) {
                    fwrite($log, ' > ' . $tabelaLote['id_tabela_preco_lotes'] . ' - ' . $tabelaLote['id_lote'] . "\n");

                    $tabelaLote['id_tabela_preco_lotes'] = null;
                    $tabelaLote['id_tabela_preco'] = $idTabela;
                    $tabelaLote['id_lote'] = TmpLote::findById($tabelaLote['id_lote']);
                    $newTabelaLote = new TabelaPrecoLote();
                    $newTabelaLote = $newTabelaLote->createRow($tabelaLote);
                    $newTabelaLote->save();
                }
            }

            $parametrosComissao = $connexao->select()->from(array('pc' => TB_PARAMETRO_COMISSAO), '*')
                ->where('pc.id_empreendimento = ?', $id)
                ->query()->fetchAll();

            //Registro de Log
            fwrite($log, "-----------------------------------------------------------------------------:\n");
            fwrite($log, "MIGRANDO PARAMETROS DE COMISSAO (" . count($parametrosComissao) . "):\n");
            fwrite($log, "-----------------------------------------------------------------------------:\n");
            foreach ($parametrosComissao as $parametroComissao) {
                fwrite($log, 'Parmetro Comisso: ' . $parametroComissao['id_parametro_comissao'] . "\n");

                $aditivo['id_parametro_comissao'] = null;
                $aditivo['id_empreendimento'] = $novoId;
                $new = new ParametroComissao();
                $new = $new->createRow($aditivo);
                $new->save();
            }

            $parcelasComissaoCorretor = $connexao->select()->from(array('pc' => TB_PARCELA_COMISSAO_CORRETOR), '*')
                ->join(array('c' => TB_CONTRATO), 'c.id = pc.id_contrato', null)
                ->join(array('l' => TB_LOTES), 'c.id_lote = l.id', null)
                ->where('l.id_empreendimento = ?', $id)
                ->query()->fetchAll();

            //Registro de Log
            fwrite($log, "-----------------------------------------------------------------------------:\n");
            fwrite($log, "MIGRANDO PARCELAS DE COMISSAO CORRETOR (" . count($parcelasComissaoCorretor) . "):\n");
            fwrite($log, "-----------------------------------------------------------------------------:\n");
            foreach ($parcelasComissaoCorretor as $parcela) {
                fwrite($log, 'Parcela Comisso: ' . $parcela['id_parcela'] . "\n");

                $parcela['id_parcela'] = null;
                $parcela['id_contrato'] = TmpContrato::findById($parcela['id_contrato']);
                $new = new ParcelaComissaoCorretor();
                $new = $new->createRow($parcela);
                $new->save();
            }

            $parcelasComissaoImobiliaria = $connexao->select()->from(array('pc' => TB_PARCELA_COMISSAO_IMOBILIARIA), '*')
                ->join(array('c' => TB_CONTRATO), 'c.id = pc.id_contrato', null)
                ->join(array('l' => TB_LOTES), 'c.id_lote = l.id', null)
                ->where('l.id_empreendimento = ?', $id)
                ->query()->fetchAll();

            //Registro de Log
            fwrite($log, "-----------------------------------------------------------------------------:\n");
            fwrite($log, "MIGRANDO PARCELAS DE COMISSAO IMOBILIARIA (" . count($parcelasComissaoImobiliaria) . "):\n");
            fwrite($log, "-----------------------------------------------------------------------------:\n");
            foreach ($parcelasComissaoImobiliaria as $parcela) {
                fwrite($log, 'Parcela Comisso: ' . $parcela['id_parcela_imobiliaria'] . "\n");

                $parcela['id_parcela_imobiliaria'] = null;
                $parcela['id_contrato'] = TmpContrato::findById($parcela['id_contrato']);
                $new = new ParcelaComissaoImobiliaria();
                $new = $new->createRow($parcela);
                $new->save();
            }

            $reservas = $connexao->select()->from(array('r' => TB_RESERVA_LOTE), '*')
                ->join(array('l' => TB_LOTES), 'r.cod_lote = l.id', null)
                ->where('l.id_empreendimento = ?', $id)
                ->query()->fetchAll();

            //Registro de Log
            fwrite($log, "-----------------------------------------------------------------------------:\n");
            fwrite($log, "MIGRANDO RESERVAS DE LOTE (" . count($reservas) . "):\n");
            fwrite($log, "-----------------------------------------------------------------------------:\n");
            foreach ($reservas as $reserva) {
                fwrite($log, 'Reserva: ' . $reserva['id'] . ' - Lote: ' . $reserva['cod_lote'] . "\n");

                $reserva['id'] = null;
                $reserva['cod_lote'] = TmpLote::findById($reserva['cod_lote']);
                $reserva['id_usuario_cancelou'] = TmpPessoa::findById($reserva['id_usuario_cancelou']);
                $new = new ReservaLote();
                $new = $new->createRow($reserva);
                $new->save();
            }

            $connexao->commit();
        } catch (Exception $e) {
            fwrite($log, "=========== Erro : " . $e->getMessage() . " ============== \n");
            $connexao->rollBack();
            return false;
        }
        return true;
    }

    public function connectarAction()
    {
        if ($this->_isPost && $this->isAjax()) {
            $dadosConexao = array(
                'dbname' => $_POST['nmBanco'],
                'host' => $_POST['host'],
                'username' => $_POST['usuario'],
                'password' => $_POST['senha']
            );
            try {
                $connection = new Zend_Db_Adapter_Pdo_Mysql($dadosConexao);
                $connection->getConnection();

                $empreendimentos = $connection->select()
                    ->from(array('e' => TB_EMPREENDIMENTO, array('id', 'nm_empreendimento')))
                    ->order('nm_empreendimento')
                    ->query()->fetchAll();
                foreach ($empreendimentos as &$e) {
                    $e['nm_empreendimento'] = utf8_encode($e['nm_empreendimento']);
                    $e['rgi'] = utf8_encode($e['rgi']);
                    $e['bairro'] = utf8_encode($e['bairro']);
                }

                echo json_encode($empreendimentos);
            } catch (Exception $e) {
                echo json_encode(array('erro' => utf8_encode($e->getMessage())));
            }
        }
    }

    private function validar()
    {
        $campos = array("nmBanco", "host", "usuario", "senha", "empreendimento");

        foreach ($campos as $cp) {
            if ($_POST [$cp] == '') {
                switch ($cp) {
                    case "nmBanco" :
                        $msg = "O campo Banco de Dados deve ser preenchido.";
                        break;
                    case "host" :
                        $msg = "O campo Host deve ser preenchido.";
                        break;
                    case "usuario" :
                        $msg = "O campo Usurio deve ser preenchido.";
                        break;
                    case "senha" :
                        $msg = "O campo Senha deve ser preenchido.";
                        break;
                    case "empreendimento" :
                        $msg = "O campo Empreendimento deve ser preenchido.";
                        break;
                }
                if (!empty($msg))
                    $this->_helper->addMensagem($cp, $msg);
                $msg = '';
            }
        }

        return !(count($this->_helper->getMensagens()) > 0);
    }

}
