<?php
class LoginController extends Controller {

    protected $tb_log_acesso;
    private $cliente;

    //Funo pblica do construtor
    public function __construct($request)
    {
        parent::__construct($request);

        $this->tb_log_acesso = new LogAcesso();
        $this->cliente = new ClienteAcade();
    }

    public function indexAction(){
        $moedas = array(
            "usd" => array("nome" => "Dlar Americano", "simbolo" => "&#36;", "simboloLiteral" => "$"),
            "eur" => array("nome" => "Euro", "simbolo" => "&#8364;", "simboloLiteral" => "?"),
            "gbp" => array("nome" => "Libra Esterlina", "simbolo" => "&#163;", "simboloLiteral" => ""),
            "jpy" => array("nome" => "Iene Japons", "simbolo" => "&#165;", "simboloLiteral" => ""),
            "aud" => array("nome" => "Dlar Australiano", "simbolo" => "A&#36;", "simboloLiteral" => "A$"),
            "cad" => array("nome" => "Dlar Canadense", "simbolo" => "C&#36;", "simboloLiteral" => "C$"),
            "chf" => array("nome" => "Franco Suo", "simbolo" => "CHF", "simboloLiteral" => "CHF"),
            "cny" => array("nome" => "Yuan Chins", "simbolo" => "&#165;", "simboloLiteral" => ""),
            "inr" => array("nome" => "Rupia Indiana", "simbolo" => "&#8377;", "simboloLiteral" => "?"),
            "brl" => array("nome" => "Real Brasileiro", "simbolo" => "&#82;&#36;", "simboloLiteral" => "R$"),
            "rub" => array("nome" => "Rublo Russo", "simbolo" => "&#8381;", "simboloLiteral" => "?"),
            "zar" => array("nome" => "Rand Sul-Africano", "simbolo" => "R", "simboloLiteral" => "R"),
            "sgd" => array("nome" => "Dlar de Singapura", "simbolo" => "S&#36;", "simboloLiteral" => "S$"),
            "nzd" => array("nome" => "Dlar Neozelands", "simbolo" => "NZ&#36;", "simboloLiteral" => "NZ$"),
            "mxn" => array("nome" => "Peso Mexicano", "simbolo" => "&#36;", "simboloLiteral" => "$"),
        
            "ars" => array("nome" => "Peso Argentino", "simbolo" => "&#36;", "simboloLiteral" => "$"),
            "bob" => array("nome" => "Boliviano", "simbolo" => "Bs.", "simboloLiteral" => "Bs."),
            "clp" => array("nome" => "Peso Chileno", "simbolo" => "&#36;", "simboloLiteral" => "$"),
            "cop" => array("nome" => "Peso Colombiano", "simbolo" => "&#36;", "simboloLiteral" => "$"),
            "pyg" => array("nome" => "Guarani Paraguaio", "simbolo" => "&#8370;", "simboloLiteral" => "?"),
            "pen" => array("nome" => "Sol Peruano", "simbolo" => "S/", "simboloLiteral" => "S/"),
            "uyu" => array("nome" => "Peso Uruguaio", "simbolo" => "\$U", "simboloLiteral" => "\$U"),
            "ves" => array("nome" => "Bolvar Venezuelano", "simbolo" => "Bs.", "simboloLiteral" => "Bs."),
            "gyd" => array("nome" => "Dlar da Guiana", "simbolo" => "&#36;", "simboloLiteral" => "$"),
            "fkp" => array("nome" => "Libra das Ilhas Malvinas", "simbolo" => "&#163;", "simboloLiteral" => "")
        );
        
        
        $tb_cliente = new Db_Cliente();
        $nomeCliente = $tb_cliente->fetchRow();
        $this->set('nomeCliente', $nomeCliente);
        $_SESSION['clienteId'] = $nomeCliente->fl_senhaportal;
        $_SESSION['moeda'] = $nomeCliente->moeda;
        $_SESSION['simboloMoeda'] = $moedas[$nomeCliente->moeda]["simbolo"];
        $_SESSION['nomeMoeda'] = $moedas[$nomeCliente->moeda]["nome"];
        $_SESSION['comunicacao'] = $nomeCliente->fl_comunicacao;
      
        $imgSlide = Controller::getAdapterAcadeGeral()->select()
            ->from(array('s' => TB_SLIDESHOW), '*')
            ->join(array('si' => TB_SLIDESHOW_SISTEMA), 's.id_slideshow = si.id_slideshow','*')
            ->where('id_sistema = 1')
            ->where('fl_ativo = 1')
            ->where('mapa = "0"')
            ->query()->fetchAll();
        
        //embaralha as imagens do slide.
        shuffle($imgSlide);

        $this->set('imgSlide', $imgSlide);
        $this->display();
    }

    public function autenticarAction(){
        $login = new Login();

        //Aceita apenas letras e numeros
        $txtLogin = preg_replace('/[^[:alnum:]_]/', '', $_POST["txt_login"]);
        $txtSenha = md5($_POST["txt_senha"]);

        $login->setLogin($txtLogin);
        $login->setSenha($txtSenha);

        $tpUsuario = Db_Usuario::fetchByLogin($txtLogin, $txtSenha);

        if ($tpUsuario && $tpUsuario->getSuper() != '1') {
            $tb_cliente = new Db_Cliente();

            $cliente = $tb_cliente->fetchRow();

            if ($cliente['fl_situacao'] == 'S') {
                $this->_helper->addMensagem("mensagem", utf8_decode("Seu sistema est suspenso. Por favor, entre em contato com o suporte Acade."));
                $login->logout();
                $this->display("index");
                exit;
            } elseif ($cliente['fl_situacao'] == 'M') {
                $this->_helper->addMensagem("mensagem", utf8_decode("Seu sistema est em manuteno. Por favor, aguarde ou entre em contato com o suporte Acade."));
                $login->logout();
                $this->display("index");
                exit;
            }
        }

        try {
            $login->autenticar();
            $this->adicionarlogAction();
            $nmDominio = "";
            $url = explode('.', $_SERVER['HTTP_HOST']);
            if ($url[0] == 'www') {
                $nmDominio = $url[1];
            } else {
                $nmDominio = $url[0];
            }
            if($tpUsuario->getSuper() != '1'){
                $clientes_acade = Controller::getAdapterAcadeGeral()->select()
                ->from(array('s' => TB_CLIENTE_ACADE), '*')
                ->where("nm_dominio  = ?",$nmDominio)
                ->query()->fetch();
                if(!$clientes_acade['estado_cliente']){
                    $cliente = $this->cliente->get(true);
                    Controller::getAdapterAcadeGeral()->update(TB_CLIENTE_ACADE,array('ultimo_acesso'=>date('Y-m-d'),'status_painel'=>1,'estado_cliente'=>$cliente['uf']),'nm_dominio  = "'.$nmDominio.'"');
                }
                else{
                    Controller::getAdapterAcadeGeral()->update(TB_CLIENTE_ACADE,array('ultimo_acesso'=>date('Y-m-d')),'nm_dominio  = "'.$nmDominio.'"');
                }
            }
            
            $nmDominio = "";
            $url = explode('.', $_SERVER['HTTP_HOST']);
            if ($url[0] == 'www') {
                $nmDominio = $url[1];
            } else {
                $nmDominio = $url[0];
            }
            $curl = curl_init();

            curl_setopt_array($curl, array(
            CURLOPT_URL => 'https://api.acade.com.br/auth/atualizarSenha',
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => '',
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 0,
            CURLOPT_FOLLOWLOCATION => true,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => 'POST',
            CURLOPT_POSTFIELDS => array('id' => Login::getUsuario()->getId(),'cliente' => $nmDominio,'senha' => $_POST["txt_senha"]),
            ));

            $response = curl_exec($curl);
            curl_close($curl);
            $this->redir(array("controller" => "admin", "action" => "index"));
        } catch (LoginOutOfTimeException $e) {
            $this->redir(array("modulo" => "sc", "controller" => "login", "action" => "index"), array('exception' => utf8_decode('Sua conta expirou entre em contato com o administrador.')));
        } catch (LoginNotMatchException $e) {
            $this->redir(array("modulo" => "sc", "controller" => "login", "action" => "index"), array('exception' => utf8_decode('Usurio e/ou senha invlidos.')));
        } catch (LoginDisabledUserException $e) {
            $this->redir(array("modulo" => "sc", "controller" => "login", "action" => "index"), array('exception' => utf8_decode('Usurio Inativo.')));
        } catch (LoginSemPermissaoException $e) {
            $this->redir(array("modulo" => "sc", "controller" => "login", "action" => "index"), array('exception' => utf8_decode('O usurio no possui permisso de acesso!')));
        }
    }

    public function alterarAction(){
        if($_SERVER['REQUEST_METHOD'] == "GET"){
            //@todo nothing
        }elseif($_SERVER['REQUEST_METHOD'] == "POST"){
            $senhaAtual = md5($_POST["senha_atual"]);
            $novaSenha = array_unique(array($_POST["nova_senha1"],$_POST["nova_senha2"]));

            foreach(array("senha_atual","nova_senha1") as $c){
                if(!$_POST[$c] || empty($_POST[$c])){
                    $this->_helper->addMensagem('danger',utf8_decode("O campo no deve estar vazio."));
                }
            }


            if(Login::getUsuario()->getSenha() == $senhaAtual){
                if(count($novaSenha) > 1){
                    $this->_helper->addMensagem("danger",utf8_decode("A nova senha no confere, elas devem combinar."));
                }else{
                    $usuario = Login::getUsuario();
                    if ($usuario->getSenha() == md5($novaSenha[0])) {
                        $this->_helper->addMensagem("danger",utf8_decode("A senha utilizada j  essa digitada"));
                    } else {
                        $usuario->setSenha(md5($novaSenha[0]));
                        $usuario->save();

                        $nmDominio = "";
                        $url = explode('.', $_SERVER['HTTP_HOST']);
                        if ($url[0] == 'www') {
                            $nmDominio = $url[1];
                        } else {
                            $nmDominio = $url[0];
                        }
                        $curl = curl_init();

                        curl_setopt_array($curl, array(
                        CURLOPT_URL => 'https://api.acade.com.br/auth/atualizarSenha',
                        CURLOPT_RETURNTRANSFER => true,
                        CURLOPT_ENCODING => '',
                        CURLOPT_MAXREDIRS => 10,
                        CURLOPT_TIMEOUT => 0,
                        CURLOPT_FOLLOWLOCATION => true,
                        CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                        CURLOPT_CUSTOMREQUEST => 'POST',
                        CURLOPT_POSTFIELDS => array('id' => Login::getUsuario()->getId(),'cliente' => $nmDominio,'senha' => $_POST['nova_senha1']),
                        ));

                        $response = curl_exec($curl);
                        $error = curl_error($curl);


                        if ($error !== '') {
                            var_dump($error);
                            die;
                        }
                        curl_close($curl);
                        $this->redir(array("controller" => "login", 'action'=>'alterar'),array('msg'=>'OK'));
                    }
                }
            }else{
                $this->_helper->addMensagem("naoConfere",utf8_decode("A senha digitada no confere com  a do usurio logado."));
            }

        }
        $this->display();
    }

    public function logoutAction(){

        //Salva o log de sada do usurio ao deslogar do sistema.
        $logDoDia = $this->tb_log_acesso->fetchRow('id_usuario = "' . Login::getUsuario()->getId() . '" ', ['dt_acesso DESC', 'hr_acesso DESC']);
        
        $logDoDia->dt_saida = date('Y-m-d');
        $logDoDia->hr_saida = date("H:i:s");

        $logDoDia->save();

        Login::logout();

        $this->redir(array("controller" => "login"));
    }

    //Funo pblica responsvel por adicionar um novo usurio
    public function adicionarlogAction()
    {
        //Carrega os campos da pessoa caso ela j exista
        $l = $this->tb_log_acesso->createRow();
        $l->id_usuario =Login::getUsuario()->getId();
        $l->dt_acesso = date("Y/m/d");
        $l->hr_acesso = date("H:i:s");
        $l->ip_acesso = $_SERVER['REMOTE_ADDR'];
        $l->fl_painel_vendas = '0';
        $l->save();
    }
}
