<?php

class LayoutController extends Controller
{ 
    private $tb_layout_itens;
    private $tb_tabela_preco;
    private $tb_tabela_preco_lotes;
    private $lotes;
    private $empreendimentos;
    private $dicionario; 
    private $tiposlayout; 

    //Funcao publica do construtor
    public function __construct($request)
    {
        parent::__construct($request);
        $this->tb_layout_itens = new LayoutItens();
        $this->tb_tabela_preco = new Layout();
        $this->tb_tabela_preco_lotes = new TabelaPrecoLote();
        $this->lotes = new Lote();
        $this->empreendimentos = new Empreendimento();
        $this->dicionario = new Dicionario(); 

        $this->tiposlayout = array(
            'REM' => 'Remessa',
            'RET' => 'Retorno',
            'APIPULSAR' => 'Api Pulsar Pay',
            'APIASAAS' => 'Api ASAAS',
            'APIPJBANK' => 'Api PJBANK',
            'APIINTER' => 'Api Inter',
            'APICRESOL' => 'Api Cresol',
            'APISICREDI' => 'Api Sicredi',
            'APIUNICRED' => 'Api Unicred',
            'APIGRAFENO' => 'Api Grafeno'
        );
    }

    /*
    * Redireciona para a ao de listar
    */
    public function indexAction()
    {
        $this->redir(array("modulo" => "sc", "controller" => "layout", 'action' => 'listar'));
    }

    //Busca na Tabela dicionario a lista de variveis cadastradas no sistema. Uso no Modal Visualizar.

    public function findVariaveisAction()
    {
        $pessoa = new Dicionario();

        $pessoa = Controller::getAdapterAcadeGeral()->select()
            ->from(array('p' => TB_DICIONARIO), array('variavel','descricao', 'id'))->where('descricao like "%Remessa%"')->query()->fetchAll();

        $ids[] = array('id' => '', 'text' => '');

        foreach ($pessoa as $p)
        {
            $ids[] = ['id' => $p['variavel'], 'text' => utf8_encode($p['descricao'])];
        }

        echo json_encode($ids);
    }

    /*
    * Exibe tela de tabela de preos e, se ha requisicao ajax, faz consulta no banco e exibe listagem de tabelas
    */
    public function listarAction()
    {
        if (Helper::verificaAjax()) {
            $listaTabela = Layout::getListLayout();

            $lista = array();
            foreach ($listaTabela as $tabela) {
                $acoes = '<div align="left">';
                $acoes .= '<form action="?m=sc&c=layout&a=editar" method="POST"> <input type="hidden" name="id" id="id" value="' . $tabela['id'] . '"></input><button type="submit" class="btn btn-default btn-xs btn-visualizar"><i class="fa fa-edit"></i></button> </form> ';
                $acoes .= '<form class="form-group" action="?m=sc&c=layout&a=duplicar" method="POST"> <input  type="hidden" name="id" id="id" value="' . $tabela['id'] . '"></input><button type="submit" title="Duplicar" class="btn btn-default btn-xs btn-visualizar"><i class="fa fa-copy"></i></button></form> ';
                $acoes .= '<form class="form-group" action="?m=sc&c=layout&a=deletar" method="POST"> <input  type="hidden" name="id" id="id" value="' . $tabela['id'] . '"></input><button type="submit" title="Apagar" class="btn btn-default btn-xs btn-visualizar"><i class="fa fa-trash"></i></button></form>';
                $acoes .= '</div>';

                $checkbox = '<div align="center" >';
                $checkbox .= '<input type="checkbox" class="rows-check" value="' . $tabela['id'] . '" id="' . $tabela['id'] . '" nomeExibidoNoDeletar="' . $tabela['nm_layout'] . '" name="linhas[]">';
                $checkbox .= '</div>';
                if($tabela['tipo_layout'] == "REM"){
                    $tipo_array = "<div style='white-space: nowrap;'>Remessa</div>";
                }elseif(strpos($tabela['tipo_layout'], "PI")){
                    $tipo_array =  "Api";
                }else{
                    $tipo_array =  "Retorno";
                }
                $lista[] = array(
                    'checkbox' => $checkbox,
                    'id_tabela_preco' => $tabela['id'],
                    'empreendimento' => $tabela['nm_layout'],
                    'tp_tabela' => $tipo_array,
                    'acoes' => $acoes
                );
            }
            
           
            echo json_encode(array(
                'draw' => $_POST['draw'],
                'recordsTotal' => '',
                'recordsFiltered' => '',
                'data' => $lista
            ));
        } else {
            $this->display('listar');
        }
    }


    public function criarAction()
    {   
        $this->set("tiposlayout", $this->tiposlayout);

        if ($this->_isPost) {
            if($_POST['tipo_layout']=='APIINTER' ){
                $adapter = Layout::setInsertLayout($_POST['nm_layout'],$_POST['ds_layout'],$_POST['tipo_layout'],$_POST['pp_token_inter'],$_POST['password_inter'],$_POST['gerar_token']);

                $this->salvarCertificado("key","certificado".$adapter.".key");
                $this->salvarCertificado("crt","certificado".$adapter.".crt");
                $this->salvarCertificado("crtWebhook","webhook".$adapter.".crt");
            }

            elseif($_POST['tipo_layout']=='APISICREDI' ){
                $adapter = Layout::setInsertLayout($_POST['nm_layout'],$_POST['ds_layout'],$_POST['tipo_layout'],$_POST['pp_token_sicredi'],$_POST['password_sicredi'],$_POST['gerar_token']);

            }

            elseif($_POST['tipo_layout']=='APIUNICRED' ){
                $adapter = Layout::setInsertLayout($_POST['nm_layout'],$_POST['ds_layout'],$_POST['tipo_layout'],$_POST['pp_token_unicred'],$_POST['password_unicred'],$_POST['gerar_token_unicred'],$_POST['req_cliente_id_unicred']);
            }
            elseif($_POST['tipo_layout']=='APIGRAFENO'){
                $adapter = Layout::setInsertLayout($_POST['nm_layout'],$_POST['ds_layout'],$_POST['tipo_layout'],$_POST['pp_token_grafeno'],null,null,null);
            }
            else{
                $adapter = Layout::setInsertLayout($_POST['nm_layout'],$_POST['ds_layout'],$_POST['tipo_layout'],$_POST['pp_token'],$_POST['password'],$_POST['gerar_token']);
            }
            $this->redir(array('modulo' => 'sc', 'controller' => 'layout', 'action' => 'listar'), array('msg' => 'success'));
        }
    
        $this->display("criar");
    }

    public function editarAction()
    {
        //Altera os dados do formulrio.
        if (isset($_POST['nm_layout'])) {
            $adapter = Layout::setUpdateLayout($_POST['id'],$_POST['nm_layout'],$_POST['tipo_layout'],
                $_POST['desc_layout'],$_POST['url_api'],$_POST['pp_token'],$_POST['password'],$_POST['req_cliente_id'],
                $_POST['tipo_retorno'],$_POST['tipo_header'],$_POST['gerar_token'],$_POST['uri_param']);
                $this->salvarCertificado("key","certificado".$_POST['id'].".key");
                $this->salvarCertificado("crt","certificado".$_POST['id'].".crt");
                $this->salvarCertificado("crtWebhook","webhook".$_POST['id'].".crt");
            $this->redir(array('modulo' => 'sc', 'controller' => 'layout', 'action' => 'listar'), array('msg' => 'success'));

        //Caso no haja alteraes, somente  exibida as informaes
        }else {
            $tabelaPrecoLotes = new LayoutItens();
            $tabelaPreco = Layout::getTabelaById($_POST['id']);
            $listaLayout = $tabelaPrecoLotes->getLayouItenstById($_POST['id'],'TODOS');
            foreach($tabelaPreco as $key=>$item){
                $tabelaPreco[$key] = str_replace('"','&#34;',$item);
            }
            $this->set("listaLayout", $listaLayout);
            $this->set("tabelaPreco", $tabelaPreco);

            $this->display("editar");
        }        
    }

    public function salvarCertificado($nome,$nomeDestino){
        //Pegando o arquivo
        if ($_FILES[$nome]['name']) {

            // Arquivo
            $up = new Filesystem();

            // Armazena o arquivo fsico
            $tmp = $_FILES[$nome]['tmp_name'];

            $path = explode('.', $_SERVER['HTTP_HOST']);
            if ($path[0] == 'www') {
                $path = $path[1];
            } else {
                $path = $path[0];
            }

            //Criando a pasta caso no tenha
            $certificadorPath = DIRETORIO_DOWNLOAD ."cliente";
            $filepath = $certificadorPath.'/'.$path.'/certificado';
            if (!is_dir($certificadorPath)) {
                mkdir($certificadorPath, 0777);
            } else if (!is_dir($filepath)) {
                mkdir($filepath, 0777);
            }

            $filepath = $filepath . '/'.$nomeDestino;
            $up->upload($tmp, $filepath);
        }
    }
    /*
     * Exibe tabela de preos para o modal de visualizar
     */
    public function visualizarAction()
    {
        $tipo_doc = explode("-",$_POST['id']);

        if ($tipo_doc[1] == 'criar'){
            $this->set('id_layout_itens', $tipo_doc[0]);
            $this->display("visualizar");   
        } else {
            //Buscando a lista de tabelas de preco
            $tabelaPrecoLotes = new LayoutItens();
            $listaLayout = $tabelaPrecoLotes->getLayoutById($tipo_doc[0]);

            //Buscando a lista de empreendimentos para o select
            $listaVariaveis = $this->dicionario->getVariaveisRemessa();
            $this->set('listaVariaveis', $listaVariaveis);
            $this->set('listaLayout', $listaLayout);
            $this->set("idTabela", $_POST['id']);
            $this->set("statusapi", $tipo_doc[1]);
            $this->display("visualizar");
        }
    }

    public function visualizarExpAction()
    {
        $listaTipos = $_POST['arraytipos']['tipos'];
        $listaColunaI = $_POST['arraytipos']['inputcolunaI'];
        $listaColunaF = $_POST['arraytipos']['inputcolunaF'];
        $listaPreenchimento = $_POST['arraytipos']['preencherTipo'];
        $listaValor = $_POST['arraytipos']['valor'];
        $linha =$_POST['linha']['linha'] ;
        $tamanho=$_POST['tamanho']['tamanho'] ;

        //Gerando os intervalos das linhas
        for ($i = 0; $i < count($listaTipos); $i++) {
            $exp .= $listaTipos[$i].":".$listaColunaI[$i]."-".$listaColunaF[$i]."+".$listaPreenchimento[$i].".".$listaValor[$i].";" . PHP_EOL;
        }
        $expressao = substr($exp,0,-1);

        if (isset($_POST['arraytipos']['tipos'][0])) {
            $auxTabela = $this->tb_layout_itens->getAdapter();
            $id_Layout_itens = $_POST['id_layout']['id_layout'];
            $id = $_POST['id']['linha'];
            try {
                if ($_POST['tipodoc']['tipodoc'] == 'inserir') {
                    if($tamanho <> ''){
                        $adapter = LayoutItens::setInsertLinha($id_Layout_itens,$linha,$tamanho,$expressao);
                    }else{
                        $adapter = LayoutItens::setInsertLinha($id_Layout_itens,$linha,0,$expressao);
                    }

                }else {
                    $tabelaLayout = new Layout();
                    $listaLayout = $tabelaLayout->getTabelaById('2');

                   if($tamanho <> '') {
                        $auxTabela->update(array('tp' => TB_LAYOUT_ITENS), array('tamanho' => $tamanho, 'linha' => $linha, 'conteudo' => $exp), 'id = ' . $id);
                    }else{
                        $auxTabela->update(array('tp' => TB_LAYOUT_ITENS), array('tamanho' => 0, 'linha' => $linha, 'conteudo' => $exp), 'id = ' . $id);
                    }
                }
            } catch (Exception $e) {
                echo "<th colspan='3'>Houve um erro, verifique :".$e->getMessage()."</th>";
            }
        }

      echo "<th width='120px' id='linhatr'>".$linha."</th><th id='linhatr1' width='120px'>".$tamanho."</th><th id='linhatr2'>".$expressao."</th>";
       
    }
    


    public function visualizarRetAction()
    {
        //Buscando a lista de Itens
        $tabelaPrecoLotes = new LayoutItens();
        $listaLayout = $tabelaPrecoLotes->getLayoutById($_GET['tipo']);

        //Setando os valores da lista de Layout
        $this->set('listaLayout', $listaLayout);
        $this->set("idTabela", $_POST['id']);
        $this->display("visualizar");
    }
    /**
     * Retorna o nmero de registros vlidos contidos na tabela selecionada.
     */
    public function contagemRegistrosAction()
    {
        //Realiza a anlise do arquivo para importar para a datatable
        $file = $_FILES[0];

        try {
            $data = PHPExcel_IOFactory::load($file['tmp_name']);

            $sheets = $data->getWorksheetIterator();
            foreach ($sheets as $sheet) {
                $array[] = $sheet->toArray();
            }
        } catch (Exception $e) {
            echo json_encode(0);
            exit;
        }

        $aux = 0;
        $auxErro = 0;
        $textoError = '';

        foreach ($array as $folha) {
            foreach ($folha as $k => $lote) {
                if ($lote[0]) {
                    $lote[2] = Helper::parseFloat($lote[2]);
                    $lote[4] = Helper::parseFloat($lote[4]);                    
                    $auxLote = Lote::getLotesEmpreendimentoQuadraNumero($_GET['idEmp'], $lote[0], $lote[1]);

                    if (isset($auxLote) && $auxLote) {
                        if ($_GET['tpTabela'] == 'N' && $lote[2] > 0 && $lote[4] > 0 && $lote[5]) {
                            $aux++;
                        } else if(in_array($_GET['tpTabela'], ['P','S']) && $lote[2] > 0) {
                            $aux++;
                        } else {
                            $auxErro++;
                        }
                    } else {
                        $auxErro++;
                        $textoError .= $lote[0].'-'.$lote[1].' | ';
                    }
                }
            }
        }

        echo json_encode(array('success'=>$aux,'error'=>$auxErro, 'textoError'=>'Possui '.$auxErro.' registros invlidos: '.$textoError));
    }

    /**
     * Remove os registros selecionados
     */
    public function deletarAction()
    {
        $registro = $_POST['id'];

        try {

            //Apaga todos os registros na tabela de preos de lotes
            $this->tb_layout_itens->delete('id_layout = ' . $registro);
            //Apaga a tabela de preos
            $this->tb_tabela_preco->delete('id = ' . $registro);

        } catch (Exception $e) {
            $this->redir(array('modulo' => 'adm',
                'controller' => 'layout',
                "action" => "listar"), array("msgFail" => $e->getMessage()));
        }
        $this->redir(array('modulo' => 'sc',
            'controller' => 'layout',
            "action" => "listar"), array("msgSuccess" => 'Registros removidos com sucesso!'));

    }

    public function buscaLotesByQuadraAction()
    {
        $listaLotes = LayoutItens::getLotesByEmpreendimentoQuadraTabelaPreco($_POST['id']);
        
        if (count($listaLotes) > 0) {
            foreach ($listaLotes as $lote) {
                $listaAuxLotes[] = array(
                    'area' => '<span style="display: table; margin: 0 auto">' . $lote['id_layout'] . 'm</span>',
                    'checkbox' => '<input type="checkbox" name="chk[]" class="rows-check" id="' . $lote['id'] . '">',
                    'quadra' => '<span style="display: table; margin: 0 auto">' . $lote['segmento'] . '</span>',
                    'lote' => '<span style="display: table; margin: 0 auto">' . $lote['linha'] . '</span>',                       
                    'acoes' => '<div align="center"><a href=?m=sc&c=layout&a=deletarLoteTabela&id=' . $lote['id'] . ' data-toggle="tooltip" title="DELETAR" class="btn btn-default btn-xs" style="margin-right:5px"><i class="fa fa-trash-o"></i> </a></div>',
                );
            }

            echo json_encode(array('draw'   => 1,
                'recordsTotal' => count($listaAuxLotes),
                'recordsFiltered' => count($listaAuxLotes),
                'data' => $listaAuxLotes));
        } else {
            echo json_encode(array('draw' => 0,
                'recordsTotal' => 0,
                'recordsFiltered' => 0,
                'data' => array()));
        }
    }

    public function findLoteByQuadraAction()
    {
        $lotes = $this->lotes->getLotesEmpreendimento($_POST['empreendimento'], $_POST['quadra']);

        $jsonLoteQuadra[] = array('id' => '',
            'text' => '');

        if ($lotes) {
            foreach ($lotes as $lote) {
                $jsonLoteQuadra[] = array('id' => $lote['idLote'],
                    'text' => 'Lote ' . $lote['lote']);
            }
        }
        echo json_encode(array('lotes' => $jsonLoteQuadra));
    }

    public function findLoteByIdAction()
    {
        $infoLote = $this->tb_tabela_preco_lotes->fetchRow("id_lote = " . $_POST['idLote'] . " AND id_tabela_preco = " . $_POST['idTabela']);
        $valorLote = $this->lotes->fetchRow("id = " . $_POST['idLote']);

        $dadosLotes = false;

        if ($infoLote) {
            $dadosLotes = $infoLote;
        }

        echo json_encode(array(
            'dadosLotes' => $dadosLotes,
            'vl_total' => Helper::getMoney($dadosLotes['vl_total']),
            'vl_sinal' => Helper::getMoney($dadosLotes['vl_sinal']),
            'vl_parcela' => Helper::getMoney($dadosLotes['vl_parcela']),
            'vl_intercalada' => Helper::getMoney($dadosLotes['vl_intercalada']),
            'qt_intercalada' => $dadosLotes['qt_intercalada'],
            'dt_atualizacao' => Helper::getDate($dadosLotes['dt_atualizacao']),
            'tx_juros' => $dadosLotes['tx_juros'],
            'qt_meses' => $dadosLotes['qt_meses'],
            'valorLote' => Helper::getMoney($valorLote['valor']),
            'qtde_mensal' => $dadosLotes['nr_parcela'],
            'periodo_intercalada' => $dadosLotes['fr_intercalada']
        ));
    }

    /**
     * Remove os registros selecionados
     */
    public function deletarLoteTabelaAction()
    {
        $id = $_GET['id'];

        try {
            if ($id) {
                //Apaga todos os registros na tabela de preos de lotes
                $this->tb_layout_itens->delete('id_layout = ' . $registro);
                //Apaga a tabela de preos
                $this->tb_tabela_preco->delete('id = ' . $registro);
            }
        } catch (Exception $e) {
            $this->redir(array('modulo' => 'adm',
                'controller' => 'tabelaPreco',
                "action" => "editar"), array("msgFail" => $e->getMessage()));
        }

        $this->redir(array('modulo' => 'adm',
            'controller' => 'tabelaPreco',
            "action" => "listar"), array("msgSuccess" => 'Registros removidos com sucesso!'));
    }

    public function mudaTipoTbAction()
    {
        if ($this->isAjax()) {
            $tb_tb_preco = $this->tb_tabela_preco->fetchRow("id_tabela_preco=" . $_POST['id_tabela_preco']);
            $tb_preco_emp = $this->tb_tabela_preco->fetchAll("id_empreendimento = " . $tb_tb_preco['id_empreendimento'])->toArray();
            $value = $_POST['tipo'] == 'padrao' ? $tb_tb_preco->fl_padrao : $tb_tb_preco->fl_ativo;
            $tbComPadrao = null;

            foreach ($tb_preco_emp as $tb_emp) {
                if ($tb_emp['fl_padrao'] == 1) {
                    $tbComPadrao = $tb_emp['id_tabela_preco'];
                }
            }

            if ($_POST['tipo'] == 'padrao') {
                if ($tbComPadrao == $tb_tb_preco['id_tabela_preco']) {
                    $tb_tb_preco->fl_padrao = 0;
                    $value = 1;
                } else if ($tbComPadrao == null) {
                    $tb_tb_preco->fl_padrao = 1;
                    $value = 0;
                } else {
                    $value = 2;
                }
            } else {
                $tb_tb_preco->fl_ativo = $value == 1 ? 0 : 1;
            }
            
            $valueName = $value == 1 ? 'Desativado' : 'Ativado';
            if ($value != 2) {
                (new RelEmpreendimento())->saveContato(4, date('Y-m-d'), $tb_tb_preco['id_empreendimento'], 'Log: Tabela de preos alterada - Nome: ' . $tb_tb_preco['nm_tabela'] . ' - Tipo ' . $_POST['tipo'] . ' para: ' . $valueName);
            }

            echo json_encode(array('save' => $tb_tb_preco->save() ? 1 : 0, 'value' => $value));
        }
    }    
    public function mudarValorTbAction() 
    {
        if ($this->isAjax()) {
            if ($_POST['pk']) {
                $tb_preco_lotes = new TabelaPrecoLotes();
                $lote = $tb_preco_lotes->getTbPrecoLoteById($_POST['pk']);
                $emp = $tb_preco_lotes->getQuadrasByIdTbPreco($lote->id_tabela_preco, $lote->id_lote);

                $nome = $_POST['name'];
                $textLog = $nome . ' alterado de ' . $lote->$nome . ' para ' . $_POST['value'] . '.';
                $lote->$nome = Helper::parseFloat($_POST['value']);
                $lote->dt_atualizacao = date('Y-m-d');

                (new RelEmpreendimento())->saveContato(4, date('Y-m-d'), $emp[0]['id_empreendimento'], 'Log: Tabela de preo alterada - Quadra: ' . $emp[0]['quadra'] . ', Lote: ' . $emp[0]['lote'] . ', Tabela nome: ' . $emp[0]['nm_tabela'] . ' - '. $textLog);
                
                echo json_encode(array('save' => $lote->save() ? 1 : 0));

            } else {
                $tb_preco_lotes = new TabelaPrecoLotes();
                $lote = $tb_preco_lotes->getTbPrecoLoteById($_POST['id_tb_preco_lotes']);
                $emp = $tb_preco_lotes->getQuadrasByIdTbPreco($lote->id_tabela_preco, $lote->id_lote);

                foreach ($_POST as $key => $post) {
                    if ($post && $key != 'id_tb_preco_lotes') {
                        $logs[] = array(
                            'tipo' => $key,
                            'valor' => $post,
                            'valorAnterior' => Helper::getMoney($lote->$key)
                        );
                        $lote->$key = Helper::parseFloat($post);
                        $lote->dt_atualizacao = date('Y-m-d');                        
                    }
                }

                if ($logs) {
                    $textLog = '';
                    foreach ($logs as $log) {
                        $textLog .= $log['tipo'] . ' alterado de '. $log['valorAnterior'] .' para ' . $log['valor'] . '. ';
                    }

                    (new RelEmpreendimento())->saveContato(4, date('Y-m-d'), $emp[0]['id_empreendimento'], 'Log: Tabela de preo alterada - Quadra: ' . $emp[0]['quadra'] . ', Lote: ' . $emp[0]['lote'] . ', Tabela nome: ' . $emp[0]['nm_tabela'] . ' - '. $textLog);
                }
                
                echo json_encode(array('save' => $lote->save() ? 1 : 0));
            }
        }
    }

    public function criarNovaLinhaAction() 
    {
        if ($this->isAjax()) {        
            $tb_preco_lotes = new TabelaPrecoLotes();
            $emp = $tb_preco_lotes->getQuadrasByIdLote($_POST['id_lote']);
            try {
                $lote = $tb_preco_lotes->createRow();
                $lote->id_tabela_preco = $_POST['id_tabela_preco'];
                $lote->id_lote = $_POST['id_lote'];
                $lote->vl_total = Helper::parseFloat($_POST['vl_total']);
                $lote->vl_parcela = ($_POST['vl_parcela'] != "") ? Helper::parseFloat($_POST['vl_parcela']) : null;
                $lote->vl_sinal = ($_POST['vl_sinal'] != "") ? Helper::parseFloat($_POST['vl_sinal']) : null;
                $lote->vl_intercalada = ($_POST['vl_intercalada'] != "") ? Helper::parseFloat($_POST['vl_intercalada']) : null;
                $lote->tx_juros = ($_POST['tx_juros'] != "") ? Helper::parseFloat($_POST['tx_juros']) : null;
                $lote->qt_meses = ($_POST['qt_meses'] != "") ? Helper::parseFloat($_POST['qt_meses']) : null;
                $lote->qt_intercalada = ($_POST['qt_intercalada'] != "") ? Helper::parseFloat($_POST['qt_intercalada']) : null;
                $lote->dt_atualizacao = date('Y-m-d');
                $lote->nr_parcela = ($_POST['nr_parcela'] != "") ? Helper::parseFloat($_POST['nr_parcela']) : null;
                $lote->fr_intercalada = ($_POST['fr_intercalada'] != "") ? Helper::parseFloat($_POST['fr_intercalada']) : null;

                $lote = $lote->save();
            } catch (Exception $e) {
                $error = $e;
            }
            
            foreach ($_POST as $key => $post) {
                if ($post) {
                    $logs[] = array(  
                        'tipo' => $key,
                        'valor' => $post,
                    );
                }
            }

            if ($logs) {
                $textLog = '';

                foreach ($logs as $log) {
                    $textLog .= $log['tipo'] . ' criado com valor '. $log['valor'] . '. ';
                }

                (new RelEmpreendimento())->saveContato(4, date('Y-m-d'), $emp[0]['id_empreendimento'], 'Log: Tabela de preo alterada, lote adicionado - Quadra: ' . $emp[0]['quadra'] . ', Lote: ' . $emp[0]['lote'] . ', Tabela nome: ' . $emp[0]['nm_tabela'] . ' - '. $textLog);
            }

            echo json_encode(array('save' => $error ? 0 : 1, 'error' => $error));
        }
    }
    public function listarLotesAction() 
    {
        if ($this->isAjax()) {
            $id_tabela_preco = $_POST['tabela'];
            $quadra = $_POST['quadra'];
            $empreendimento = $_POST['emp'];

            $tb_preco_lotes = new TabelaPrecoLotes();
            try {
                $lotes = $tb_preco_lotes->getDiferencaLotesByTbPrecoId($id_tabela_preco, $quadra, $empreendimento);
            } catch (Exception $e) {
                $error = $e;
            }

            echo json_encode( array('lotes' => $lotes?$lotes:null, 'erro' => $error?$error:null) );
        }
    }

    public function listarTiposAction(){
        $filtro = isset( $_POST['filtro'] ) ? $_POST['filtro'] : NULL;

        # codigo para obter os dados do banco de acordo com o filtro ...

        $html = "<select><option>teste</option></select>";
        $html .= "<select><option>teste</option></select>";
        $html .= "<select><option>teste</option></select>";
        echo $html;
    }

    public function duplicarAction()
    {

        $original_layout = Zend_Db_Table::getDefaultAdapter()->select()->from(array('e'=>TB_LAYOUT))->where('id = '.$_POST['id'])->query()->fetch();

        //Cria um array com todos os itens da tabela Layout_Itens de acordo com o ID_LAYOUT
        $original_layout_itens = Zend_Db_Table::getDefaultAdapter()->select()->from(array('e'=>TB_LAYOUT_ITENS))->where('id_layout = '.$_POST['id'])->query()->fetchAll();
        try {

            $remessa = new Layout();
            $remessa = $remessa->createRow();
            $remessa->nm_layout = $original_layout['nm_layout'].' - COPIA';
            $remessa->desc_layout = $original_layout['desc_layout'];
            $remessa->tipo_layout = $original_layout['tipo_layout'];
            $remessa->dt_layout = date('Y-m-d');
            $remessa->tipo_header = $original_layout['tipo_header'];
            $remessa->tipo_retorno = $original_layout['tipo_retorno'];
            $remessa->gerar_token = $original_layout['gerar_token'];
            $remessa->url_api = $original_layout['url_api'];
            $remessa->url_api_listar = $original_layout['url_api_listar'];
            $remessa->uri_param = $original_layout['uri_param'];
            $remessa->pp_token = $original_layout['pp_token'];
            $remessa->password = $original_layout['password'];
            $remessa->log = '';
            $id_layout = $remessa->save();

            foreach ($original_layout_itens as $original_itens){

                Layout::setInsertLayoutItens($id_layout,$original_itens['linha'],
                    $original_itens['tamanho'],$original_itens['conteudo'],$original_itens['log']);
            }



            $this->redir(array('modulo' => 'sc',
                'controller' => 'layout',
                "action" => "listar"), array("msgSuccess" => 'Registros duplicados com sucesso!'));

        }catch (Exception $e){
            $this->redir(array('modulo' => 'sc',
                'controller' => 'layout',
                "action" => "listar"), array("exception" => $e->getMessage()));

        }

    }
    
    public function tokenCresolAction()
    {
        $this->display('tokenCresol');
    }


}
