<?php

class ImportarPessoaController extends Controller
{

    public function __construct($request)
    {
        parent::__construct($request);

        $this->empreendimento = new Empreendimento();
    }

    public function indexAction()
    {
        $this->redir(array("controller" => "importarPessoa", "action" => "migrar"));
    }

    public function migrarAction()
    {
        $empreendimentos = $this->empreendimento->getDefaultAdapter()->select()->from(array('e' => TB_EMPREENDIMENTO));

        //verifica se o usuario tem o perfil de usuario de empreendimento
        if ($_SESSION['usuario']) {
            try {
                $instanceUsuarioEmpreendimento = new Usuario_Empreendimento();
                $ids = $instanceUsuarioEmpreendimento->listaEmpreendimentosRepresentante($_SESSION['usuario']);
                if (count($ids)) {
                    $id = implode(',', $ids);
                    $empreendimentos->where("e.id IN({$id})");
                } else {
                    $empreendimentos->where("1");
                }
            } catch (Exception $e) {
            }
        }

        $empreendimentos = $empreendimentos->order('nm_empreendimento')->query()->fetchAll();


        if ($this->_isPost) {
            set_time_limit(600);

            try {
                $file = $_FILES['arquivoContratos'];
                $data = PHPExcel_IOFactory::load($file['tmp_name']);
            } catch (Exception $e) {
                $this->_helper->addMensagem('arquivo', 'No foi possvel ler o arquivo. Verifique o Padro do Arquivo.');
            }
            if (isset($data)) {
                try {
                    $sheets = $data->getWorksheetIterator();
                    foreach ($sheets as $sheet) {
                        foreach ($sheet->getRowIterator() as $rowsheet) {
                            $auxRow = array();
                            $cellIterator = $rowsheet->getCellIterator();
                            $cellIterator->setIterateOnlyExistingCells(true);
                            foreach ($cellIterator as $k => $cell) {
                                $value = $cell->getValue();
                                if (PHPExcel_Shared_Date::isDateTime($cell)) {
                                    $value = gmdate("Y-m-d", ($value - 25569) * 86400);
                                }
                                $auxRow[ord($k) - 65] = $value;
                            }
                            $array[] = $auxRow;
                        }
                    }
                } catch (Exception $e) {
                }

                if ($this->validar($array)) {

                    $log = fopen('upload/LogImportacaoPessoa_' . date('his_dmY') . '.txt', 'a');

                    $tmpPessoa = new TmpPessoa();
                    $tmpPessoa->delete('1');

                    //Registro de Log
                    fwrite($log, "-----------------------------------------------------------------------------:\n");
                    fwrite($log, "INICIANDO IMPORTAO" . ":\n");
                    fwrite($log, "-----------------------------------------------------------------------------:\n:\n");

                    foreach ($array as $row) {
                        try {
                            fwrite($log, implode(', ', $row) . ":\n");
                            // var_dump($row);exit;
                            $pessoa = Pessoa_Fisica::findbyCpf($row[3]);

                            if($row[1] == 'F'){ //Pessoa fsica

                                if (!$pessoa) {
                                    //Pessoa
                                    $p = new Pessoa();
                                    $transaction = $p->getAdapter()->beginTransaction();
                                    $p = $p->createRow();
                                    $p->nm_pessoa = $row[2];
                                    $p->email = $row[19];
                                    $p->nr_telefone = $row[16];
                                    $p->nr_celular = $row[17];
                                    $p->nr_recado = $row[18];
                                    $p->nr_cep = $row[15];
                                    $p->endereco = $row[10];
                                    $p->nr_endereco = $row[11];
                                    $p->ds_complemento = $row[12];
                                    $p->nm_bairro = $row[13];
                                    $p->ds_observacao = 'Migracao de Pessoa';
                                    $p->cd_cidade = $row[14];
                                    $p->tp_pessoa = "F";
                                    $p->dt_cadastro = date("Y-m-d H:i:s");
                                    $p->log = (Login::getUsuario()->getLogin() . ' - ' . date('d/m/Y H:i:s') . ' - i');
    
                                    $id = $p->save();
    
                                    //Pessoa fsica
                                    $pfs = new Pessoa_Fisica();
                                    $pf = $pfs->createRow();
                                    $pf->id_pessoa = $id;
                                    $pf->nr_cpf = $row[5];
                                    $pf->dt_nascimento = $this->_helper->filters($row[8]);
                                    $pf->nr_rg = $this->_helper->filters($row[6]);
                                    $pf->cd_documento = $this->_helper->filters('1');
                                    $pf->nm_profissao = $this->_helper->filters($row[20]);
                                    $pf->tp_nacionalidade = $this->_helper->filters('B');
                                    $pf->nm_nacionalidade = $this->_helper->filters($row[9]);
                                    $pf->cd_cidade_nasc = $this->_helper->filters($row[14]);
                                    $pf->est_civil = $this->_helper->filters($row[23]);
                                    $pf->nm_pai = $this->_helper->filters($row[21]);
                                    $pf->sexo = $this->_helper->filters($row[4]);
                                    $pf->nm_mae = $this->_helper->filters($row[22]);
    
                                    $pf->save();
                                    $transaction->commit();
    
                                    //Salva na tabela temporria e no log os ids antigo e novo
                                    fwrite($log, '  Pessoa Adicionada. Cdigo: ' . $row[0] . ' - ID: ' . $id . ":\n");
                                    $tmpPessoa->createRow(array(
                                        'id_empreendimento' => 0,
                                        'id_pessoa_antigo' => $row[0],
                                        'id_pessoa_novo' => $id,
                                        'id_conjuge' => $row[24]
                                    ))->save();
                                } else
                                    fwrite($log, "----> ERRO: PESSOA COM CPF EXISTENTE NO SISTEMA.:\n");

                            }else{ //Pessoa Jurdica
                                
                                if (!$pessoa) {
                                    //Pessoa
                                    $p = new Pessoa();
                                    $transaction = $p->getAdapter()->beginTransaction();
                                    $p = $p->createRow();
                                    $p->nm_pessoa = $row[2];
                                    $p->email = $row[19];
                                    $p->nr_telefone = $row[16];
                                    $p->nr_celular = $row[17];
                                    $p->nr_recado = $row[18];
                                    $p->nr_cep = $row[15];
                                    $p->endereco = $row[10];
                                    $p->nr_endereco = $row[11];
                                    $p->ds_complemento = $row[12];
                                    $p->nm_bairro = $row[1];
                                    $p->ds_observacao = 'Migracao de Pessoa';
                                    $p->cd_cidade = $row[14];
                                    $p->tp_pessoa = "J";
                                    $p->dt_cadastro = date("Y-m-d H:i:s");
                                    $p->log = (Login::getUsuario()->getLogin() . ' - ' . date('d/m/Y H:i:s') . ' - i');
    
                                    $id = $p->save();
    
                                    //Pessoa jurdica
                                    $pjs = new Pessoa_Juridica();
                                    $pj = $pjs->createRow();
                                    $pj->id_pessoa = $id;
                                    $pj->nr_cnpj = $row[5];
                                    $pj->nm_fantasia = $this->_helper->filters($row[3]);
    
                                    $idPj = $pj->save();

                                    //Representante
                                    $repr = new Representante();
                                    $rep = $repr->createRow();
                                    $rep->id_pessoa_juridica = $idPj;
                                    $rep->id_pessoa = $row[7];
                                    $rep->fl_principal = 1;
                                    $rep->save();

                                    $transaction->commit();
    
                                    //Salva na tabela temporria e no log os ids antigo e novo
                                    fwrite($log, '  Pessoa Adicionada. Cdigo: ' . $row[0] . ' - ID: ' . $id . ":\n");
                                    $tmpPessoa->createRow(array(
                                        'id_empreendimento' => 0,
                                        'id_pessoa_antigo' => $row[0],
                                        'id_pessoa_novo' => $id
                                    ))->save();
                                } else
                                    fwrite($log, "----> ERRO: PESSOA COM CPF EXISTENTE NO SISTEMA.:\n");
                            }
                            
                            
                        } catch (Exception $e) {
                            if (isset($transaction))
                                $transaction->rollBack();
                            fwrite($log, "===================================ERRO=====================================:\n");
                            fwrite($log, $e->getMessage());
                        }
                    }
                    foreach ($array as $row) {
                        if($row[24] != null){
                            $tmpConjuge = $tmpPessoa->getDefaultAdapter()->select()
                            ->from(array('tmp'=> TMP_PESSOA), array('id_pessoa_antigo', 'id_pessoa_novo', 'id_conjuge'))
                            ->join(array('tmpC'=>TMP_PESSOA), 'tmp.id_conjuge = tmpC.id_pessoa_antigo', array('idConj'=> 'id_pessoa_antigo', 'novoConj'=> 'id_pessoa_novo'))
                            ->where('tmp.id_pessoa_antigo = ?', $row[0])
                            ->query()->fetch();

                            $pfs = new Pessoa_Fisica();
                            $pf = $pfs->fetchRow('id_pessoa = ' . $tmpConjuge['id_pessoa_novo']);
                            $pf->cd_conjuge = $tmpConjuge['novoConj'];
                            $pf->save();
                        }
                    }
                    //Fecha o arquivo de log
                    fclose($log);
                    $this->_helper->addMensagem('sucesso', 'Operao Realizada com Sucesso!');

                } else {
                    $this->set('dados', $_POST);
                }
            }
        }

        $this->set('empreendimentos', $empreendimentos);
        $this->display('form');
    }

    private function validar($array)
    {
        if (!is_array($array) || count($array) == 0)
            $this->_helper->addMensagem('arquivo', 'Nenhum registro vlido encontrado no arquivo selecionado. Verifique o Padro do Arquivo.');

        return !(count($this->_helper->getMensagens()) > 0);
    }

    public function loteByEmpreendimentoAction()
    {
        $contratos = Contrato::byEmpreendimento($_POST['id_empreendimento'], Contrato::CONTRATO_TODOS, 2, array("nm_pessoa", "lote", "quadra", "id"), true);

        $lista = array();
        foreach ($contratos as $contrato) {
            $lista[] = array('id' => $contrato['id'], 'text' => substr_replace(utf8_encode($contrato['nm_pessoa']), "...", 30) . ' Quadra: ' . $contrato['quadra'] . ' - Lote: ' . $contrato['lote']);
        }

        echo json_encode($lista);
    }

}