<?php

class ImportarParcelaController extends Controller
{

    public function __construct($request)
    {
        parent::__construct($request);

        $this->empreendimento = new Empreendimento();
    }

    public function indexAction()
    {
        $this->redir(array("controller" => "importarParcela", "action" => "migrar"));
    }

    public function migrarAction()
    {
        $empreendimentos = $this->empreendimento->getDefaultAdapter()->select()->from(array('e' => TB_EMPREENDIMENTO));

        //verifica se o usuario tem o perfil de usuario de empreendimento
        if ($_SESSION['usuario']) {
            try {
                $instanceUsuarioEmpreendimento = new Usuario_Empreendimento();
                $ids = $instanceUsuarioEmpreendimento->listaEmpreendimentosRepresentante($_SESSION['usuario']);
                if (count($ids)) {
                    $id = implode(',', $ids);
                    $empreendimentos->where("e.id IN({$id})");
                } else {
                    $empreendimentos->where("1");
                }
            } catch (Exception $e) {
            }
        }

        $empreendimentos = $empreendimentos->order('nm_empreendimento')->query()->fetchAll();


        if ($this->_isPost) {
            set_time_limit(600);

            try {
                $file = $_FILES['arquivoContratos'];
                $data = PHPExcel_IOFactory::load($file['tmp_name']);
            } catch (Exception $e) {
                $this->_helper->addMensagem('arquivo', 'No foi possvel ler o arquivo. Verifique o Padro do Arquivo.');
            }
            if (isset($data)) {
                try {
                    $sheets = $data->getWorksheetIterator();
                    foreach ($sheets as $sheet) {
                        foreach ($sheet->getRowIterator() as $rowsheet) {
                            $auxRow = array();
                            $cellIterator = $rowsheet->getCellIterator();
                            $cellIterator->setIterateOnlyExistingCells(true);
                            foreach ($cellIterator as $k => $cell) {
                                $value = $cell->getValue();
                                //Implementado condio, para trato de celulas vazias.
                                if ($cell != '')
                                    if (PHPExcel_Shared_Date::isDateTime($cell)) {
                                        $value = gmdate("Y-m-d", ($value - 25569) * 86400);
                                    }
                                $auxRow[ord($k) - 65] = $value;
                            }
                            $array[] = $auxRow;
                        }
                    }
                } catch (Exception $e) {
                }

                if ($this->validar($array)) {

                    $log = fopen('upload/LogImportacaoParcela_' . date('his_dmY') . '.txt', 'a');

                    //Registro de Log
                    fwrite($log, "-----------------------------------------------------------------------------:\n");
                    fwrite($log, "INICIANDO IMPORTAO PARCELAS:\n");
                    fwrite($log, "-----------------------------------------------------------------------------:\n:\n");

                    foreach ($array as $row) {
                        try {
                            fwrite($log, implode(', ', $row) . ":\n");
                            $parcela = Parcela::findParcelasMigracao($row[0], $row[1], $row[2]);
                           
                            if ($parcela) {
                                if ($parcela['pago'] === '0') {
                                    $p = Parcela::getInstance()->fetchRow('id_parcela_contrato = ' . $parcela['id_parcela_contrato']);
                                    $p->id_parcela_contrato_antigo = $row[3];
                                    $p->dt_parcela = $row[4];
                                    $p->dt_pagamento = $row[5];
                                    $p->dt_credito = $row[6];
                                    $p->pago = ($row[5] ? '1' : '0');
                                    $p->vl_parcela = $row[7];
                                    $p->vl_juros = $row[8];
                                    $p->vl_multa = $row[9];
                                    $p->desconto = $row[10];
                                    $p->fm_baixa = $row[11];
                                    $p->vl_total_pago = $row[12];
                                    $p->tp_baixa = $row[13];
                                    //Implementado condio para verificar campo banco vazio.
                                    if (is_numeric($row[14]))
                                        $p->id_banco = $row[14];
                                    $p->obs = $row[15];
                                    $p->nr_tipo_parcela = $row[16];
                                    $p->log = 'Migrao ' . date("Y-m-d H:i:s");

                                    $p->save();
                                } else
                                    fwrite($log, "-----------------------------> ERRO: PARCELA J BAIXADA.:\n");
                            } else
                                fwrite($log, "---------------> ERRO: PARCELA NO EXISTENTE NO SISTEMA.:\n");
                        } catch (Exception $e) {
                            if (isset($transaction))
                                $transaction->rollBack();
                            fwrite($log, "===================================ERRO=====================================:\n");
                            fwrite($log, $e->getMessage() . ":\n");
                        }
                    }

                    //Fecha o arquivo de log
                    fclose($log);
                    $this->_helper->addMensagem('sucesso', 'Operao Realizada com Sucesso!');

                } else {
                    $this->set('dados', $_POST);
                }
            }
        }

        $this->set('empreendimentos', $empreendimentos);
        $this->display('form');
    }

    private function validar($array)
    {
        if (!is_array($array) || count($array) == 0)
            $this->_helper->addMensagem('arquivo', 'Nenhum registro vlido encontrado no arquivo selecionado. Verifique o Padro do Arquivo.');

        return !(count($this->_helper->getMensagens()) > 0);
    }

    public function loteByEmpreendimentoAction()
    {
        $contratos = Contrato::byEmpreendimento($_POST['id_empreendimento'], Contrato::CONTRATO_TODOS, 2, array("nm_pessoa", "lote", "quadra", "id"), true);

        $lista = array();
        foreach ($contratos as $contrato) {
            $lista[] = array('id' => $contrato['id'], 'text' => substr_replace(utf8_encode($contrato['nm_pessoa']), "...", 30) . ' Quadra: ' . $contrato['quadra'] . ' - Lote: ' . $contrato['lote']);
        }

        echo json_encode($lista);
    }

}