<?php

class GraficosController extends Controller {

    public function buscaVendasPorMesEanoAction() {
        $vendas = null;
        //Verifica se o usurio tem permisso para visualizar o grfico de vendas
        if (ACL::hasPermission( Login::getUsuario(), Db_Action::findByNome ( "graficoVendas", Db_Controller::findByName ( __CLASS__ )))) {
            $vendas = (new Graficos())->vendasPorMesEano($_GET['idEmpreendimento']);
        }

        echo json_encode($vendas);
    }

    public function buscaParcelasPagasNoMesAction() {
        $parcelas = null;
        //Verifica se o usurio tem permisso para visualizar o grfico de parcelas pagas
        if (ACL::hasPermission( Login::getUsuario(), Db_Action::findByNome ( "graficoParcelasPagas", Db_Controller::findByName ( __CLASS__ )))) {
            $parcelas = (new Graficos())->parcelasPagasNoMes($_GET['idEmpreendimento']);
        }

        echo json_encode($parcelas);
    }

    public function buscaDistratosPorMesEanoAction() {
        $distratos = null;
        //Verifica se o usurio tem permisso para visualizar o grfico de distratos
        if (ACL::hasPermission( Login::getUsuario(), Db_Action::findByNome ( "graficoDistratos", Db_Controller::findByName ( __CLASS__ )))) {
            $distratos = (new Graficos())->distratosPorMesEano($_GET['idEmpreendimento']);
        }

        echo json_encode($distratos);
    }

    public function buscaTotaisSituacaoLoteAction() {
        $lotes = null;
        //Verifica se o usurio tem permisso para visualizar o grfico de lotes
        if (ACL::hasPermission( Login::getUsuario(), Db_Action::findByNome ( "graficoLotes", Db_Controller::findByName ( __CLASS__ )))) {
            // $lotes = (new Graficos())->totaisSituacaoLote($_GET['idEmpreendimento']);
            $lotes = (new Graficos())->totaisStatusLotes($_GET['idEmpreendimento']);
        }
        
        echo json_encode($lotes);
    }

    public function criarQueryLotesAction() {
        $lotes = (new Graficos())->retornaQuerySql();
    }
}