<?php
class ControllerController extends Controller {
	
	public function indexAction(){
		$this->redir(array("controller" => "controller", "action" => "listar"));
	}

	public function adicionarAction() {
                $this->set('form','layout/forms/form-controller.php');
                $this->set('back','?m=lo&c=lote');
		$this->set("modulos",Db_Modulo::fetchAll());		
		$this->display("form");
	}
	
	public function saveAction() {
		
		if (Login::isLogado () && ACL::hasPermission ( Login::getUsuario (), Db_Action::findByNome("adicionar", Db_Controller::findByName ( __CLASS__ ) ) )) {
			
			$c = new Db_Controller();
			$c->setId($_POST["id"]);
			$c->setNome($_POST ["nome"] );
			$c->setRotulo($_POST ["rotulo"] );
			$c->setModuloId($_POST["modulo"]);
			$c->setRotina($_POST["sigla"]);
			$this->set("controller",$c);
			$acao = "i";
			if (!$_POST["id"]=="")
				$acao = "u";
			
			if($this->validar()){
				$c->setLog(Login::getUsuario()->getLogin().' - '.date('d/m/Y').' - '.$acao);
				$c->save();	
				$this->redir(array("controller" => "controller", "action" => "listar"),array("msg" => "OK"));
			}else{
				$this->adicionarAction();				
			}
		}else{
			throw new Exception("O usurio no tem permisso de acessar essa action.");
		}
	}
	
	public function editarAction(){
		$this->set("modulos",Db_Modulo::fetchAll());			
		$this->set("controller",Db_Controller::find($_GET["id"]));
		$this->display("form");
	}
	
	private function validar(){
		//validao vazio
		$campos = array ("nome", "rotulo");
		foreach ( $campos as $cp ) {
			if ($_POST [$cp] == "") {
				switch ($cp) {
					case "nome" :
						$msg = "O campo Nome  obrigatrio.";
						break;
					case "rotulo" :
						$msg = "O campo Rtulo  obrigatrio.";
						break;
				}
				$this->_helper->addMensagem($cp,$msg);
			}
			if($_POST["sigla"]!=""){
                            if(Db_Controller::findByRotina($_POST["sigla"])){
				if(!$_POST["id"])
					$this->_helper->addMensagem("siglaExiste","Escolha outra sigla para sua rotina!");
                            }
                        
                        }
			
		}
		
		return !(count($this->_helper->getMensagens()) > 0);
	}
	
	public function listarAction(){
		$this->set("botoes",array("Adicionar" => array("c" => "controller", "a" => "adicionar")));		
		
		if($_GET["msg"] == "OK"){
			$this->_helper->addMensagem("ok","Operao realizada com sucesso!");
		}elseif($_GET["msg"] == "FAIL"){
			$this->_helper->addMensagem("fail","Erro! Operao no pode ser completada!");
		}

        $count = Db_Controller::fetchAll(null,true);
        
        /*Total de linhas*/
        $totalItems = $count[0]->count;

        /*Seta as opes do paginador*/
        $pager_options = array(
                'mode'       => 'Sliding',   // Sliding or Jumping mode. See below.
                'perPage'    => 10,   // Total rows to show per page
                'delta'      => 4,   // See below
                'totalItems' => $totalItems,
        );

        /*Instancia o paginador*/
        $pager = Pager::factory($pager_options);
        /* The following code will retreive the result using the pager options */

        /*Seta o offset para colocar na query*/
        list($from, $to) = $pager->getOffsetByPageId();

        /*Ajuste para MySQL que comea o offset com 0*/
        $from = $from - 1;

        /*A quanditade de linhas por query*/
        $perPage = $pager_options['perPage'];

		$this->set("action",array("c" => "controller", "a" => "pesquisar"));	
		$this->set("subtitulo","Rotinas");        
		$this->set("controllers",Db_Controller::fetchAll(null, false, $from, $perPage));
        $this->set('paginacao',$pager->links);
		$this->display();
	}
	
	public function pesquisarAction(){
		$controllers = Db_Controller::fullSearch($_GET["termo"]);
		$this->set("action",array("c" => "controller", "a" => "pesquisar"));	
		$this->set("subtitulo","Rotinas");
		$this->set("controllers",$controllers);
		$this->set("botoes",array("voltar" => array("c" => "controller", "a" => "listar")));
		$this->display();
	}
	
	public function deletarAction(){
		try{
			Db_Controller::delete($_GET["id"]);
			$this->redir(array("controller" => "controller", "action" => "listar"),array("msg" => "OK"));
		} catch(Exception $e){
			$this->redir(array("controller" => "controller", "action" => "listar"),array("msg" => "FAIL"));
		}		
		$this->listarAction();
	}
}