<?php

class ContratoAntigoController extends Controller
{

    public function __construct($request)
    {
        parent::__construct($request);

        $this->empreendimento = new Empreendimento();
    }

    public function indexAction()
    {
        $this->redir(array("modulo" => "sc", "controller" => "contratoAntigo", "action" => "migrar"));
    }

    public function migrarAction()
    {
        $empreendimentos = $this->empreendimento->getDefaultAdapter()->select()->from(array('e' => TB_EMPREENDIMENTO));

        //verifica se o usuario tem o perfil de usuario de empreendimento
        if ($_SESSION['usuario']) {
            try {
                $instanceUsuarioEmpreendimento = new Usuario_Empreendimento();
                $ids = $instanceUsuarioEmpreendimento->listaEmpreendimentosRepresentante($_SESSION['usuario']);
                if (count($ids)) {
                    $id = implode(',', $ids);
                    $empreendimentos->where("e.id IN({$id})");
                } else {
                    $empreendimentos->where("1");
                }
            } catch (Exception $e) {
            }
        }

        $empreendimentos = $empreendimentos->order('nm_empreendimento')->query()->fetchAll();


        if ($this->_isPost) {
            set_time_limit(600);

            try {
                $file = $_FILES['arquivoContratos'];
                $data = PHPExcel_IOFactory::load($file['tmp_name']);
            } catch (Exception $e) {
                $this->_helper->addMensagem('arquivo', 'No foi possvel ler o arquivo. Verifique o Padro do Arquivo.');
            }
            try {
                $sheets = $data->getWorksheetIterator();
                foreach ($sheets as $sheet) {
                    foreach ($sheet->getRowIterator() as $rowsheet) {
                        $auxRow = array();
                        $cellIterator = $rowsheet->getCellIterator();
                        $cellIterator->setIterateOnlyExistingCells(false);

                        foreach ($cellIterator as $k => $cell) {
                            $value = $cell->getValue();

                            if (!is_null($value)) {
                                if (PHPExcel_Shared_Date::isDateTime($cell)) {
                                    $value = gmdate("Y-m-d", ($value - 25569) * 86400);
                                }
                            }
                            $auxRow[] = $value;

                        }
                        if (count($auxRow) >= 14)
                            $array[] = $auxRow;
                    }
                }
            } catch (Exception $e) {
            }

            if ($this->validar($array)) {

                $log = fopen('upload/LogImportarContratos' . date('his_dmY') . '.txt', 'a');
                try {
                    //Registro de Log
                    fwrite($log, "-----------------------------------------------------------------------------:\n");
                    fwrite($log, "INICIANDO IMPORTAO" . ":\n");
                    fwrite($log, "-----------------------------------------------------------------------------:\n:\n");

                    if ($_POST['tipo'] == '1')
                        self::importarContratosAtivos($array, $log);
                    else
                        self::importarContratosAntigos($array, $log);

                } catch (Exception $e) {
                    fwrite($log, "===================================ERRO=====================================:\n");
                    fwrite($log, $e->getMessage());
                }
                //Fecha o arquivo de log
                fclose($log);
                $this->_helper->addMensagem('sucesso', 'Operao Realizada com Sucesso!');

            } else {
                $this->set('dados', $_POST);
            }
        }

        $this->set('empreendimentos', $empreendimentos);
        $this->display('form');
    }

    private function validar($array)
    {
        if (!is_array($array) || count($array) == 0)
            $this->_helper->addMensagem('arquivo', 'Nenhum registro vlido encontrado no arquivo selecionado. Verifique o Padro do Arquivo.');

        return !(count($this->_helper->getMensagens()) > 0);
    }

    private static function importarContratosAntigos($array, $log)
    {
        foreach ($array as $row) {
            fwrite($log, implode(', ', $row) . ":\n");

            $pessoa = Pessoa_Fisica::findbyCpf($row[4]);
            if ($pessoa) {
                $lote = new Lote();
                $lote = $lote->findLotesByEmpreendimentoQuadraLote($row[0], $row[1], $row[2]);
                if ($lote) {
                    $corretor = new Corretor_Empreendimento();
                    $corretor = $corretor->fetchRow('id_pessoa = ' . $row[5]);
                    if ($corretor) {
                        $banco = new Banco();
                        $banco = $banco->fetchRow('id = ' . $row[6]);
                        if ($banco) {
                            $contrato = Contrato::getIdByLote($lote[0]['id']);
                            if (!$contrato) {
                                try {
                                    $contrato = new Contrato();
                                    $contrato = $contrato->createRow();
                                    $contrato->id_banco = $row[6];
                                    $contrato->id_lote = $lote[0]['id'];
                                    $contrato->id_corretor = $row[5];
                                    $contrato->nr_proposta = $row[7];
                                    $contrato->dt_contrato = $row[10];
                                    $contrato->fl_aprovar_contrato = 1;
                                    $contrato->fl_coinc_intercalada = '0';
                                    $contrato->nr_parcela = 1;
                                    $contrato->vl_parcela = 0;
                                    $contrato->inclui_sinal_contrato = null;
                                    $contrato->dt_primeira_parcela = $row[11];
                                    $contrato->obs = 'Migrao contratos antigos';
                                    $contrato->id_pessoa = $pessoa['id'];
                                    $contrato->fl_gerado = '1';
                                    $contrato->fl_distrato = $row[13];
                                    $contrato->log = (Login::getUsuario()->getLogin() . ' - ' . date('d/m/Y H:m:s') . ' - i');

                                    $idContrato = $contrato->save();

                                    $newParcela = new Parcela();
                                    $newParcela = $newParcela->createRow();
                                    $newParcela->id_parcela = 1;
                                    $newParcela->id_contrato = $idContrato;
                                    $newParcela->vl_parcela = 0;
                                    $newParcela->vl_total_pago = 0;
                                    $newParcela->dt_parcela = $row[11];
                                    $newParcela->dt_pagamento = $row[11];
                                    $newParcela->dt_credito = $row[11];
                                    $newParcela->tp_parcela = 'N';
                                    $newParcela->tp_baixa = 'T';
                                    $newParcela->fl_reajustavel = 0;
                                    $newParcela->pago = '1';
                                    $newParcela->fl_envio = '0';
                                    $newParcela->obs = 'Migrao contratos antigos';
                                    $newParcela->log = (Login::getUsuario()->getLogin() . ' - ' . date('d/m/Y H:m:s') . ' - i');

                                    $newParcela->save();

                                } catch (Exception $e) {
                                    fwrite($log, "----> ERRO: " . $e->getMessage() . ".:\n");
                                }
                            } else {
                                fwrite($log, "----> ERRO: LOTE J POSSUI UM CONTRATO CADASTRADO.:\n");
                            }
                        } else {
                            fwrite($log, "----> ERRO: BANCO NO CADASTRADO NO SISTEMA.:\n");
                        }
                    } else {
                        fwrite($log, "----> ERRO: CORRETOR NO CADASTRADO NO SISTEMA.:\n");
                    }
                } else {
                    fwrite($log, "----> ERRO: LOTE NAO ENCONTRADO NO SISTEMA.:\n");
                }
            } else {
                fwrite($log, "----> ERRO: PESSOA NAO ENCONTRADA NO SISTEMA.:\n");
            }
        }
    }

    private static function importarContratosAtivos($array, $log)
    {

        foreach ($array as $row) {

            fwrite($log, implode(', ', $row) . ":\n");

            $idpessoa = TmpPessoa::findById($row[6]);
            if ($idpessoa) {
                $lote = new Lote();
                $lote = $lote->findLotesByEmpreendimentoQuadraLote($row[1], $row[3], $row[2]);
                if ($lote) {
                    $corretor = new Corretor_Empreendimento();
                    $corretor = $corretor->fetchRow('id_corretor = ' . $row[8]);
                    if ($corretor) {
                        $banco = new Banco();
                        $banco = $banco->fetchRow('id = ' . $row[9]);
                        if ($banco) {
                            $contrato = Contrato::getIdByLote($lote[0]['id']);
                            if (!$contrato || $row[4] == '1') {
                                try {
                                    $contrato = new Contrato();
                                    $contrato = $contrato->createRow();
                                    
                                    $contrato->id_indice = Helper::apenasNumeros($row[26]);
                                    $contrato->id_banco = $row[9];
                                    $contrato->id_lote = $lote[0]['id'];
                                    $contrato->id_corretor = $row[8];
                                    $contrato->nr_proposta = $row[0];
                                    $contrato->dt_contrato = Helper::getInputDate($row[5]);
                                    $contrato->fl_aprovar_contrato = 1;
                                    //Parcelas Normais
                                    $contrato->fl_coinc_intercalada = ($row[21] == 'S') ? '1' : '0';
                                    $contrato->nr_parcela = (int)$row[14];
                                    $contrato->vl_parcela = $row[15];
                                    $contrato->dt_primeira_parcela = Helper::getInputDate($row[16]);
                                    //Parcelas Sinal
                                    $contrato->nr_parcela_sinal = $row[11];
                                    $contrato->vl_sinal = $row[12];
                                    $contrato->dt_sinal = Helper::getInputDate($row[13]);
                                    $contrato->inclui_sinal_contrato = 0;
                                    //Parcelas Intercaladas
                                    $contrato->nr_intercalada = (int)$row[17];
                                    $contrato->vl_intercalada = $row[18];
                                    $contrato->dt_intercalada = Helper::getInputDate($row[19]);
                                    $contrato->fr_intercalada = (int)$row[20];
                                    // Parcelas Chaves
                                    $contrato->nr_parcela_entrega = $row[22];
                                    $contrato->vl_parcela_entrega  = $row[23];
                                    $contrato->dt_parcela_entrega =  Helper::getInputDate($row[24]);
                                    
                                    //Outras Informaes
                                    $contrato->obs = $row[10];
                                    $contrato->id_pessoa = $idpessoa;
                                    $contrato->fl_gerado = '0';
                                    $contrato->fl_distrato = $row[4];
                                    $contrato->dt_reajuste = Helper::getInputDate($row[25]);
                                    $contrato->log = (Login::getUsuario()->getLogin() . ' - ' . date('d/m/Y H:m:s') . ' - i');

                                    $idContrato = $contrato->save();

                                    //PARCELAS SINAL
                                    if ((int)$row[11] > 0) {
                                        $valor = (float)$row[12] / (int)$row[11];
                                        for ($i = 0; $i < (int)$row[11]; $i++) {
                                            $rowSinal = new Sinal();
                                            $rowSinal = $rowSinal->createRow();

                                            $data = strtotime(Helper::getInputDate($row[13]));
                                            $data = date("Y-m-d", strtotime("+" . $i . " month", $data));

                                            $rowSinal->valor = $valor;
                                            $rowSinal->dtVencimento = $data;
                                            $rowSinal->parcela = $i + 1;
                                            $rowSinal->idContrato = $idContrato;
                                            $rowSinal->save();
                                        }
                                    }
                                } catch (Exception $e) {
                                    fwrite($log, "----> ERRO: " . $e->getMessage() . ".:\n");
                                }
                            } else {
                                fwrite($log, "----> ERRO: LOTE J POSSUI UM CONTRATO CADASTRADO.:\n");
                            }
                        } else {
                            fwrite($log, "----> ERRO: BANCO NO CADASTRADO NO SISTEMA.:\n");
                        }
                    } else {
                        fwrite($log, "----> ERRO: CORRETOR NO CADASTRADO NO SISTEMA.:\n");
                    }
                } else {
                    fwrite($log, "----> ERRO: LOTE NAO ENCONTRADO NO SISTEMA.:\n");
                }
            } else {
                fwrite($log, "----> ERRO: PESSOA NAO ENCONTRADA NO SISTEMA.:\n");
            }
        }
    }

    public function loteByEmpreendimentoAction()
    {
        $contratos = Contrato::byEmpreendimento($_POST['id_empreendimento'], Contrato::CONTRATO_TODOS, 2, array("nm_pessoa", "lote", "quadra", "id"), true);

        $lista = array();
        foreach ($contratos as $contrato) {
            $lista[] = array('id' => $contrato['id'], 'text' => substr_replace(utf8_encode($contrato['nm_pessoa']), "...", 30) . ' Quadra: ' . $contrato['quadra'] . ' - Lote: ' . $contrato['lote']);
        }

        echo json_encode($lista);
    }

}