<?php

class ClienteController extends Controller
{

    private $tb_cliente;
    private $tb_municipio;
    private $tb_agrupada;
    private $tb_docusign;
    private $tb_docusignVinculo;
    private $tb_docusignCadastro;
    private $tb_comunicacao;
    public function __construct($request)
    {
        parent::__construct($request);
        $this->tb_cliente = new Db_Cliente();
        $this->tb_municipio = new Db_Cidade();
        $this->tb_agrupada = new Db_TabelaAgrupada();
        $this->tb_docusign = new DocusignEventos();
        $this->tb_docusignVinculo = new DocusignVinculo();
        $this->tb_docusignCadastro = new DocusignCadastro();
        $this->tb_comunicacao = new Comunicacao();
        $this->dataHora = date("d/m/Y H:i:s", strtotime("now"));
        $this->usuario = (Login::getUsuario()) ? Login::getUsuario()->getLogin() : null;
    }

    public function indexAction()
    {
        $cliente = Db_Cliente::getCliente();
        if ($cliente)
            $this->redir(array("modulo" => "sc", "controller" => "cliente", "action" => "editar"), array('id' => $cliente['cd_cliente']));
        else
            $this->redir(array("modulo" => "sc", "controller" => "cliente", "action" => "adicionar"));
    }

    public function adicionarAction()
    {
        $nmDominio = "";
        $url = explode('.', $_SERVER['HTTP_HOST']);
        if ($url[0] == 'www') {
            $nmDominio = $url[1];
        } else {
            $nmDominio = $url[0];
        }
        $this->set('nmDominio', $nmDominio);
        
        // Insercao em cliente
        $tb_cliente = $this->tb_cliente->createRow();
        $tb_cliente->cd_cliente = $_POST['cdAcade'];
        $tb_cliente->dt_contrato = ($_POST["dtContrato"]) ? $this->_helper->getInputDate($_POST["dtContrato"]) : null;
        $tb_cliente->fl_parcelas_migradas = $_POST["flParcelaMigradas"];
        $tb_cliente->nm_razao_social = $_POST["nmRazaoSocial"];
        $tb_cliente->nm_fantasia = $_POST["nmFantasia"];
        $tb_cliente->nr_cnpj = $_POST["nrCnpjCpf"];
        $tb_cliente->nr_inscricao_municipal = $_POST["nrInscricaoMunicipal"];
        $tb_cliente->nr_inscricao_estadual = $_POST["nrInscricaoEstadual"];
        $tb_cliente->nr_uf_telefone = $_POST["nrUfTelefone"];
        $tb_cliente->nr_telefone = $_POST["nrTelefone"];
        $tb_cliente->fl_situacao = $_POST['cdTipo'];
        $tb_cliente->cd_plano_cliente = $_POST['cdPlanoCliente'];
        //Adicionado fieldset para Outorgante!
        $tb_cliente->nome_outorgante = $_POST['nome_outorgante'];
        $tb_cliente->telefone_outorgante = $_POST['telefone_outorgante'];
        $tb_cliente->fl_contrato_digital = $_POST['contratoDigital'];
        $tb_cliente->fl_oportunidades = $_POST['oportunidades'];
        $tb_cliente->email_outorgante = $_POST['email_outorgante'];

        if ($_POST["nrUfTelefone2"] && $_POST["nrTelefone2"]) {
            $tb_cliente->nr_uf_telefone2 = $_POST["nrUfTelefone2"];
            $tb_cliente->nr_telefone2 = $_POST["nrTelefone2"];
        }

        $tb_cliente->ds_url = $_POST["dsUrl"];
        $tb_cliente->ds_email = $_POST["dsEmail"];
        $tb_cliente->nr_cep = Helper::apenasNumeros($_POST["nrCep"]);
        $tb_cliente->ds_endereco = $_POST["dsEndereco"];
        $tb_cliente->nm_bairro = $_POST["nmBairro"];

        if (!empty($_POST["cd_cidade"])) {
            $tb_cliente->cd_municipio = $_POST["cd_cidade"];
        }

        $tb_cliente->fl_optante_simples = $_POST["flOptanteSimples"];
        $tb_cliente->moeda = $_POST["moeda"];
        $tb_cliente->fl_painel_venda = $_POST["flPainelVenda"];
        (new Empreendimento())->alteraQuantidadeDownloads($_POST["qtdDownload"]);
        $tb_cliente->fl_planta_venda = $_POST["flPlantaVenda"];
        $tb_cliente->fl_acade_ged = $_POST["flAcadeGed"];
        $tb_cliente->fl_acade_finan = $_POST["flAcadeFinan"];
        $tb_cliente->fl_senhaportal = $_POST["flAcadePortal"];
        $tb_cliente->fl_acade_expert = $_POST["flAcadeExpert"];
        $tb_cliente->ds_log = $this->usuario . ' - ' . $this->dataHora . ' - ' . $operacao . ' - ' . $tela;

        $tb_cliente->fl_comunicacao = $_POST["flComunicacao"];
        $tb_cliente->qtd_envio_email = $_POST["qtd_envio_email"]?$_POST["qtd_envio_email"]:"0";
        //armazena a logomarca
        if ($_FILES['dsEndLogomarca']['name']) {
            // Arquivo
            $up = new Filesystem();

            //alterar o nome colocando a hora atual
            $name = $this->_helper->removeAcentos($_FILES['dsEndLogomarca']['name']);
            $name = explode(".", $name);
            $name = 'logoCliente_' . $_POST['cdAcade'] . '.' . $name[1];

            // Armazena o arquivo fisico
            $tmp = $_FILES['dsEndLogomarca']['tmp_name'];
            $to = "upload/image/fotoLogomarca/" . $name;
            $rs = Filesystem::upload($tmp, $to);
            $tb_cliente->ds_end_logomarca = $to;
        }
        $id = $tb_cliente->save();
        $this->redir(array("modulo" => "sc", "controller" => "cliente", "action" => "editar"), array('id' => $id, "msg" => "OK"));
    }

    public function editarAction()
    {
        $nmDominio = "";
        $url = explode('.', $_SERVER['HTTP_HOST']);
        if ($url[0] == 'www') {
            $nmDominio = $url[1];
        } else {
            $nmDominio = $url[0];
        }
        $this->set('nmDominio', $nmDominio);
        //nome da tela e a operacao realizada I-inclusao
        $tela = $this->get('nomeTela');
        $operacao = 'A';

        $planos = $this->tb_agrupada->findByTabelaId(16, null, 'descricao');
        $this->set('planos', $planos);
        
        $cliente = $this->tb_cliente->fetchRow("cd_cliente = {$_GET['id']}")->toArray();
        $qtdDownload = (new Empreendimento())->fetchRow();
        $cliente['qtd_download'] = $qtdDownload['qtd_download'];
        $this->set("cliente", $cliente);

        $cidade = $this->tb_municipio->find($cliente["cd_municipio"]);
        $this->set('cidade', $cidade);

        if ($cliente['ds_end_logomarca']) {
            $paths = explode('/', $cliente['ds_end_logomarca']);
            $arquivo['arquivo'] = end($paths);
            $arquivo['isImage'] = false;
            $arquivo['caminho'] = $cliente['ds_end_logomarca'];
            $extensoes = array('.jpg', '.jpg', '.gif', '.bpm', '.png');
            foreach ($extensoes as $ext) {
                if (strstr(strtolower($arquivo['arquivo']), $ext)) {
                    $arquivo['isImage'] = true;
                    break;
                }
            }
            $this->set('arquivo', $arquivo);
        }

        $this->set('edit', true);
        $this->set('nmbotao', 'Alterar');
        $this->set('back', $this->_helper->getLink(array('m' => 'sc', 'c' => 'cliente', 'a' => 'index')));

        if ($this->_isPost && $this->validar($_POST['nrCnpjCpf'])) {
            // Atualizacao na tabela de Cliente
            $tb_cliente = $this->tb_cliente->fetchRow("cd_cliente = {$_GET['id']}");

            if ($tb_cliente) {
                $tb_cliente->cd_cliente = $_POST['cdAcade'];
                $tb_cliente->dt_contrato = ($_POST["dtContrato"]) ? $this->_helper->getInputDate($_POST["dtContrato"]) : null;
                $tb_cliente->fl_parcelas_migradas = $_POST["flParcelaMigradas"];
                $tb_cliente->nm_razao_social = $_POST["nmRazaoSocial"];
                $tb_cliente->nm_fantasia = $_POST["nmFantasia"];
                $tb_cliente->nr_cnpj = $_POST["nrCnpjCpf"];
                $tb_cliente->nr_inscricao_municipal = $_POST["nrInscricaoMunicipal"];
                $tb_cliente->nr_inscricao_estadual = $_POST["nrInscricaoEstadual"];
                $tb_cliente->nr_uf_telefone = $_POST["nrUfTelefone"];
                $tb_cliente->nr_telefone = $_POST["nrTelefone"];
                $tb_cliente->fl_situacao = $_POST['cdTipo'];
                $tb_cliente->cd_plano_cliente = $_POST['cdPlanoCliente'];
                //Adicionado fieldset para Outorgante!
                $tb_cliente->nome_outorgante = $_POST['nome_outorgante'];
                $tb_cliente->telefone_outorgante = $_POST['telefone_outorgante'];
                $tb_cliente->fl_contrato_digital = $_POST['contratoDigital'];
                
                $tb_cliente->fl_oportunidades = $_POST['oportunidades'];
                $tb_cliente->email_outorgante = $_POST['email_outorgante'];

                if ($_POST["nrUfTelefone2"] && $_POST["nrTelefone2"]) {
                    $tb_cliente->nr_uf_telefone2 = $_POST["nrUfTelefone2"];
                    $tb_cliente->nr_telefone2 = $_POST["nrTelefone2"];
                } else {
                    $tb_cliente->nr_uf_telefone2 = null;
                    $tb_cliente->nr_telefone2 = null;
                }

                $tb_cliente->ds_url = $_POST["dsUrl"];
                $tb_cliente->ds_email = $_POST["dsEmail"];
                $tb_cliente->nr_cep = Helper::apenasNumeros($_POST["nrCep"]);
                $tb_cliente->ds_endereco = $_POST["dsEndereco"];
                $tb_cliente->nm_bairro = $_POST["nmBairro"];

                if (!empty($_POST["cd_cidade"])) {
                    $tb_cliente->cd_municipio = $_POST["cd_cidade"];
                }

                $tb_cliente->fl_optante_simples = $_POST["flOptanteSimples"];
                $tb_cliente->moeda = $_POST["moeda"];
                $tb_cliente->fl_painel_venda = $_POST["flPainelVenda"];
                $tb_cliente->fl_versao = $_POST["flVersao"];
                $tb_cliente->fl_planta_venda = $_POST["flPlantaVenda"];
                (new Empreendimento())->alteraQuantidadeDownloads($_POST["qtdDownload"]);
                $tb_cliente->fl_acade_ged = $_POST["flAcadeGed"];
                $tb_cliente->fl_acade_finan = $_POST["flAcadeFinan"];
                $tb_cliente->fl_senhaportal = $_POST["flAcadePortal"];
                $tb_cliente->fl_acade_expert = $_POST["flAcadeExpert"];
                $tb_cliente->fl_comunicacao = $_POST["flComunicacao"];
                $tb_cliente->qtd_envio_email = $_POST["qtd_envio_email"];
                $tb_cliente->ds_log = $this->usuario . ' - ' . $this->dataHora . ' - ' . $operacao . ' - ' . $tela;

                $_SESSION['clienteId'] = $_POST["flAcadePortal"];

                //Altera a logomarca
                if ($_FILES['dsEndLogomarca']['name']) {

                    // Arquivo
                    $up = new Filesystem();

                    //remove o aquivo antigo
                    if (file_exists($tb_cliente->ds_end_logomarca)) {
                        Filesystem::delete($tb_cliente->ds_end_logomarca);
                    }

                    //alterar o nome do arquivo
                    $name = $this->_helper->removeAcentos($_FILES['dsEndLogomarca']['name']);
                    $name = explode(".", $name);
                    $name = 'logoCliente_' . $cliente["cd_cliente"] . '.' . $name[1];

                    // Armazena o arquivo fisico
                    $tmp = $_FILES['dsEndLogomarca']['tmp_name'];

                    $path = explode('.', $_SERVER['HTTP_HOST']);
                    if ($path[0] == 'www') {
                        $path = $path[1];
                    } else {
                        $path = $path[0];
                    }

                    $pastaCliente = "upload/cliente/";
                    if (!is_dir($pastaCliente)) {
                        mkdir($pastaCliente, 0777, true);
                    }
                    $pastaPath = $pastaCliente . $path;
                    if (!is_dir($pastaCliente)) {
                        mkdir($pastaPath, 0777, true);
                    }
                    $fullPath = $pastaPath . '/' . $name;

                    $rs = $up->upload($tmp, $fullPath);
                    if ($rs) {
                        $tb_cliente->ds_end_logomarca = $fullPath;
                    }
                }

                $id = $tb_cliente->save();
                $this->redir(array("modulo" => "sc", "controller" => "cliente", "action" => "editar"), array('id' => $id, "msg" => "OK"));
            } else {
                $this->redir(array("modulo" => "sc", "controller" => "cliente", "action" => "adicionar"));
            }
        }

        $this->display('form');
    }

    public function excluirImagemAction()
    {
        $tb_cliente = $this->tb_cliente->fetchRow("cd_cliente = {$_GET['id']}");
        //remove o aquivo
        if (file_exists($tb_cliente->ds_end_logomarca))
            Filesystem::delete($tb_cliente->ds_end_logomarca);
        //Remove o registro
        $tb_cliente->ds_end_logomarca = '';
        $tb_cliente->save();

        $this->redir(array("modulo" => "sc", "controller" => "cliente", "action" => "editar"), array("id" => $_GET['id']));
    }

    private function validar()
    {
        //checa se o CNPJ e valido
        if ($_POST["nrCnpjCpf"] == '99.999.999/9999-99') {
            if ($this->_helper->validaCNPJ($_POST["nrCnpjCpf"]) == false) {
                $this->_helper->addMensagem("nrCnpjCpf", "CNPJ invlido");
            }
        } elseif($_POST["nrCnpjCpf"] == '999.999.999-99') {
            if ($this->_helper->validaCPF($_POST["nrCnpjCpf"]) == false) {
                $this->_helper->addMensagem("nrCnpjCpf", "CPF invlido");
            }
        }

        $campos = array("cdPlanoCliente", "cdTipo", "nmRazaoSocial", "nrCnpjCpf");

        foreach ($campos as $cp) {
            if ($_POST [$cp] == '') {
                switch ($cp) {
                    case "cdPlanoCliente" :
                        $msg = "O campo Plano Cliente deve ser preenchido.";
                        break;
                    case "cdTipo" :
                        $msg = "O campo Situao de Acesso deve ser preenchido.";
                        break;
                    case "nmRazaoSocial" :
                        $msg = "O campo Razo Social deve ser preenchido.";
                        break;
                    case "nrCnpjCpf" :
                        $msg = "O campo CNPJ deve ser preenchido.";
                        break;
                }
                if (!empty($msg))
                    $this->_helper->addMensagem($cp, $msg);
                $msg = '';
            }
        }

        return !(count($this->_helper->getMensagens()) > 0);
    }

    public function findCidadeByNomeAction()
    {
        $dados = array();
        //Buscando a lista de lotes para exibir na tela
        $lista = Cidade::findByNome(utf8_decode($_GET['term']));
        if ($lista) foreach ($lista as $cidade) {
            $dados[] = array('text' => utf8_encode($cidade['nome'].' - '.$cidade['uf']), 'value' => $cidade['id']);
        }
        echo json_encode($dados);
    }
    public function codeDocusignAction()
    {
        $state = explode("-",$_POST['state']);
        $docusign = $this->tb_docusignCadastro->getLista($state[0])[0];
        
        $this->tb_docusignCadastro->atualizarCode($state[0],$_POST['code']);

        $cliente_id = Db_Cliente::getCliente()['cd_cliente'];
        $urlDocusign = "https://account-d.docusign.com";
        if($state['1']=="2"){
            $urlDocusign = "https://account.docusign.com";
        }
        $curl = curl_init();

        curl_setopt_array($curl, array(
          CURLOPT_URL => $urlDocusign.'/oauth/token',
          CURLOPT_RETURNTRANSFER => true,
          CURLOPT_ENCODING => '',
          CURLOPT_MAXREDIRS => 100,
          CURLOPT_TIMEOUT => 0,
          CURLOPT_FOLLOWLOCATION => true,
          CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
          CURLOPT_CUSTOMREQUEST => 'POST',
          CURLOPT_POSTFIELDS => 'grant_type=authorization_code&code='.$_POST['code'],
          CURLOPT_HTTPHEADER => array(
            'Authorization: Basic '.base64_encode($docusign['docusign_integration_key'].":".$docusign['docusign_secret_key']),
            'Content-Type: application/x-www-form-urlencoded'
          ),
        ));
        
        $response = curl_exec($curl);
        curl_close($curl);

        $json = json_decode($response);
        if(!isset($json->access_token))
        {
            $this->redir(array("modulo" => "sc", "controller" => "cliente", "action" => "editar"), array('id' => $cliente_id, "erro" => "Erro: ".$response));
        }

        $this->tb_docusignCadastro->atualizarToken($state[0],$json->access_token,$json->refresh_token);

        $this->redir(array("modulo" => "sc", "controller" => "cliente", "action" => "editar"), array('id' => $cliente_id, "msg" => "OK"));
    }

    public function homologacaoDocusignAction(){
        $listaContatos=[];
        array_push($listaContatos,array("email"=>"suporte4@acade.com.br","name"=>utf8_encode("Homologao Docusign"),"recipientId"=>count($listaContatos)+1));
        
        $docusign = $this->tb_docusignCadastro->getLista($_GET['idDocusign'])[0];
        $cliente_id = Db_Cliente::getCliente()['cd_cliente'];
        
        $infoDocusign = $this->infoTokenDocusign($docusign['docusign_access_token'],'https://account-d.docusign.com');
        if(isset($infoDocusign->error)){
            $token = $this->refreshTokenDocusign($docusign['docusign_refresh_token'],$docusign['docusign_integration_key'],$docusign['docusign_secret_key'],'https://account-d.docusign.com');
            if(isset( $token->access_token)){
                
                $this->tb_docusignCadastro->atualizarToken($_GET['idDocusign'],$token->access_token,$token->refresh_token);
                $docusign['docusign_access_token'] = $token->access_token;
    
                $docusign['docusign_refresh_token'] = $token->refresh_token;

                $infoDocusign = $this->infoTokenDocusign($token->access_token);
            }
            else{
                $this->redir(array("modulo" => "adm", "controller" => "contrato", "action" => "listar"), array("exception" => 'Houve algum erro, entre em contato com suporte. Falha ao atualizar token ' . json_encode($token)));
                return;
            }
        }
        $data = file_get_contents(getcwd()."/modulo/sc/controller/homologacaoDocusign/".$_GET['id'].".pdf");
        $base64 = base64_encode($data);
        $envelope = $this->criarEnvelopeDocusign($docusign['docusign_access_token'], $docusign['docusign_id_cliente'], $infoDocusign->accounts[0]->base_uri, $base64, $listaContatos, 'Contrato_Resumo_' . time());
        echo json_encode($envelope);
    }

    public function eventoDocusignAction(){
        if(!file_get_contents('php://input')){
            echo "Falha <br>";
            var_dump(file_get_contents('php://input'));
        }
        $obj = json_decode(file_get_contents('php://input'), true);
        $dt = new DateTime($obj['generatedDateTime'], new DateTimeZone('UTC'));
        $dt->setTimezone(new DateTimeZone('America/Recife'));

        $envelopeId = $obj['data']['envelopeId'];
        $envelopeDataEvento = $dt->format('Y-m-d H:i:s');;
        $envelopeEvento = $obj['event'];
        $users=[];
        if($obj['data']['recipientId']){
            foreach($obj['data']['envelopeSummary']['recipients']['signers'] as $dest){
                $users[]=[$dest['email'],$dest['status']];
                if($dest['recipientId']==$obj['data']['recipientId']){
                    $destinatarioNome = utf8_encode($dest['name']);
                    $destinatarioEmail = $dest['email'];
                    $destinatarioId = $dest['userId'];
                }
            }
            $this->tb_docusignVinculo->atualizarUsuarios($obj['data']['envelopeId'],json_encode($users));
        }

        $remetenteEmail = $obj['data']['envelopeSummary']['sender']['email'];
        $remetenteNome = $obj['data']['envelopeSummary']['sender']['userName'];
        $remetenteId = $obj['data']['envelopeSummary']['sender']['userId'];

        $this->tb_docusign->adicionar($envelopeId,$envelopeDataEvento,$envelopeEvento,$destinatarioNome,$destinatarioEmail,$destinatarioId,$remetenteEmail,$remetenteNome,$remetenteId);
        echo "OK";
    }

    public function eventoWhatsappAction(){
        header("Access-Control-Allow-Origin: *"); // Permitir chamadas de qualquer origem
        header("Access-Control-Allow-Methods: POST, GET, OPTIONS"); // Mtodos permitidos
        header("Access-Control-Allow-Headers: Content-Type, Authorization"); // Cabealhos permitidos
        if($_POST['ack']=="1"){
            $this->tb_comunicacao->atualizar($_POST['agendamento'],1, date("Y-m-d H:i:s"));
            echo "ok, enviado";
        }
        elseif($_POST['ack']=="3"){
            $this->tb_comunicacao->atualizar($_POST['agendamento'],1, false,date("Y-m-d H:i:s"));
            echo "ok, lido";
        }
        
        elseif($_POST['ack']=="-1"){
            $this->tb_comunicacao->atualizar($_POST['agendamento'],-1, false,false);
            echo "ok, no enviado";
        }
    }

    public function consultaUnicredAction(){
        
        $parcela = new Parcela();
        $parcelas = $parcela->consultaBoletoSemRegistro();
        if($parcelas){
            $curl = curl_init();

            curl_setopt_array($curl, array(
            CURLOPT_URL => 'https://api.e-unicred.com.br/oauth2/v2/grant-token',//'https://api.e-unicred.com.br/homolog/oauth2/v2/grant-token',
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => '',
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 0,
            CURLOPT_FOLLOWLOCATION => true,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_POSTFIELDS =>json_encode(array("nomeUsuario"=> $parcelas[0]['pp_token'], "senha"=>$parcelas[0]['password'])),
            CURLOPT_HTTPHEADER => array(
                'apiKey: '.$parcelas[0]['gerar_token'],
                'Content-Type: application/json'
            ),
            ));

            $response = curl_exec($curl);

            curl_close($curl);
            $autenticacao = json_decode($response);
            if(!$autenticacao->accessToken){
                echo "falha na autenticao ".$response;
                //die;
            }

            $bearerToken=$autenticacao->accessToken;
            var_dump($autenticacao);
            foreach($parcelas as $p){
                var_dump($p);
                $curl = curl_init();

                curl_setopt_array($curl, array(
                CURLOPT_URL => 'https://api.e-unicred.com.br/cobranca/v2/beneficiarios/'.$p['req_cliente_id'].'/titulos/'.$p['cod_boleto_api'].'/status',//'https://api.e-unicred.com.br/homolog/cobranca/v2/beneficiarios/'.$p['req_cliente_id'].'/titulos/'.$p['cod_boleto_api'].'/status',
                CURLOPT_RETURNTRANSFER => true,
                CURLOPT_ENCODING => '',
                CURLOPT_MAXREDIRS => 10,
                CURLOPT_TIMEOUT => 0,
                CURLOPT_FOLLOWLOCATION => true,
                CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                CURLOPT_CUSTOMREQUEST => 'GET',
                CURLOPT_HTTPHEADER => array(
                    'apiKey: '.$p['gerar_token'],
                    'cooperativa: '.$p['nr_cooperativa'],
                    'Authorization: Bearer '.$bearerToken,
                ),
                ));

                $response = curl_exec($curl);
                curl_close($curl);
                $objResultado = json_decode($response);
                
                var_dump($objResultado);
                if($objResultado->nossoNumero){
                    $parcela->registroBoleto($p['id_parcela_contrato'],$objResultado->nossoNumero,$objResultado->codBarras,$objResultado->linhaDigitavel,$objResultado->qrCodePix);
                }
               
            }
        }
        
    }
    public function consultaParcelaRegistradaAction(){
        
        $parcela = new Parcela();
        $boleto = $parcela->ultimasRegistradas();
        foreach($boleto as $key=>$b){
            $boleto[$key] = array_map('utf8_encode', $b);
        }
        echo json_encode($boleto);
    }

    public function gerarTokenApiAction(){
        header("Content-Type: application/json;");
        $length = 10; // define o comprimento do cdigo
        $characters = '0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ'; // define os caracteres permitidos
        $code = '';
        for ($i = 0; $i < $length; $i++) {
            $code .= $characters[rand(0, strlen($characters) - 1)]; // escolhe um caractere aleatrio
        }
        //echo $code; // imprime o cdigo

        $tb_cliente = $this->tb_cliente->fetchRow("cd_cliente = {$_POST['id']}");
        if ($tb_cliente) {
            $tb_cliente->tokenApi = $code;
            $id = $tb_cliente->save();
            echo json_encode(array("token"=>$code,"status"=>true));
        }
        else{
            echo json_encode(array("erro"=>"Cliente no encontrado","status"=>false));

        }
    }
}